/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.sklogger;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import oracle.kv.impl.util.sklogger.MetricFamilySamples;
import oracle.kv.impl.util.sklogger.RateMetric;
import oracle.kv.impl.util.sklogger.StatsData;

public class Counter
extends RateMetric<RateResult, Element> {
    public Counter(String name, String ... labelNames) {
        super(name, labelNames);
        this.initializeNoLabelsElement();
    }

    @Override
    protected Element newElement() {
        return new Element();
    }

    public long getValue() {
        return ((Element)this.noLabelsElement).getValue();
    }

    public void incrValue() {
        ((Element)this.noLabelsElement).incrValue();
    }

    public void incrValue(long delta) {
        ((Element)this.noLabelsElement).incrValue(delta);
    }

    @Override
    public MetricFamilySamples<RateResult> collect() {
        return this.collect(StatsData.Type.COUNTER);
    }

    @Override
    public MetricFamilySamples<RateResult> collectSinceLastTime(String watcherName) {
        return this.collectSinceLastTime(StatsData.Type.COUNTER, watcherName);
    }

    public static class RateResult
    extends RateMetric.RateResult {
        private static final long serialVersionUID = 1L;
        private final long count;

        public RateResult(long duration, long count) {
            super(duration);
            this.count = count;
        }

        public long getCount() {
            return this.count;
        }

        public double getThroughputPerSecond() {
            double seconds = (double)this.duration / 1.0E9;
            if (seconds == 0.0) {
                return 0.0;
            }
            return (double)this.count / seconds;
        }

        @Override
        public Map<String, Object> toMap() {
            Map<String, Object> map = super.toMap();
            map.put("count", this.count);
            map.put("throughputPerSecond", this.getThroughputPerSecond());
            return map;
        }
    }

    public static final class Element
    extends RateMetric.Element<RateResult> {
        private final ConcurrentHashMap<String, HistoryItem> watchers;
        private final AtomicLong value = new AtomicLong(0L);

        private Element() {
            this.watchers = new ConcurrentHashMap();
        }

        public long getValue() {
            return this.value.get();
        }

        public void incrValue() {
            this.value.incrementAndGet();
        }

        public void incrValue(long delta) {
            this.value.addAndGet(delta);
        }

        @Override
        public RateResult rate() {
            long currentTime = System.nanoTime();
            long currentValue = this.getValue();
            long lastTime = this.initialTime;
            long lastValue = 0L;
            return new RateResult(currentTime - lastTime, currentValue - 0L);
        }

        @Override
        public RateResult rateSinceLastTime(String watcherName) {
            long currentTime = System.nanoTime();
            long currentValue = this.getValue();
            long lastTime = this.initialTime;
            long lastValue = 0L;
            HistoryItem historyItem = this.watchers.get(watcherName);
            if (historyItem != null) {
                lastTime = historyItem.lastTime;
                lastValue = historyItem.lastValue;
                historyItem.lastTime = currentTime;
                historyItem.lastValue = currentValue;
            } else {
                this.watchers.put(watcherName, new HistoryItem(currentTime, currentValue));
            }
            return new RateResult(currentTime - lastTime, currentValue - lastValue);
        }

        private static final class HistoryItem {
            private long lastTime;
            private long lastValue;

            private HistoryItem(long time, long value) {
                this.lastTime = time;
                this.lastValue = value;
            }
        }
    }
}

