/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.registry.ssl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import oracle.kv.impl.async.EndpointConfigBuilder;
import oracle.kv.impl.security.ssl.SSLControl;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.TimeoutSocket;

public class SSLClientSocketFactory
extends ClientSocketFactory {
    private static final long serialVersionUID = 1L;
    private static volatile SSLControl trustedSSLControl;
    private static volatile SSLControl defaultUserSSLControl;
    private static final Map<String, SSLControl> userSSLControlMap;
    private final String kvStoreName;
    private final Use clientUse;

    public SSLClientSocketFactory(String name, int connectTimeoutMs, int readTimeoutMs, String kvStoreName) {
        super(name, connectTimeoutMs, readTimeoutMs);
        this.kvStoreName = kvStoreName;
        this.clientUse = Use.USER;
    }

    public SSLClientSocketFactory(String name, int connectTimeoutMs, int readTimeoutMs) {
        this(name, connectTimeoutMs, readTimeoutMs, Use.USER);
    }

    public SSLClientSocketFactory(String name, int connectTimeoutMs, int readTimeoutMs, Use clientUse) {
        super(name, connectTimeoutMs, readTimeoutMs);
        this.kvStoreName = null;
        this.clientUse = clientUse;
        this.checkValidFields();
    }

    private void checkValidFields() {
        ObjectUtil.checkNull("clientUse", this.clientUse);
    }

    public SSLClientSocketFactory(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.kvStoreName = SerializationUtil.readString(in, serialVersion);
        this.clientUse = Use.readFastExternal(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writeString(out, serialVersion, this.kvStoreName);
        this.clientUse.writeFastExternal(out, serialVersion);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.kvStoreName == null ? 0 : this.kvStoreName.hashCode()) + this.clientUse.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "<SSLClientSocketFactory name=" + this.name + " id=" + this.hashCode() + " connectMs=" + this.connectTimeoutMs + " readMs=" + this.readTimeoutMs + " kvStoreName=" + this.kvStoreName + " clientUse=" + this.clientUse + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SSLClientSocketFactory)) {
            return false;
        }
        SSLClientSocketFactory other = (SSLClientSocketFactory)obj;
        if (!this.clientUse.equals(other.clientUse)) {
            return false;
        }
        return !(this.kvStoreName == null ? other.kvStoreName != null : !this.kvStoreName.equals(other.kvStoreName));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        TimeoutSocket sock = this.createTimeoutSocket(host, port);
        boolean ok = false;
        try {
            SSLControl control = this.getSSLControl();
            SSLContext context = control != null ? control.sslContext() : SSLContext.getDefault();
            SSLSocket sslSock = (SSLSocket)context.getSocketFactory().createSocket(sock, host, port, true);
            if (control != null) {
                control.applySSLParameters(sslSock);
            }
            sslSock.startHandshake();
            if (control != null && control.hostVerifier() != null && !control.hostVerifier().verify(host, sslSock.getSession())) {
                throw new IOException("SSL connection to host " + host + " is not valid.");
            }
            ok = true;
            SSLSocket sSLSocket = sslSock;
            return sSLSocket;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IOException("Unknown algorithm", nsae);
        }
        finally {
            if (!ok) {
                try {
                    ((Socket)sock).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private SSLControl getSSLControl() throws IOException {
        SSLControl control = null;
        if (Use.TRUSTED.equals(this.clientUse)) {
            control = trustedSSLControl;
            if (control == null) {
                throw new IOException("Cannot create TRUSTED client SSLSocket with empty trustedSSLControl");
            }
        } else {
            if (this.kvStoreName != null) {
                control = userSSLControlMap.get(this.kvStoreName);
            }
            if (control == null) {
                control = defaultUserSSLControl;
            }
        }
        return control;
    }

    public static void clearUserSSLControlMap() {
        userSSLControlMap.clear();
    }

    static void setTrustedControl(SSLControl trustedControl) {
        trustedSSLControl = trustedControl;
    }

    static void setUserControl(SSLControl userControl, String storeContext) {
        if (storeContext != null) {
            userSSLControlMap.put(storeContext, userControl);
        }
        defaultUserSSLControl = userControl;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        try {
            this.checkValidFields();
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Invalid fields: " + e.getMessage(), e);
        }
    }

    @Override
    public EndpointConfigBuilder getEndpointConfigBuilder() throws IOException {
        return super.getEndpointConfigBuilder().sslControl(this.getSSLControl());
    }

    static {
        userSSLControlMap = new ConcurrentHashMap<String, SSLControl>();
    }

    public static enum Use implements FastExternalizable
    {
        USER(0),
        TRUSTED(1);

        private static final Use[] VALUES;

        private Use(int ordinal) {
            if (ordinal != this.ordinal()) {
                throw new IllegalArgumentException("Wrong ordinal");
            }
        }

        private static Use readFastExternal(DataInput in, short serialVersion) throws IOException {
            byte ordinal = in.readByte();
            try {
                return VALUES[ordinal];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Wrong ordinal for Use: " + ordinal, e);
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            out.writeByte(this.ordinal());
        }

        static {
            VALUES = Use.values();
        }
    }
}

