/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;

public class SerializeExceptionUtil {
    public static void writeException(Throwable exception, DataOutput out, short serialVersion) throws IOException {
        ObjectUtil.checkNull("exception", exception);
        if (exception instanceof FastExternalizable) {
            SerializeExceptionUtil.writeFastExternal((FastExternalizable)((Object)exception), out, serialVersion);
        } else {
            SerializeExceptionUtil.writeStandard(exception, out, serialVersion);
        }
    }

    public static Throwable readException(DataInput in, short serialVersion) throws IOException {
        switch (Format.readFastExternal(in, serialVersion)) {
            case FAST_EXTERNALIZABLE: {
                return SerializeExceptionUtil.readFastExternal(in, serialVersion);
            }
            case STANDARD: {
                return SerializeExceptionUtil.readStandard(in, serialVersion);
            }
        }
        throw new AssertionError();
    }

    private static void writeFastExternal(FastExternalizable exception, DataOutput out, short serialVersion) throws IOException {
        Format.FAST_EXTERNALIZABLE.writeFastExternal(out, serialVersion);
        SerializationUtil.writeNonNullString(out, serialVersion, exception.getClass().getName());
        exception.writeFastExternal(out, serialVersion);
    }

    private static Throwable readFastExternal(DataInput in, short serialVersion) throws IOException {
        String className = SerializationUtil.readNonNullString(in, serialVersion);
        try {
            Class<Throwable> cl = Class.forName(className).asSubclass(Throwable.class);
            Constructor<Throwable> cons = cl.getConstructor(DataInput.class, Short.TYPE);
            return cons.newInstance(in, serialVersion);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw SerializeExceptionUtil.readExceptionFailed(className, null, e);
        }
        catch (Exception e) {
            throw SerializeExceptionUtil.readExceptionFailed(className, null, e);
        }
    }

    private static IOException readExceptionFailed(String className, String message, Throwable exception) {
        return new IOException("Problem reading exception of type " + className + (message != null ? " with message '" + message + "': " : ": ") + exception, exception);
    }

    private static void writeStandard(Throwable exception, DataOutput out, short serialVersion) throws IOException {
        if (SerializeExceptionUtil.isKVSClass(exception.getClass())) {
            throw new IllegalArgumentException("Attempt to write a KVS exception that does not implement FastExternalizable: " + exception, exception);
        }
        Format.STANDARD.writeFastExternal(out, serialVersion);
        SerializationUtil.writeNonNullString(out, serialVersion, exception.getClass().getName());
        SerializeExceptionUtil.writeMessageAndCause(out, serialVersion, exception.getMessage(), exception.getCause());
    }

    private static final boolean isKVSClass(Class<?> cl) {
        return cl.getName().startsWith("oracle.kv.");
    }

    public static void writeMessageAndCause(DataOutput out, short serialVersion, String message, Throwable cause) throws IOException {
        SerializationUtil.writeString(out, serialVersion, message);
        if (cause != null) {
            out.writeBoolean(true);
            SerializeExceptionUtil.writeException(cause, out, serialVersion);
        } else {
            out.writeBoolean(false);
        }
    }

    private static Throwable readStandard(DataInput in, short serialVersion) throws IOException {
        String className = SerializationUtil.readNonNullString(in, serialVersion);
        String message = SerializationUtil.readString(in, serialVersion);
        Throwable cause = in.readBoolean() ? SerializeExceptionUtil.readException(in, serialVersion) : null;
        try {
            Class<Throwable> cl = Class.forName(className).asSubclass(Throwable.class);
            try {
                Constructor<Throwable> cons = cl.getConstructor(String.class, Throwable.class);
                return cons.newInstance(message, cause);
            }
            catch (Exception cons) {
                try {
                    Constructor<Throwable> cons2 = cl.getConstructor(String.class);
                    Throwable t = cons2.newInstance(message);
                    if (cause != null) {
                        t.initCause(cause);
                    }
                    return t;
                }
                catch (Exception cons2) {
                    if (cl == AssertionError.class) {
                        AssertionError t = new AssertionError((Object)message);
                        ((Throwable)((Object)t)).initCause(cause);
                        return t;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new RuntimeException("Problem reading exception of type " + className + (message != null ? " with message '" + message + "'" : ""), cause);
    }

    public static enum Format implements FastExternalizable
    {
        FAST_EXTERNALIZABLE(0),
        STANDARD(1);

        private static final Format[] VALUES;

        private Format(int ordinal) {
            if (ordinal != this.ordinal()) {
                throw new IllegalArgumentException("Wrong ordinal");
            }
        }

        public static Format readFastExternal(DataInput in, short serialVersion) throws IOException {
            byte ordinal = in.readByte();
            try {
                return VALUES[ordinal];
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Wrong ordinal for SerializeExceptionUtil.Format: " + ordinal, e);
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            out.writeByte(this.ordinal());
        }

        static {
            VALUES = Format.values();
        }
    }
}

