/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.kv.impl.security.ExecutionContext;

public class KVThreadFactory
implements ThreadFactory {
    private final String name;
    private final Logger logger;
    private final AtomicInteger id;

    public KVThreadFactory(String name, Logger exceptionLogger) {
        this.name = name;
        this.logger = exceptionLogger;
        this.id = new AtomicInteger();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, "KV" + this.getName() + "_" + this.id.incrementAndGet());
        t.setDaemon(true);
        t.setUncaughtExceptionHandler(this.makeUncaughtExceptionHandler());
        return t;
    }

    public Thread.UncaughtExceptionHandler makeUncaughtExceptionHandler() {
        return new LogUncaughtException();
    }

    public static class KVPrivilegedThreadFactory
    extends KVThreadFactory {
        private final ExecutionContext execCtx;

        public KVPrivilegedThreadFactory(String name, ExecutionContext execCtx, Logger exceptionLogger) {
            super(name, exceptionLogger);
            this.execCtx = execCtx;
        }

        @Override
        public Thread newThread(final Runnable r) {
            return super.newThread(new Runnable(){

                @Override
                public void run() {
                    if (execCtx == null) {
                        r.run();
                    } else {
                        ExecutionContext.runWithContext((ExecutionContext.SimpleProcedure)new ExecutionContext.SimpleProcedure(){

                            public void run() {
                                r.run();
                            }
                        }, (ExecutionContext)execCtx);
                    }
                }
            });
        }
    }

    private class LogUncaughtException
    implements Thread.UncaughtExceptionHandler {
        private LogUncaughtException() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (KVThreadFactory.this.logger != null) {
                KVThreadFactory.this.logger.severe(t + " experienced this uncaught exception " + e);
            }
        }
    }
}

