/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import com.sleepycat.je.utilint.PropUtil;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.ParamConstant;
import oracle.kv.impl.param.Parameter;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.util.ExternalDataSourceException;

public final class ExternalDataSourceUtils {
    public static void checkParams(ParameterMap params) {
        Map<String, ParamConstant> allParams = ParamConstant.getAllParams();
        for (Parameter p : params) {
            if (allParams.containsKey(p.getName())) continue;
            throw new IllegalArgumentException(p.getName() + " is not a recognized parameter.");
        }
    }

    public static Consistency parseConsistency(String consistencyString) {
        Consistency consistency = null;
        if ("ABSOLUTE".equalsIgnoreCase(consistencyString)) {
            consistency = Consistency.ABSOLUTE;
        } else if ("NONE_REQUIRED_NO_MASTER".equalsIgnoreCase(consistencyString)) {
            consistency = Consistency.NONE_REQUIRED_NO_MASTER;
        } else if ("NONE_REQUIRED".equalsIgnoreCase(consistencyString)) {
            consistency = Consistency.NONE_REQUIRED;
        } else if ("TIME".regionMatches(true, 0, consistencyString, 0, 4)) {
            String consistencyParamName = ParamConstant.CONSISTENCY.getName();
            int firstParenIdx = consistencyString.indexOf("(");
            int lastParenIdx = consistencyString.indexOf(")");
            if (firstParenIdx < 0 || lastParenIdx < 0 || lastParenIdx < firstParenIdx) {
                throw new ExternalDataSourceException(consistencyParamName + " value of " + consistencyString + " is formatted incorrectly.");
            }
            String timeParam = consistencyString.substring(firstParenIdx + 1, lastParenIdx);
            String[] lagAndTimeout = timeParam.split(",");
            if (lagAndTimeout.length != 2) {
                throw new ExternalDataSourceException(consistencyParamName + " value of " + consistencyString + " is formatted incorrectly.");
            }
            try {
                long permissibleLagMSecs = PropUtil.parseDuration(lagAndTimeout[0].trim());
                long timeoutMSecs = PropUtil.parseDuration(lagAndTimeout[1].trim());
                consistency = new Consistency.Time(permissibleLagMSecs, TimeUnit.MILLISECONDS, timeoutMSecs, TimeUnit.MILLISECONDS);
            }
            catch (IllegalArgumentException IAE) {
                throw new ExternalDataSourceException(consistencyParamName + " value of " + consistencyString + " is formatted incorrectly.");
            }
        } else {
            throw new ExternalDataSourceException("Unknown consistency specified: " + consistencyString);
        }
        return consistency;
    }

    public static int parseTimeout(String timeoutValue) {
        return PropUtil.parseDuration(timeoutValue);
    }
}

