/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.ExprUpdateField;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

public class ExprUpdateRow
extends Expr {
    public static RecordDefImpl theNumRowsUpdatedType;
    private TableImpl theTable;
    private ArrayList<Expr> theArgs;
    private boolean theUpdateTTL;
    private boolean theHasReturningClause;

    ExprUpdateRow(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, ExprSFW input, TableImpl table, boolean hasReturningClause) {
        super(qcb, sctx, Expr.ExprKind.UPDATE_ROW, location);
        this.theTable = table;
        this.theArgs = new ArrayList(8);
        this.theArgs.add(input);
        input.addParent(this);
        this.theHasReturningClause = hasReturningClause;
        this.theType = hasReturningClause ? TypeManager.createTableRecordType(table, ExprType.Quantifier.QSTN) : TypeManager.createType(theNumRowsUpdatedType, ExprType.Quantifier.ONE);
    }

    TableImpl getTable() {
        return this.theTable;
    }

    @Override
    int getNumChildren() {
        return this.theArgs.size();
    }

    @Override
    Expr getInput() {
        return this.theArgs.get(0);
    }

    void addUpdateClauses(ArrayList<Expr> clauses, boolean updateTTL) {
        for (Expr clause : clauses) {
            this.theArgs.add(clause);
            clause.addParent(this);
        }
        this.theUpdateTTL = updateTTL;
    }

    Expr getArg(int i) {
        return this.theArgs.get(i);
    }

    void setArg(int i, Expr newExpr, boolean destroy) {
        this.theArgs.get(i).removeParent(this, destroy);
        this.theArgs.set(i, newExpr);
        newExpr.addParent(this);
    }

    boolean updateTTL() {
        return this.theUpdateTTL;
    }

    ExprUpdateField getTTLExpr() {
        ExprUpdateField e = (ExprUpdateField)this.theArgs.get(this.theArgs.size() - 1);
        if (e.getUpdateKind() == Expr.UpdateKind.TTL_HOURS || e.getUpdateKind() == Expr.UpdateKind.TTL_DAYS) {
            return e;
        }
        return null;
    }

    boolean hasReturningClause() {
        return this.theHasReturningClause;
    }

    @Override
    ExprType computeType() {
        return this.theType;
    }

    @Override
    boolean mayReturnNULL() {
        return false;
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        for (int i = 1; i < this.theArgs.size(); ++i) {
            this.theArgs.get(i).display(sb, formatter);
            if (i >= this.theArgs.size() - 1) continue;
            sb.append(",\n");
        }
        sb.append("\n");
        this.theArgs.get(0).display(sb, formatter);
    }

    static {
        FieldMap fmap = new FieldMap();
        fmap.put("NumRowsUpdated", FieldDefImpl.integerDef, false, FieldDefImpl.integerDef.createInteger(1));
        theNumRowsUpdatedType = FieldDefFactory.createRecordDef(fmap, null);
    }
}

