/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.AbstractResponderEndpoint;
import oracle.kv.impl.async.BytesUtil;
import oracle.kv.impl.async.DialogHandler;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.EndpointHandler;
import oracle.kv.impl.async.EndpointHandlerManager;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.SocketPrepared;
import oracle.kv.impl.async.dialog.ProtocolMesg;
import oracle.kv.impl.async.dialog.netty.NettyEndpointGroup;
import oracle.kv.impl.async.dialog.netty.NettyEndpointHandler;
import oracle.kv.impl.async.dialog.netty.NettyUtil;
import oracle.kv.impl.async.dialog.netty.VerifyingSSLHandler;
import oracle.kv.impl.security.ssl.SSLControl;
import oracle.kv.impl.util.CommonLoggerUtils;

class PreReadWrappedEndpointHandler
extends SimpleChannelInboundHandler<ByteBuf>
implements EndpointHandler,
EndpointHandlerManager {
    private final AbstractResponderEndpoint responderEndpoint;
    private final EndpointConfig endpointConfig;
    private final NetworkAddress remoteAddress;
    private final NettyEndpointGroup.NettyListener listener;
    private final NettyEndpointHandler endpointHandler;
    private volatile boolean preReadDone = false;
    private volatile boolean isShutdown = false;
    private final byte[] magicNumber = new byte[ProtocolMesg.MAGIC_NUMBER.length];
    private final ByteBuffer magicNumberBuf = ByteBuffer.wrap(this.magicNumber);

    PreReadWrappedEndpointHandler(AbstractResponderEndpoint responderEndpoint, EndpointConfig endpointConfig, NetworkAddress remoteAddress, NettyEndpointGroup.NettyListener listener) {
        this.responderEndpoint = responderEndpoint;
        this.endpointConfig = endpointConfig;
        this.remoteAddress = remoteAddress;
        this.listener = listener;
        this.endpointHandler = new NettyEndpointHandler(responderEndpoint.getLogger(), this, endpointConfig, false, remoteAddress, listener.getDialogHandlerFactories());
    }

    public void handlerAdded(ChannelHandlerContext context) {
        SSLControl sslControl;
        ChannelPipeline pipeline = context.pipeline();
        if (NettyEndpointGroup.logHandlerEnabled()) {
            pipeline.addFirst(new ChannelHandler[]{new LoggingHandler()});
        }
        if ((sslControl = this.endpointConfig.getSSLControl()) != null) {
            VerifyingSSLHandler handler = NettyUtil.newSSLHandler(this.endpointHandler.getStringID(), sslControl, this.remoteAddress, false, this.responderEndpoint.getLogger());
            pipeline.addLast(new ChannelHandler[]{handler.sslHandler()});
            pipeline.addLast(new ChannelHandler[]{handler});
        }
        pipeline.addLast(new ChannelHandler[]{this.endpointHandler.decoder()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead0(ChannelHandlerContext context, ByteBuf msg) throws Exception {
        Logger logger = this.responderEndpoint.getLogger();
        if (!this.preReadDone) {
            msg.readBytes(this.magicNumberBuf);
            if (this.magicNumberBuf.remaining() != 0) {
                return;
            }
            this.preReadDone = true;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Got connection with magic number: {0}", BytesUtil.toString(this.magicNumber, 0, this.magicNumber.length));
            }
            if (!Arrays.equals(this.magicNumber, ProtocolMesg.MAGIC_NUMBER)) {
                try {
                    ByteBuffer preReadBytes = ByteBuffer.allocate(this.magicNumber.length + msg.readableBytes());
                    this.magicNumberBuf.clear();
                    preReadBytes.put(this.magicNumberBuf);
                    msg.getBytes(msg.readerIndex(), preReadBytes);
                    preReadBytes.clear();
                    this.endpointHandler.handedOffToSync();
                    context.deregister().addListener((GenericFutureListener)new SocketInitializer(preReadBytes, context));
                }
                finally {
                    this.shutdown("Got non-async connection", true);
                }
                return;
            }
            if (this.listener.getDialogHandlerFactories().isEmpty()) {
                logger.log(Level.INFO, "Got async connection, but no available dialog factory for responding");
                this.shutdown("No factory for async connection", true);
                return;
            }
            this.endpointHandler.onChannelReady();
        }
        msg.retain();
        context.fireChannelRead((Object)msg);
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        Logger logger = this.responderEndpoint.getLogger();
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "{0} got exception, preReadDone={1}, endpointHandler={2}, cause={3}", new Object[]{this.getClass().getSimpleName(), this.preReadDone, this.endpointHandler, CommonLoggerUtils.getStackTrace(cause)});
        }
        context.fireExceptionCaught(cause);
    }

    @Override
    public NetworkAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public ScheduledExecutorService getSchedExecService() {
        return this.endpointHandler.getSchedExecService();
    }

    @Override
    public long getUUID() {
        return this.endpointHandler.getUUID();
    }

    @Override
    public long getConnID() {
        return this.endpointHandler.getConnID();
    }

    @Override
    public String getStringID() {
        return this.endpointHandler.getStringID();
    }

    @Override
    public void startDialog(int dialogType, DialogHandler dialogHandler, long timeoutMillis) {
        this.endpointHandler.startDialog(dialogType, dialogHandler, timeoutMillis);
    }

    @Override
    public int getNumDialogsLimit() {
        return this.endpointHandler.getNumDialogsLimit();
    }

    @Override
    public void shutdown(String detail, boolean force) {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        this.responderEndpoint.onHandlerShutdown(this);
        this.endpointHandler.shutdown(detail, force);
    }

    @Override
    public void onHandlerShutdown(EndpointHandler handler) {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        this.responderEndpoint.onHandlerShutdown(this);
    }

    private class SocketInitializer
    implements ChannelFutureListener {
        private final ByteBuffer preReadBytes;
        private final ChannelHandlerContext context;

        SocketInitializer(ByteBuffer preReadBytes, ChannelHandlerContext context) {
            this.preReadBytes = preReadBytes;
            this.context = context;
        }

        public void operationComplete(ChannelFuture future) {
            block5: {
                Logger logger = PreReadWrappedEndpointHandler.this.responderEndpoint.getLogger();
                if (!future.isSuccess()) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.log(Level.INFO, "Error deregistering socket: {0}", CommonLoggerUtils.getStackTrace(future.cause()));
                    }
                    future.channel().close();
                    return;
                }
                SocketPrepared socketPrepared = PreReadWrappedEndpointHandler.this.listener.getSocketPrepared();
                if (socketPrepared == null) {
                    logger.log(Level.INFO, "Got non-async connection, but no sync handler is present");
                    return;
                }
                SocketChannel socketChannel = NettyUtil.getSocketChannel(this.context.channel());
                try {
                    socketChannel.configureBlocking(true);
                    logger.log(Level.FINE, "Handing off the connection to the non-async handler: handler={0}, buf={1}, socket={2}", new Object[]{socketPrepared, BytesUtil.toString(this.preReadBytes, this.preReadBytes.limit()), socketChannel.socket()});
                    socketPrepared.onPrepared(this.preReadBytes, socketChannel.socket());
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.INFO)) break block5;
                    logger.log(Level.INFO, "Error handing off the channel to non-async handler: {0}", CommonLoggerUtils.getStackTrace(e));
                }
            }
        }
    }
}

