/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.List;
import oracle.kv.Version;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

public class TupleValue
extends FieldValueImpl {
    private static final long serialVersionUID = 1L;
    final FieldValueImpl[] theRegisters;
    final int[] theTupleRegs;
    final RecordDefImpl theDef;
    long theExpirationTime;
    Version theRowVersion;

    public TupleValue(RecordDefImpl def, FieldValueImpl[] regs, int[] regIds) {
        this.theRegisters = regs;
        this.theTupleRegs = regIds;
        this.theDef = def;
    }

    @Override
    public FieldValueImpl clone() {
        throw new IllegalStateException("TupleValue does not implement clone");
    }

    public String toString() {
        return this.toJsonString(false);
    }

    @Override
    public long sizeof() {
        throw new IllegalStateException("Unexpected call");
    }

    public int hashCode() {
        int code = this.size();
        for (int i = 0; i < this.size(); ++i) {
            String fname = this.theDef.getFieldName(i);
            code += fname.hashCode();
            code += this.get(i).hashCode();
        }
        return code;
    }

    public boolean equals(Object otherObj) {
        if (this == otherObj) {
            return true;
        }
        if (otherObj instanceof RecordValueImpl) {
            RecordValueImpl other = (RecordValueImpl)otherObj;
            if (this.size() == other.size() && this.getDefinition().equals(other.getDefinition())) {
                for (int i = 0; i < this.size(); ++i) {
                    FieldValueImpl val2;
                    FieldValueImpl val1 = this.get(i);
                    if (val1.equals(val2 = other.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (otherObj instanceof TupleValue) {
            TupleValue other = (TupleValue)otherObj;
            if (this.size() == other.size() && this.getDefinition().equals(other.getDefinition())) {
                for (int i = 0; i < this.size(); ++i) {
                    FieldValueImpl val2;
                    FieldValueImpl val1 = this.get(i);
                    if (val1.equals(val2 = other.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public int compareTo(FieldValue o) {
        throw new IllegalStateException("TupleValue is not comparable to any other value");
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.RECORD;
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public RecordDefImpl getDefinition() {
        return this.theDef;
    }

    @Override
    public int size() {
        return this.theTupleRegs.length;
    }

    public List<String> getFieldNames() {
        return this.getDefinition().getFieldNames();
    }

    public List<String> getFieldNamesInternal() {
        return this.getDefinition().getFieldNamesInternal();
    }

    public String getFieldName(int pos) {
        return this.getDefinition().getFieldName(pos);
    }

    public int getFieldPos(String fieldName) {
        return this.getDefinition().getFieldPos(fieldName);
    }

    public FieldValueImpl get(String fieldName) {
        int pos = this.getDefinition().getFieldPos(fieldName);
        return this.theRegisters[this.theTupleRegs[pos]];
    }

    public FieldValueImpl get(int pos) {
        return this.theRegisters[this.theTupleRegs[pos]];
    }

    public void setExpirationTime(long t) {
        this.theExpirationTime = t;
    }

    public long getExpirationTime() {
        return this.theExpirationTime;
    }

    public void setVersion(Version v) {
        this.theRowVersion = v;
    }

    public Version getVersion() {
        return this.theRowVersion;
    }

    @Override
    public boolean isTuple() {
        return true;
    }

    @Override
    public JsonNode toJsonNode() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        for (int i = 0; i < this.theTupleRegs.length; ++i) {
            FieldValueImpl val = this.get(i);
            assert (val != null);
            node.put(this.getFieldName(i), val.toJsonNode());
        }
        return node;
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append('{');
        for (int i = 0; i < this.theTupleRegs.length; ++i) {
            FieldValueImpl val = this.get(i);
            if (i > 0) {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(this.getDefinition().getFieldName(i));
            sb.append('\"');
            sb.append(':');
            if (val == null) {
                sb.append("java-null");
                continue;
            }
            val.toStringBuilder(sb);
        }
        sb.append('}');
    }

    public int getNumFields() {
        return this.theTupleRegs.length;
    }

    FieldDefImpl getFieldDef(String fieldName) {
        return this.getDefinition().getField(fieldName);
    }

    FieldDefImpl getFieldDef(int pos) {
        return this.getDefinition().getFieldDef(pos);
    }

    void putFieldValue(int fieldPos, FieldValueImpl value) {
        this.theRegisters[this.theTupleRegs[fieldPos]] = value;
    }

    public RecordValueImpl toRecord() {
        RecordValueImpl rec = this.theDef.createRecord();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == null) {
                throw new NullPointerException("TupleValue has null value for field " + this.getFieldName(i));
            }
            rec.put(i, (FieldValue)this.get(i));
        }
        return rec;
    }

    public void toTuple(RecordValueImpl rec, boolean doNullOnEmpty) {
        assert (this.theDef.equals(rec.getDefinition()));
        if (doNullOnEmpty) {
            for (int i = 0; i < this.size(); ++i) {
                FieldValueImpl val = rec.get(i);
                this.theRegisters[this.theTupleRegs[i]] = val.isEMPTY() ? NullValueImpl.getInstance() : val;
            }
        } else {
            for (int i = 0; i < this.size(); ++i) {
                this.theRegisters[this.theTupleRegs[i]] = rec.get(i);
            }
        }
    }
}

