/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.lob;

import java.util.ArrayList;
import oracle.kv.Key;

public class ChunkKeyFactory {
    private final int metadataVersion;
    static final int KEY_RADIX = 32;

    ChunkKeyFactory(int metadataVersion) {
        this.metadataVersion = metadataVersion;
    }

    Key create(Key internalLobKey, long superChunkId, long chunkId) {
        if (superChunkId <= 0L || chunkId <= 0L) {
            throw new IllegalArgumentException("super chunk id:" + superChunkId + "chunk id:" + chunkId);
        }
        ArrayList<String> majorPath = new ArrayList<String>(internalLobKey.getMajorPath());
        majorPath.add(this.getIdString(superChunkId));
        ArrayList<String> minorPath = new ArrayList<String>(internalLobKey.getMinorPath());
        minorPath.add(this.getIdString(chunkId));
        return Key.createKey(majorPath, minorPath);
    }

    Key createSuperChunkKey(Key internalLobKey, long superChunkId) {
        if (superChunkId <= 0L) {
            throw new IllegalArgumentException("Invalid super chunk id:" + superChunkId);
        }
        ArrayList<String> majorPath = new ArrayList<String>(internalLobKey.getMajorPath());
        majorPath.add(this.getIdString(superChunkId));
        return Key.createKey(majorPath);
    }

    int getChunkId(Key chunkKey) {
        return Integer.parseInt(chunkKey.getMinorPath().get(0), 32);
    }

    private String getIdString(long i) {
        if (this.metadataVersion == 1) {
            String s = Long.toString(i, 32);
            return "0000000".substring(7 - s.length()) + s;
        }
        return Long.toString(i, 32);
    }

    int getMetadataVersion() {
        return this.metadataVersion;
    }
}

