/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.json;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.persistence.json.JsonPlatform;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.Session;

public class JsonTypeConverter
implements Converter {
    JsonPlatform platform = null;

    public Object convertObjectValueToDataValue(Object jsonValue, Session session) {
        if (jsonValue instanceof JsonValue) {
            return this.platform.convertJsonValueToDataValue((JsonValue)jsonValue);
        }
        throw new IllegalArgumentException("Source object is not an instance of JsonValue");
    }

    public Object convertDataValueToObjectValue(Object jdbcValue, Session session) {
        return this.platform.convertDataValueToJsonValue(jdbcValue);
    }

    public boolean isMutable() {
        return false;
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        this.platform = (JsonPlatform)session.getPlatform().getJsonPlatform().unwrap(JsonPlatform.class);
        if (mapping.isDirectToFieldMapping() && ((AbstractDirectMapping)mapping).getFieldClassification() == null) {
            AbstractDirectMapping directMapping = (AbstractDirectMapping)AbstractDirectMapping.class.cast(mapping);
            Class attributeClassification = mapping.getAttributeClassification();
            if (attributeClassification.isInstance(JsonObject.class)) {
                directMapping.setFieldClassification(JsonObject.class);
            } else if (attributeClassification.isInstance(JsonArray.class)) {
                directMapping.setFieldClassification(JsonArray.class);
            } else {
                ((AbstractDirectMapping)mapping).setFieldClassification(JsonValue.class);
            }
        }
    }
}

