/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.BooleanDefImpl;
import oracle.kv.impl.api.table.DoubleDefImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NameUtils;
import oracle.kv.impl.api.table.NullJsonValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.SequenceDefImpl;
import oracle.kv.impl.api.table.StringDefImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TableBuilder;
import oracle.kv.impl.api.table.TableBuilderBase;
import oracle.kv.impl.api.table.TableEvolver;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadataHelper;
import oracle.kv.impl.api.table.TablePath;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.impl.query.compiler.DdlException;
import oracle.kv.impl.query.compiler.EscapeUtil;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprArrayConstr;
import oracle.kv.impl.query.compiler.ExprArrayFilter;
import oracle.kv.impl.query.compiler.ExprArraySlice;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprCase;
import oracle.kv.impl.query.compiler.ExprCast;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprDeleteRow;
import oracle.kv.impl.query.compiler.ExprFieldStep;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.ExprInsertRow;
import oracle.kv.impl.query.compiler.ExprIsOfType;
import oracle.kv.impl.query.compiler.ExprMapConstr;
import oracle.kv.impl.query.compiler.ExprMapFilter;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.ExprSeqMap;
import oracle.kv.impl.query.compiler.ExprUpdateField;
import oracle.kv.impl.query.compiler.ExprUpdateRow;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.FuncExtractFromTimestamp;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.IndexExpr;
import oracle.kv.impl.query.compiler.JsonCollector;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.SortSpec;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.compiler.parser.KVQLBaseListener;
import oracle.kv.impl.query.compiler.parser.KVQLParser;
import oracle.kv.impl.query.runtime.ArithUnaryOpIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.query.PrepareCallback;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FieldValueFactory;
import oracle.kv.table.SequenceDef;
import oracle.kv.table.Table;
import oracle.kv.table.TimeToLive;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class Translator
extends KVQLBaseListener {
    private static final String ALL_PRIVS = "ALL";
    private static final int MIN_QUERY_COST = 2;
    private final ParseTreeWalker theWalker = new ParseTreeWalker();
    private final TableMetadataHelper theMetadataHelper;
    private final QueryControlBlock theQCB;
    private final FunctionLib theFuncLib;
    private final StaticContext theInitSctx;
    private StaticContext theSctx;
    private final Stack<StaticContext> theScopes = new Stack();
    private boolean theAllowUndeclaredVars;
    private final Stack<Expr> theExprs = new Stack();
    private final Stack<ExprSFW> theSFWExprs = new Stack();
    private final Stack<Boolean> theInSelectClause = new Stack();
    private final Stack<Boolean> theInWhereClause = new Stack();
    private final Stack<Expr> theNearExprs = new Stack();
    private final Stack<Function> theAggrFunctions = new Stack();
    private final Stack<String> theColNames = new Stack();
    private final Stack<SortSpec> theSortSpecs = new Stack();
    private final Stack<FieldDefImpl> theTypes = new Stack();
    private final Stack<ExprType.Quantifier> theQuantifiers = new Stack();
    private final Stack<FieldDefHelper> theFields = new Stack();
    private Set<String> theSequenceOptions = null;
    private IdentityDefHelper theIdentityHelper = null;
    private final JsonCollector jsonCollector = new JsonCollector();
    private final ArrayList<TableImpl> theTables = new ArrayList();
    private final ArrayList<String> theTableAliases = new ArrayList();
    private int theExternalVarsCounter;
    private Expr theRootExpr = null;
    private RuntimeException theException;
    private TableBuilderBase theTableBuilder;
    private boolean theInDDL = false;

    public Translator(QueryControlBlock qcb) {
        this.theQCB = qcb;
        this.theMetadataHelper = qcb.getTableMetaHelper();
        this.theSctx = this.theInitSctx = qcb.getInitSctx();
        this.theFuncLib = CompilerAPI.getFuncLib();
        this.theScopes.push(this.theInitSctx);
    }

    Expr getRootExpr() {
        return this.theRootExpr;
    }

    public RuntimeException getException() {
        return this.theException;
    }

    public void setException(RuntimeException de) {
        this.theException = de;
    }

    public boolean succeeded() {
        return this.theException == null;
    }

    public boolean isQuery() {
        return this.theRootExpr != null;
    }

    public void translate(ParseTree tree) {
        try {
            this.theWalker.walk(this, tree);
        }
        catch (DdlException e) {
            throw e;
        }
        catch (StopWalkException e) {
        }
        catch (RuntimeException e) {
            this.setException(e);
        }
    }

    void pushScope() {
        StaticContext sctx = new StaticContext(this.theScopes.peek());
        this.theScopes.push(sctx);
        this.theSctx = sctx;
    }

    void popScope() {
        this.theScopes.pop();
        this.theSctx = this.theScopes.peek();
    }

    @Override
    public void exitQuery(KVQLParser.QueryContext ctx) {
        this.theRootExpr = this.theExprs.pop();
        assert (this.theRootExpr != null);
        assert (this.theExprs.isEmpty());
        assert (this.theColNames.isEmpty());
        assert (this.theTypes.isEmpty());
    }

    @Override
    public void enterStatement(KVQLParser.StatementContext ctx) {
        if (ctx.query() == null && ctx.update_statement() == null && ctx.insert_statement() == null && ctx.delete_statement() == null) {
            this.theInDDL = true;
        }
    }

    @Override
    public void exitStatement(KVQLParser.StatementContext ctx) {
        this.theInDDL = false;
    }

    @Override
    public void exitVar_decl(KVQLParser.Var_declContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        String varName = ctx.var_name().getText();
        FieldDefImpl varType = this.theTypes.pop();
        if (varName.equals("$element") || varName.equals("$pos") || varName.equals("$key") || varName.equals("$value")) {
            throw new QueryException(varName + " cannot be used as the name of an external variable");
        }
        ExprVar varExpr = new ExprVar(this.theQCB, this.theInitSctx, loc, varName, varType, this.theExternalVarsCounter++);
        this.theInitSctx.addVariable(varExpr);
    }

    @Override
    public void enterSfw_expr(KVQLParser.Sfw_exprContext ctx) {
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.SELECT);
        }
        QueryException.Location loc = Translator.getLocation(ctx);
        ExprSFW sfw = new ExprSFW(this.theQCB, this.theInitSctx, loc);
        this.theExprs.push(sfw);
        this.theSFWExprs.push(sfw);
        this.theWalker.walk(this, ctx.from_clause());
        if (ctx.where_clause() != null) {
            this.theWalker.walk(this, ctx.where_clause());
        }
        if (ctx.groupby_clause() != null) {
            this.theWalker.walk(this, ctx.groupby_clause());
        }
        if (ctx.orderby_clause() != null) {
            this.theWalker.walk(this, ctx.orderby_clause());
        }
        this.theWalker.walk(this, ctx.select_clause());
        if (ctx.limit_clause() != null) {
            this.theWalker.walk(this, ctx.limit_clause());
        }
        if (ctx.offset_clause() != null) {
            this.theWalker.walk(this, ctx.offset_clause());
        }
        for (int numParseChildren = ctx.getChildCount(); numParseChildren > 0; --numParseChildren) {
            ctx.removeLastChild();
        }
    }

    @Override
    public void exitSfw_expr(KVQLParser.Sfw_exprContext ctx) {
        ExprSFW sfw = (ExprSFW)this.theExprs.peek();
        this.theSFWExprs.pop();
        for (int i = 0; i < sfw.getNumFroms(); ++i) {
            this.popScope();
        }
        sfw.rewriteNearPred();
    }

    @Override
    public void enterFrom_clause(KVQLParser.From_clauseContext ctx) {
        int i;
        ExprBaseTable tableExpr;
        QueryException.Location loc;
        this.pushScope();
        ExprSFW sfw = (ExprSFW)this.theExprs.peek();
        int numDescendants = 0;
        KVQLParser.Nested_tablesContext nestedTablesCtx = ctx.nested_tables();
        KVQLParser.From_tableContext targetTableCtx = null;
        List<KVQLParser.From_tableContext> ancCtxs = null;
        List<KVQLParser.From_tableContext> descCtxs = null;
        if (nestedTablesCtx != null) {
            loc = Translator.getLocation(nestedTablesCtx);
            tableExpr = new ExprBaseTable(this.theQCB, this.theInitSctx, loc);
            targetTableCtx = nestedTablesCtx.from_table();
            KVQLParser.Ancestor_tablesContext ancCtx = nestedTablesCtx.ancestor_tables();
            KVQLParser.Descendant_tablesContext descCtx = nestedTablesCtx.descendant_tables();
            this.translateTable(tableExpr, targetTableCtx, false, false);
            if (ancCtx != null) {
                ancCtxs = ancCtx.from_table();
                for (KVQLParser.From_tableContext anc : ancCtxs) {
                    this.translateTable(tableExpr, anc, true, false);
                }
            }
            if (descCtx != null) {
                descCtxs = descCtx.from_table();
                numDescendants = descCtxs.size();
                for (KVQLParser.From_tableContext desc : descCtxs) {
                    this.translateTable(tableExpr, desc, false, true);
                }
            }
        } else {
            targetTableCtx = ctx.from_table();
            loc = Translator.getLocation(targetTableCtx);
            tableExpr = new ExprBaseTable(this.theQCB, this.theInitSctx, loc);
            this.translateTable(tableExpr, targetTableCtx, false, false);
        }
        tableExpr.finalizeTables();
        this.orderTables(sfw, tableExpr, targetTableCtx, ancCtxs, descCtxs);
        if (numDescendants > 0) {
            // empty if block
        }
        int numParseChildren = ctx.getChildCount();
        ArrayList<KVQLParser.ExprContext> exprCtxs = new ArrayList<KVQLParser.ExprContext>(numParseChildren);
        ArrayList<KVQLParser.Var_nameContext> varCtxs = new ArrayList<KVQLParser.Var_nameContext>(numParseChildren);
        for (i = 0; i < numParseChildren; ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof KVQLParser.ExprContext) {
                exprCtxs.add((KVQLParser.ExprContext)child);
                continue;
            }
            if (!(child instanceof KVQLParser.Var_nameContext)) continue;
            varCtxs.add((KVQLParser.Var_nameContext)child);
        }
        assert (exprCtxs.size() == varCtxs.size());
        for (i = 0; i < exprCtxs.size(); ++i) {
            KVQLParser.ExprContext exprCtx = (KVQLParser.ExprContext)exprCtxs.get(i);
            KVQLParser.Var_nameContext varCtx = (KVQLParser.Var_nameContext)varCtxs.get(i);
            String varName = varCtx.getText();
            this.theWalker.walk(this, exprCtx);
            Expr domainExpr = this.theExprs.pop();
            ExprVar var = sfw.createFromVar(domainExpr, varName);
            this.pushScope();
            this.theSctx.addVariable(var);
        }
        while (numParseChildren > 0) {
            ctx.removeLastChild();
            --numParseChildren;
        }
    }

    private void translateTable(ExprBaseTable tableExpr, KVQLParser.From_tableContext tableCtx, boolean isAncestor, boolean isDescendant) {
        TableImpl table;
        QueryException.Location loc;
        String[] pathName;
        boolean isTarget = !isAncestor && !isDescendant;
        String namespace = null;
        KVQLParser.Aliased_table_nameContext aliasedTableName = tableCtx.aliased_table_name();
        if (aliasedTableName.table_name() != null) {
            namespace = this.computeNamespace(aliasedTableName.table_name());
            pathName = Translator.getNamePath(aliasedTableName.table_name().id_path());
            loc = Translator.getLocation(aliasedTableName);
        } else {
            pathName = new String[]{aliasedTableName.SYSTEM_TABLE_NAME().getText()};
            loc = Translator.getLocation(aliasedTableName.SYSTEM_TABLE_NAME());
        }
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().namespaceName(namespace);
            this.theQCB.getPrepareCallback().tableName(Translator.concatPathName(pathName));
        }
        if (isTarget) {
            if (tableCtx.ON() != null) {
                throw new QueryException("ON clause can not be used on a target table in the FROM clause", Translator.getLocation(tableCtx.ON()));
            }
            if (this.theQCB.getPrepareCallback() != null && !this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        if ((table = this.getTable(namespace, pathName, loc)) == null) {
            throw new QueryException("Table " + NameUtils.makeQualifiedName(namespace, Translator.concatPathName(pathName)) + " does not exist", loc);
        }
        if (isTarget) {
            this.theQCB.setTargetTable(table);
        }
        String alias = aliasedTableName.tab_alias() == null ? Translator.concatPathName(pathName, '_') : aliasedTableName.tab_alias().getText();
        QueryException.Location location = loc = aliasedTableName.tab_alias() == null ? Translator.getLocation(tableCtx) : Translator.getLocation(aliasedTableName.tab_alias());
        if (this.theTableAliases.contains(alias)) {
            throw new QueryException("Table alias " + alias + " is not unique", loc);
        }
        this.theTables.add(table);
        this.theTableAliases.add(alias);
        tableExpr.addTable(table, alias, isAncestor, isDescendant, loc);
    }

    private void orderTables(ExprSFW sfw, ExprBaseTable tableExpr, KVQLParser.From_tableContext targetTableCtx, List<KVQLParser.From_tableContext> ancCtxs, List<KVQLParser.From_tableContext> descCtxs) {
        ArrayList<TableImpl> tables = tableExpr.getTables();
        int numTables = this.theTables.size();
        if (numTables == 1) {
            String vname = ExprVar.createVarNameFromTableAlias(tableExpr.getAliases().get(0));
            ExprVar var = sfw.createTableVar(tableExpr, tables.get(0), vname);
            this.theSctx.addVariable(var);
            return;
        }
        ArrayList<TableImpl> sortedTables = new ArrayList<TableImpl>(numTables);
        ArrayList<String> sortedAliases = new ArrayList<String>(numTables);
        ArrayList<ExprVar> sortedVars = new ArrayList<ExprVar>(numTables);
        TableImpl topTable = tables.get(0).getTopLevelTable();
        this.traverseTables(sfw, tableExpr, targetTableCtx, ancCtxs, descCtxs, topTable, sortedTables, sortedAliases, sortedVars);
        tableExpr.setSortedTables(sortedTables, sortedAliases);
        for (ExprVar var : sortedVars) {
            this.theSctx.addVariable(var);
        }
    }

    private void traverseTables(ExprSFW sfw, ExprBaseTable tableExpr, KVQLParser.From_tableContext targetTableCtx, List<KVQLParser.From_tableContext> ancCtxs, List<KVQLParser.From_tableContext> descCtxs, TableImpl table, ArrayList<TableImpl> sortedTables, ArrayList<String> sortedAliases, ArrayList<ExprVar> sortedVars) {
        ArrayList<TableImpl> tables = tableExpr.getTables();
        ArrayList<String> aliases = tableExpr.getAliases();
        int numAncestors = tableExpr.getNumAncestors();
        int i = tables.indexOf(table);
        if (i >= 0) {
            this.pushScope();
            sortedTables.add(table);
            sortedAliases.add(aliases.get(i));
            int sortedPos = sortedTables.size() - 1;
            String vname = ExprVar.createVarNameFromTableAlias(aliases.get(i));
            ExprVar var = sfw.createTableVar(tableExpr, table, vname);
            sortedVars.add(var);
            this.theSctx.addVariable(var);
            if (i == 0) {
                if (targetTableCtx.ON() != null) {
                    throw new QueryException("ON predicates is not allowed on the target table of a NESTED TABLES clause");
                }
            } else if (i <= numAncestors) {
                KVQLParser.From_tableContext anc = ancCtxs.get(i - 1);
                if (anc.ON() != null) {
                    this.theWalker.walk(this, anc.or_expr());
                    tableExpr.setTablePred(sortedPos, this.theExprs.pop(), false);
                }
            } else {
                KVQLParser.From_tableContext desc = descCtxs.get(i - numAncestors - 1);
                if (desc.ON() != null) {
                    this.theWalker.walk(this, desc.or_expr());
                    tableExpr.setTablePred(sortedPos, this.theExprs.pop(), false);
                }
            }
        }
        for (Map.Entry<String, Table> entry : table.getChildTables().entrySet()) {
            this.traverseTables(sfw, tableExpr, targetTableCtx, ancCtxs, descCtxs, (TableImpl)entry.getValue(), sortedTables, sortedAliases, sortedVars);
        }
        if (i >= 0) {
            this.popScope();
        }
    }

    @Override
    public void enterWhere_clause(KVQLParser.Where_clauseContext ctx) {
        this.theInWhereClause.push(true);
        this.theNearExprs.push(null);
    }

    @Override
    public void exitWhere_clause(KVQLParser.Where_clauseContext ctx) {
        this.theInWhereClause.pop();
        Expr condExpr = this.theExprs.pop();
        ExprSFW sfwExpr = (ExprSFW)this.theExprs.peek();
        sfwExpr.addWhereClause(condExpr);
        Expr near = this.theNearExprs.pop();
        if (near != null) {
            if (near != condExpr) {
                if (condExpr.getFunction(FunctionLib.FuncCode.OP_AND) == null) {
                    throw new QueryException("The geo_near function must be a top-level predicate in WHERE clause", near.getLocation());
                }
                Expr.ExprIter children = condExpr.getChildren();
                boolean found = false;
                while (children.hasNext()) {
                    Expr child = children.next();
                    if (child != near) continue;
                    found = true;
                    break;
                }
                children.reset();
                if (!found) {
                    throw new QueryException("The geo_near function must be a top-level predicate in WHERE clause", near.getLocation());
                }
            }
            sfwExpr.setNearPred((ExprFuncCall)near);
        }
    }

    @Override
    public void enterGroupby_clause(KVQLParser.Groupby_clauseContext ctx) {
        this.theExprs.push(null);
    }

    @Override
    public void exitGroupby_clause(KVQLParser.Groupby_clauseContext ctx) {
        ArrayList<Expr> gbExprs = new ArrayList<Expr>();
        Expr expr = this.theExprs.pop();
        while (expr != null) {
            gbExprs.add(expr);
            expr = this.theExprs.pop();
        }
        Collections.reverse(gbExprs);
        ExprSFW sfw = (ExprSFW)this.theExprs.peek();
        sfw.addGroupByClause(gbExprs);
        sfw.analyseOrderOrGroupBy(false);
    }

    @Override
    public void enterSelect_list(KVQLParser.Select_listContext ctx) {
        this.theInSelectClause.push(true);
        if (ctx.STAR() != null) {
            ExprSFW sfw = (ExprSFW)this.theExprs.peek();
            if (sfw.hasGroupBy()) {
                throw new QueryException("select * is not allowed together with group by");
            }
            int numFroms = sfw.getNumFroms();
            ArrayList<Expr> colExprs = new ArrayList<Expr>(numFroms);
            ArrayList<String> colNames = new ArrayList<String>(numFroms);
            for (int i = 0; i < numFroms; ++i) {
                for (ExprVar var : sfw.getFromClause(i).getVars()) {
                    colExprs.add(var);
                    String varname = var.getName();
                    if (varname.startsWith("$$")) {
                        colNames.add(var.getName().substring(2));
                        continue;
                    }
                    colNames.add(var.getName().substring(1));
                }
            }
            sfw.setConstructsRecord(colExprs.size() > 1);
            sfw.addSelectClause(colNames, colExprs);
        } else {
            this.theExprs.push(null);
            this.theColNames.push(null);
        }
    }

    @Override
    public void exitSelect_list(KVQLParser.Select_listContext ctx) {
        if (ctx.STAR() != null) {
            return;
        }
        ArrayList<Expr> colExprs = new ArrayList<Expr>();
        ArrayList<String> colNames = new ArrayList<String>();
        Expr expr = this.theExprs.pop();
        String name = this.theColNames.pop();
        boolean hasASclauses = true;
        HashSet<String> uniqueColNames = new HashSet<String>(colNames.size());
        while (expr != null) {
            if (name == null) {
                hasASclauses = false;
                if (expr.getKind() == Expr.ExprKind.FIELD_STEP) {
                    name = ((ExprFieldStep)expr).getFieldName();
                } else if (expr.getKind() == Expr.ExprKind.VAR) {
                    name = ((ExprVar)expr).getName().substring(1);
                }
            } else if (!uniqueColNames.add(name)) {
                throw new QueryException("Duplicate column name in SELECT clause: " + name, expr.getLocation());
            }
            colExprs.add(expr);
            colNames.add(name);
            expr = this.theExprs.pop();
            name = this.theColNames.pop();
        }
        Collections.reverse(colExprs);
        Collections.reverse(colNames);
        uniqueColNames.clear();
        ExprSFW sfw = (ExprSFW)this.theExprs.peek();
        for (int i = 0; i < colNames.size(); ++i) {
            String colName = (String)colNames.get(i);
            if (colName != null && uniqueColNames.add(colName)) continue;
            colNames.set(i, "Column_" + (i + 1));
        }
        if (colNames.size() == 1 && !hasASclauses) {
            sfw.setConstructsRecord(false);
            this.theQCB.setWrapResultInRecord((String)colNames.get(0));
        } else {
            sfw.setConstructsRecord(true);
        }
        if (sfw.hasGroupBy()) {
            if (sfw.getNumGroupByExprs() == 0 && sfw.hasSort()) {
                sfw.removeSort();
            }
            ExprSFW outerSFW = new ExprSFW(this.theQCB, this.theInitSctx, sfw.getLocation());
            String varName = this.theQCB.createInternalVarName(null);
            ExprVar outerFromVar = outerSFW.createFromVar(sfw, varName);
            outerSFW.setConstructsRecord(sfw.getConstructsRecord());
            for (int i = 0; i < colExprs.size(); ++i) {
                Expr colExpr = colExprs.get(i);
                String colName = colNames.get(i);
                Expr newColExpr = sfw.rewriteSelectExprForGroupBy(i, colExpr, colName, colExpr, outerSFW, outerFromVar);
                outerSFW.addField(colName, newColExpr);
            }
            if (outerSFW.needOuterSFWForGroupBy()) {
                this.popScope();
                this.pushScope();
                this.theSctx.addVariable(outerFromVar);
                this.theSFWExprs.pop();
                this.theSFWExprs.push(outerSFW);
                this.theExprs.pop();
                this.theExprs.push(outerSFW);
            } else {
                sfw.removeParent(outerSFW, false);
                sfw.setFieldNames(colNames);
            }
        } else {
            sfw.addSelectClause(colNames, colExprs);
        }
        this.theInSelectClause.pop();
    }

    @Override
    public void enterCol_alias(KVQLParser.Col_aliasContext ctx) {
        if (ctx.id() == null) {
            this.theColNames.push(null);
        } else {
            this.theColNames.push(ctx.id().getText());
        }
    }

    @Override
    public void exitHint(KVQLParser.HintContext ctx) {
        ExprSFW sfwExpr = (ExprSFW)this.theExprs.peek();
        if (sfwExpr == null && (sfwExpr = (ExprSFW)this.theExprs.get(this.theExprs.size() - 2)) == null) {
            throw new QueryStateException("SFW expr not found.");
        }
        assert (ctx.table_name().id_path() != null) : "Table name missing from  hint at: " + Translator.getLocation(ctx.table_name());
        ExprBaseTable exprBaseTable = sfwExpr.getFirstFrom().getTableExpr();
        String tableName = ctx.table_name().getText();
        if (!exprBaseTable.getTargetTable().getFullName().equals(tableName)) {
            throw new QueryException("Table name specified in hint doesn't match the table in the FROM statement.", Translator.getLocation(ctx.table_name()));
        }
        if (ctx.PREFER_INDEXES() != null) {
            for (KVQLParser.Index_nameContext indxCtx : ctx.index_name()) {
                String indexName = indxCtx.getText();
                IndexImpl indx = (IndexImpl)exprBaseTable.getTargetTable().getIndex(indexName);
                if (indx == null) continue;
                exprBaseTable.addIndexHint(indx, false, Translator.getLocation(indxCtx));
            }
        } else if (ctx.FORCE_INDEX() != null) {
            for (KVQLParser.Index_nameContext indxCtx : ctx.index_name()) {
                String indexName = indxCtx.getText();
                IndexImpl indx = (IndexImpl)exprBaseTable.getTargetTable().getIndex(indexName);
                if (indx == null) continue;
                exprBaseTable.addIndexHint(indx, true, Translator.getLocation(indxCtx));
            }
        } else if (ctx.PREFER_PRIMARY_INDEX() != null) {
            exprBaseTable.addIndexHint(null, false, Translator.getLocation(ctx));
        } else if (ctx.FORCE_PRIMARY_INDEX() != null) {
            exprBaseTable.addIndexHint(null, true, Translator.getLocation(ctx));
        }
    }

    @Override
    public void enterOrderby_clause(KVQLParser.Orderby_clauseContext ctx) {
        this.theExprs.push(null);
        this.theSortSpecs.push(null);
    }

    @Override
    public void exitOrderby_clause(KVQLParser.Orderby_clauseContext ctx) {
        ArrayList<Expr> sortExprs = new ArrayList<Expr>();
        ArrayList<SortSpec> sortSpecs = new ArrayList<SortSpec>();
        Expr expr = this.theExprs.pop();
        SortSpec spec = this.theSortSpecs.pop();
        while (expr != null) {
            sortExprs.add(expr);
            sortSpecs.add(spec);
            expr = this.theExprs.pop();
            spec = this.theSortSpecs.pop();
        }
        Collections.reverse(sortExprs);
        Collections.reverse(sortSpecs);
        ExprSFW sfw = (ExprSFW)this.theExprs.peek();
        sfw.addSortClause(sortExprs, sortSpecs);
        sfw.analyseOrderOrGroupBy(true);
    }

    @Override
    public void enterSort_spec(KVQLParser.Sort_specContext ctx) {
        boolean desc = false;
        boolean nullsFirst = false;
        if (ctx.DESC() != null) {
            desc = true;
        }
        if (ctx.NULLS() == null) {
            nullsFirst = desc;
        } else if (ctx.FIRST() != null) {
            nullsFirst = true;
        }
        this.theSortSpecs.push(new SortSpec(desc, nullsFirst));
    }

    @Override
    public void exitLimit_clause(KVQLParser.Limit_clauseContext ctx) {
        Expr limitExpr = null;
        limitExpr = this.theExprs.pop();
        ExprSFW sfwExpr = (ExprSFW)this.theExprs.peek();
        sfwExpr.addLimit(limitExpr);
    }

    @Override
    public void exitOffset_clause(KVQLParser.Offset_clauseContext ctx) {
        Expr offsetExpr = null;
        offsetExpr = this.theExprs.pop();
        ExprSFW sfwExpr = (ExprSFW)this.theExprs.peek();
        sfwExpr.addOffset(offsetExpr);
    }

    @Override
    public void enterCase_expr(KVQLParser.Case_exprContext ctx) {
        this.theExprs.push(null);
    }

    @Override
    public void exitCase_expr(KVQLParser.Case_exprContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        if (ctx.ELSE() != null) {
            exprs.add(this.theExprs.pop());
        }
        Expr expr = this.theExprs.pop();
        while (expr != null) {
            exprs.add(expr);
            expr = this.theExprs.pop();
        }
        Collections.reverse(exprs);
        ExprCase caseExpr = new ExprCase(this.theQCB, this.theInitSctx, loc, exprs);
        this.theExprs.push(caseExpr);
    }

    @Override
    public void exitOr_expr(KVQLParser.Or_exprContext ctx) {
        ExprFuncCall fnCall;
        if (ctx.OR() == null) {
            return;
        }
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr op2 = this.theExprs.pop();
        Expr op1 = this.theExprs.pop();
        ArrayList<Expr> args = new ArrayList<Expr>(2);
        if (op1.getKind() == Expr.ExprKind.FUNC_CALL) {
            fnCall = (ExprFuncCall)op1;
            if (fnCall.getFunction().getCode() == FunctionLib.FuncCode.OP_OR) {
                this.flattenAndOrArgs(fnCall.getChildren(), args);
            } else {
                args.add(op1);
            }
        } else {
            args.add(op1);
        }
        if (op2.getKind() == Expr.ExprKind.FUNC_CALL) {
            fnCall = (ExprFuncCall)op2;
            if (fnCall.getFunction().getCode() == FunctionLib.FuncCode.OP_OR) {
                this.flattenAndOrArgs(fnCall.getChildren(), args);
            } else {
                args.add(op2);
            }
        } else {
            args.add(op2);
        }
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_OR), args);
        this.theExprs.push(expr);
    }

    @Override
    public void exitAnd_expr(KVQLParser.And_exprContext ctx) {
        ExprFuncCall fnCall;
        if (ctx.AND() == null) {
            return;
        }
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr op2 = this.theExprs.pop();
        Expr op1 = this.theExprs.pop();
        ArrayList<Expr> args = new ArrayList<Expr>(2);
        if (op1.getKind() == Expr.ExprKind.FUNC_CALL) {
            fnCall = (ExprFuncCall)op1;
            if (fnCall.getFunction().getCode() == FunctionLib.FuncCode.OP_AND) {
                this.flattenAndOrArgs(fnCall.getChildren(), args);
            } else {
                args.add(op1);
            }
        } else {
            args.add(op1);
        }
        if (op2.getKind() == Expr.ExprKind.FUNC_CALL) {
            fnCall = (ExprFuncCall)op2;
            if (fnCall.getFunction().getCode() == FunctionLib.FuncCode.OP_AND) {
                this.flattenAndOrArgs(fnCall.getChildren(), args);
            } else {
                args.add(op2);
            }
        } else {
            args.add(op2);
        }
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_AND), args);
        this.theExprs.push(expr);
    }

    private void flattenAndOrArgs(Expr.ExprIter children, List<Expr> args) {
        while (children.hasNext()) {
            Expr arg = children.next();
            children.remove(false);
            args.add(arg);
        }
        children.reset();
    }

    @Override
    public void exitNot_expr(KVQLParser.Not_exprContext ctx) {
        if (ctx.NOT() == null) {
            return;
        }
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr input = this.theExprs.pop();
        ArrayList<Expr> args = new ArrayList<Expr>(1);
        args.add(input);
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_NOT), args);
        this.theExprs.push(expr);
    }

    @Override
    public void exitIs_null_expr(KVQLParser.Is_null_exprContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        if (ctx.NULL() == null) {
            return;
        }
        Function func = ctx.NOT() != null ? this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_IS_NOT_NULL) : this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_IS_NULL);
        Expr input = this.theExprs.pop();
        ArrayList<Expr> args = new ArrayList<Expr>(1);
        args.add(input);
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func, args);
        this.theExprs.push(expr);
    }

    @Override
    public void exitExists_expr(KVQLParser.Exists_exprContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        Function func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_EXISTS);
        Expr input = this.theExprs.pop();
        ArrayList<Expr> args = new ArrayList<Expr>(1);
        args.add(input);
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func, args);
        this.theExprs.push(expr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void exitComp_expr(KVQLParser.Comp_exprContext ctx) {
        Function func;
        QueryException.Location loc = Translator.getLocation(ctx);
        KVQLParser.Comp_opContext cmpctx = ctx.comp_op();
        KVQLParser.Any_opContext anyctx = ctx.any_op();
        if (cmpctx == null && anyctx == null) {
            return;
        }
        Expr op2 = this.theExprs.pop();
        Expr op1 = this.theExprs.pop();
        if (cmpctx != null) {
            if (cmpctx.EQ() != null) {
                func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_EQ);
            } else if (cmpctx.NEQ() != null) {
                func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_NEQ);
            } else if (cmpctx.GT() != null) {
                func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_GT);
            } else if (cmpctx.GTE() != null) {
                func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_GE);
            } else if (cmpctx.LT() != null) {
                func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_LT);
            } else {
                if (cmpctx.LTE() == null) throw new QueryException("Unexpected comparison operator: " + cmpctx.getText(), loc);
                func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_LE);
            }
        } else if (anyctx.EQ_ANY() != null) {
            func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_EQ_ANY);
        } else if (anyctx.NEQ_ANY() != null) {
            func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_NEQ_ANY);
        } else if (anyctx.GT_ANY() != null) {
            func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_GT_ANY);
        } else if (anyctx.GTE_ANY() != null) {
            func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_GE_ANY);
        } else if (anyctx.LT_ANY() != null) {
            func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_LT_ANY);
        } else {
            if (anyctx.LTE_ANY() == null) throw new QueryException("Unexpected comparison operator: " + anyctx.getText(), loc);
            func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_LE_ANY);
        }
        ArrayList<Expr> args = new ArrayList<Expr>(2);
        args.add(op1);
        args.add(op2);
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func, args);
        this.theExprs.push(expr);
    }

    @Override
    public void enterQuantified_type_def(KVQLParser.Quantified_type_defContext ctx) {
        if (ctx.PLUS() != null) {
            this.theQuantifiers.push(ExprType.Quantifier.PLUS);
        } else if (ctx.STAR() != null) {
            this.theQuantifiers.push(ExprType.Quantifier.STAR);
        } else if (ctx.QUESTION_MARK() != null) {
            this.theQuantifiers.push(ExprType.Quantifier.QSTN);
        } else {
            this.theQuantifiers.push(ExprType.Quantifier.ONE);
        }
    }

    @Override
    public void exitIs_of_type_expr(KVQLParser.Is_of_type_exprContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr input = this.theExprs.pop();
        boolean notFlag = ctx.NOT() != null;
        int numTypes = ctx.quantified_type_def().size();
        ArrayList<FieldDef> types = new ArrayList<FieldDef>(numTypes);
        ArrayList<ExprType.Quantifier> quantifiers = new ArrayList<ExprType.Quantifier>(numTypes);
        ArrayList<Boolean> onlyFlags = new ArrayList<Boolean>(numTypes);
        for (int i = 0; i < numTypes; ++i) {
            FieldDefImpl typeDef = this.theTypes.pop();
            ExprType.Quantifier typeQuantifier = this.theQuantifiers.pop();
            types.add(typeDef);
            quantifiers.add(typeQuantifier);
            onlyFlags.add(ctx.ONLY(i) != null);
        }
        ExprIsOfType expr = new ExprIsOfType(this.theQCB, this.theInitSctx, loc, input, notFlag, types, quantifiers, onlyFlags);
        this.theExprs.push(expr);
    }

    @Override
    public void exitCast_expr(KVQLParser.Cast_exprContext ctx) {
        Expr input = this.theExprs.pop();
        FieldDefImpl typeDefImpl = this.theTypes.pop();
        ExprType.Quantifier typeQuantifier = this.theQuantifiers.pop();
        Expr expr = ExprCast.create(this.theQCB, this.theInitSctx, Translator.getLocation(ctx), input, typeDefImpl, typeQuantifier);
        this.theExprs.push(expr);
    }

    @Override
    public void exitExtract_expr(KVQLParser.Extract_exprContext ctx) {
        FuncExtractFromTimestamp.Unit unit;
        QueryException.Location loc = Translator.getLocation(ctx);
        String text = ctx.id().getText();
        try {
            unit = FuncExtractFromTimestamp.Unit.valueOf(text.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new QueryException("Unrecognized unit: " + text, loc);
        }
        FunctionLib.FuncCode funcCode = FunctionLib.FuncCode.values()[FunctionLib.FuncCode.FN_YEAR.ordinal() + unit.ordinal()];
        Function func = this.theFuncLib.getFunc(funcCode);
        Expr input = this.theExprs.pop();
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func, input);
        this.theExprs.push(expr);
    }

    @Override
    public void exitAdd_expr(KVQLParser.Add_exprContext ctx) {
        if (ctx.PLUS().isEmpty() && ctx.MINUS().isEmpty()) {
            return;
        }
        QueryException.Location loc = Translator.getLocation(ctx);
        Function func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_ADD_SUB);
        String operations = "";
        ArrayList<Expr> args = new ArrayList<Expr>(ctx.getChildCount() / 2 + 2);
        for (int c = ctx.getChildCount() - 1; c >= 0; c -= 2) {
            ParseTree pt = ctx.getChild(c);
            if (pt instanceof RuleNode) {
                Expr op = this.theExprs.pop();
                if (c > 0) {
                    ParseTree ptOp = ctx.getChild(c - 1);
                    if (ptOp instanceof TerminalNode) {
                        int tokenId = ((TerminalNode)ptOp).getSymbol().getType();
                        if (tokenId == 163) {
                            operations = "+" + operations;
                            args.add(op);
                            continue;
                        }
                        if (tokenId == 164) {
                            operations = "-" + operations;
                            args.add(op);
                            continue;
                        }
                        throw new QueryStateException("Unexpected arithmetic operator in: " + ctx.getText());
                    }
                    throw new QueryStateException("Unexpected arithmetic parse tree in: " + ctx.getText());
                }
                operations = "+" + operations;
                args.add(op);
                continue;
            }
            throw new QueryStateException("Unexpected arithmetic parse tree in: " + ctx.getText());
        }
        Collections.reverse(args);
        StringValueImpl ops = FieldDefImpl.stringDef.createString(operations);
        args.add(new ExprConst(this.theQCB, this.theInitSctx, loc, ops));
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func, args);
        this.theExprs.push(expr);
    }

    @Override
    public void exitMultiply_expr(KVQLParser.Multiply_exprContext ctx) {
        if (ctx.STAR().isEmpty() && ctx.DIV().isEmpty()) {
            return;
        }
        QueryException.Location loc = Translator.getLocation(ctx);
        Function func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_MULT_DIV);
        String operations = "";
        ArrayList<Expr> args = new ArrayList<Expr>(ctx.getChildCount() / 2 + 2);
        for (int c = ctx.getChildCount() - 1; c >= 0; c -= 2) {
            ParseTree pt = ctx.getChild(c);
            if (pt instanceof RuleNode) {
                Expr op = this.theExprs.pop();
                if (c > 0) {
                    ParseTree ptOp = ctx.getChild(c - 1);
                    if (ptOp instanceof TerminalNode) {
                        int tokenId = ((TerminalNode)ptOp).getSymbol().getType();
                        if (tokenId == 147) {
                            operations = "*" + operations;
                            args.add(op);
                            continue;
                        }
                        if (tokenId == 165) {
                            operations = "/" + operations;
                            args.add(op);
                            continue;
                        }
                        throw new QueryStateException("Unexpected arithmetic operator in: " + ctx.getText());
                    }
                    throw new QueryStateException("Unexpected arithmetic parse tree in: " + ctx.getText());
                }
                operations = "*" + operations;
                args.add(op);
                continue;
            }
            throw new QueryStateException("Unexpected arithmetic parse tree in: " + ctx.getText());
        }
        Collections.reverse(args);
        StringValueImpl ops = FieldDefImpl.stringDef.createString(operations);
        args.add(new ExprConst(this.theQCB, this.theInitSctx, loc, ops));
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func, args);
        this.theExprs.push(expr);
    }

    @Override
    public void exitUnary_expr(KVQLParser.Unary_exprContext ctx) {
        FieldValueImpl val;
        if (ctx.MINUS() == null) {
            return;
        }
        QueryException.Location loc = Translator.getLocation(ctx);
        Function func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_ARITH_UNARY);
        Expr op = this.theExprs.pop();
        if (op.getKind() == Expr.ExprKind.CONST && !(val = ((ExprConst)op).getValue()).isNull()) {
            FieldValueImpl negVal = ArithUnaryOpIter.getNegativeOfValue(val, Translator.getLocation(ctx));
            ExprConst expr = new ExprConst(this.theQCB, this.theInitSctx, loc, negVal);
            this.theExprs.push(expr);
            return;
        }
        ArrayList<Expr> args = new ArrayList<Expr>(1);
        args.add(op);
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func, args);
        this.theExprs.push(expr);
    }

    @Override
    public void exitPath_expr(KVQLParser.Path_exprContext ctx) {
        Expr expr = this.theExprs.peek();
        if (!expr.isStepExpr()) {
            return;
        }
        IndexExpr.create(expr);
    }

    @Override
    public void enterMap_field_step(KVQLParser.Map_field_stepContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr inputExpr = this.theExprs.pop();
        ExprVar ctxItemVar = null;
        ExprFieldStep step = new ExprFieldStep(this.theQCB, this.theInitSctx, loc, inputExpr);
        if (ctx.id() == null && ctx.string() == null) {
            ctxItemVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$", step);
            step.addCtxVars(ctxItemVar);
            this.pushScope();
            this.theSctx.addVariable(ctxItemVar);
        }
        this.theExprs.push(step);
    }

    @Override
    public void exitMap_field_step(KVQLParser.Map_field_stepContext ctx) {
        String fieldName = null;
        Expr fieldNameExpr = null;
        if (ctx.id() != null) {
            fieldName = ctx.id().getText();
        } else if (ctx.string() != null) {
            fieldName = Translator.stripFirstLast(ctx.string().getText());
            fieldName = EscapeUtil.inlineEscapedChars(fieldName);
        } else {
            fieldNameExpr = this.theExprs.pop();
        }
        ExprFieldStep step = (ExprFieldStep)this.theExprs.peek();
        step.addFieldNameExpr(fieldName, fieldNameExpr);
        if (ctx.id() == null && ctx.string() == null) {
            this.popScope();
        }
    }

    @Override
    public void enterMap_filter_step(KVQLParser.Map_filter_stepContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        ExprMapFilter.FilterKind kind = ctx.KEYS() != null ? ExprMapFilter.FilterKind.KEYS : ExprMapFilter.FilterKind.VALUES;
        Expr inputExpr = this.theExprs.pop();
        ExprMapFilter step = new ExprMapFilter(this.theQCB, this.theInitSctx, loc, kind, inputExpr);
        if (ctx.expr() != null) {
            ExprVar ctxItemVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$", step);
            ExprVar ctxElemVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$value", step);
            ExprVar ctxKeyVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$key", step);
            step.addCtxVars(ctxItemVar, ctxElemVar, ctxKeyVar);
            this.pushScope();
            this.theSctx.addVariable(ctxItemVar);
            this.theSctx.addVariable(ctxElemVar);
            this.theSctx.addVariable(ctxKeyVar);
        }
        this.theExprs.push(step);
    }

    @Override
    public void exitMap_filter_step(KVQLParser.Map_filter_stepContext ctx) {
        Expr predExpr = null;
        if (ctx.expr() != null) {
            predExpr = this.theExprs.pop();
            ExprMapFilter filterStep = (ExprMapFilter)this.theExprs.peek();
            filterStep.addPredExpr(predExpr);
            this.popScope();
        }
    }

    @Override
    public void enterArray_slice_step(KVQLParser.Array_slice_stepContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr inputExpr = this.theExprs.pop();
        ExprVar ctxItemVar = null;
        ExprArraySlice step = new ExprArraySlice(this.theQCB, this.theInitSctx, loc, inputExpr);
        assert (ctx.COLON() != null);
        ctxItemVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$", step);
        step.addCtxVars(ctxItemVar);
        this.pushScope();
        this.theSctx.addVariable(ctxItemVar);
        this.theExprs.push(step);
    }

    @Override
    public void exitArray_slice_step(KVQLParser.Array_slice_stepContext ctx) {
        Expr lowExpr = null;
        Expr highExpr = null;
        List<KVQLParser.ExprContext> args = ctx.expr();
        if (args.size() == 2) {
            highExpr = this.theExprs.pop();
            lowExpr = this.theExprs.pop();
        } else if (args.size() == 1) {
            if (ctx.getChild(1) instanceof KVQLParser.ExprContext) {
                lowExpr = this.theExprs.pop();
            } else {
                highExpr = this.theExprs.pop();
            }
        }
        ExprArraySlice step = (ExprArraySlice)this.theExprs.peek();
        step.addBoundaryExprs(lowExpr, highExpr);
        this.popScope();
    }

    @Override
    public void enterArray_filter_step(KVQLParser.Array_filter_stepContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr inputExpr = this.theExprs.pop();
        ExprArrayFilter step = new ExprArrayFilter(this.theQCB, this.theInitSctx, loc, inputExpr);
        if (ctx.expr() != null) {
            ExprVar ctxItemVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$", step);
            ExprVar ctxElemVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$element", step);
            ExprVar ctxElemPosVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$pos", step);
            step.addCtxVars(ctxItemVar, ctxElemVar, ctxElemPosVar);
            this.pushScope();
            this.theSctx.addVariable(ctxItemVar);
            this.theSctx.addVariable(ctxElemVar);
            this.theSctx.addVariable(ctxElemPosVar);
        }
        this.theExprs.push(step);
    }

    @Override
    public void exitArray_filter_step(KVQLParser.Array_filter_stepContext ctx) {
        ExprArrayFilter filterStep;
        Expr predExpr = null;
        if (ctx.expr() != null) {
            predExpr = this.theExprs.pop();
            filterStep = (ExprArrayFilter)this.theExprs.pop();
            filterStep.addPredExpr(predExpr);
            this.popScope();
        } else {
            filterStep = (ExprArrayFilter)this.theExprs.pop();
        }
        Expr expr = filterStep.convertToSliceStep();
        this.theExprs.push(expr);
    }

    @Override
    public void enterArray_constructor(KVQLParser.Array_constructorContext ctx) {
        this.theExprs.push(null);
    }

    @Override
    public void exitArray_constructor(KVQLParser.Array_constructorContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        ArrayList<Expr> inputs = new ArrayList<Expr>();
        Expr input = this.theExprs.pop();
        while (input != null) {
            inputs.add(input);
            input = this.theExprs.pop();
        }
        Collections.reverse(inputs);
        ExprArrayConstr arrayConstr = new ExprArrayConstr(this.theQCB, this.theInitSctx, loc, inputs, false);
        this.theExprs.push(arrayConstr);
    }

    @Override
    public void enterMap_constructor(KVQLParser.Map_constructorContext ctx) {
        this.theExprs.push(null);
    }

    @Override
    public void exitMap_constructor(KVQLParser.Map_constructorContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        ArrayList<Expr> inputs = new ArrayList<Expr>();
        Expr input = this.theExprs.pop();
        while (input != null) {
            inputs.add(input);
            input = this.theExprs.pop();
        }
        Collections.reverse(inputs);
        ExprMapConstr mapConstr = new ExprMapConstr(this.theQCB, this.theInitSctx, loc, inputs);
        this.theExprs.push(mapConstr);
    }

    @Override
    public void enterTransform_expr(KVQLParser.Transform_exprContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        ExprSeqMap seqMap = new ExprSeqMap(this.theQCB, this.theInitSctx, loc);
        this.theExprs.push(seqMap);
    }

    @Override
    public void exitTransform_input_expr(KVQLParser.Transform_input_exprContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr inExpr = this.theExprs.pop();
        ExprSeqMap seqMap = (ExprSeqMap)this.theExprs.peek();
        seqMap.addInputExpr(inExpr);
        ExprVar ctxItemVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$", seqMap);
        seqMap.addCtxVar(ctxItemVar);
        this.pushScope();
        this.theSctx.addVariable(ctxItemVar);
    }

    @Override
    public void exitTransform_expr(KVQLParser.Transform_exprContext ctx) {
        Expr mapExpr = this.theExprs.pop();
        ExprSeqMap seqMap = (ExprSeqMap)this.theExprs.peek();
        seqMap.addMapExpr(mapExpr);
        this.popScope();
    }

    @Override
    public void enterFunc_call(KVQLParser.Func_callContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        Function func = this.theSctx.findFunction(ctx.id().getText(), 1);
        if (func != null && func.isAggregate()) {
            if (!this.theAggrFunctions.isEmpty()) {
                throw new QueryException("Aggregate functions cannot be nested", loc);
            }
            if (this.theSFWExprs.size() != this.theInSelectClause.size()) {
                throw new QueryException("Aggregate functions can appear in SELECT clause only", loc);
            }
            this.theAggrFunctions.push(func);
        }
        this.theExprs.push(null);
    }

    @Override
    public void exitFunc_call(KVQLParser.Func_callContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        ArrayList<Expr> inputs = new ArrayList<Expr>();
        Expr input = this.theExprs.pop();
        while (input != null) {
            inputs.add(input);
            input = this.theExprs.pop();
        }
        Collections.reverse(inputs);
        Function func = this.theSctx.findFunction(ctx.id().getText(), inputs.size());
        if (func == null) {
            throw new QueryException("Could not find function with name " + ctx.id().getText() + " and arity " + inputs.size(), loc);
        }
        if (func.isAggregate()) {
            this.theAggrFunctions.pop();
            ExprSFW sfw = this.theSFWExprs.peek();
            sfw.setNumGroupByExprs(0);
        }
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func, inputs);
        if (func.getCode() == FunctionLib.FuncCode.FN_GEO_NEAR) {
            if (this.theSFWExprs.size() != this.theInWhereClause.size()) {
                throw new QueryException("The geo_near function can appear in WHERE clause only", loc);
            }
            Expr prevNear = this.theNearExprs.peek();
            if (prevNear != null) {
                throw new QueryException("There can be at most one geo_near function in the WHERE clause", loc);
            }
            this.theNearExprs.set(this.theNearExprs.size() - 1, expr);
        }
        this.theExprs.push(expr);
    }

    @Override
    public void enterCount_star(KVQLParser.Count_starContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        if (!this.theAggrFunctions.isEmpty()) {
            throw new QueryException("Aggregate functions cannot be nested", loc);
        }
        if (this.theSFWExprs.size() != this.theInSelectClause.size()) {
            throw new QueryException("Aggregate functions can appear in SELECT clause only", loc);
        }
        ExprSFW sfw = this.theSFWExprs.peek();
        sfw.setNumGroupByExprs(0);
        Function func = this.theSctx.findFunction("count(*)", 0);
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func);
        this.theExprs.push(expr);
    }

    @Override
    public void exitVar_ref(KVQLParser.Var_refContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        String varName = ctx.getText();
        ExprVar varExpr = this.theScopes.peek().findVariable(varName);
        if (varExpr == null) {
            if (!this.theAllowUndeclaredVars) {
                throw new QueryException(" Unknown variable " + varName, Translator.getLocation(ctx));
            }
            varExpr = new ExprVar(this.theQCB, this.theInitSctx, loc, varName, FieldDefImpl.anyDef, this.theExternalVarsCounter++);
            this.theInitSctx.addVariable(varExpr);
        }
        this.theExprs.push(varExpr);
    }

    @Override
    public void exitColumn_ref(KVQLParser.Column_refContext ctx) {
        int i;
        String colName;
        QueryException.Location loc = Translator.getLocation(ctx);
        List<KVQLParser.IdContext> ids = ctx.id();
        String tableAlias = null;
        boolean found = false;
        if (ids.size() == 1) {
            colName = ids.get(0).getText();
            for (i = 0; i < this.theTables.size(); ++i) {
                if (this.theTables.get(i).getField(colName) == null) continue;
                if (found) {
                    throw new QueryException("The reference to column " + colName + " is ambiguous because more than one tables has a column with this name", loc);
                }
                found = true;
                tableAlias = this.theTableAliases.get(i);
            }
        } else {
            assert (ids.size() == 2);
            colName = ids.get(1).getText();
            tableAlias = ids.get(0).getText();
            for (i = 0; i < this.theTables.size(); ++i) {
                if (!this.theTableAliases.get(i).equals(tableAlias) || this.theTables.get(i).getField(colName) == null) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new QueryException("No table in the FROM clause has a column named " + colName, loc);
        }
        if (tableAlias == null) {
            throw new QueryStateException("No tables in FROM clause!");
        }
        String varName = tableAlias.charAt(0) == '$' ? tableAlias : "$$" + tableAlias;
        ExprVar varExpr = this.theScopes.peek().findVariable(varName);
        if (varExpr == null) {
            throw new QueryException("Table alias " + tableAlias + " cannot be referenced at this location", loc);
        }
        ExprFieldStep expr = new ExprFieldStep(this.theQCB, this.theInitSctx, loc, (Expr)varExpr, colName);
        this.theExprs.push(expr);
    }

    @Override
    public void exitConst_expr(KVQLParser.Const_exprContext ctx) {
        FieldValue value;
        QueryException.Location loc;
        block14: {
            loc = Translator.getLocation(ctx);
            try {
                Object val;
                if (ctx.number() != null) {
                    String numberString = ctx.number().getText();
                    try {
                        if (ctx.number().INT() != null) {
                            Long val2 = Long.parseLong(numberString);
                            value = Integer.MIN_VALUE <= val2 && val2 <= Integer.MAX_VALUE ? FieldDefImpl.integerDef.createInteger(val2.intValue()) : FieldDefImpl.longDef.createLong(val2);
                            break block14;
                        }
                        if (ctx.number().FLOAT() != null) {
                            Double val3 = Double.parseDouble(numberString);
                            value = FieldDefImpl.doubleDef.createDouble(val3);
                            if (val3.isInfinite()) {
                                value = FieldValueFactory.createNumber(new BigDecimal(numberString));
                            }
                            break block14;
                        }
                        numberString = Translator.stripNumericLetter(numberString);
                        value = FieldValueFactory.createNumber(new BigDecimal(numberString));
                    }
                    catch (NumberFormatException nfe) {
                        value = FieldValueFactory.createNumber(new BigDecimal(numberString));
                    }
                    break block14;
                }
                if (ctx.TRUE() != null) {
                    val = Boolean.parseBoolean(ctx.TRUE().getText());
                    value = FieldDefImpl.booleanDef.createBoolean((Boolean)val);
                } else if (ctx.FALSE() != null) {
                    val = Boolean.parseBoolean(ctx.FALSE().getText());
                    value = FieldDefImpl.booleanDef.createBoolean((Boolean)val);
                } else if (ctx.NULL() != null) {
                    value = NullJsonValueImpl.getInstance();
                } else {
                    val = Translator.stripFirstLast(ctx.string().getText());
                    val = EscapeUtil.inlineEscapedChars((String)val);
                    value = FieldDefImpl.stringDef.createString((String)val);
                }
            }
            catch (NumberFormatException nfe) {
                throw new QueryException("Invalid numeric literal: " + ctx.getText(), loc);
            }
        }
        ExprConst constExpr = new ExprConst(this.theQCB, this.theInitSctx, loc, (FieldValueImpl)value);
        this.theExprs.push(constExpr);
    }

    private static String stripNumericLetter(String numberString) {
        char lastChar = numberString.charAt(numberString.length() - 1);
        if (lastChar == 'n' || lastChar == 'N') {
            numberString = numberString.substring(0, numberString.length() - 1);
        }
        return numberString;
    }

    @Override
    public void enterInsert_statement(KVQLParser.Insert_statementContext ctx) {
        this.pushScope();
        this.theAllowUndeclaredVars = true;
        String namespace = this.computeNamespace(ctx.table_name());
        String[] tableName = Translator.getNamePath(ctx.table_name().id_path());
        QueryException.Location loc = Translator.getLocation(ctx);
        TableImpl table = this.getTable(namespace, tableName, loc);
        if (table == null) {
            throw new QueryException("Table " + NameUtils.makeQualifiedName(namespace, Translator.concatPathName(tableName)) + " does not exist", loc);
        }
        this.theQCB.setTargetTable(table);
        String tableAlias = ctx.tab_alias() == null ? Translator.concatPathName(tableName) : ctx.tab_alias().getText();
        this.theTables.add(table);
        this.theTableAliases.add(tableAlias);
        RecordDefImpl rowDef = table.getRowDef();
        ArrayList<Integer> colPositions = null;
        List<KVQLParser.IdContext> idCtxList = ctx.id();
        if (idCtxList != null && !idCtxList.isEmpty()) {
            colPositions = new ArrayList<Integer>(idCtxList.size());
            for (int i = 0; i < idCtxList.size(); ++i) {
                KVQLParser.IdContext idctx = idCtxList.get(i);
                String name = idctx.getText();
                try {
                    colPositions.add(rowDef.getFieldPos(name));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new QueryException("Table " + table.getFullName() + " does not have a column named " + name, Translator.getLocation(idctx));
                }
            }
        }
        ExprInsertRow ins = new ExprInsertRow(this.theQCB, this.theInitSctx, loc, table, colPositions, ctx.UPSERT() != null, ctx.insert_returning_clause() != null);
        this.theExprs.push(ins);
    }

    @Override
    public void exitInsert_statement(KVQLParser.Insert_statementContext ctx) {
        this.theRootExpr = this.theExprs.pop();
        if (this.theRootExpr.getKind() == Expr.ExprKind.INSERT_ROW) {
            ((ExprInsertRow)this.theRootExpr).validate();
        }
        assert (this.theRootExpr != null);
        assert (this.theExprs.isEmpty());
        assert (this.theColNames.isEmpty());
        assert (this.theTypes.isEmpty());
        this.theAllowUndeclaredVars = false;
        this.popScope();
    }

    @Override
    public void exitInsert_clause(KVQLParser.Insert_clauseContext ctx) {
        if (ctx.DEFAULT() == null) {
            Expr valExpr = this.theExprs.pop();
            ExprInsertRow ins = (ExprInsertRow)this.theExprs.peek();
            ins.addInsertClause(valExpr, Translator.getLocation(ctx));
        } else {
            ExprInsertRow ins = (ExprInsertRow)this.theExprs.peek();
            ins.addInsertClause(null, Translator.getLocation(ctx));
        }
    }

    @Override
    public void exitInsert_ttl_clause(KVQLParser.Insert_ttl_clauseContext ctx) {
        Expr.UpdateKind ttlKind;
        ExprInsertRow ins;
        Expr ttlExpr = null;
        if (ctx.USING() != null) {
            ins = (ExprInsertRow)this.theExprs.peek();
            ttlKind = Expr.UpdateKind.TTL_TABLE;
        } else {
            ttlExpr = this.theExprs.pop();
            ttlExpr = ExprPromote.create(null, ttlExpr, TypeManager.NUMBER_QSTN());
            ins = (ExprInsertRow)this.theExprs.peek();
            ttlKind = ctx.HOURS() != null ? Expr.UpdateKind.TTL_HOURS : Expr.UpdateKind.TTL_DAYS;
        }
        ins.addTTLClause(ttlExpr, ttlKind);
    }

    @Override
    public void enterInsert_returning_clause(KVQLParser.Insert_returning_clauseContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        ExprInsertRow ins = (ExprInsertRow)this.theExprs.pop();
        ins.validate();
        ExprSFW returningSFW = new ExprSFW(this.theQCB, this.theInitSctx, loc);
        TableImpl table = ins.getTable();
        String varName = ExprVar.createVarNameFromTableAlias(this.theTableAliases.get(0));
        ExprVar var = returningSFW.createTableVar(ins, table, varName);
        this.theSctx.addVariable(var);
        this.theExprs.push(returningSFW);
    }

    @Override
    public void enterDelete_statement(KVQLParser.Delete_statementContext ctx) {
        TableImpl table;
        this.pushScope();
        String namespace = this.computeNamespace(ctx.table_name());
        String[] tableName = Translator.getNamePath(ctx.table_name().id_path());
        QueryException.Location loc = Translator.getLocation(ctx.table_name());
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.DELETE);
            this.theQCB.getPrepareCallback().namespaceName(namespace);
            this.theQCB.getPrepareCallback().tableName(Translator.concatPathName(tableName));
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        if ((table = this.getTable(namespace, tableName, loc)) == null) {
            throw new QueryException("Table " + NameUtils.makeQualifiedName(namespace, Translator.concatPathName(tableName)) + " does not exist", loc);
        }
        this.theQCB.setTargetTable(table);
        String tableAlias = ctx.tab_alias() == null ? Translator.concatPathName(tableName) : ctx.tab_alias().getText();
        this.theTables.add(table);
        this.theTableAliases.add(tableAlias);
        String varName = ExprVar.createVarNameFromTableAlias(tableAlias);
        ExprBaseTable tableExpr = new ExprBaseTable(this.theQCB, this.theInitSctx, loc);
        tableExpr.addTable(table, tableAlias, false, false, loc);
        tableExpr.finalizeTables();
        tableExpr.setIsDelete();
        ExprSFW sfw = new ExprSFW(this.theQCB, this.theInitSctx, loc);
        ExprVar var = sfw.createTableVar(tableExpr, table, varName);
        this.theSctx.addVariable(var);
        if (ctx.delete_returning_clause() == null) {
            sfw.addPrimKeyToSelect();
            ExprDeleteRow del = new ExprDeleteRow(this.theQCB, this.theInitSctx, loc, sfw, false);
            this.theExprs.push(del);
        } else {
            this.theExprs.push(sfw);
        }
    }

    @Override
    public void exitDelete_statement(KVQLParser.Delete_statementContext ctx) {
        this.popScope();
        if (ctx.delete_returning_clause() == null) {
            Expr whereCond = null;
            if (ctx.WHERE() != null) {
                whereCond = this.theExprs.pop();
            }
            ExprDeleteRow del = (ExprDeleteRow)this.theExprs.pop();
            ExprSFW inputSFW = (ExprSFW)del.getInput();
            if (whereCond != null) {
                inputSFW.addWhereClause(whereCond);
            }
            this.theRootExpr = del;
            return;
        }
        QueryException.Location loc = Translator.getLocation(ctx);
        ExprSFW inputSFW = (ExprSFW)this.theExprs.pop();
        int numFields = inputSFW.getNumFields();
        int[] primKeyPositions = inputSFW.addPrimKeyToSelect();
        ExprDeleteRow del = new ExprDeleteRow(this.theQCB, this.theInitSctx, loc, inputSFW, true);
        del.addPrimKeyPositions(primKeyPositions);
        if (numFields == inputSFW.getNumFields()) {
            this.theRootExpr = del;
            return;
        }
        this.pushScope();
        ExprSFW returningSFW = new ExprSFW(this.theQCB, this.theInitSctx, loc);
        ExprVar tableVar = inputSFW.getFromClause(0).getTargetTableVar();
        String varName = tableVar.getName();
        ExprVar var = returningSFW.createFromVar(del, varName);
        this.theSctx.addVariable(var);
        for (int i = 0; i < numFields; ++i) {
            Expr inField = inputSFW.getFieldExpr(i);
            ExprFieldStep outField = new ExprFieldStep(this.theQCB, this.theInitSctx, inField.getLocation(), (Expr)var, i);
            returningSFW.addField(inputSFW.getFieldName(i), outField);
        }
        if (numFields == 1 && inputSFW.getFieldExpr(0) == tableVar) {
            returningSFW.setConstructsRecord(false);
        }
        this.theExprs.push(returningSFW);
        this.theRootExpr = returningSFW;
        this.popScope();
    }

    @Override
    public void enterDelete_returning_clause(KVQLParser.Delete_returning_clauseContext ctx) {
        Expr e = this.theExprs.peek();
        if (e.getKind() == Expr.ExprKind.SFW) {
            return;
        }
        Expr whereCond = this.theExprs.pop();
        ExprSFW sfw = (ExprSFW)this.theExprs.peek();
        sfw.addWhereClause(whereCond);
    }

    @Override
    public void enterUpdate_statement(KVQLParser.Update_statementContext ctx) {
        TableImpl table;
        this.pushScope();
        this.theAllowUndeclaredVars = true;
        String namespace = this.computeNamespace(ctx.table_name());
        String[] tableName = Translator.getNamePath(ctx.table_name().id_path());
        QueryException.Location loc = Translator.getLocation(ctx.table_name());
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.UPDATE);
            this.theQCB.getPrepareCallback().namespaceName(namespace);
            this.theQCB.getPrepareCallback().tableName(Translator.concatPathName(tableName));
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        if ((table = this.getTable(namespace, tableName, loc)) == null) {
            throw new QueryException("Table " + NameUtils.makeQualifiedName(namespace, Translator.concatPathName(tableName)) + " does not exist", loc);
        }
        this.theQCB.setTargetTable(table);
        String tableAlias = ctx.tab_alias() == null ? Translator.concatPathName(tableName) : ctx.tab_alias().getText();
        this.theTables.add(table);
        this.theTableAliases.add(tableAlias);
        String varName = ExprVar.createVarNameFromTableAlias(tableAlias);
        ExprBaseTable tableExpr = new ExprBaseTable(this.theQCB, this.theInitSctx, loc);
        tableExpr.addTable(table, tableAlias, false, false, loc);
        tableExpr.finalizeTables();
        tableExpr.addIndexHint(null, true, loc);
        tableExpr.setIsUpdate();
        ExprSFW sfw = new ExprSFW(this.theQCB, this.theInitSctx, loc);
        ExprVar var = sfw.createTableVar(tableExpr, table, varName);
        this.theSctx.addVariable(var);
        ArrayList<Expr> colExprs = new ArrayList<Expr>(1);
        ArrayList<String> colNames = new ArrayList<String>(1);
        colExprs.add(var);
        String varname = var.getName();
        if (varname.startsWith("$$")) {
            colNames.add(var.getName().substring(2));
        } else {
            colNames.add(var.getName().substring(1));
        }
        sfw.setConstructsRecord(false);
        sfw.addSelectClause(colNames, colExprs);
        ExprUpdateRow upd = new ExprUpdateRow(this.theQCB, this.theInitSctx, loc, sfw, table, ctx.update_returning_clause() != null);
        this.theExprs.push(upd);
        this.theExprs.push(null);
    }

    @Override
    public void exitUpdate_statement(KVQLParser.Update_statementContext ctx) {
        if (ctx.update_returning_clause() == null) {
            this.addWhereAndUpdateClauses();
        }
        this.popScope();
        this.theAllowUndeclaredVars = false;
        this.theRootExpr = this.theExprs.pop();
        assert (this.theRootExpr != null);
        assert (this.theExprs.isEmpty());
        assert (this.theColNames.isEmpty());
        assert (this.theTypes.isEmpty());
    }

    @Override
    public void enterUpdate_returning_clause(KVQLParser.Update_returning_clauseContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        this.addWhereAndUpdateClauses();
        this.popScope();
        this.pushScope();
        ExprUpdateRow upd = (ExprUpdateRow)this.theExprs.pop();
        ExprSFW inputSFW = (ExprSFW)upd.getInput();
        ExprSFW returningSFW = new ExprSFW(this.theQCB, this.theInitSctx, loc);
        String varName = inputSFW.getFromClause(0).getTargetTableVar().getName();
        TableImpl table = upd.getTable();
        ExprVar var = returningSFW.createTableVar(upd, table, varName);
        this.theSctx.addVariable(var);
        this.theExprs.push(returningSFW);
    }

    private void addWhereAndUpdateClauses() {
        ArrayList<Expr> clauses = new ArrayList<Expr>();
        ExprUpdateField ttlClause = null;
        Expr whereCond = this.theExprs.pop();
        ExprUpdateField clause = (ExprUpdateField)this.theExprs.pop();
        while (clause != null) {
            if (clause.isTTLUpdate()) {
                if (ttlClause == null) {
                    ttlClause = clause;
                }
            } else {
                clauses.add(clause);
            }
            clause = (ExprUpdateField)this.theExprs.pop();
        }
        Collections.reverse(clauses);
        if (ttlClause != null) {
            clauses.add(ttlClause);
        }
        ExprUpdateRow updExpr = (ExprUpdateRow)this.theExprs.peek();
        updExpr.addUpdateClauses(clauses, ttlClause != null);
        ExprSFW inputSFW = (ExprSFW)updExpr.getInput();
        inputSFW.addWhereClause(whereCond);
    }

    @Override
    public void exitTtl_clause(KVQLParser.Ttl_clauseContext ctx) {
        ExprUpdateField upd;
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr ttlExpr = null;
        if (ctx.USING() != null) {
            upd = new ExprUpdateField(this.theQCB, this.theInitSctx, loc, ttlExpr);
            upd.setUpdateKind(Expr.UpdateKind.TTL_TABLE);
        } else {
            ttlExpr = this.theExprs.pop();
            ttlExpr = ExprPromote.create(null, ttlExpr, TypeManager.NUMBER_QSTN());
            upd = new ExprUpdateField(this.theQCB, this.theInitSctx, loc, ttlExpr);
            if (ctx.HOURS() != null) {
                upd.setUpdateKind(Expr.UpdateKind.TTL_HOURS);
            } else {
                upd.setUpdateKind(Expr.UpdateKind.TTL_DAYS);
            }
        }
        this.theExprs.push(upd);
    }

    @Override
    public void enterSet_clause(KVQLParser.Set_clauseContext ctx) {
        this.pushScope();
    }

    @Override
    public void exitSet_clause(KVQLParser.Set_clauseContext ctx) {
        Expr valueExpr = this.theExprs.pop();
        ExprUpdateField upd = (ExprUpdateField)this.theExprs.peek();
        upd.setUpdateKind(Expr.UpdateKind.SET);
        upd.addNewValueExpr(valueExpr);
        upd.removeTargetItemVar();
        this.popScope();
    }

    @Override
    public void enterAdd_clause(KVQLParser.Add_clauseContext ctx) {
        this.pushScope();
    }

    @Override
    public void exitAdd_clause(KVQLParser.Add_clauseContext ctx) {
        Expr valueExpr = this.theExprs.pop();
        Expr posExpr = null;
        if (ctx.pos_expr() != null) {
            posExpr = this.theExprs.pop();
        }
        ExprUpdateField upd = (ExprUpdateField)this.theExprs.peek();
        upd.setUpdateKind(Expr.UpdateKind.ADD);
        upd.addNewValueExpr(valueExpr);
        if (posExpr != null) {
            upd.addPosExpr(posExpr);
        }
        upd.removeTargetItemVar();
        this.popScope();
    }

    @Override
    public void enterPut_clause(KVQLParser.Put_clauseContext ctx) {
        this.pushScope();
    }

    @Override
    public void exitPut_clause(KVQLParser.Put_clauseContext ctx) {
        Expr valueExpr = this.theExprs.pop();
        ExprUpdateField upd = (ExprUpdateField)this.theExprs.peek();
        upd.setUpdateKind(Expr.UpdateKind.PUT);
        upd.addNewValueExpr(valueExpr);
        upd.removeTargetItemVar();
        this.popScope();
    }

    @Override
    public void enterRemove_clause(KVQLParser.Remove_clauseContext ctx) {
        this.pushScope();
    }

    @Override
    public void exitRemove_clause(KVQLParser.Remove_clauseContext ctx) {
        ExprUpdateField upd = (ExprUpdateField)this.theExprs.peek();
        upd.setUpdateKind(Expr.UpdateKind.REMOVE);
        upd.removeTargetItemVar();
        this.popScope();
    }

    @Override
    public void exitTarget_expr(KVQLParser.Target_exprContext ctx) {
        ExprFieldStep fieldStep;
        int fieldPos;
        Expr path;
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr step = path = this.theExprs.pop();
        Expr firstStep = null;
        int numSteps = 0;
        TableImpl targetTable = this.theTables.get(0);
        while (step != null) {
            ExprVar var;
            TableImpl table;
            if (step.isStepExpr()) {
                firstStep = step;
                step = step.getInput();
                ++numSteps;
                continue;
            }
            if (step.getKind() == Expr.ExprKind.VAR && (table = (var = (ExprVar)step).getTable()).getId() == targetTable.getId()) break;
            throw new QueryException("Target expression in update clause is not a path expression over a row of table " + targetTable.getFullName(), loc);
        }
        if (firstStep != null && firstStep.getKind() != Expr.ExprKind.FIELD_STEP) {
            throw new QueryException("Target expression in update clause does not start with a field step\n" + path.display(), loc);
        }
        if (numSteps == 1 && path.getKind() == Expr.ExprKind.FIELD_STEP && (fieldPos = (fieldStep = (ExprFieldStep)path).getFieldPos()) >= 0 && targetTable.isPrimKeyAtPos(fieldPos)) {
            throw new QueryException("Cannot update a primary key column", loc);
        }
        ExprUpdateField upd = new ExprUpdateField(this.theQCB, this.theInitSctx, loc, path);
        ExprVar targetItemVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$", upd);
        this.theSctx.addVariable(targetItemVar);
        upd.addTargetItemVar(targetItemVar);
        this.theExprs.push(upd);
    }

    @Override
    public void enterAny(KVQLParser.AnyContext ctx) {
        if (this.theInDDL) {
            throw new QueryException("Type Any not allowed in DDL statements.", Translator.getLocation(ctx));
        }
        this.theTypes.push(FieldDefFactory.createAnyDef());
    }

    @Override
    public void enterAnyAtomic(KVQLParser.AnyAtomicContext ctx) {
        if (this.theInDDL) {
            throw new QueryException("Type AnyAtomic not allowed in DDL statements.", Translator.getLocation(ctx));
        }
        this.theTypes.push(FieldDefFactory.createAnyAtomicDef());
    }

    @Override
    public void enterAnyJsonAtomic(KVQLParser.AnyJsonAtomicContext ctx) {
        if (this.theInDDL) {
            throw new QueryException("Type AnyJsonAtomic not allowed in DDL statements.", Translator.getLocation(ctx));
        }
        this.theTypes.push(FieldDefFactory.createAnyJsonAtomicDef());
    }

    @Override
    public void enterJSON(KVQLParser.JSONContext ctx) {
        this.theTypes.push(FieldDefFactory.createJsonDef());
    }

    @Override
    public void enterAnyRecord(KVQLParser.AnyRecordContext ctx) {
        if (this.theInDDL) {
            throw new QueryException("Type AnyRecord not allowed in DDL statements.", Translator.getLocation(ctx));
        }
        this.theTypes.push(FieldDefFactory.createAnyRecordDef());
    }

    @Override
    public void enterRecord(KVQLParser.RecordContext ctx) {
        this.theFields.push(null);
    }

    @Override
    public void exitRecord(KVQLParser.RecordContext ctx) {
        FieldMap fieldMap = new FieldMap();
        FieldDefHelper field = this.theFields.pop();
        assert (field != null);
        while (field != null) {
            this.setNameForNamedType(field.getName(), field.getType());
            field.validate();
            fieldMap.put(field.getName(), field.getType(), field.getNullable(), field.getDefault());
            field = this.theFields.pop();
        }
        fieldMap.reverseFieldOrder();
        RecordDefImpl type = FieldDefFactory.createRecordDef(fieldMap, null);
        this.theTypes.push(type);
    }

    @Override
    public void enterField_def(KVQLParser.Field_defContext ctx) {
        String name = ctx.id().getText();
        String comment = null;
        if (ctx.comment() != null) {
            comment = Translator.stripFirstLast(ctx.comment().string().getText());
            comment = EscapeUtil.inlineEscapedChars(comment);
        }
        FieldDefHelper field = new FieldDefHelper(name, comment, Translator.getLocation(ctx));
        this.theFields.push(field);
    }

    @Override
    public void exitField_def(KVQLParser.Field_defContext ctx) {
        assert (!this.theFields.empty());
        assert (!this.theTypes.empty());
        FieldDefHelper field = this.theFields.peek();
        field.setType(this.theTypes.pop());
        assert (this.theTypes.empty());
    }

    @Override
    public void enterDefault_value(KVQLParser.Default_valueContext ctx) {
        assert (!this.theFields.empty());
        assert (!this.theTypes.empty());
        FieldDefHelper fieldDefHelper = this.theFields.peek();
        FieldDefImpl type = this.theTypes.peek();
        fieldDefHelper.setType(type);
        String strval = ctx.getChild(1).getText();
        fieldDefHelper.setDefault(strval, ctx);
    }

    @Override
    public void enterNot_null(KVQLParser.Not_nullContext ctx) {
        assert (!this.theFields.empty());
        FieldDefHelper field = this.theFields.peek();
        FieldDefImpl type = this.theTypes.peek();
        field.setType(type);
        field.setNullable(false, ctx);
    }

    @Override
    public void exitArray(KVQLParser.ArrayContext ctx) {
        FieldDefImpl elemType = this.theTypes.pop();
        this.setNameForNamedType(null, elemType);
        ArrayDefImpl type = FieldDefFactory.createArrayDef(elemType);
        this.theTypes.push(type);
    }

    @Override
    public void exitMap(KVQLParser.MapContext ctx) {
        FieldDefImpl elemType = this.theTypes.pop();
        this.setNameForNamedType(null, elemType);
        MapDefImpl type = FieldDefFactory.createMapDef(elemType);
        this.theTypes.push(type);
    }

    @Override
    public void enterInt(KVQLParser.IntContext ctx) {
        boolean isLong = ctx.integer_def().LONG_T() != null;
        FieldDefImpl type = isLong ? FieldDefFactory.createLongDef() : FieldDefFactory.createIntegerDef();
        this.theTypes.push(type);
    }

    @Override
    public void enterFloat(KVQLParser.FloatContext ctx) {
        boolean isNumber;
        boolean isDouble = ctx.float_def().DOUBLE_T() != null;
        boolean bl = isNumber = ctx.float_def().NUMBER_T() != null;
        DoubleDefImpl type = isDouble ? FieldDefFactory.createDoubleDef() : (isNumber ? FieldDefFactory.createNumberDef() : FieldDefFactory.createFloatDef());
        this.theTypes.push(type);
    }

    @Override
    public void enterStringT(KVQLParser.StringTContext ctx) {
        StringDefImpl type = FieldDefFactory.createStringDef();
        this.theTypes.push(type);
    }

    @Override
    public void enterEnum(KVQLParser.EnumContext ctx) {
        String[] values = Translator.makeIdArray(ctx.enum_def().id_list().id());
        try {
            EnumDefImpl type = FieldDefFactory.createEnumDef(values);
            this.theTypes.push(type);
        }
        catch (IllegalArgumentException iae) {
            String msg = "Invalid ENUM type '" + ctx.enum_def().getText() + "': " + iae.getMessage();
            throw new QueryException(msg, Translator.getLocation(ctx));
        }
    }

    @Override
    public void enterBoolean(KVQLParser.BooleanContext ctx) {
        BooleanDefImpl type = FieldDefFactory.createBooleanDef();
        this.theTypes.push(type);
    }

    @Override
    public void enterBinary(KVQLParser.BinaryContext ctx) {
        int size = 0;
        if (ctx.binary_def().INT() != null) {
            size = Integer.parseInt(ctx.binary_def().INT().getText());
        }
        FieldDefImpl type = size == 0 ? FieldDefFactory.createBinaryDef() : FieldDefFactory.createFixedBinaryDef(size);
        this.theTypes.push(type);
    }

    @Override
    public void enterTimestamp(KVQLParser.TimestampContext ctx) {
        int precision = -1;
        if (ctx.timestamp_def().INT() != null) {
            precision = Integer.parseInt(ctx.timestamp_def().INT().getText());
            if (precision > 9) {
                throw new QueryException("Timestamp precision exceeds the maximum allowed precision (9)");
            }
            if (precision < 0) {
                throw new QueryException("Timestamp precision cannot be a negative number");
            }
        }
        if (this.theInDDL && precision < 0) {
            throw new QueryException("In DDL statements there is no default precision for the Timestamp type. The precision must be explicitly specified.", Translator.getLocation(ctx));
        }
        if (precision < 0) {
            precision = 9;
        }
        TimestampDefImpl type = FieldDefFactory.createTimestampDef(precision);
        this.theTypes.push(type);
    }

    @Override
    public void enterIdentity_def(KVQLParser.Identity_defContext ctx) {
        this.theSequenceOptions = new HashSet<String>();
        this.theIdentityHelper = new IdentityDefHelper();
        if (ctx.ALWAYS() != null) {
            this.theIdentityHelper.setAlways(true);
        }
        if (ctx.NULL() != null) {
            this.theIdentityHelper.setOnNull(true);
        }
    }

    @Override
    public void enterSequence_options(KVQLParser.Sequence_optionsContext ctx) {
        if (ctx.signed_int() != null) {
            String stringValue = ctx.signed_int().getText();
            if (ctx.START() != null) {
                if (this.theSequenceOptions.contains("START")) {
                    throw new QueryException("START WITH can be specified for only one time", Translator.getLocation(ctx));
                }
                this.theIdentityHelper.setStart(stringValue);
                this.theSequenceOptions.add("START");
            } else if (ctx.INCREMENT() != null) {
                if (this.theSequenceOptions.contains("INCREMENT")) {
                    throw new QueryException("INCREMENT BY can be specified for only one time", Translator.getLocation(ctx));
                }
                this.theIdentityHelper.setIncrement(stringValue);
                this.theSequenceOptions.add("INCREMENT");
            } else if (ctx.MAXVALUE() != null) {
                if (this.theSequenceOptions.contains("MAXVALUE")) {
                    throw new QueryException("MAXVALUE can be specified for only one time and cannot be specified when NO MAXVALUE is specified.", Translator.getLocation(ctx));
                }
                this.theIdentityHelper.setMax(stringValue);
                this.theSequenceOptions.add("MAXVALUE");
            } else if (ctx.MINVALUE() != null) {
                if (this.theSequenceOptions.contains("MINVALUE")) {
                    throw new QueryException("MINVALUE can be specified for only one time and cannot be specified when NO MINVALUE is specified.", Translator.getLocation(ctx));
                }
                this.theIdentityHelper.setMin(stringValue);
                this.theSequenceOptions.add("MINVALUE");
            }
        } else if (ctx.NO() != null && ctx.MAXVALUE() != null) {
            if (this.theSequenceOptions.contains("MAXVALUE")) {
                throw new QueryException("NO MAXVALUE can be specified for only one time and cannot be specified when MAXVALUE is specified.", Translator.getLocation(ctx));
            }
            this.theIdentityHelper.setMax("MAXVALUE");
            this.theSequenceOptions.add("MAXVALUE");
        } else if (ctx.NO() != null && ctx.MINVALUE() != null) {
            if (this.theSequenceOptions.contains("MINVALUE")) {
                throw new QueryException("NO MINVALUE can be specified for only one time and cannot be specified when MINVALUE is specified.", Translator.getLocation(ctx));
            }
            this.theIdentityHelper.setMax("MINVALUE");
            this.theSequenceOptions.add("MINVALUE");
        } else if (ctx.NO() == null && ctx.CACHE() != null) {
            String stringValue = ctx.INT().getText();
            if (this.theSequenceOptions.contains("CACHE")) {
                throw new QueryException("CACHE can be specified for only one time and cannot be specified when NO CACHE is specified.", Translator.getLocation(ctx));
            }
            if (Integer.parseInt(stringValue) == 0) {
                throw new QueryException("CACHE value cannot be 0.", Translator.getLocation(ctx));
            }
            this.theIdentityHelper.setCache(stringValue);
            this.theSequenceOptions.add("CACHE");
        } else if (ctx.NO() != null && ctx.CACHE() != null) {
            if (this.theSequenceOptions.contains("CACHE")) {
                throw new QueryException("NO CACHE can be specified for only one time and cannot be specified when CACHE is specified.", Translator.getLocation(ctx));
            }
            this.theIdentityHelper.setCache(null);
            this.theSequenceOptions.add("CACHE");
        } else if (ctx.NO() == null && ctx.CYCLE() != null) {
            if (this.theSequenceOptions.contains("CYCLE")) {
                throw new QueryException("CYCLE can be specified for only one time and cannot be specified when NO CYCLE is specified.", Translator.getLocation(ctx));
            }
            this.theIdentityHelper.setCycle(true);
            this.theSequenceOptions.add("CYCLE");
        } else if (ctx.NO() != null && ctx.CYCLE() != null) {
            if (this.theSequenceOptions.contains("CYCLE")) {
                throw new QueryException("NO CYCLE can be specified for only one time and cannot be specified when CYCLE is specified.", Translator.getLocation(ctx));
            }
            this.theIdentityHelper.setCycle(false);
            this.theSequenceOptions.add("CYCLE");
        }
    }

    private void setNameForNamedType(String name, FieldDef type) {
        if (type.isRecord()) {
            ((RecordDefImpl)type).setName(name != null ? name : this.theQCB.generateFieldName(this.getNamePrefix("RECORD")));
        } else if (type.isEnum()) {
            ((EnumDefImpl)type).setName(name != null ? name : this.theQCB.generateFieldName(this.getNamePrefix("ENUM")));
        } else if (type.isFixedBinary()) {
            ((FixedBinaryDefImpl)type).setName(name != null ? name : this.theQCB.generateFieldName(this.getNamePrefix("FIXEDBINARY")));
        }
    }

    private String getNamePrefix(String name) {
        if (this.theTableBuilder instanceof TableEvolver) {
            return name + ((TableEvolver)this.theTableBuilder).getTableVersion();
        }
        return name;
    }

    @Override
    public void enterCreate_namespace_statement(KVQLParser.Create_namespace_statementContext ctx) {
        boolean ifNotExists;
        String namespace = ctx.namespace().getText();
        TableImpl.validateNamespace(namespace);
        boolean bl = ifNotExists = ctx.EXISTS() != null;
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.CREATE_NAMESPACE);
            this.theQCB.getPrepareCallback().namespaceName(namespace);
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("CREATE NAMESPACE must execute on a server");
        }
        this.theQCB.getStatementFactory().createNamespace(namespace, ifNotExists);
    }

    @Override
    public void enterDrop_namespace_statement(KVQLParser.Drop_namespace_statementContext ctx) {
        boolean ifExists;
        String namespace = ctx.namespace().getText();
        TableImpl.validateNamespace(namespace);
        boolean bl = ifExists = ctx.EXISTS() != null;
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.DROP_NAMESPACE);
            this.theQCB.getPrepareCallback().namespaceName(namespace);
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("DROP NAMESPACE must execute on a server");
        }
        boolean cascade = ctx.CASCADE() != null;
        this.theQCB.getStatementFactory().dropNamespace(namespace, ifExists, cascade);
    }

    @Override
    public void enterCreate_table_statement(KVQLParser.Create_table_statementContext ctx) {
        String namespace = this.computeNamespace(ctx.table_name());
        String name = Translator.getPathLeaf(ctx.table_name().id_path());
        String[] parentPath = Translator.getParentPath(ctx.table_name().id_path());
        if (this.theQCB.getPrepareCallback() != null && parentPath != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.CREATE_TABLE);
            this.theQCB.getPrepareCallback().namespaceName(namespace);
            this.theQCB.getPrepareCallback().tableName(Translator.concatPathName(parentPath) + "." + name);
        }
        TableImpl parentTable = this.getParentTable(ctx.table_name());
        KVQLParser.Table_defContext table_def = ctx.table_def();
        if (table_def.key_def() == null || table_def.key_def().isEmpty() || table_def.key_def().size() > 1) {
            throw new QueryException("Table definition must contain a single primary key definition", Translator.getLocation(table_def));
        }
        String comment = null;
        if (ctx.comment() != null) {
            comment = Translator.stripFirstLast(ctx.comment().string().getText());
            EscapeUtil.inlineEscapedChars(comment);
        }
        this.theFields.push(null);
        this.theTableBuilder = TableBuilder.createTableBuilder(namespace, name, comment, parentTable);
    }

    private String computeNamespace(KVQLParser.Table_nameContext ctx) {
        String ns = null;
        if (ctx.namespace() != null) {
            ns = ctx.namespace().getText();
        }
        String optionsNs = this.theQCB.getNamespace();
        if (ns != null) {
            int tdi;
            if ("sysdefault".equalsIgnoreCase(ns)) {
                ns = null;
            }
            if (optionsNs != null && !"sysdefault".equalsIgnoreCase(optionsNs) && (tdi = optionsNs.indexOf(64)) >= 0) {
                ns = optionsNs.substring(0, tdi) + (ns == null ? "" : ns);
            }
        } else {
            ns = optionsNs == null || "sysdefault".equalsIgnoreCase(optionsNs) ? null : optionsNs;
        }
        return ns;
    }

    @Override
    public void exitCreate_table_statement(KVQLParser.Create_table_statementContext ctx) {
        boolean ifNotExists;
        TableImpl table;
        assert (this.theTableBuilder != null);
        assert (!this.theFields.isEmpty());
        assert (this.theTypes.isEmpty());
        ArrayList<FieldDefHelper> fields = new ArrayList<FieldDefHelper>();
        FieldDefHelper field = this.theFields.pop();
        assert (field != null);
        while (field != null) {
            this.setNameForNamedType(field.getName(), field.getType());
            field.validate();
            fields.add(field);
            field = this.theFields.pop();
        }
        assert (this.theFields.isEmpty());
        Collections.reverse(fields);
        for (FieldDefHelper field1 : fields) {
            this.theTableBuilder.addField(field1.getName(), (FieldDef)field1.getType(), (Boolean)field1.getNullable(), field1.getDefault());
        }
        SequenceDef sequenceDef = null;
        try {
            this.theTableBuilder.validatePrimaryKeyFields();
            table = this.theTableBuilder.buildTable();
            if (table.hasIdentityColumn()) {
                sequenceDef = this.theTableBuilder.getSequenceDef();
            }
            this.theTableBuilder = null;
        }
        catch (Exception e) {
            throw new QueryException("Cannot build table: " + e.getMessage());
        }
        boolean bl = ifNotExists = ctx.EXISTS() != null;
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.CREATE_TABLE);
            this.theQCB.getPrepareCallback().namespaceName(table.getInternalNamespace());
            this.theQCB.getPrepareCallback().tableName(table.getFullName());
            if (ifNotExists) {
                this.theQCB.getPrepareCallback().ifNotExistsFound();
            }
            this.theQCB.getPrepareCallback().newTable(table);
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("CREATE TABLE must execute on a server");
        }
        this.theQCB.getStatementFactory().createTable(table, ifNotExists, sequenceDef);
    }

    @Override
    public void enterColumn_def(KVQLParser.Column_defContext ctx) {
        String name = ctx.id().getText();
        String comment = null;
        if (ctx.comment() != null) {
            comment = Translator.stripFirstLast(ctx.comment().string().getText());
            comment = EscapeUtil.inlineEscapedChars(comment);
        }
        FieldDefHelper field = new FieldDefHelper(name, comment, Translator.getLocation(ctx));
        this.theFields.push(field);
    }

    @Override
    public void exitColumn_def(KVQLParser.Column_defContext ctx) {
        FieldDefHelper field = this.theFields.peek();
        field.setType(this.theTypes.pop());
        assert (this.theTypes.empty());
        if (this.theIdentityHelper != null) {
            if (this.theTableBuilder.getSequenceDef() != null) {
                throw new QueryException("Only one IDENTITY field is allowed in a table.", Translator.getLocation(ctx.identity_def()));
            }
            this.theTableBuilder.setIdentity(field.getName(), this.theIdentityHelper.getAlways(), this.theIdentityHelper.getOnNull(), new SequenceDefImpl(field.getType(), this.theIdentityHelper));
            this.theIdentityHelper = null;
        }
    }

    @Override
    public void enterKey_def(KVQLParser.Key_defContext ctx) {
        assert (this.theTableBuilder != null);
        try {
            if (ctx.shard_key_def() == null) {
                if (ctx.id_list_with_size() == null) {
                    throw new QueryException("PRIMARY KEY must contain a list of fields", Translator.getLocation(ctx));
                }
                this.makePrimaryKey(ctx.id_list_with_size().id_with_size());
                return;
            }
            List<KVQLParser.Id_with_sizeContext> shardKeyList = ctx.shard_key_def().id_list_with_size().id_with_size();
            this.theTableBuilder.shardKey(Translator.makeKeyIdArray(shardKeyList));
            ArrayList<KVQLParser.Id_with_sizeContext> pkey = new ArrayList<KVQLParser.Id_with_sizeContext>(shardKeyList);
            if (ctx.id_list_with_size() != null) {
                pkey.addAll(ctx.id_list_with_size().id_with_size());
            }
            this.makePrimaryKey(pkey);
        }
        catch (IllegalArgumentException iae) {
            throw new QueryException(iae.getMessage(), Translator.getLocation(ctx));
        }
    }

    @Override
    public void enterTtl_def(KVQLParser.Ttl_defContext ctx) {
        KVQLParser.DurationContext duration = ctx.duration();
        QueryException.Location loc = Translator.getLocation(ctx);
        try {
            this.theTableBuilder.setDefaultTTL(TimeToLive.createTimeToLive(Integer.parseInt(duration.INT().getText()), Translator.convertToTimeUnit(duration.time_unit())));
        }
        catch (NumberFormatException nfex) {
            String msg = "Invalid TTL value: " + duration.INT().getText() + " in " + duration.INT().getText() + " " + duration.time_unit().getText();
            throw new QueryException(msg, loc);
        }
        catch (IllegalArgumentException iae) {
            String msg = "Invalid TTL Unit: " + (Object)((Object)Translator.convertToTimeUnit(duration.time_unit())) + " in " + duration.INT().getText() + " " + duration.time_unit().getText();
            throw new QueryException(msg, loc);
        }
    }

    @Override
    public void enterAlter_table_statement(KVQLParser.Alter_table_statementContext ctx) {
        TableImpl currentTable;
        String namespace = this.computeNamespace(ctx.table_name());
        String[] pathName = Translator.getNamePath(ctx.table_name().id_path());
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.ALTER_TABLE);
            this.theQCB.getPrepareCallback().namespaceName(namespace);
            this.theQCB.getPrepareCallback().tableName(Translator.concatPathName(pathName));
            if (!this.theQCB.getPrepareCallback().prepareNeeded() && this.theMetadataHelper == null) {
                throw new StopWalkException();
            }
        }
        if ((currentTable = this.getTable(namespace, pathName, Translator.getLocation(ctx))) == null) {
            Translator.noTable(namespace, pathName, Translator.getLocation(ctx));
        }
        this.theTableBuilder = TableEvolver.createTableEvolver(currentTable);
    }

    @Override
    public void exitAlter_table_statement(KVQLParser.Alter_table_statementContext ctx) {
        TableImpl table;
        TableEvolver evolver = (TableEvolver)this.theTableBuilder;
        try {
            table = evolver.evolveTable();
        }
        catch (IllegalArgumentException iae) {
            throw new QueryException(iae.getMessage(), Translator.getLocation(ctx));
        }
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().newTable(table);
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("ALTER TABLE must execute on a server");
        }
        this.theTableBuilder = null;
        this.theQCB.getStatementFactory().evolveTable(table);
    }

    @Override
    public void enterAdd_field_statement(KVQLParser.Add_field_statementContext ctx) {
        String comment = null;
        if (ctx.comment() != null) {
            comment = Translator.stripFirstLast(ctx.comment().string().getText());
            comment = EscapeUtil.inlineEscapedChars(comment);
        }
        FieldDefHelper fieldDefHelper = new FieldDefHelper("", comment, Translator.getLocation(ctx));
        this.theFields.push(fieldDefHelper);
    }

    @Override
    public void exitAdd_field_statement(KVQLParser.Add_field_statementContext ctx) {
        assert (!this.theFields.empty());
        assert (!this.theTypes.empty());
        assert (this.theTableBuilder != null);
        TableEvolver evolver = (TableEvolver)this.theTableBuilder;
        FieldDefHelper field = this.theFields.pop();
        field.setType(this.theTypes.pop());
        assert (this.theTypes.empty());
        List<String> stepsList = Translator.getStepsList(ctx.schema_path());
        String newFieldName = stepsList.get(stepsList.size() - 1);
        this.setNameForNamedType(newFieldName, field.getType());
        field.validate();
        try {
            evolver.addField(new TablePath(evolver.getFieldMap(), stepsList), (FieldDef)field.getType(), (Boolean)field.getNullable(), field.getDefault());
            if (this.theIdentityHelper != null) {
                assert (stepsList.size() == 1);
                evolver.setIdentity(stepsList.get(0), this.theIdentityHelper.getAlways(), this.theIdentityHelper.getOnNull(), new SequenceDefImpl(field.getType(), this.theIdentityHelper));
                this.theIdentityHelper = null;
            }
        }
        catch (IllegalArgumentException iae) {
            throw new QueryException(iae.getMessage(), Translator.getLocation(ctx.schema_path()));
        }
    }

    @Override
    public void exitDrop_field_statement(KVQLParser.Drop_field_statementContext ctx) {
        List<String> stepsList = Translator.getStepsList(ctx.schema_path());
        try {
            this.theTableBuilder.removeField(new TablePath(this.theTableBuilder.getFieldMap(), stepsList));
        }
        catch (IllegalArgumentException iae) {
            throw new QueryException(iae.getMessage(), iae, Translator.getLocation(ctx.schema_path()));
        }
    }

    static List<String> getStepsList(KVQLParser.Schema_pathContext schemaPathCtx) {
        KVQLParser.Init_schema_path_stepContext initStep = schemaPathCtx.init_schema_path_step();
        List<KVQLParser.Schema_path_stepContext> steps = schemaPathCtx.schema_path_step();
        ArrayList<String> stepsList = new ArrayList<String>(steps.size() + 1);
        stepsList.add(initStep.id().getText());
        if (initStep.LBRACK() != null) {
            assert (initStep.RBRACK() != null);
            for (TerminalNode t : initStep.LBRACK()) {
                stepsList.add("[]");
            }
        }
        for (KVQLParser.Schema_path_stepContext step : steps) {
            if (step.id() != null) {
                stepsList.add(step.id().getText());
                if (step.LBRACK() == null) continue;
                assert (step.RBRACK() != null);
                for (TerminalNode t : step.LBRACK()) {
                    stepsList.add("[]");
                }
                continue;
            }
            stepsList.add("values()");
        }
        return stepsList;
    }

    @Override
    public void exitModify_field_statement(KVQLParser.Modify_field_statementContext ctx) {
        if (ctx.type_def() != null) {
            throw new QueryException("MODIFY is not supported at this time", Translator.getLocation(ctx));
        }
        List<String> stepsList = Translator.getStepsList(ctx.schema_path());
        TablePath tablePath = new TablePath(this.theTableBuilder.getFieldMap(), stepsList);
        if (ctx.DROP() != null) {
            assert (ctx.IDENTITY() != null);
            try {
                this.theTableBuilder.setIdentity(null, false, false, null);
            }
            catch (IllegalArgumentException iae) {
                throw new QueryException(iae.getMessage(), iae, Translator.getLocation(ctx.schema_path()));
            }
        } else if (ctx.identity_def() != null) {
            assert (this.theIdentityHelper != null);
            assert (this.theTableBuilder != null);
            FieldDefImpl field = (FieldDefImpl)this.theTableBuilder.getField(tablePath);
            this.theTableBuilder.setIdentity(tablePath.getPathName(), ctx.identity_def().ALWAYS() != null, ctx.identity_def().NULL() != null, new SequenceDefImpl(field, this.theIdentityHelper));
            this.theIdentityHelper = null;
        }
    }

    @Override
    public void enterDrop_table_statement(KVQLParser.Drop_table_statementContext ctx) {
        boolean ifExists = ctx.EXISTS() != null;
        String namespace = this.computeNamespace(ctx.table_name());
        String[] tableName = Translator.getNamePath(ctx.table_name().id_path());
        TableImpl table = this.getTableSilently(namespace, tableName);
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.DROP_TABLE);
            this.theQCB.getPrepareCallback().namespaceName(namespace);
            this.theQCB.getPrepareCallback().tableName(Translator.concatPathName(tableName));
            if (ifExists) {
                this.theQCB.getPrepareCallback().ifExistsFound();
            }
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("DROP TABLE must execute on a server");
        }
        this.theQCB.getStatementFactory().dropTable(namespace, Translator.concatPathName(tableName), table, ifExists);
    }

    @Override
    public void enterCreate_index_statement(KVQLParser.Create_index_statementContext ctx) {
        boolean ifNotExists = ctx.EXISTS() != null;
        String namespace = this.computeNamespace(ctx.table_name());
        String[] tableName = Translator.getNamePath(ctx.table_name().id_path());
        String indexName = ctx.index_name().id().getText();
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.CREATE_INDEX);
            if (ifNotExists) {
                this.theQCB.getPrepareCallback().ifNotExistsFound();
            }
            this.theQCB.getPrepareCallback().namespaceName(namespace);
            this.theQCB.getPrepareCallback().tableName(Translator.concatPathName(tableName));
            this.theQCB.getPrepareCallback().indexName(indexName);
        }
        List<KVQLParser.Index_pathContext> pathCtxs = ctx.index_path_list().index_path();
        String[] fieldNames = Translator.getIndexFieldNames(pathCtxs);
        FieldDef.Type[] typeArray = Translator.makeTypeArray(pathCtxs);
        Map<String, String> geoProps = Translator.getGeoProperties(pathCtxs);
        String indexComment = null;
        if (ctx.comment() != null) {
            indexComment = Translator.stripFirstLast(ctx.comment().string().getText());
            indexComment = EscapeUtil.inlineEscapedChars(indexComment);
        }
        if (this.theQCB.getPrepareCallback() != null && !this.theQCB.getPrepareCallback().prepareNeeded()) {
            throw new StopWalkException();
        }
        TableImpl table = this.getTable(namespace, tableName, Translator.getLocation(ctx));
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("CREATE INDEX must execute on a server");
        }
        this.theQCB.getStatementFactory().createIndex(namespace, Translator.concatPathName(tableName), table, indexName, fieldNames, typeArray, null, geoProps, indexComment, ifNotExists, false);
    }

    private static String[] getIndexFieldNames(List<KVQLParser.Index_pathContext> list) {
        String[] names = new String[list.size()];
        int i = 0;
        for (KVQLParser.Index_pathContext path : list) {
            boolean isValues;
            if (path.path_type() == null) {
                names[i] = path.getText();
            } else if (path.name_path() != null) {
                names[i] = path.name_path().getText();
            } else if (path.values_expr() != null) {
                names[i] = path.values_expr().getText();
            } else {
                throw new IllegalStateException("Unexpected name path in index statement: " + path.getText());
            }
            boolean isMapKeys = path.keys_expr() != null;
            boolean bl = isValues = path.values_expr() != null;
            if (!isMapKeys && !isValues) {
                ++i;
                continue;
            }
            String indexPath = names[i];
            String lower = indexPath.toLowerCase();
            if (lower.startsWith("keys(") || lower.startsWith("keyof(") || lower.startsWith("elementof(")) {
                StringBuilder sb = new StringBuilder();
                int lp = lower.indexOf(40);
                int rp = lower.indexOf(41, lp);
                sb.append(indexPath.substring(lp + 1, rp));
                sb.append('.');
                sb.append(isValues ? "values()" : "keys()");
                if (indexPath.length() > rp + 1) {
                    sb.append(indexPath.substring(rp + 1, indexPath.length()));
                }
                names[i] = sb.toString();
            }
            ++i;
        }
        return names;
    }

    private static FieldDef.Type[] makeTypeArray(List<KVQLParser.Index_pathContext> list) {
        FieldDef.Type[] types = new FieldDef.Type[list.size()];
        boolean returnTypes = false;
        boolean isGeom = false;
        int i = 0;
        for (KVQLParser.Index_pathContext path : list) {
            KVQLParser.Path_typeContext typeCtx = path.path_type();
            if (typeCtx == null) {
                types[i] = null;
            } else {
                returnTypes = true;
                if (typeCtx.INTEGER_T() != null) {
                    types[i] = FieldDef.Type.INTEGER;
                } else if (typeCtx.LONG_T() != null) {
                    types[i] = FieldDef.Type.LONG;
                } else if (typeCtx.DOUBLE_T() != null) {
                    types[i] = FieldDef.Type.DOUBLE;
                } else if (typeCtx.NUMBER_T() != null) {
                    types[i] = FieldDef.Type.NUMBER;
                } else if (typeCtx.STRING_T() != null) {
                    types[i] = FieldDef.Type.STRING;
                } else if (typeCtx.BOOLEAN_T() != null) {
                    types[i] = FieldDef.Type.BOOLEAN;
                } else if (typeCtx.GEOMETRY_T() != null) {
                    types[i] = FieldDef.Type.GEOMETRY;
                    isGeom = true;
                } else if (typeCtx.POINT_T() != null) {
                    types[i] = FieldDef.Type.POINT;
                    isGeom = true;
                }
            }
            ++i;
        }
        if (isGeom) {
            CompilerAPI.getGeoUtils();
        }
        if (returnTypes) {
            return types;
        }
        return null;
    }

    private static Map<String, String> getGeoProperties(List<KVQLParser.Index_pathContext> list) {
        HashMap<String, String> properties = null;
        for (KVQLParser.Index_pathContext path : list) {
            KVQLParser.Path_typeContext typeCtx = path.path_type();
            if (typeCtx == null || typeCtx.GEOMETRY_T() == null || typeCtx.jsobject() == null) continue;
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            String jsontext = typeCtx.jsobject().getText();
            MapValueImpl json = (MapValueImpl)FieldValueFactory.createValueFromJson(jsontext);
            FieldValueImpl maxCellsVal = json.get("max_covering_cells");
            FieldValueImpl minCellsVal = json.get("min_covering_cells");
            FieldValueImpl maxSplitsVal = json.get("max_splits");
            FieldValueImpl splitRatioVal = json.get("split_ratio");
            if (maxCellsVal != null) {
                if (maxCellsVal.getDefinition().getType() != FieldDef.Type.INTEGER) {
                    throw new IllegalArgumentException("Value of max_covering_cells field is not an integer");
                }
                properties.put("max_covering_cells", maxCellsVal.toString());
            }
            if (minCellsVal != null) {
                if (minCellsVal.getDefinition().getType() != FieldDef.Type.INTEGER) {
                    throw new IllegalArgumentException("Value of min_covering_cells field is not an integer");
                }
                properties.put("min_covering_cells", minCellsVal.toString());
            }
            if (maxSplitsVal != null) {
                if (maxSplitsVal.getDefinition().getType() != FieldDef.Type.INTEGER) {
                    throw new IllegalArgumentException("Value of max_splits field is not an integer");
                }
                properties.put("max_splits", maxSplitsVal.toString());
            }
            if (splitRatioVal == null) continue;
            if (splitRatioVal.getDefinition().getType() != FieldDef.Type.DOUBLE) {
                throw new IllegalArgumentException("Value of split_ratio field is not a double");
            }
            properties.put("split_ratio", splitRatioVal.toString());
        }
        return null;
    }

    @Override
    public void enterDrop_index_statement(KVQLParser.Drop_index_statementContext ctx) {
        boolean ifExists = ctx.EXISTS() != null;
        boolean override = ctx.OVERRIDE() != null;
        String namespace = this.computeNamespace(ctx.table_name());
        String[] tableName = Translator.getNamePath(ctx.table_name().id_path());
        String indexName = ctx.index_name().id().getText();
        TableImpl table = this.getTableSilently(namespace, tableName);
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.DROP_INDEX);
            this.theQCB.getPrepareCallback().namespaceName(namespace);
            this.theQCB.getPrepareCallback().tableName(Translator.concatPathName(tableName));
            if (ifExists) {
                this.theQCB.getPrepareCallback().ifExistsFound();
            }
            this.theQCB.getPrepareCallback().indexName(indexName);
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("DROP INDEX must execute on a server");
        }
        this.theQCB.getStatementFactory().dropIndex(namespace, Translator.concatPathName(tableName), table, indexName, ifExists, override);
    }

    @Override
    public void exitCreate_text_index_statement(KVQLParser.Create_text_index_statementContext ctx) {
        boolean ifNotExists = false;
        if (ctx.EXISTS() != null) {
            ifNotExists = true;
        }
        boolean override = ctx.OVERRIDE() != null;
        String namespace = this.computeNamespace(ctx.table_name());
        String[] tableName = Translator.getNamePath(ctx.table_name().id_path());
        String indexName = ctx.index_name().id().getText();
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.CREATE_INDEX);
            if (ifNotExists) {
                this.theQCB.getPrepareCallback().ifNotExistsFound();
            }
            this.theQCB.getPrepareCallback().namespaceName(namespace);
            this.theQCB.getPrepareCallback().tableName(Translator.concatPathName(tableName));
            this.theQCB.getPrepareCallback().indexName(indexName);
            this.theQCB.getPrepareCallback().isTextIndex();
        }
        IndexImpl.AnnotatedField[] ftsFieldArray = this.makeFtsFieldArray(ctx.fts_field_list().fts_path_list().fts_path());
        HashMap<String, String> properties = new HashMap<String, String>();
        KVQLParser.Es_propertiesContext propCtx = ctx.es_properties();
        if (propCtx != null) {
            for (KVQLParser.Es_property_assignmentContext prop : propCtx.es_property_assignment()) {
                if (prop.ES_SHARDS() != null) {
                    String shards = prop.INT().toString();
                    if (Integer.parseInt(shards) < 1) {
                        throw new DdlException("The " + prop.ES_SHARDS() + " value of " + shards + " is not allowed.");
                    }
                    properties.put(prop.ES_SHARDS().toString(), shards);
                    continue;
                }
                if (prop.ES_REPLICAS() == null) continue;
                String replicas = prop.INT().toString();
                if (Integer.parseInt(replicas) < 0) {
                    throw new DdlException("The " + prop.ES_REPLICAS() + " value of " + replicas + " is not allowed.");
                }
                properties.put(prop.ES_REPLICAS().toString(), replicas);
            }
        }
        if (properties.isEmpty()) {
            properties = null;
        }
        String indexComment = null;
        if (ctx.comment() != null) {
            indexComment = Translator.stripFirstLast(ctx.comment().string().getText());
            indexComment = EscapeUtil.inlineEscapedChars(indexComment);
        }
        if (this.theQCB.getPrepareCallback() != null && !this.theQCB.getPrepareCallback().prepareNeeded()) {
            throw new StopWalkException();
        }
        TableImpl table = this.getTable(namespace, tableName, Translator.getLocation(ctx));
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("CREATE FULLTEXT INDEX must execute on a server");
        }
        this.theQCB.getStatementFactory().createIndex(namespace, Translator.concatPathName(tableName), table, indexName, null, null, ftsFieldArray, properties, indexComment, ifNotExists, override);
    }

    @Override
    public void enterDescribe_statement(KVQLParser.Describe_statementContext ctx) {
        boolean describeAsJson;
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.DESCRIBE);
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        String namespace = null;
        String[] tableName = null;
        String indexName = null;
        ArrayList<List<String>> schemaPaths = null;
        if (ctx.table_name() != null) {
            namespace = this.computeNamespace(ctx.table_name());
            if (this.getTable(namespace, tableName = Translator.getNamePath(ctx.table_name().id_path()), Translator.getLocation(ctx.table_name())) == null) {
                Translator.noTable(namespace, tableName, Translator.getLocation(ctx.table_name()));
            }
            if (ctx.schema_path_list() != null) {
                List<KVQLParser.Schema_pathContext> pathCtxList = ctx.schema_path_list().schema_path();
                schemaPaths = new ArrayList<List<String>>(pathCtxList.size());
                for (KVQLParser.Schema_pathContext spctx : pathCtxList) {
                    schemaPaths.add(Translator.getStepsList(spctx));
                }
            }
            if (ctx.index_name() != null) {
                indexName = ctx.index_name().id().getText();
            }
        }
        boolean bl = describeAsJson = ctx.JSON() != null;
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("DESCRIBE TABLE must execute on a server");
        }
        this.theQCB.getStatementFactory().describeTable(namespace, Translator.concatPathName(tableName), indexName, schemaPaths, describeAsJson);
    }

    @Override
    public void enterShow_statement(KVQLParser.Show_statementContext ctx) {
        boolean asJson;
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.SHOW);
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        if (this.getShowUserOrRoleOp(ctx)) {
            return;
        }
        boolean bl = asJson = ctx.JSON() != null;
        if (ctx.NAMESPACES() != null) {
            if (this.theQCB.getStatementFactory() == null) {
                throw new DdlException("SHOW NAMESPACES must execute on a server");
            }
            this.theQCB.getStatementFactory().showNamespaces(asJson);
            return;
        }
        String namespace = null;
        String[] tableName = null;
        boolean showTables = false;
        boolean showIndexes = false;
        if (ctx.table_name() != null) {
            namespace = this.computeNamespace(ctx.table_name());
            if (this.getTable(namespace, tableName = Translator.getNamePath(ctx.table_name().id_path()), Translator.getLocation(ctx.table_name())) == null) {
                Translator.noTable(namespace, tableName, Translator.getLocation(ctx.table_name()));
            }
            if (ctx.INDEXES() != null) {
                showIndexes = true;
            }
        } else {
            assert (ctx.TABLES() != null);
            showTables = true;
        }
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("SHOW TABLE|INDEX must execute on a server");
        }
        this.theQCB.getStatementFactory().showTableOrIndex(namespace, Translator.concatPathName(tableName), showTables, showIndexes, asJson);
    }

    @Override
    public void exitCreate_user_statement(KVQLParser.Create_user_statementContext ctx) {
        boolean isEnabled;
        boolean passExpired;
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.CREATE_USER);
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        String userName = Translator.getIdentifierName(ctx.create_user_identified_clause(), "user");
        boolean isExternal = ctx.create_user_identified_clause().IDENTIFIED_EXTERNALLY() != null;
        boolean isAdmin = ctx.ADMIN() != null;
        boolean bl = passExpired = ctx.create_user_identified_clause().PASSWORD_EXPIRE() != null;
        boolean bl2 = ctx.account_lock() != null ? !Translator.isAccountLocked(ctx.account_lock()) : (isEnabled = true);
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("CREATE USER must execute on a server");
        }
        if (!isExternal) {
            Long pwdLifetimeInMillis = ctx.create_user_identified_clause().password_lifetime() == null ? null : Long.valueOf(Translator.resolvePassLifeTime(ctx.create_user_identified_clause().password_lifetime()));
            String plainPass = Translator.resolvePlainPassword(ctx.create_user_identified_clause().identified_clause());
            if (passExpired) {
                pwdLifetimeInMillis = -1L;
            }
            this.theQCB.getStatementFactory().createUser(userName, isEnabled, isAdmin, plainPass, pwdLifetimeInMillis);
        } else {
            this.theQCB.getStatementFactory().createExternalUser(userName, isEnabled, isAdmin);
        }
    }

    @Override
    public void exitCreate_role_statement(KVQLParser.Create_role_statementContext ctx) {
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.CREATE_ROLE);
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        String roleName = Translator.getIdentifierName(ctx.id(), "role");
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("CREATE ROLE must execute on a server");
        }
        this.theQCB.getStatementFactory().createRole(roleName);
    }

    @Override
    public void exitAlter_user_statement(KVQLParser.Alter_user_statementContext ctx) {
        Boolean isEnabled;
        Long pwdLifetimeInMillis;
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.ALTER_USER);
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        String userName = Translator.getIdentifierName(ctx.identifier_or_string(), "user");
        boolean retainPassword = false;
        String newPass = null;
        KVQLParser.Reset_password_clauseContext resetPassCtx = ctx.reset_password_clause();
        if (resetPassCtx != null) {
            newPass = Translator.resolvePlainPassword(resetPassCtx.identified_clause());
            retainPassword = resetPassCtx.RETAIN_CURRENT_PASSWORD() != null;
        }
        boolean clearRetainedPassword = ctx.CLEAR_RETAINED_PASSWORD() != null;
        boolean passwordExpire = ctx.PASSWORD_EXPIRE() != null;
        Long l = pwdLifetimeInMillis = ctx.password_lifetime() == null ? null : Long.valueOf(Translator.resolvePassLifeTime(ctx.password_lifetime()));
        Boolean bl = ctx.account_lock() != null ? Boolean.valueOf(!Translator.isAccountLocked(ctx.account_lock())) : (isEnabled = null);
        if (passwordExpire) {
            pwdLifetimeInMillis = -1L;
        }
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("ALTER USER must execute on a server");
        }
        this.theQCB.getStatementFactory().alterUser(userName, isEnabled, newPass, retainPassword, clearRetainedPassword, pwdLifetimeInMillis);
    }

    @Override
    public void exitDrop_user_statement(KVQLParser.Drop_user_statementContext ctx) {
        boolean cascade;
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.DROP_USER);
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        String userName = Translator.getIdentifierName(ctx.identifier_or_string(), "user");
        boolean bl = cascade = ctx.CASCADE() != null;
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("DROP USER must execute on a server");
        }
        this.theQCB.getStatementFactory().dropUser(userName, cascade);
    }

    @Override
    public void exitDrop_role_statement(KVQLParser.Drop_role_statementContext ctx) {
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.DROP_ROLE);
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        String roleName = Translator.getIdentifierName(ctx.id(), "role");
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("DROP ROLE must execute on a server");
        }
        this.theQCB.getStatementFactory().dropRole(roleName);
    }

    @Override
    public void exitGrant_statement(KVQLParser.Grant_statementContext ctx) {
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.GRANT);
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        HashSet<String> privSet = new HashSet<String>();
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("GRANT must execute on a server");
        }
        if (ctx.grant_roles() != null) {
            String[] roleNames = Translator.makeIdArray(ctx.grant_roles().id_list().id());
            if (ctx.grant_roles().principal().USER() != null) {
                assert (ctx.grant_roles().principal().ROLE() == null);
                String grantee = Translator.getIdentifierName(ctx.grant_roles().principal().identifier_or_string(), "user");
                this.theQCB.getStatementFactory().grantRolesToUser(grantee, roleNames);
            } else {
                String grantee = Translator.getIdentifierName(ctx.grant_roles().principal().id(), "role");
                this.theQCB.getStatementFactory().grantRolesToRole(grantee, roleNames);
            }
            return;
        }
        if (ctx.grant_system_privileges() != null) {
            List<KVQLParser.Priv_itemContext> privItemList = ctx.grant_system_privileges().sys_priv_list().priv_item();
            Translator.getPrivSet(privItemList, privSet);
            String roleName = Translator.getIdentifierName(ctx.grant_system_privileges().id(), "role");
            this.theQCB.getStatementFactory().grantPrivileges(roleName, null, null, privSet);
            return;
        }
        if (ctx.grant_object_privileges() != null) {
            if (!ctx.grant_object_privileges().obj_priv_list().ALL().isEmpty()) {
                privSet.add(ALL_PRIVS);
            } else {
                List<KVQLParser.Priv_itemContext> privItemList = ctx.grant_object_privileges().obj_priv_list().priv_item();
                Translator.getPrivSet(privItemList, privSet);
            }
            String roleName = Translator.getIdentifierName(ctx.grant_object_privileges().id(), "role");
            if (ctx.grant_object_privileges().object() != null) {
                String[] onTable = Translator.getNamePath(ctx.grant_object_privileges().object().table_name().id_path());
                String namespace = this.computeNamespace(ctx.grant_object_privileges().object().table_name());
                this.theQCB.getStatementFactory().grantPrivileges(roleName, namespace, Translator.concatPathName(onTable), privSet);
                return;
            }
            if (ctx.grant_object_privileges().namespace() != null) {
                String namespace = ctx.grant_object_privileges().namespace().getText();
                this.theQCB.getStatementFactory().grantNamespacePrivileges(roleName, NameUtils.switchToInternalUse(namespace), privSet);
                return;
            }
        }
    }

    @Override
    public void exitRevoke_statement(KVQLParser.Revoke_statementContext ctx) {
        if (this.theQCB.getPrepareCallback() != null) {
            this.theQCB.getPrepareCallback().queryOperation(PrepareCallback.QueryOperation.REVOKE);
            if (!this.theQCB.getPrepareCallback().prepareNeeded()) {
                throw new StopWalkException();
            }
        }
        HashSet<String> privSet = new HashSet<String>();
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("REVOKE must execute on a server");
        }
        if (ctx.revoke_roles() != null) {
            String[] roleNames = Translator.makeIdArray(ctx.revoke_roles().id_list().id());
            if (ctx.revoke_roles().principal().USER() != null) {
                assert (ctx.revoke_roles().principal().ROLE() == null);
                String revokee = Translator.getIdentifierName(ctx.revoke_roles().principal().identifier_or_string(), "user");
                this.theQCB.getStatementFactory().revokeRolesFromUser(revokee, roleNames);
            } else {
                String revokee = Translator.getIdentifierName(ctx.revoke_roles().principal().id(), "role");
                this.theQCB.getStatementFactory().revokeRolesFromRole(revokee, roleNames);
            }
            return;
        }
        if (ctx.revoke_system_privileges() != null) {
            List<KVQLParser.Priv_itemContext> privItemList = ctx.revoke_system_privileges().sys_priv_list().priv_item();
            Translator.getPrivSet(privItemList, privSet);
            String roleName = Translator.getIdentifierName(ctx.revoke_system_privileges().id(), "role");
            this.theQCB.getStatementFactory().revokePrivileges(roleName, null, null, privSet);
            return;
        }
        if (ctx.revoke_object_privileges() != null) {
            if (!ctx.revoke_object_privileges().obj_priv_list().ALL().isEmpty()) {
                privSet.add(ALL_PRIVS);
            } else {
                List<KVQLParser.Priv_itemContext> privItemList = ctx.revoke_object_privileges().obj_priv_list().priv_item();
                Translator.getPrivSet(privItemList, privSet);
            }
            String roleName = Translator.getIdentifierName(ctx.revoke_object_privileges().id(), "role");
            if (ctx.revoke_object_privileges().object() != null) {
                String[] onTable = Translator.getNamePath(ctx.revoke_object_privileges().object().table_name().id_path());
                String namespace = this.computeNamespace(ctx.revoke_object_privileges().object().table_name());
                this.theQCB.getStatementFactory().revokePrivileges(roleName, namespace, Translator.concatPathName(onTable), privSet);
                return;
            }
            if (ctx.revoke_object_privileges().namespace() != null) {
                String namespace = ctx.revoke_object_privileges().namespace().getText();
                this.theQCB.getStatementFactory().revokeNamespacePrivileges(roleName, NameUtils.switchToInternalUse(namespace), privSet);
                return;
            }
        }
    }

    @Override
    public void exitJsonAtom(KVQLParser.JsonAtomContext ctx) {
        this.jsonCollector.exitJsonAtom(ctx);
    }

    @Override
    public void exitJsonArrayValue(KVQLParser.JsonArrayValueContext ctx) {
        this.jsonCollector.exitJsonArrayValue(ctx);
    }

    @Override
    public void exitJsonObjectValue(KVQLParser.JsonObjectValueContext ctx) {
        this.jsonCollector.exitJsonObjectValue(ctx);
    }

    @Override
    public void exitJsonPair(KVQLParser.JsonPairContext ctx) {
        this.jsonCollector.exitJsonPair(ctx);
    }

    @Override
    public void exitArrayOfJsonValues(KVQLParser.ArrayOfJsonValuesContext ctx) {
        this.jsonCollector.exitArrayOfJsonValues(ctx);
    }

    @Override
    public void exitEmptyJsonArray(KVQLParser.EmptyJsonArrayContext ctx) {
        this.jsonCollector.exitEmptyJsonArray(ctx);
    }

    @Override
    public void exitJsonObject(KVQLParser.JsonObjectContext ctx) {
        this.jsonCollector.exitJsonObject(ctx);
    }

    @Override
    public void exitEmptyJsonObject(KVQLParser.EmptyJsonObjectContext ctx) {
        this.jsonCollector.exitEmptyJsonObject(ctx);
    }

    @Override
    public void exitJson_text(KVQLParser.Json_textContext ctx) {
        this.jsonCollector.exitJson_text(ctx);
    }

    private boolean getShowUserOrRoleOp(KVQLParser.Show_statementContext ctx) {
        boolean asJson;
        boolean bl = asJson = ctx.JSON() != null;
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("SHOW must execute on a server");
        }
        if (ctx.identifier_or_string() != null && ctx.USER() != null) {
            String name = Translator.getIdentifierName(ctx.identifier_or_string(), "user");
            this.theQCB.getStatementFactory().showUser(name, asJson);
            return true;
        }
        if (ctx.id() != null && ctx.ROLE() != null) {
            String name = Translator.getIdentifierName(ctx.id(), "role");
            this.theQCB.getStatementFactory().showRole(name, asJson);
            return true;
        }
        if (ctx.USERS() != null) {
            this.theQCB.getStatementFactory().showUser(null, asJson);
            return true;
        }
        if (ctx.ROLES() != null) {
            this.theQCB.getStatementFactory().showRole(null, asJson);
            return true;
        }
        return false;
    }

    private static boolean isAccountLocked(KVQLParser.Account_lockContext ctx) {
        if (ctx.LOCK() != null) {
            assert (ctx.UNLOCK() == null);
            return true;
        }
        return false;
    }

    private static String getIdentifierName(KVQLParser.IdContext ctx, String idType) {
        if (ctx != null) {
            return ctx.getText();
        }
        throw new QueryException("Invalid empty name of " + idType, Translator.getLocation(ctx));
    }

    private static String getIdentifierName(KVQLParser.Identifier_or_stringContext ctx, String idType) {
        String result;
        if (ctx.id() != null) {
            return Translator.getIdentifierName(ctx.id(), idType);
        }
        if (ctx.string() != null && !(result = EscapeUtil.inlineEscapedChars(Translator.stripFirstLast(ctx.string().getText()))).equals("")) {
            return result;
        }
        throw new QueryException("Invalid empty name of " + idType, Translator.getLocation(ctx));
    }

    private static String getIdentifierName(KVQLParser.Create_user_identified_clauseContext ctx, String idType) {
        String result;
        if (ctx.identified_clause() != null && ctx.id() != null) {
            return Translator.getIdentifierName(ctx.id(), idType);
        }
        if (ctx.IDENTIFIED_EXTERNALLY() != null && ctx.string() != null && !(result = EscapeUtil.inlineEscapedChars(Translator.stripFirstLast(ctx.string().getText()))).equals("")) {
            return result;
        }
        throw new QueryException("Invalid empty name of " + idType, Translator.getLocation(ctx));
    }

    private static String resolvePlainPassword(KVQLParser.Identified_clauseContext ctx) {
        String passStr = ctx.by_password().string().getText();
        if (passStr.isEmpty() || passStr.length() <= 2) {
            throw new QueryException("Invalid empty password", Translator.getLocation(ctx));
        }
        return passStr;
    }

    private static long resolvePassLifeTime(KVQLParser.Password_lifetimeContext ctx) {
        long timeValue;
        try {
            timeValue = Integer.parseInt(ctx.duration().INT().getText());
            if (timeValue < 0L) {
                throw new QueryException("Time value must not be negative", Translator.getLocation(ctx));
            }
        }
        catch (NumberFormatException nfe) {
            throw new QueryException("Invalid numeric value for time value", Translator.getLocation(ctx));
        }
        TimeUnit timeUnit = Translator.convertToTimeUnit(ctx.duration().time_unit());
        return TimeUnit.MILLISECONDS.convert(timeValue, timeUnit);
    }

    private static TimeUnit convertToTimeUnit(KVQLParser.Time_unitContext ctx) {
        String unitStr = ctx.getText();
        try {
            return TimeUnit.valueOf(unitStr.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            try {
                return DDLTimeUnit.valueOf(unitStr.toUpperCase(Locale.ENGLISH)).getUnit();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new QueryException("Unrecognized time unit " + unitStr, Translator.getLocation(ctx));
            }
        }
    }

    private static String[] getNamePath(KVQLParser.Id_pathContext ctx) {
        List<KVQLParser.IdContext> steps = ctx.id();
        String[] result = new String[steps.size()];
        int i = 0;
        for (KVQLParser.IdContext step : steps) {
            result[i] = step.getText();
            ++i;
        }
        return result;
    }

    private static String[] getParentPath(KVQLParser.Id_pathContext ctx) {
        List<KVQLParser.IdContext> steps = ctx.id();
        if (steps.size() == 1) {
            return null;
        }
        String[] result = new String[steps.size() - 1];
        int i = 0;
        for (KVQLParser.IdContext step : steps) {
            result[i] = step.getText();
            if (++i != steps.size() - 1) continue;
            break;
        }
        return result;
    }

    private static String getPathLeaf(KVQLParser.Id_pathContext ctx) {
        List<KVQLParser.IdContext> steps = ctx.id();
        return steps.get(steps.size() - 1).getText();
    }

    private static String concatPathName(String[] pathName) {
        return Translator.concatPathName(pathName, '.');
    }

    private static String concatPathName(String[] pathName, char separator) {
        if (pathName == null) {
            return null;
        }
        int numSteps = pathName.length;
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < numSteps; ++i) {
            name.append(pathName[i]);
            if (i >= numSteps - 1) continue;
            name.append(separator);
        }
        return name.toString();
    }

    private TableImpl getParentTable(KVQLParser.Table_nameContext ctx) {
        String namespace = this.computeNamespace(ctx);
        String[] parentPath = Translator.getParentPath(ctx.id_path());
        if (parentPath == null) {
            return null;
        }
        TableImpl parent = this.getTable(namespace, parentPath, Translator.getLocation(ctx));
        if (parent == null) {
            String fullPath = NameUtils.makeQualifiedName(namespace, Translator.concatPathName(Translator.getNamePath(ctx.id_path())));
            String parentName = NameUtils.makeQualifiedName(namespace, Translator.concatPathName(parentPath));
            Translator.noParentTable(parentName, fullPath, Translator.getLocation(ctx));
        }
        return parent;
    }

    private TableImpl getTable(String namespace, String[] pathName, QueryException.Location location) {
        if (this.theMetadataHelper == null) {
            throw new QueryException("No metadata found for table " + NameUtils.makeQualifiedName(namespace, Translator.concatPathName(pathName)), location);
        }
        return this.theMetadataHelper.getTable(namespace, pathName, this.theInDDL ? 0 : 2);
    }

    private TableImpl getTableSilently(String namespace, String[] pathName) {
        return this.theMetadataHelper == null ? null : this.theMetadataHelper.getTable(namespace, pathName, this.theInDDL ? 0 : 2);
    }

    private static String[] makeIdArray(List<KVQLParser.IdContext> list) {
        String[] ids = new String[list.size()];
        int i = 0;
        for (KVQLParser.IdContext idCtx : list) {
            ids[i++] = idCtx.getText();
        }
        return ids;
    }

    private static String[] makeKeyIdArray(List<KVQLParser.Id_with_sizeContext> list) {
        String[] ids = new String[list.size()];
        int i = 0;
        for (KVQLParser.Id_with_sizeContext idCtx : list) {
            ids[i++] = idCtx.id().getText();
        }
        return ids;
    }

    private void makePrimaryKey(List<KVQLParser.Id_with_sizeContext> list) {
        for (KVQLParser.Id_with_sizeContext idCtx : list) {
            String keyField = idCtx.id().getText();
            this.theTableBuilder.primaryKey(keyField);
            if (idCtx.storage_size() == null) continue;
            int size = Integer.parseInt(idCtx.storage_size().INT().getText());
            this.theTableBuilder.primaryKeySize(keyField, size);
        }
    }

    private static void getPrivSet(List<KVQLParser.Priv_itemContext> pCtxList, Set<String> privSet) {
        for (KVQLParser.Priv_itemContext privItem : pCtxList) {
            if (privItem.ALL_PRIVILEGES() != null) {
                privSet.add(ALL_PRIVS);
                continue;
            }
            privSet.add(Translator.getIdentifierName(privItem.id(), "privilege"));
        }
    }

    private IndexImpl.AnnotatedField[] makeFtsFieldArray(List<KVQLParser.Fts_pathContext> list) {
        IndexImpl.AnnotatedField[] fieldspecs = new IndexImpl.AnnotatedField[list.size()];
        int i = 0;
        for (KVQLParser.Fts_pathContext pctx : list) {
            KVQLParser.Index_pathContext path = pctx.index_path();
            String fieldName = path.getText();
            String jsonStr = (String)this.jsonCollector.get(pctx.jsobject());
            fieldspecs[i++] = new IndexImpl.AnnotatedField(fieldName, jsonStr);
        }
        return fieldspecs;
    }

    private static String stripFirstLast(String s) {
        return s.substring(1, s.length() - 1);
    }

    private static void noTable(String namespace, String[] pathName, QueryException.Location location) {
        throw new QueryException("Table does not exist: " + NameUtils.makeQualifiedName(namespace, Translator.concatPathName(pathName)), location);
    }

    private static void noParentTable(String parentName, String fullName, QueryException.Location location) {
        throw new QueryException("Parent table does not exist (" + parentName + ") in table path " + fullName, location);
    }

    private static QueryException.Location getLocation(ParserRuleContext ctx) {
        int startLine = -1;
        int startColumn = -1;
        int endLine = -1;
        int endColumn = -1;
        if (ctx.getStart() != null) {
            startLine = ctx.getStart().getLine();
            startColumn = ctx.getStart().getCharPositionInLine();
        }
        if (ctx.getStop() != null) {
            endLine = ctx.getStop().getLine();
            endColumn = ctx.getStop().getCharPositionInLine();
        }
        return new QueryException.Location(startLine, startColumn, endLine, endColumn);
    }

    private static QueryException.Location getLocation(TerminalNode node) {
        int startLine = -1;
        int startColumn = -1;
        int endLine = -1;
        int endColumn = -1;
        if (node != null && node.getSymbol() != null) {
            startLine = node.getSymbol().getLine();
            startColumn = node.getSymbol().getCharPositionInLine();
            endLine = node.getSymbol().getLine();
            endColumn = node.getSymbol().getCharPositionInLine();
        }
        return new QueryException.Location(startLine, startColumn, endLine, endColumn);
    }

    private static class StopWalkException
    extends RuntimeException {
        private StopWalkException() {
        }
    }

    static enum DDLTimeUnit {
        S{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.SECONDS;
            }
        }
        ,
        M{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.MINUTES;
            }
        }
        ,
        H{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.HOURS;
            }
        }
        ,
        D{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.DAYS;
            }
        };


        abstract TimeUnit getUnit();
    }

    public static class IdentityDefHelper {
        private boolean isSetAlways = false;
        private boolean always = false;
        private boolean isSetOnNull = false;
        private boolean onNull = false;
        private boolean isSetStart = false;
        private String start = null;
        private boolean isSetIncrement = false;
        private String increment = null;
        private boolean isSetMax = false;
        private String max = null;
        private boolean isSetMin = false;
        private String min = null;
        private boolean isSetCache = false;
        private String cache = null;
        private boolean isSetCycle = false;
        private boolean cycle = false;

        public boolean isSetAlways() {
            return this.isSetAlways;
        }

        public boolean getAlways() {
            return this.always;
        }

        public void setAlways(boolean always) {
            this.always = always;
            this.isSetAlways = true;
        }

        public boolean isSetOnNull() {
            return this.isSetOnNull;
        }

        public boolean getOnNull() {
            return this.onNull;
        }

        public void setOnNull(boolean onNull) {
            this.onNull = onNull;
            this.isSetOnNull = true;
        }

        public boolean isSetStart() {
            return this.isSetStart;
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
            this.isSetStart = true;
        }

        public boolean isSetIncrement() {
            return this.isSetIncrement;
        }

        public String getIncrement() {
            return this.increment;
        }

        public void setIncrement(String increment) {
            this.increment = increment;
            this.isSetIncrement = true;
        }

        public boolean isSetMax() {
            return this.isSetMax;
        }

        public String getMax() {
            return this.max;
        }

        public void setMax(String max) {
            this.max = max;
            this.isSetMax = true;
        }

        public boolean isSetMin() {
            return this.isSetMin;
        }

        public String getMin() {
            return this.min;
        }

        public void setMin(String min) {
            this.min = min;
            this.isSetMin = true;
        }

        public boolean isSetCache() {
            return this.isSetCache;
        }

        public String getCache() {
            return this.cache;
        }

        public void setCache(String cache) {
            this.cache = cache;
            this.isSetCache = true;
        }

        public boolean isSetCycle() {
            return this.isSetCycle;
        }

        public boolean getCycle() {
            return this.cycle;
        }

        public void setCycle(boolean cycle) {
            this.cycle = cycle;
            this.isSetCycle = true;
        }
    }

    private static class FieldDefHelper {
        final String name;
        String comment;
        final QueryException.Location location;
        FieldDefImpl type = null;
        FieldValueImpl defaultValue = null;
        boolean nullable = true;

        FieldDefHelper(String name, String comment, QueryException.Location location) {
            this.name = name;
            this.comment = comment;
            this.location = location;
        }

        String getName() {
            return this.name;
        }

        void setType(FieldDefImpl t) {
            this.type = t;
        }

        FieldDefImpl getType() {
            return this.type;
        }

        void setNullable(boolean v, KVQLParser.Not_nullContext ctx) {
            this.nullable = v;
            if (!this.nullable) {
                if (this.type.isAtomic()) {
                    return;
                }
                throw new QueryException("Fields of type: " + this.type.getType() + " cannot be created as not-nullable", Translator.getLocation(ctx));
            }
        }

        boolean getNullable() {
            return this.nullable;
        }

        void setDefault(String strval, KVQLParser.Default_valueContext ctx) {
            if (this.type == null) {
                throw new QueryStateException("Type must be set before setting a default value.");
            }
            if (!this.type.isAtomic()) {
                throw new QueryException("Fields of type: " + this.type.getType() + " cannot have default values", Translator.getLocation(ctx));
            }
            if (ctx.string() != null) {
                if (!(this.type.isString() || this.type.isTimestamp() || this.type.isBinary() || this.type.isFixedBinary())) {
                    throw new QueryException("Quoted default value for a non-string field. Field = " + this.name + " Value = " + strval, Translator.getLocation(ctx));
                }
                strval = Translator.stripFirstLast(strval);
                strval = EscapeUtil.inlineEscapedChars(strval);
            }
            if (ctx.number() != null) {
                if (!(this.type.isInteger() || this.type.isLong() || this.type.isFloat() || this.type.isNumber() || this.type.isDouble() || this.type.isTimestamp())) {
                    throw new QueryException("Numeric default value for a non-numeric field. Field = " + this.name + " Value = " + strval, Translator.getLocation(ctx));
                }
                strval = Translator.stripNumericLetter(strval);
            }
            if (ctx.id() != null && !this.type.isEnum()) {
                throw new QueryException("id as default value for a non-enum field. Field = " + this.name + " Value = " + strval, Translator.getLocation(ctx));
            }
            if (!(ctx.TRUE() == null && ctx.FALSE() == null || this.type.isBoolean())) {
                throw new QueryException("Boolean default value for a non-boolean field. Field = " + this.name + " Value = " + strval, Translator.getLocation(ctx));
            }
            try {
                switch (this.type.getType()) {
                    case INTEGER: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.createInteger(Integer.parseInt(strval)));
                        break;
                    }
                    case LONG: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.createLong(Long.parseLong(strval)));
                        break;
                    }
                    case FLOAT: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.createFloat(Float.parseFloat(strval)));
                        break;
                    }
                    case DOUBLE: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.createDouble(Double.parseDouble(strval)));
                        break;
                    }
                    case NUMBER: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.createNumber(new BigDecimal(strval)));
                        break;
                    }
                    case STRING: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.createString(strval));
                        break;
                    }
                    case ENUM: {
                        this.defaultValue = this.type.createEnum(strval);
                        break;
                    }
                    case BOOLEAN: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.createBoolean(Boolean.parseBoolean(strval)));
                        break;
                    }
                    case TIMESTAMP: {
                        if (ctx.string() != null) {
                            this.defaultValue = (FieldValueImpl)((Object)this.type.asTimestamp().fromString(strval));
                            break;
                        }
                        assert (ctx.number().INT() != null);
                        this.defaultValue = ((TimestampDefImpl)this.type).createTimestamp(new Timestamp(Long.parseLong(strval)));
                        break;
                    }
                    case BINARY: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.asBinary().fromString(strval));
                        break;
                    }
                    case FIXED_BINARY: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.asFixedBinary().fromString(strval));
                        break;
                    }
                    default: {
                        throw new QueryException("Unexpected type for default value. Field = " + this.name + " Type = " + this.type + " Value = " + strval, Translator.getLocation(ctx));
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                throw new QueryException(iae.getMessage(), Translator.getLocation(ctx));
            }
        }

        FieldValueImpl getDefault() {
            return this.defaultValue;
        }

        void validate() {
            if (this.defaultValue == null && !this.nullable) {
                throw new QueryException("Non-nullable field without a default value.  Field = " + this.name, this.location);
            }
            this.type.setDescription(this.comment);
        }
    }
}

