/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.nio;

import com.sleepycat.je.rep.net.DataChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.AbstractResponderEndpoint;
import oracle.kv.impl.async.BytesUtil;
import oracle.kv.impl.async.DialogHandler;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.EndpointHandler;
import oracle.kv.impl.async.EndpointHandlerManager;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.SocketPrepared;
import oracle.kv.impl.async.dialog.ProtocolMesg;
import oracle.kv.impl.async.dialog.nio.ChannelHandler;
import oracle.kv.impl.async.dialog.nio.NioChannelExecutor;
import oracle.kv.impl.async.dialog.nio.NioEndpointGroup;
import oracle.kv.impl.async.dialog.nio.NioEndpointHandler;
import oracle.kv.impl.util.CommonLoggerUtils;

class PreReadWrappedEndpointHandler
implements EndpointHandler,
EndpointHandlerManager,
ChannelHandler {
    private static final int ASYNC_MAGIC_NUMBER = BytesUtil.bytesToInt(ProtocolMesg.MAGIC_NUMBER, 0);
    private static final int RMI_MAGIC_NUMBER = 1246907721;
    private static final int TLS12_MAGIC_NUMBER = 369296128;
    private final AbstractResponderEndpoint responderEndpoint;
    private final NetworkAddress remoteAddress;
    private final NioChannelExecutor channelExecutor;
    private final SocketChannel socketChannel;
    private final NioEndpointGroup.NioListener listener;
    private final byte[] magicNumber = new byte[ProtocolMesg.MAGIC_NUMBER.length];
    private final ByteBuffer magicNumberBuf = ByteBuffer.wrap(this.magicNumber);
    private final NioEndpointHandler endpointHandler;
    private volatile boolean isShutdown = false;

    PreReadWrappedEndpointHandler(AbstractResponderEndpoint responderEndpoint, EndpointConfig endpointConfig, NetworkAddress remoteAddress, NioChannelExecutor channelExecutor, NioEndpointGroup.NioListener listener, DataChannel dataChannel) {
        this.responderEndpoint = responderEndpoint;
        this.remoteAddress = remoteAddress;
        this.channelExecutor = channelExecutor;
        this.socketChannel = dataChannel.getSocketChannel();
        this.listener = listener;
        this.endpointHandler = new NioEndpointHandler(responderEndpoint.getLogger(), this, endpointConfig, false, remoteAddress, channelExecutor, listener.getDialogHandlerFactories(), dataChannel);
    }

    @Override
    public NetworkAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public ScheduledExecutorService getSchedExecService() {
        return this.channelExecutor;
    }

    @Override
    public long getUUID() {
        return this.endpointHandler.getUUID();
    }

    @Override
    public long getConnID() {
        return this.endpointHandler.getConnID();
    }

    @Override
    public String getStringID() {
        return this.endpointHandler.getStringID();
    }

    @Override
    public void startDialog(int dialogType, DialogHandler dialogHandler, long timeoutMillis) {
        this.endpointHandler.startDialog(dialogType, dialogHandler, timeoutMillis);
    }

    @Override
    public int getNumDialogsLimit() {
        return this.endpointHandler.getNumDialogsLimit();
    }

    @Override
    public void shutdown(String detail, boolean force) {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        this.responderEndpoint.onHandlerShutdown(this);
        this.endpointHandler.shutdown(detail, force);
    }

    @Override
    public void onHandlerShutdown(EndpointHandler handler) {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        this.responderEndpoint.onHandlerShutdown(this);
    }

    @Override
    public void onConnected() {
        try {
            if (!this.onChannelPreRead()) {
                this.channelExecutor.registerRead(this.socketChannel, this);
            }
        }
        catch (IOException e) {
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().log(Level.FINE, "Error registering for read after pre-read: endpoint={0}, error={1}", new Object[]{this.endpointHandler, CommonLoggerUtils.getStackTrace(e)});
            }
            this.shutdown(e.getMessage(), true);
        }
    }

    @Override
    public void onRead() {
        this.onChannelPreRead();
    }

    @Override
    public void onWrite() {
        throw new IllegalStateException();
    }

    @Override
    public void onClosing() {
        this.shutdown("Executor closing", true);
    }

    @Override
    public void onError(Throwable t, SelectableChannel channel) {
        this.endpointHandler.onError(t, channel);
    }

    private boolean onChannelPreRead() {
        Logger logger = this.getLogger();
        try {
            this.socketChannel.read(this.magicNumberBuf);
            if (this.magicNumberBuf.remaining() != 0) {
                return false;
            }
            if (logger.isLoggable(Level.FINE)) {
                int magicInt = BytesUtil.bytesToInt(this.magicNumber, 0);
                logger.log(Level.FINE, "Done pre-reading: magic number={0}{1}, remoteAddress={2}, localAddress={3}", new Object[]{BytesUtil.toString(this.magicNumber, 0, this.magicNumber.length), magicInt == ASYNC_MAGIC_NUMBER ? " (Async)" : (magicInt == 1246907721 ? " (RMI)" : (magicInt == 369296128 ? " (TLSv1.2)" : "")), this.remoteAddress, this.listener.getLocalAddress()});
            }
            if (!Arrays.equals(this.magicNumber, ProtocolMesg.MAGIC_NUMBER)) {
                try {
                    SocketPrepared socketPrepared = this.listener.getSocketPrepared();
                    if (socketPrepared == null) {
                        logger.log(Level.INFO, "Got non-async connection, but no sync handler is present: remoteAddress={0}, localAddress={1}", new Object[]{this.remoteAddress, this.listener.getLocalAddress()});
                    } else {
                        this.endpointHandler.handedOffToSync();
                        this.channelExecutor.deregister(this.socketChannel);
                        this.socketChannel.configureBlocking(true);
                        this.magicNumberBuf.clear();
                        logger.log(Level.FINE, "Handing off the connection to the non-async handler: handler={0}, buf={1}, socket={2}", new Object[]{socketPrepared, BytesUtil.toString(this.magicNumberBuf, this.magicNumberBuf.limit()), this.socketChannel.socket()});
                        socketPrepared.onPrepared(this.magicNumberBuf, this.socketChannel.socket());
                    }
                }
                finally {
                    this.shutdown("Got non-async connection", true);
                }
                return true;
            }
            if (this.listener.getDialogHandlerFactories().isEmpty()) {
                logger.log(Level.INFO, "Got async connection, but no available dialog factory for responding");
                this.shutdown("No factory for async connection", true);
                return true;
            }
            logger.log(Level.FINE, "Async endpoint handler enabled for a new connection: {0}", this.endpointHandler);
            this.channelExecutor.registerRead(this.socketChannel, this.endpointHandler);
            this.endpointHandler.onChannelReady();
            this.endpointHandler.onRead();
            return true;
        }
        catch (Throwable t) {
            Level level = Level.INFO;
            if (t instanceof IOException) {
                level = Level.FINE;
            }
            if (logger.isLoggable(level)) {
                logger.log(level, "Error while doing pre-read, remoteAddress={0}, localAddress={1}: {2}", new Object[]{this.remoteAddress, this.listener.getLocalAddress(), CommonLoggerUtils.getStackTrace(t)});
            }
            this.shutdown(t.getMessage(), true);
            return true;
        }
    }

    private Logger getLogger() {
        return this.responderEndpoint.getLogger();
    }
}

