/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.admin;

import com.sleepycat.je.rep.InsufficientLogException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.kv.KVSecurityException;
import oracle.kv.impl.fault.ClientAccessException;
import oracle.kv.impl.fault.ProcessExitCode;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.fault.ServiceFaultHandler;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.admin.RepNodeAdminFaultException;
import oracle.kv.impl.util.ConfigurableService;

public class RepNodeAdminFaultHandler
extends ServiceFaultHandler {
    private final AtomicInteger activeRequests = new AtomicInteger(0);

    public RepNodeAdminFaultHandler(RepNodeService repNodeService, Logger logger, ProcessExitCode defaultExitCode) {
        super((ConfigurableService)repNodeService, logger, defaultExitCode);
    }

    public int getActiveRequests() {
        return this.activeRequests.get();
    }

    @Override
    protected RuntimeException getThrowException(RuntimeException fault) {
        if (fault instanceof ClientAccessException) {
            return ((ClientAccessException)fault).getCause();
        }
        if (fault instanceof KVSecurityException) {
            return fault;
        }
        return new RepNodeAdminFaultException(fault);
    }

    @Override
    public ProcessExitCode getExitCode(RuntimeException requestException, ProcessExitCode exitCode) {
        return requestException instanceof InsufficientLogException ? null : super.getExitCode(requestException, exitCode);
    }

    @Override
    public <R, E extends Exception> R execute(ProcessFaultHandler.Operation<R, E> operation) throws E {
        this.activeRequests.incrementAndGet();
        try {
            R r = super.execute(operation);
            return r;
        }
        finally {
            this.activeRequests.decrementAndGet();
        }
    }

    @Override
    public <R> R execute(ProcessFaultHandler.SimpleOperation<R> operation) {
        this.activeRequests.incrementAndGet();
        try {
            R r = super.execute(operation);
            return r;
        }
        finally {
            this.activeRequests.decrementAndGet();
        }
    }

    @Override
    public <E extends Exception> void execute(ProcessFaultHandler.Procedure<E> proc) throws E {
        this.activeRequests.incrementAndGet();
        try {
            super.execute(proc);
        }
        finally {
            this.activeRequests.decrementAndGet();
        }
    }

    @Override
    public void execute(ProcessFaultHandler.SimpleProcedure proc) {
        this.activeRequests.incrementAndGet();
        try {
            super.execute(proc);
        }
        finally {
            this.activeRequests.decrementAndGet();
        }
    }
}

