/*
 * Copyright (c) 1998, 2021 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     James - initial impl
package org.eclipse.persistence.testing.tests.plsql;

import org.eclipse.persistence.testing.models.plsql.PLSQLXMLSystem;

/**
 * This model tests calling PLSQL stored procedures with PLSQL types.
 */
public class PLSQLXMLTestModel extends PLSQLTestModel {
    public PLSQLXMLTestModel() {
        setDescription("This model tests calling PLSQL stored procedures with PLSQL types from project XML.");
    }

    @Override
    public void addRequiredSystems() {
        if (!getSession().getLogin().getPlatform().isOracle()) {
            warning("PLSQL is only supported on Oracle.");
        }

        addRequiredSystem(new PLSQLXMLSystem());
    }
}
