/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.netty;

import com.sleepycat.je.rep.net.SSLAuthenticator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;

public class VerifyingSSLHandler
extends ChannelInboundHandlerAdapter {
    private final Logger logger;
    private final String endpointId;
    private final SSLEngine sslEngine;
    private final String targetHost;
    private final HostnameVerifier hostVerifier;
    private final SSLAuthenticator authenticator;
    private final SslHandler sslHandler;

    public VerifyingSSLHandler(Logger logger, String endpointId, SSLEngine sslEngine, String targetHost, HostnameVerifier hostVerifier, SSLAuthenticator authenticator) {
        this.logger = logger;
        this.endpointId = endpointId;
        this.sslEngine = sslEngine;
        this.targetHost = targetHost;
        this.hostVerifier = hostVerifier;
        this.authenticator = authenticator;
        this.sslHandler = new SslHandler(sslEngine);
    }

    public SslHandler sslHandler() {
        return this.sslHandler;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        boolean peerTrusted;
        if (evt != SslHandshakeCompletionEvent.SUCCESS) {
            super.userEventTriggered(ctx, evt);
            return;
        }
        this.logger.log(Level.INFO, "SSL handshake done ({0})", this.endpointId);
        SSLSession session = this.sslEngine.getSession();
        if (this.sslEngine.getUseClientMode()) {
            boolean peerTrusted2;
            if (this.hostVerifier == null) return;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Verifying server host, verifier={0}, targetHost={1}, principal={2}, certificates={3}", new Object[]{this.hostVerifier, this.targetHost, session.getPeerPrincipal(), Arrays.toString(session.getPeerCertificates())});
            }
            if (peerTrusted2 = this.hostVerifier.verify(this.targetHost, session)) {
                this.logger.log(Level.FINE, "SSL host verifier reports that connection target is valid");
                return;
            }
            this.logger.log(Level.INFO, "SSL host verifier reports that connection target is NOT valid");
            throw new IOException("Server identity could not be verified");
        }
        if (this.authenticator == null) return;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Authenticating client host, authenticator={0}, principal={1}", new Object[]{this.authenticator, session.getPeerPrincipal()});
        }
        if (peerTrusted = this.authenticator.isTrusted(session)) {
            this.logger.log(Level.FINE, "SSL authenticator reports that channel is trusted");
            return;
        }
        this.logger.log(Level.INFO, "SSL authenticator reports that channel is NOT trusted");
    }
}

