/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.weaving;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Version;
import java.io.Serializable;
import org.eclipse.persistence.testing.models.weaving.Customer;
import org.eclipse.persistence.testing.models.weaving.Item;

@Entity(name="OrderBean")
@Table(name="CMP3_ORDER")
@NamedQuery(name="findAllOrdersByItem", query="SELECT OBJECT(theorder) FROM OrderBean theorder WHERE theorder.item.itemId = :id")
public class Order
implements Serializable {
    private Integer orderId;
    private int version;
    private Item item;
    private int quantity;
    private String shippingAddress;
    private Customer customer;

    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="ORDER_TABLE_GENERATOR")
    @TableGenerator(name="ORDER_TABLE_GENERATOR", table="CMP3_CUSTOMER_SEQ", pkColumnName="SEQ_NAME", valueColumnName="SEQ_COUNT", pkColumnValue="ORDER_SEQ")
    @Column(name="ORDER_ID")
    public Integer getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Integer id) {
        this.orderId = id;
    }

    @Version
    @Column(name="ORDER_VERSION")
    protected int getVersion() {
        return this.version;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    @OneToOne(cascade={CascadeType.PERSIST}, fetch=FetchType.LAZY)
    @JoinColumn(name="ITEM_ID", referencedColumnName="ITEM_ID")
    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    @Column(name="SHIP_ADDR")
    public String getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(String shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CUST_ID")
    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }
}

