/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.sklogger;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.kv.impl.util.sklogger.MetricFamilySamples;
import oracle.kv.impl.util.sklogger.MetricRegistry;
import oracle.kv.impl.util.sklogger.StatsData;

public abstract class Metric<E extends Element>
extends StatsData {
    protected final List<String> labelNames;
    protected TreeMap<String[], E> elements;
    protected E noLabelsElement;

    public Metric(String name, String ... labelNames) {
        super(name);
        for (String labelName : labelNames) {
            this.checkMetricLabelName(labelName);
        }
        this.labelNames = Arrays.asList(labelNames);
        this.elements = new TreeMap(new StringArrayComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E labels(String ... labelValues) {
        if (labelValues.length != this.labelNames.size()) {
            throw new IllegalArgumentException("Incorrect number of labels.");
        }
        for (String label : labelValues) {
            if (label != null) continue;
            throw new IllegalArgumentException("Label cannot be null.");
        }
        Element e = (Element)this.elements.get(labelValues);
        if (e != null) {
            return (E)e;
        }
        Metric metric = this;
        synchronized (metric) {
            e = (Element)this.elements.get(labelValues);
            if (e != null) {
                return (E)e;
            }
            e = this.newElement();
            TreeMap<String[], E> newElements = new TreeMap<String[], E>(this.elements);
            newElements.put(labelValues, e);
            this.elements = newElements;
            return (E)e;
        }
    }

    protected void initializeNoLabelsElement() {
        if (this.labelNames.size() == 0) {
            this.noLabelsElement = this.labels(new String[0]);
        }
    }

    private void checkMetricLabelName(String name) {
        if (name == null || name.contains(".")) {
            throw new IllegalArgumentException("Invalid metric label name: " + name);
        }
    }

    protected abstract E newElement();

    public abstract MetricFamilySamples<?> collect();

    public Metric<?> registerTo(MetricRegistry registry) {
        registry.addMetricData(this);
        return this;
    }

    private static class StringArrayComparator
    implements Comparator<String[]> {
        private StringArrayComparator() {
        }

        @Override
        public int compare(String[] s1, String[] s2) {
            if (s1.equals(s2)) {
                return 0;
            }
            for (int i = 0; i < s1.length; ++i) {
                int result = s1[i].compareTo(s2[i]);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    public static abstract class Result
    implements Serializable {
        public static final long serialVersionUID = 1L;

        public abstract Map<String, Object> toMap();
    }

    public static interface Element {
    }
}

