/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo.change;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.Add;
import oracle.kv.impl.topo.change.Remove;
import oracle.kv.impl.topo.change.TopologyChange;
import oracle.kv.impl.topo.change.Update;

@Persistent
public class TopologyChangeTracker
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Topology topology;
    private int seqNum = 0;
    private LinkedList<TopologyChange> changes;

    public TopologyChangeTracker(Topology topology) {
        this.topology = topology;
        this.changes = new LinkedList();
    }

    private TopologyChangeTracker() {
    }

    public int getFirstChangeSeqNum() {
        return this.changes.size() == 0 ? -1 : this.changes.get(0).getSequenceNumber();
    }

    public int getSeqNum() {
        return this.seqNum;
    }

    public void logAdd(Topology.Component<?> component) {
        component.setSequenceNumber(++this.seqNum);
        this.changes.add(new Add(this.seqNum, component));
    }

    public void logUpdate(Topology.Component<?> newComponent) {
        newComponent.setSequenceNumber(++this.seqNum);
        this.changes.add(new Update(this.seqNum, newComponent));
    }

    public void logRemove(ResourceId resourceId) {
        this.changes.add(new Remove(++this.seqNum, resourceId));
        assert (this.topology.get(resourceId) == null);
    }

    public List<TopologyChange> getChanges(int startSeqNum) {
        int minSeqNum;
        int n = minSeqNum = this.changes.size() == 0 ? 0 : this.changes.getFirst().sequenceNumber;
        if (startSeqNum < minSeqNum) {
            return null;
        }
        if (startSeqNum > this.changes.getLast().getSequenceNumber()) {
            return null;
        }
        LinkedList<TopologyChange> copy = new LinkedList<TopologyChange>();
        for (TopologyChange change : this.changes) {
            if (change.getSequenceNumber() < startSeqNum) continue;
            copy.add(change.clone());
        }
        return copy;
    }

    public List<TopologyChange> getChanges() {
        return this.getChanges(this.changes.size() == 0 ? 0 : this.changes.getFirst().sequenceNumber);
    }

    public void discardChanges(int startSeqNum) {
        Iterator i = this.changes.iterator();
        while (i.hasNext() && ((TopologyChange)i.next()).getSequenceNumber() <= startSeqNum) {
            i.remove();
        }
    }
}

