/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.ExprMapConstr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.util.SerialVersion;

public class MapConstrIter
extends PlanIter {
    private final PlanIter[] theArgs;
    private final MapDefImpl theDef;

    public MapConstrIter(ExprMapConstr e, int resultReg, PlanIter[] args) {
        super(e, resultReg);
        this.theArgs = args;
        this.theDef = e.getMapType();
    }

    MapConstrIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theArgs = MapConstrIter.deserializeIters(in, serialVersion);
        this.theDef = (MapDefImpl)MapConstrIter.deserializeFieldDef(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        if (serialVersion < 13) {
            String QV3String = SerialVersion.getKVVersion((short)13).getNumericVersionString();
            throw new QueryException("Cannot execute a query with a map constructor at a server whose version is less than " + QV3String + "\nserialVersion = " + serialVersion + " expected version = " + 13);
        }
        super.writeFastExternal(out, serialVersion);
        MapConstrIter.serializeIters(this.theArgs, out, serialVersion);
        MapConstrIter.serializeFieldDef(this.theDef, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.MAP_CONSTR;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        for (PlanIter arg : this.theArgs) {
            arg.open(rcb);
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        int numArgs = this.theArgs.length;
        MapValueImpl map = this.theDef.createMap();
        for (int i = 0; i < numArgs; i += 2) {
            FieldValueImpl nameValue;
            boolean more = this.theArgs[i].next(rcb);
            if (!more || !(more = this.theArgs[i + 1].next(rcb)) || (nameValue = rcb.getRegVal(this.theArgs[i].getResultReg())).isNull()) continue;
            String name = ((StringValueImpl)nameValue).get();
            FieldValueImpl elemValue = rcb.getRegVal(this.theArgs[i + 1].getResultReg());
            if (elemValue.isNull()) continue;
            if (elemValue.isTuple()) {
                elemValue = ((TupleValue)elemValue).toRecord();
            }
            try {
                map.put(name, elemValue);
                continue;
            }
            catch (IllegalArgumentException e) {
                if (rcb.getTraceLevel() >= 1) {
                    rcb.trace("Query Plan:\n" + rcb.getRootIter().display() + "\nValue:\n" + elemValue);
                }
                throw new QueryException(e, this.theLocation);
            }
        }
        rcb.setRegVal(this.theResultReg, map);
        state.done();
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        for (PlanIter arg : this.theArgs) {
            arg.reset(rcb);
        }
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        for (PlanIter arg : this.theArgs) {
            arg.close(rcb);
        }
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append("Type:\n");
        formatter.indent(sb);
        this.theDef.display(sb, formatter);
        sb.append("\n");
        for (int i = 0; i < this.theArgs.length; ++i) {
            this.theArgs[i].display(sb, formatter);
            if (i >= this.theArgs.length - 1) continue;
            sb.append(",\n");
        }
    }
}

