/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.EnumValueImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FloatValueImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FuncCompOp;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.NumberValue;

public class CompOpIter
extends PlanIter {
    private final FunctionLib.FuncCode theCode;
    private final PlanIter theLeftOp;
    private final PlanIter theRightOp;

    public CompOpIter(Expr e, int resultReg, FunctionLib.FuncCode code, PlanIter[] argIters) {
        super(e, resultReg);
        this.theCode = code;
        assert (argIters.length == 2);
        this.theLeftOp = argIters[0];
        this.theRightOp = argIters[1];
    }

    CompOpIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short ordinal = CompOpIter.readOrdinal(in, FunctionLib.FuncCode.values().length);
        this.theCode = FunctionLib.FuncCode.values()[ordinal];
        this.theLeftOp = CompOpIter.deserializeIter(in, serialVersion);
        this.theRightOp = CompOpIter.deserializeIter(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.theCode.ordinal());
        CompOpIter.serializeIter(this.theLeftOp, out, serialVersion);
        CompOpIter.serializeIter(this.theRightOp, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.COMP_OP;
    }

    @Override
    FunctionLib.FuncCode getFuncCode() {
        return this.theCode;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new CompIterState());
        this.theLeftOp.open(rcb);
        this.theRightOp.open(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        boolean result;
        CompIterState state = (CompIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean leftOpNext = this.theLeftOp.next(rcb);
        if (leftOpNext && this.theLeftOp.next(rcb)) {
            throw new QueryException("The left operand of comparison operator " + FuncCompOp.printOp(this.theCode) + " is a sequence with more than one items. Comparison operators cannot operate on sequences of more than one items.", this.theLocation);
        }
        boolean rightOpNext = this.theRightOp.next(rcb);
        if (rightOpNext && this.theRightOp.next(rcb)) {
            throw new QueryException("The right operand of comparison operator " + FuncCompOp.printOp(this.theCode) + " is a sequence with more than one items. Comparison operators cannot operate on sequences of more than one items.", this.theLocation);
        }
        if (!rightOpNext && !leftOpNext) {
            state.theResult.comp = 0;
        } else if (!rightOpNext || !leftOpNext) {
            if (this.theCode != FunctionLib.FuncCode.OP_NEQ) {
                state.theResult.incompatible = true;
            } else {
                state.theResult.comp = 1;
            }
        } else {
            FieldValueImpl lvalue = rcb.getRegVal(this.theLeftOp.getResultReg());
            FieldValueImpl rvalue = rcb.getRegVal(this.theRightOp.getResultReg());
            assert (lvalue != null && rvalue != null);
            CompOpIter.compare(rcb, lvalue, rvalue, this.theCode, state.theResult, this.getLocation());
        }
        if (state.theResult.haveNull) {
            rcb.setRegVal(this.theResultReg, NullValueImpl.getInstance());
            state.done();
            return true;
        }
        if (state.theResult.incompatible) {
            rcb.setRegVal(this.theResultReg, BooleanValueImpl.falseValue);
            state.done();
            return true;
        }
        int comp = state.theResult.comp;
        switch (this.theCode) {
            case OP_EQ: {
                result = comp == 0;
                break;
            }
            case OP_NEQ: {
                result = comp != 0;
                break;
            }
            case OP_GT: {
                result = comp > 0;
                break;
            }
            case OP_GE: {
                result = comp >= 0;
                break;
            }
            case OP_LT: {
                result = comp < 0;
                break;
            }
            case OP_LE: {
                result = comp <= 0;
                break;
            }
            default: {
                throw new QueryStateException("Invalid operation code: " + (Object)((Object)this.theCode));
            }
        }
        BooleanValueImpl res = result ? BooleanValueImpl.trueValue : BooleanValueImpl.falseValue;
        rcb.setRegVal(this.theResultReg, res);
        state.done();
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theLeftOp.reset(rcb);
        this.theRightOp.reset(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theLeftOp.close(rcb);
        this.theRightOp.close(rcb);
        state.close();
    }

    static void compare(RuntimeControlBlock rcb, FieldValueImpl v0, FieldValueImpl v1, FunctionLib.FuncCode opCode, CompResult res, QueryException.Location location) {
        if (rcb.getTraceLevel() >= 3) {
            rcb.trace("Comparing values: \n" + v0 + "\n" + v1);
        }
        res.clear();
        if (v0.isNull() || v1.isNull()) {
            res.haveNull = true;
            return;
        }
        if (v1.isJsonNull()) {
            if (v0.isJsonNull()) {
                res.comp = 0;
                return;
            }
            if (opCode != FunctionLib.FuncCode.OP_NEQ) {
                res.incompatible = true;
                return;
            }
            res.comp = 1;
            return;
        }
        FieldDef.Type tc0 = v0.getType();
        FieldDef.Type tc1 = v1.getType();
        switch (tc0) {
            case INTEGER: {
                switch (tc1) {
                    case INTEGER: {
                        res.comp = IntegerValueImpl.compare(((IntegerValueImpl)v0).getInt(), ((IntegerValueImpl)v1).getInt());
                        return;
                    }
                    case LONG: {
                        res.comp = LongValueImpl.compare(((IntegerValueImpl)v0).getLong(), ((LongValueImpl)v1).getLong());
                        return;
                    }
                    case FLOAT: {
                        res.comp = Float.compare(((IntegerValueImpl)v0).getInt(), ((FloatValueImpl)v1).getFloat());
                        return;
                    }
                    case DOUBLE: {
                        res.comp = Double.compare(((IntegerValueImpl)v0).getInt(), ((DoubleValueImpl)v1).getDouble());
                        return;
                    }
                    case NUMBER: {
                        res.comp = -v1.compareTo(v0);
                        return;
                    }
                }
                res.incompatible = true;
                return;
            }
            case LONG: {
                switch (tc1) {
                    case INTEGER: {
                        res.comp = LongValueImpl.compare(((LongValueImpl)v0).getLong(), ((IntegerValueImpl)v1).getLong());
                        return;
                    }
                    case LONG: {
                        res.comp = LongValueImpl.compare(((LongValueImpl)v0).getLong(), ((LongValueImpl)v1).getLong());
                        return;
                    }
                    case FLOAT: {
                        res.comp = Float.compare(((LongValueImpl)v0).getLong(), ((FloatValueImpl)v1).getFloat());
                        return;
                    }
                    case DOUBLE: {
                        res.comp = Double.compare(((LongValueImpl)v0).getLong(), ((DoubleValueImpl)v1).getDouble());
                        return;
                    }
                    case NUMBER: {
                        res.comp = -v1.compareTo(v0);
                        return;
                    }
                }
                res.incompatible = true;
                return;
            }
            case FLOAT: {
                switch (tc1) {
                    case INTEGER: {
                        res.comp = Float.compare(((FloatValueImpl)v0).getFloat(), ((IntegerValueImpl)v1).getInt());
                        return;
                    }
                    case LONG: {
                        res.comp = Float.compare(((FloatValueImpl)v0).getFloat(), ((LongValueImpl)v1).getLong());
                        return;
                    }
                    case FLOAT: {
                        res.comp = Float.compare(((FloatValueImpl)v0).getFloat(), ((FloatValueImpl)v1).getFloat());
                        return;
                    }
                    case DOUBLE: {
                        res.comp = Double.compare(((FloatValueImpl)v0).getDouble(), ((DoubleValueImpl)v1).getDouble());
                        return;
                    }
                    case NUMBER: {
                        res.comp = -v1.compareTo(v0);
                        return;
                    }
                }
                res.incompatible = true;
                return;
            }
            case DOUBLE: {
                switch (tc1) {
                    case INTEGER: {
                        res.comp = Double.compare(((DoubleValueImpl)v0).getDouble(), ((IntegerValueImpl)v1).getInt());
                        return;
                    }
                    case LONG: {
                        res.comp = Double.compare(((DoubleValueImpl)v0).getDouble(), ((LongValueImpl)v1).getLong());
                        return;
                    }
                    case FLOAT: {
                        res.comp = Double.compare(((DoubleValueImpl)v0).getDouble(), ((FloatValueImpl)v1).getDouble());
                        return;
                    }
                    case DOUBLE: {
                        res.comp = Double.compare(((DoubleValueImpl)v0).getDouble(), ((DoubleValueImpl)v1).getDouble());
                        return;
                    }
                    case NUMBER: {
                        res.comp = -v1.compareTo(v0);
                        return;
                    }
                }
                res.incompatible = true;
                return;
            }
            case NUMBER: {
                NumberValue number = (NumberValue)((Object)v0);
                if (v1.isNumeric()) {
                    res.comp = number.compareTo(v1);
                } else {
                    res.incompatible = true;
                }
                return;
            }
            case STRING: {
                switch (tc1) {
                    case STRING: {
                        res.comp = ((StringValueImpl)v0).getString().compareTo(((StringValueImpl)v1).getString());
                        return;
                    }
                    case ENUM: {
                        FieldValueImpl enumVal = TypeManager.promote(v0, TypeManager.createValueType(v1));
                        if (enumVal == null) {
                            res.incompatible = true;
                            return;
                        }
                        CompOpIter.compareEnums(enumVal, v1, res);
                        return;
                    }
                }
                res.incompatible = true;
                return;
            }
            case ENUM: {
                switch (tc1) {
                    case STRING: {
                        FieldValueImpl enumVal = TypeManager.promote(v1, TypeManager.createValueType(v0));
                        if (enumVal == null) {
                            res.incompatible = true;
                            return;
                        }
                        CompOpIter.compareEnums(v0, enumVal, res);
                        return;
                    }
                    case ENUM: {
                        CompOpIter.compareEnums(v0, v1, res);
                        return;
                    }
                }
                res.incompatible = true;
                return;
            }
            case BOOLEAN: {
                if (tc1 != FieldDef.Type.BOOLEAN) {
                    res.incompatible = true;
                    return;
                }
                res.comp = ((BooleanValueImpl)v0).compareTo(v1);
                return;
            }
            case BINARY: 
            case FIXED_BINARY: {
                if (tc1 != FieldDef.Type.BINARY && tc1 != FieldDef.Type.FIXED_BINARY) {
                    res.incompatible = true;
                    return;
                }
                if (opCode != FunctionLib.FuncCode.OP_EQ && opCode != FunctionLib.FuncCode.OP_NEQ) {
                    res.incompatible = true;
                    return;
                }
                res.comp = Arrays.equals(v0.getBytes(), v1.getBytes()) ? 0 : 1;
                return;
            }
            case TIMESTAMP: {
                if (tc1 != FieldDef.Type.TIMESTAMP) {
                    res.incompatible = true;
                    return;
                }
                res.comp = ((TimestampValueImpl)v0).compareTo(v1);
                return;
            }
            case RECORD: {
                if (tc1 != FieldDef.Type.RECORD) {
                    res.incompatible = true;
                    return;
                }
                if (opCode != FunctionLib.FuncCode.OP_EQ && opCode != FunctionLib.FuncCode.OP_NEQ) {
                    res.incompatible = true;
                    return;
                }
                if (v0.isTuple()) {
                    v0 = ((TupleValue)v0).toRecord();
                }
                if (v1.isTuple()) {
                    v1 = ((TupleValue)v1).toRecord();
                }
                RecordValueImpl r0 = (RecordValueImpl)v0;
                RecordValueImpl r1 = (RecordValueImpl)v1;
                CompOpIter.compareRecords(rcb, r0, r1, opCode, res, location);
                return;
            }
            case MAP: {
                if (tc1 != FieldDef.Type.MAP) {
                    res.incompatible = true;
                    return;
                }
                if (opCode != FunctionLib.FuncCode.OP_EQ && opCode != FunctionLib.FuncCode.OP_NEQ) {
                    res.incompatible = true;
                    return;
                }
                MapValueImpl m0 = (MapValueImpl)v0;
                MapValueImpl m1 = (MapValueImpl)v1;
                CompOpIter.compareMaps(rcb, m0, m1, opCode, res, location);
                return;
            }
            case ARRAY: {
                if (tc1 != FieldDef.Type.ARRAY) {
                    res.incompatible = true;
                    return;
                }
                ArrayValueImpl a0 = (ArrayValueImpl)v0;
                ArrayValueImpl a1 = (ArrayValueImpl)v1;
                if ((opCode == FunctionLib.FuncCode.OP_EQ || opCode == FunctionLib.FuncCode.OP_NEQ) && a0.size() != a1.size()) {
                    res.comp = 1;
                    return;
                }
                int minSize = Math.min(a0.size(), a1.size());
                for (int i = 0; i < minSize; ++i) {
                    FieldValueImpl elem0 = a0.getElement(i);
                    FieldValueImpl elem1 = a1.getElement(i);
                    assert (elem0 != null);
                    assert (elem1 != null);
                    CompOpIter.compare(rcb, elem0, elem1, opCode, res, location);
                    if (res.comp == 0 && !res.haveNull && !res.incompatible) continue;
                    return;
                }
                if (a0.size() != minSize) {
                    res.comp = 1;
                    return;
                }
                if (a1.size() != minSize) {
                    res.comp = -1;
                    return;
                }
                res.comp = 0;
                return;
            }
            case JSON: {
                assert (v0.isJsonNull());
                if (v1.isJsonNull()) {
                    res.comp = 0;
                    return;
                }
                if (opCode != FunctionLib.FuncCode.OP_NEQ) {
                    res.incompatible = true;
                    return;
                }
                res.comp = 1;
                return;
            }
        }
        throw new QueryStateException("Unexpected operand type in comparison operator: " + tc0);
    }

    static void compareMaps(RuntimeControlBlock rcb, MapValueImpl v0, MapValueImpl v1, FunctionLib.FuncCode opCode, CompResult res, QueryException.Location location) {
        if (v0.size() != v1.size()) {
            res.comp = 1;
            return;
        }
        for (Map.Entry<String, FieldValue> e0 : v0.getMap().entrySet()) {
            String k0 = e0.getKey();
            FieldValueImpl fv0 = (FieldValueImpl)e0.getValue();
            FieldValueImpl fv1 = v1.getFieldValue(k0);
            if (fv1 == null) {
                res.comp = 1;
                return;
            }
            CompOpIter.compare(rcb, fv0, fv1, opCode, res, location);
            if (res.comp == 0 && !res.haveNull && !res.incompatible) continue;
            return;
        }
        res.comp = 0;
    }

    static void compareRecords(RuntimeControlBlock rcb, RecordValueImpl v0, RecordValueImpl v1, FunctionLib.FuncCode opCode, CompResult res, QueryException.Location location) {
        if (v0.getNumFields() != v1.getNumFields()) {
            res.comp = 1;
            return;
        }
        for (int i = 0; i < v0.getNumFields(); ++i) {
            String k1;
            FieldValueImpl fv0 = v0.get(i);
            FieldValueImpl fv1 = v1.get(i);
            CompOpIter.compare(rcb, fv0, fv1, opCode, res, location);
            if (res.comp != 0 || res.haveNull || res.incompatible) {
                return;
            }
            String k0 = v0.getFieldName(i);
            if (k0.equalsIgnoreCase(k1 = v1.getFieldName(i))) continue;
            res.comp = 1;
            return;
        }
        res.comp = 0;
    }

    static void compareEnums(FieldValueImpl v0, FieldValueImpl v1, CompResult res) {
        EnumDefImpl def1;
        EnumValueImpl e0 = (EnumValueImpl)v0;
        EnumValueImpl e1 = (EnumValueImpl)v1;
        EnumDefImpl def0 = e0.getDefinition();
        if (def0.valuesEqual(def1 = e1.getDefinition())) {
            int idx0 = e0.getIndex();
            int idx1 = e1.getIndex();
            res.comp = Integer.valueOf(idx0).compareTo(idx1);
            return;
        }
        res.incompatible = true;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theLeftOp.display(sb, formatter);
        sb.append(",\n");
        this.theRightOp.display(sb, formatter);
    }

    private static class CompIterState
    extends PlanIterState {
        final CompResult theResult = new CompResult();

        private CompIterState() {
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.theResult.incompatible = false;
            this.theResult.haveNull = false;
        }
    }

    public static class CompResult {
        int comp;
        boolean incompatible;
        boolean haveNull;

        void clear() {
            this.incompatible = false;
            this.haveNull = false;
        }

        public String toString() {
            return "(comp, incompatible, haveNull) = (" + this.comp + ", " + this.incompatible + ", " + this.haveNull + ")";
        }
    }
}

