/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.runtime.FuncMinMaxIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.FieldDef;

class FuncMinMax
extends Function {
    FuncMinMax(FunctionLib.FuncCode code, String name) {
        super(code, name, TypeManager.ANY_STAR(), TypeManager.ANY_ATOMIC_ONE());
    }

    @Override
    ExprType getRetType(ExprFuncCall caller) {
        FieldDefImpl inType = caller.getInput().getType().getDef();
        FieldDef.Type inTypeCode = inType.getType();
        switch (inTypeCode) {
            case INTEGER: {
                return TypeManager.INT_ONE();
            }
            case LONG: {
                return TypeManager.LONG_ONE();
            }
            case FLOAT: {
                return TypeManager.FLOAT_ONE();
            }
            case DOUBLE: {
                return TypeManager.DOUBLE_ONE();
            }
            case NUMBER: {
                return TypeManager.NUMBER_ONE();
            }
            case STRING: {
                return TypeManager.STRING_ONE();
            }
            case TIMESTAMP: {
                return TypeManager.TIMESTAMP_ONE();
            }
            case BOOLEAN: {
                return TypeManager.BOOLEAN_ONE();
            }
            case ENUM: {
                return TypeManager.createType(caller.getInput().getType(), ExprType.Quantifier.ONE);
            }
            case ANY: 
            case ANY_ATOMIC: 
            case JSON: 
            case ANY_JSON_ATOMIC: 
            case ARRAY: {
                return this.theReturnType;
            }
            case EMPTY: 
            case RECORD: 
            case ANY_RECORD: 
            case MAP: 
            case BINARY: 
            case FIXED_BINARY: 
            case GEOMETRY: 
            case POINT: {
                throw new QueryException("Invalid input type for the " + this.theName + "aggregate function:\n" + inType.getDDLString(), caller.getLocation());
            }
        }
        throw new QueryStateException("Should not be here");
    }

    @Override
    boolean mayReturnNULL(ExprFuncCall caller) {
        return true;
    }

    @Override
    boolean isAggregate() {
        return true;
    }

    @Override
    Expr normalizeCall(ExprFuncCall caller) {
        FieldDefImpl inType = caller.getArg(0).getType().getDef();
        if (inType.isEmpty()) {
            return new ExprConst(caller.getQCB(), caller.getSctx(), caller.getLocation(), NullValueImpl.getInstance());
        }
        if (!inType.isAtomic() && !inType.isWildcard() && inType.isArray()) {
            throw new QueryException("Invalid input type for the " + this.theName + "aggregate function:\n" + inType.getDDLString(), caller.getLocation());
        }
        return caller;
    }

    @Override
    PlanIter codegen(CodeGenerator codegen, ExprFuncCall caller, PlanIter[] argIters) {
        int resultReg = codegen.allocateResultReg(caller);
        return new FuncMinMaxIter(caller, resultReg, this.theCode, argIters[0]);
    }
}

