/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

class ExprPromote
extends Expr {
    private Expr theInput;
    private ExprType theTargetType;

    static Expr create(Expr parent, Expr child, ExprType targetType) {
        if (child.getKind() == Expr.ExprKind.CONST) {
            FieldValueImpl val = ((ExprConst)child).getValue();
            FieldDefImpl valDef = val.getDefinition();
            FieldValueImpl newVal = TypeManager.promote(val, targetType);
            if (newVal == null) {
                throw new QueryException("Cannot promote item " + val + "\nof type :\n" + valDef + "\nto type :\n" + targetType, child.getLocation());
            }
            ((ExprConst)child).setValue(newVal);
            return child;
        }
        ExprType childType = child.getType();
        if (childType.isSubType(targetType)) {
            return child;
        }
        if (!TypeManager.typesIntersect(childType, targetType)) {
            ExprType.TypeCode cc = childType.getCode();
            ExprType.TypeCode tc = targetType.getCode();
            if ((cc != ExprType.TypeCode.INT && cc != ExprType.TypeCode.LONG || tc != ExprType.TypeCode.FLOAT && tc != ExprType.TypeCode.DOUBLE) && (cc != ExprType.TypeCode.STRING || tc != ExprType.TypeCode.ENUM)) {
                throw new QueryException("Cannot promote type :\n" + childType + "\nto type :\n" + targetType, child.getLocation());
            }
        }
        if (parent != null) {
            child.removeParent(parent, false);
        }
        ExprPromote promoteExpr = new ExprPromote(child.getQCB(), child.getSctx(), child, targetType);
        if (parent != null) {
            promoteExpr.addParent(parent);
        }
        return promoteExpr;
    }

    ExprPromote(QueryControlBlock qcb, StaticContext sctx, Expr input, ExprType type) {
        super(qcb, sctx, Expr.ExprKind.PROMOTE, input.getLocation());
        this.theTargetType = type;
        this.theInput = input;
        this.theInput.addParent(this);
    }

    @Override
    int getNumChildren() {
        return 1;
    }

    @Override
    Expr getInput() {
        return this.theInput;
    }

    void setInput(Expr newExpr, boolean destroy) {
        this.theInput.removeParent(this, destroy);
        this.theInput = newExpr;
        newExpr.addParent(this);
        this.setLocation(newExpr.getLocation());
    }

    ExprType getTargetType() {
        return this.theTargetType;
    }

    @Override
    ExprType computeType() {
        ExprType inType = this.theInput.getType();
        ExprType inputItemType = inType.getItemType();
        ExprType targetItemType = this.theTargetType.getItemType();
        ExprType.Quantifier q = TypeManager.getIntersectionQuant(inType.getQuantifier(), this.theTargetType.getQuantifier());
        if (inputItemType.isSubType(targetItemType)) {
            return TypeManager.createType(inputItemType, q);
        }
        return TypeManager.createType(targetItemType, q);
    }

    @Override
    public boolean mayReturnNULL() {
        return this.theInput.mayReturnNULL();
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append(this.theTargetType);
        sb.append(",\n");
        this.theInput.display(sb, formatter);
    }
}

