/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.ResourceLimitException;
import oracle.kv.impl.util.SerializationUtil;

public class IndexLimitException
extends ResourceLimitException {
    private static final long serialVersionUID = 1L;
    private final int indexLimit;

    public IndexLimitException(String tableName, int indexLimit, String msg) {
        super(tableName, msg);
        assert (tableName != null);
        this.indexLimit = indexLimit;
    }

    public IndexLimitException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.indexLimit = SerializationUtil.readPackedInt(in);
    }

    public int getIndexLimit() {
        return this.indexLimit;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writePackedInt(out, this.indexLimit);
    }
}

