/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.service;

import jakarta.annotation.PreDestroy;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.util.Collections;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.persistence.jpa.rs.DataStorage;
import org.eclipse.persistence.jpa.rs.PersistenceContextFactory;
import org.eclipse.persistence.jpa.rs.PersistenceContextFactoryProvider;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSExceptionMapper;
import org.eclipse.persistence.jpa.rs.resources.MetadataResource;
import org.eclipse.persistence.jpa.rs.resources.QueryResource;
import org.eclipse.persistence.jpa.rs.resources.unversioned.EntityResource;
import org.eclipse.persistence.jpa.rs.resources.unversioned.PersistenceResource;
import org.eclipse.persistence.jpa.rs.resources.unversioned.PersistenceUnitResource;
import org.eclipse.persistence.jpa.rs.resources.unversioned.SingleResultQueryResource;

@ApplicationPath(value="/persistence/")
public class JPARSApplication
extends Application {
    private final Set<Class<?>> classes;

    public JPARSApplication() {
        HashSet<Class> c = new HashSet<Class>();
        c.add(PersistenceResource.class);
        c.add(PersistenceUnitResource.class);
        c.add(EntityResource.class);
        c.add(SingleResultQueryResource.class);
        c.add(org.eclipse.persistence.jpa.rs.resources.unversioned.QueryResource.class);
        c.add(org.eclipse.persistence.jpa.rs.resources.PersistenceResource.class);
        c.add(org.eclipse.persistence.jpa.rs.resources.PersistenceUnitResource.class);
        c.add(org.eclipse.persistence.jpa.rs.resources.EntityResource.class);
        c.add(org.eclipse.persistence.jpa.rs.resources.SingleResultQueryResource.class);
        c.add(QueryResource.class);
        c.add(MetadataResource.class);
        c.add(JPARSExceptionMapper.class);
        this.classes = Collections.unmodifiableSet(c);
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    @PreDestroy
    public void preDestroy() {
        DataStorage.destroy();
        ServiceLoader<PersistenceContextFactoryProvider> persistenceContextFactoryProviderLoader = ServiceLoader.load(PersistenceContextFactoryProvider.class, Thread.currentThread().getContextClassLoader());
        for (PersistenceContextFactoryProvider persistenceContextFactoryProvider : persistenceContextFactoryProviderLoader) {
            PersistenceContextFactory persistenceContextFactory = persistenceContextFactoryProvider.getPersistenceContextFactory(null);
            if (persistenceContextFactory == null) continue;
            persistenceContextFactory.close();
        }
    }
}

