/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.DataObject;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import commonj.sdo.impl.ExternalizableDelegator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.helper.SDOHelperContext;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;

public class SDOResolvable
implements ExternalizableDelegator.Resolvable {
    private static final long serialVersionUID = 2807334877368539299L;
    public static final String DEFAULT_ROOT_ELEMENT_NAME = "dataObject";
    public static final int SDO_HELPER_CONTEXT_ID_IDENTIFIER = 2;
    public static final int SDO_ROOT_OBJECT_IDENTIFIER = 1;
    public static final int SDO_INTERNAL_OBJECT_IDENTIFIER = 0;
    private transient SDODataObject theSDODataObject;
    private transient HelperContext aHelperContext;

    public SDOResolvable() {
        this.aHelperContext = SDOHelperContext.getHelperContext();
    }

    public SDOResolvable(HelperContext aContext) {
        this.aHelperContext = aContext;
    }

    public SDOResolvable(Object target, HelperContext aContext) {
        this.theSDODataObject = (SDODataObject)target;
        this.aHelperContext = aContext;
    }

    public Object readResolve() throws ObjectStreamException {
        return this.theSDODataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        DeflaterOutputStream aGZIPOutputStream = null;
        ByteArrayOutputStream aByteOutputStream = null;
        if (this.theSDODataObject.getContainer() == null) {
            try {
                String identifier = null;
                if (this.aHelperContext.getClass() == SDOHelperContext.class) {
                    identifier = ((SDOHelperContext)this.aHelperContext).getIdentifier();
                }
                if (identifier != null && !identifier.equals("")) {
                    objectOutput.writeByte(2);
                    objectOutput.writeUTF(identifier);
                } else {
                    objectOutput.writeByte(1);
                }
                aByteOutputStream = new ByteArrayOutputStream();
                aGZIPOutputStream = new GZIPOutputStream(aByteOutputStream);
                XMLDocument aDocument = this.aHelperContext.getXMLHelper().createDocument((DataObject)this.theSDODataObject, "commonj.sdo", "sdo:dataObject");
                ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).serialize(aDocument, aGZIPOutputStream, null);
                ((GZIPOutputStream)aGZIPOutputStream).finish();
                aGZIPOutputStream.flush();
                aByteOutputStream.flush();
                byte[] buf = aByteOutputStream.toByteArray();
                objectOutput.writeInt(buf.length);
                objectOutput.write(buf);
            }
            finally {
                if (aGZIPOutputStream != null) {
                    aGZIPOutputStream.close();
                }
                if (aByteOutputStream != null) {
                    aByteOutputStream.close();
                }
            }
        } else {
            objectOutput.writeByte(0);
            String aPath = this.theSDODataObject._getPath();
            objectOutput.writeUTF(aPath);
            objectOutput.writeObject(this.theSDODataObject.getRootObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        aByteInputStream = null;
        aGZIPInputStream = null;
        dataObjectIdentifier = objectInput.read();
        switch (dataObjectIdentifier) {
            case 0: {
                xPathString = objectInput.readUTF();
                deserializedDataObject = (SDODataObject)objectInput.readObject();
                this.theSDODataObject = (SDODataObject)deserializedDataObject.get(xPathString);
                break;
            }
            case 1: {
                try {
                    aStreamLength = objectInput.readInt();
                    aGZIPByteArray = new byte[aStreamLength];
                    objectInput.readFully(aGZIPByteArray);
                    aByteInputStream = new ByteArrayInputStream(aGZIPByteArray);
                    aGZIPInputStream = new GZIPInputStream(aByteInputStream);
                    aDocument = this.aHelperContext.getXMLHelper().load((InputStream)aGZIPInputStream);
                    this.theSDODataObject = (SDODataObject)aDocument.getRootObject();
                    break;
                }
                finally {
                    if (aGZIPInputStream != null) {
                        aGZIPInputStream.close();
                    }
                    if (aByteInputStream != null) {
                        aByteInputStream.close();
                    }
                }
            }
            case 2: {
                try {
                    helperContextIdentifier = objectInput.readUTF();
                    aStreamLength = objectInput.readInt();
                    aGZIPByteArray = new byte[aStreamLength];
                    objectInput.readFully(aGZIPByteArray);
                    aByteInputStream = new ByteArrayInputStream(aGZIPByteArray);
                    aGZIPInputStream = new GZIPInputStream(aByteInputStream);
                    contextToUse = SDOHelperContext.getHelperContext(helperContextIdentifier);
                    aDocument = contextToUse.getXMLHelper().load((InputStream)aGZIPInputStream);
                    this.theSDODataObject = (SDODataObject)aDocument.getRootObject();
                    if (aGZIPInputStream == null) ** GOTO lbl45
                }
                catch (Throwable var12_16) {
                    if (aGZIPInputStream != null) {
                        aGZIPInputStream.close();
                    }
                    if (aByteInputStream != null) {
                        aByteInputStream.close();
                    }
                    throw var12_16;
                }
                aGZIPInputStream.close();
lbl45:
                // 2 sources

                if (aByteInputStream == null) break;
                aByteInputStream.close();
                break;
            }
        }
    }

    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }
}

