/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.cobol;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.eis.cobol.CobolRedefinedFieldValue;
import org.eclipse.persistence.internal.eis.cobol.CobolRow;
import org.eclipse.persistence.internal.eis.cobol.CompositeObject;
import org.eclipse.persistence.internal.eis.cobol.ElementaryFieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.FieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.RecordMetaData;
import org.eclipse.persistence.internal.helper.DatabaseField;

public class CompositeFieldMetaData
extends ElementaryFieldMetaData
implements CompositeObject {
    protected Vector myCompositeFields;

    public CompositeFieldMetaData() {
        this.initialize();
    }

    public CompositeFieldMetaData(String fieldName, String recordName) {
        super.initialize(fieldName, recordName);
        this.initialize();
    }

    public CompositeFieldMetaData(String fieldName, RecordMetaData record) {
        super.initialize(fieldName, record);
        this.initialize();
    }

    public CompositeFieldMetaData(String fieldName, RecordMetaData record, Vector fields) {
        super.initialize(fieldName, record);
        this.initialize(fields);
    }

    @Override
    protected void initialize() {
        this.myCompositeFields = new Vector();
    }

    protected void initialize(Vector fields) {
        this.myCompositeFields = fields;
    }

    @Override
    public FieldMetaData deepCopy() {
        CompositeFieldMetaData fieldCopy = new CompositeFieldMetaData(this.myName, this.myRecord.getName());
        fieldCopy.setIsFieldRedefine(this.isRedefine);
        fieldCopy.setDecimalPosition(this.decimalPosition);
        fieldCopy.setArraySize(this.myArraySize);
        fieldCopy.setSize(this.mySize);
        fieldCopy.setOffset(this.myOffset);
        fieldCopy.setType(this.myType);
        if (this.isFieldRedefine()) {
            fieldCopy.setFieldRedefined(this.myFieldRedefined.deepCopy());
        }
        fieldCopy.setDependentFieldName(this.myDependentFieldName);
        Enumeration fieldsEnum = this.myCompositeFields.elements();
        while (fieldsEnum.hasMoreElements()) {
            FieldMetaData field = (FieldMetaData)fieldsEnum.nextElement();
            fieldCopy.addField(field.deepCopy());
        }
        return fieldCopy;
    }

    @Override
    public int getSize() {
        Enumeration fieldsEnum = this.myCompositeFields.elements();
        int size = 0;
        while (fieldsEnum.hasMoreElements()) {
            FieldMetaData field = (FieldMetaData)fieldsEnum.nextElement();
            if (field.isFieldRedefine()) continue;
            size += field.getSize();
        }
        return size;
    }

    @Override
    public void setSize(int size) {
    }

    @Override
    public boolean hasDecimal() {
        return false;
    }

    @Override
    public int getDecimalPosition() {
        return -1;
    }

    public void setDecimalPosition() {
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void setType(int type) {
    }

    @Override
    public Vector getFields() {
        return this.myCompositeFields;
    }

    @Override
    public void setFields(Vector newCompositeFields) {
        this.myCompositeFields = newCompositeFields;
    }

    @Override
    public void addField(FieldMetaData newField) {
        this.myCompositeFields.addElement(newField);
    }

    @Override
    public FieldMetaData getFieldNamed(String fieldName) {
        Enumeration fieldsEnum = this.getFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            FieldMetaData field = (FieldMetaData)fieldsEnum.nextElement();
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    @Override
    public Object extractValueFromArray(byte[] recordData) {
        ArrayList<CobolRow> fieldValue = new ArrayList<CobolRow>(this.getFields().size());
        if (this.isArray()) {
            int offset = this.getOffset();
            for (int i = this.getArraySize(); i > 0; --i) {
                CompositeFieldMetaData fieldCopy = (CompositeFieldMetaData)this.deepCopy();
                fieldCopy.setOffset(offset);
                fieldCopy.resetChildOffsets();
                CobolRow compositeRow = new CobolRow();
                fieldCopy.writeCompositeOnRow(compositeRow, recordData);
                fieldValue.add(compositeRow);
                offset += this.getSize();
            }
        } else {
            CobolRow compositeRow = new CobolRow();
            this.writeCompositeOnRow(compositeRow, recordData);
            fieldValue.add(compositeRow);
        }
        return fieldValue;
    }

    public void writeCompositeOnRow(CobolRow row, byte[] recordData) {
        Enumeration fields = this.getFields().elements();
        while (fields.hasMoreElements()) {
            FieldMetaData currentField = (FieldMetaData)fields.nextElement();
            currentField.writeOnRow(row, recordData);
        }
    }

    @Override
    public void writeOnRow(CobolRow row, byte[] recordData) {
        if (this.isArray() && this.dependsOn()) {
            this.adjustArraySize(row);
        }
        DatabaseField field = new DatabaseField(this.getName(), this.getRecord().getName());
        Object value = this.isFieldRedefine() ? new CobolRedefinedFieldValue(this, recordData) : this.extractValueFromArray(recordData);
        row.add(field, value);
    }

    @Override
    public void writeOnArray(CobolRow row, byte[] recordData) {
        Object obj = row.get(this.getName());
        List fieldValue = (List)obj;
        if (this.isArray()) {
            if (this.dependsOn()) {
                this.adjustArraySize(row);
            }
            int offset = this.getOffset();
            Iterator elements = fieldValue.iterator();
            for (int i = this.getArraySize(); i > 0; --i) {
                CompositeFieldMetaData fieldCopy = (CompositeFieldMetaData)this.deepCopy();
                fieldCopy.setOffset(offset);
                fieldCopy.resetChildOffsets();
                CobolRow compositeRow = (CobolRow)((Object)elements.next());
                fieldCopy.writeCompositeOnArray(compositeRow, recordData);
                offset += this.getSize();
            }
        } else {
            CobolRow compositeRow = (CobolRow)((Object)fieldValue.get(0));
            this.writeCompositeOnArray(compositeRow, recordData);
        }
    }

    protected void writeCompositeOnArray(CobolRow row, byte[] recordData) {
        Enumeration fields = this.getFields().elements();
        while (fields.hasMoreElements()) {
            FieldMetaData currentField = (FieldMetaData)fields.nextElement();
            currentField.writeOnArray(row, recordData);
        }
    }

    protected void resetChildOffsets() {
        Enumeration childFieldsEnum = this.myCompositeFields.elements();
        int offset = this.getOffset();
        while (childFieldsEnum.hasMoreElements()) {
            FieldMetaData field = (FieldMetaData)childFieldsEnum.nextElement();
            field.setOffset(offset);
            if (field.isComposite()) {
                ((CompositeFieldMetaData)field).resetChildOffsets();
            }
            offset += field.getSize();
        }
    }
}

