/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.lang.annotation.ElementType;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.aggregated.CascadingMetaDataBuilder;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetMethodFromPropertyName;
import org.hibernate.validator.internal.xml.ContainerElementTypeConfigurationBuilder;
import org.hibernate.validator.internal.xml.GroupConversionBuilder;
import org.hibernate.validator.internal.xml.MetaConstraintBuilder;
import org.hibernate.validator.internal.xml.binding.ConstraintType;
import org.hibernate.validator.internal.xml.binding.GetterType;

class ConstrainedGetterBuilder {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final GroupConversionBuilder groupConversionBuilder;
    private final MetaConstraintBuilder metaConstraintBuilder;
    private final AnnotationProcessingOptionsImpl annotationProcessingOptions;

    ConstrainedGetterBuilder(MetaConstraintBuilder metaConstraintBuilder, GroupConversionBuilder groupConversionBuilder, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        this.metaConstraintBuilder = metaConstraintBuilder;
        this.groupConversionBuilder = groupConversionBuilder;
        this.annotationProcessingOptions = annotationProcessingOptions;
    }

    Set<ConstrainedExecutable> buildConstrainedGetters(List<GetterType> getterList, Class<?> beanClass, String defaultPackage) {
        HashSet<ConstrainedExecutable> constrainedExecutables = CollectionHelper.newHashSet();
        ArrayList<String> alreadyProcessedGetterNames = CollectionHelper.newArrayList();
        for (GetterType getterType : getterList) {
            String getterName = getterType.getName();
            Method getter = ConstrainedGetterBuilder.findGetter(beanClass, getterName, alreadyProcessedGetterNames);
            ConstraintLocation constraintLocation = ConstraintLocation.forGetter(beanClass, getter);
            HashSet<MetaConstraint<?>> metaConstraints = CollectionHelper.newHashSet();
            for (ConstraintType constraint : getterType.getConstraint()) {
                MetaConstraint metaConstraint = this.metaConstraintBuilder.buildMetaConstraint(constraintLocation, constraint, ElementType.METHOD, defaultPackage, null);
                metaConstraints.add(metaConstraint);
            }
            ContainerElementTypeConfigurationBuilder containerElementTypeConfigurationBuilder = new ContainerElementTypeConfigurationBuilder(this.metaConstraintBuilder, this.groupConversionBuilder, constraintLocation, defaultPackage);
            ContainerElementTypeConfigurationBuilder.ContainerElementTypeConfiguration containerElementTypeConfiguration = containerElementTypeConfigurationBuilder.build(getterType.getContainerElementType(), ReflectionHelper.typeOf(getter));
            ConstrainedExecutable constrainedGetter = new ConstrainedExecutable(ConfigurationSource.XML, getter, Collections.emptyList(), Collections.emptySet(), metaConstraints, containerElementTypeConfiguration.getMetaConstraints(), this.getCascadingMetaDataForGetter(containerElementTypeConfiguration.getTypeParametersCascadingMetaData(), getter, getterType, defaultPackage));
            constrainedExecutables.add(constrainedGetter);
            if (getterType.getIgnoreAnnotations() == null) continue;
            this.annotationProcessingOptions.ignoreConstraintAnnotationsOnMember(getter, getterType.getIgnoreAnnotations());
        }
        return constrainedExecutables;
    }

    private CascadingMetaDataBuilder getCascadingMetaDataForGetter(Map<TypeVariable<?>, CascadingMetaDataBuilder> containerElementTypesCascadingMetaData, Method method, GetterType getterType, String defaultPackage) {
        Type type = ReflectionHelper.typeOf(method);
        boolean isCascaded = getterType.getValid() != null;
        Map<Class<?>, Class<?>> groupConversions = this.groupConversionBuilder.buildGroupConversionMap(getterType.getConvertGroup(), defaultPackage);
        return CascadingMetaDataBuilder.annotatedObject(type, isCascaded, containerElementTypesCascadingMetaData, groupConversions);
    }

    private static Method findGetter(Class<?> beanClass, String getterName, List<String> alreadyProcessedGetterNames) {
        if (alreadyProcessedGetterNames.contains(getterName)) {
            throw LOG.getIsDefinedTwiceInMappingXmlForBeanException(getterName, beanClass);
        }
        alreadyProcessedGetterNames.add(getterName);
        Method method = ConstrainedGetterBuilder.run(GetMethodFromPropertyName.action(beanClass, getterName));
        if (method == null) {
            throw LOG.getBeanDoesNotContainThePropertyException(beanClass, getterName);
        }
        return method;
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

