/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.ui.chatroom;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.IContainerConnectedEvent;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.IContainerEjectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.IExceptionHandler;
import org.eclipse.ecf.internal.presence.ui.Activator;
import org.eclipse.ecf.internal.presence.ui.Messages;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomInfo;
import org.eclipse.ecf.presence.chatroom.IChatRoomManager;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessage;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageEvent;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageEvent;
import org.eclipse.ecf.presence.ui.chatroom.ChatRoomManagerView;
import org.eclipse.ecf.presence.ui.chatroom.IChatRoomCommandListener;
import org.eclipse.ecf.presence.ui.chatroom.IChatRoomViewCloseListener;
import org.eclipse.ecf.presence.ui.chatroom.IMessageRenderer;
import org.eclipse.ecf.presence.ui.chatroom.MessageRenderer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ChatRoomManagerUI
implements IChatRoomCommandListener {
    public static final String ROOM_DELIMITER = ",";
    protected IContainer container;
    protected IChatRoomManager manager;
    private boolean isContainerConnected = false;
    private boolean viewAlreadyActive = false;
    protected IExceptionHandler exceptionHandler = null;
    protected ChatRoomManagerView chatroomview = null;
    protected ID targetID = null;
    protected String[] channels = null;

    public ChatRoomManagerUI(IContainer container, IChatRoomManager manager) {
        this(container, manager, null);
    }

    public ChatRoomManagerUI(IContainer container, IChatRoomManager manager, IExceptionHandler exceptionHandler) {
        this.container = container;
        this.manager = manager;
        this.exceptionHandler = exceptionHandler;
    }

    public ID getTargetID() {
        return this.targetID;
    }

    public String handleCommand(IChatRoomContainer chatRoomContainer, String inputLine) {
        return inputLine;
    }

    protected IChatRoomViewCloseListener createChatRoomViewCloseListener() {
        return new IChatRoomViewCloseListener(){

            public void chatRoomViewClosing() {
                ChatRoomManagerUI.this.container.disconnect();
            }
        };
    }

    private void setupNewView() throws Exception {
        IChatRoomInfo roomInfo = this.manager.getChatRoomInfo(null);
        Assert.isNotNull((Object)roomInfo, (String)Messages.ChatRoomManagerUI_EXCEPTION_NO_ROOT_CHAT_ROOM_MANAGER);
        IChatRoomContainer managerChatRoom = roomInfo.createChatRoomContainer();
        this.chatroomview.initializeWithManager(ChatRoomManagerView.getUsernameFromID(this.targetID), ChatRoomManagerView.getHostnameFromID(this.targetID), managerChatRoom, this, this.createChatRoomViewCloseListener());
        this.chatroomview.setMessageRenderer(this.getDefaultMessageRenderer());
        this.container.addListener(new IContainerListener(){

            public void handleEvent(IContainerEvent evt) {
                Display.getDefault().syncExec(new Runnable(this, evt){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ IContainerEvent val$evt;
                    {
                        this.this$1 = var1_1;
                        this.val$evt = iContainerEvent;
                    }

                    public void run() {
                        if (this.val$evt instanceof IContainerDisconnectedEvent || this.val$evt instanceof IContainerEjectedEvent) {
                            ID departedContainerID = this.val$evt instanceof IContainerDisconnectedEvent ? ((IContainerDisconnectedEvent)this.val$evt).getTargetID() : ((IContainerEjectedEvent)this.val$evt).getTargetID();
                            ID connectedID = 2.access$0(this.this$1).targetID;
                            if (connectedID == null || connectedID.equals((Object)departedContainerID)) {
                                2.access$0(this.this$1).chatroomview.disconnected();
                                ChatRoomManagerUI.access$0(2.access$0(this.this$1), false);
                            }
                        } else if (this.val$evt instanceof IContainerConnectedEvent) {
                            ChatRoomManagerUI.access$0(2.access$0(this.this$1), true);
                            2.access$0(this.this$1).chatroomview.setEnabled(true);
                            String[] roomsForTarget = 2.access$0(this.this$1).getRoomsForTarget();
                            int i = 0;
                            while (i < roomsForTarget.length) {
                                IChatRoomInfo info = 2.access$0(this.this$1).manager.getChatRoomInfo(roomsForTarget[i]);
                                2.access$0(this.this$1).chatroomview.joinRoom(info, 2.access$0(this.this$1).getPasswordForChatRoomConnect(info));
                                ++i;
                            }
                        }
                    }
                });
            }

            static /* synthetic */ ChatRoomManagerUI access$0(2 var0) {
                return var0.ChatRoomManagerUI.this;
            }
        });
        managerChatRoom.addMessageListener(new IIMMessageListener(){

            public void handleMessageEvent(IIMMessageEvent messageEvent) {
                if (messageEvent instanceof IChatRoomMessageEvent) {
                    IChatRoomMessage m = ((IChatRoomMessageEvent)messageEvent).getChatRoomMessage();
                    ChatRoomManagerUI.this.chatroomview.handleMessage(m.getFromID(), m.getMessage());
                } else if (messageEvent instanceof IChatMessageEvent) {
                    IChatMessage chatMessage = ((IChatMessageEvent)messageEvent).getChatMessage();
                    ChatRoomManagerUI.this.chatroomview.handleChatMessage(chatMessage);
                }
            }
        });
    }

    protected IMessageRenderer getDefaultMessageRenderer() {
        return new MessageRenderer();
    }

    protected String getPasswordForChatRoomConnect(IChatRoomInfo info) {
        return null;
    }

    public void showForTarget(final ID target) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    ChatRoomManagerUI.this.targetID = target;
                    ChatRoomManagerUI.this.chatroomview = ChatRoomManagerUI.this.getChatRoomManagerView();
                    if (!ChatRoomManagerUI.this.viewAlreadyActive) {
                        ChatRoomManagerUI.this.setupNewView();
                    } else if (ChatRoomManagerUI.this.isContainerConnected) {
                        ChatRoomManagerUI.this.channels = ChatRoomManagerUI.this.getRoomsForTarget();
                        int i = 0;
                        while (i < ChatRoomManagerUI.this.channels.length) {
                            IChatRoomInfo info = ChatRoomManagerUI.this.manager.getChatRoomInfo(ChatRoomManagerUI.this.channels[i]);
                            ChatRoomManagerUI.this.chatroomview.joinRoom(info, ChatRoomManagerUI.this.getPasswordForChatRoomConnect(info));
                            ++i;
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    if (ChatRoomManagerUI.this.exceptionHandler != null) {
                        ChatRoomManagerUI.this.exceptionHandler.handleException((Throwable)e);
                    }
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.presence.ui", 4, String.valueOf(Messages.ChatRoomManagerUI_EXCEPTION_CHAT_ROOM_VIEW_INITIALIZATION) + target, (Throwable)e));
                }
            }
        });
    }

    public boolean isContainerConnected() {
        return this.isContainerConnected;
    }

    protected String getSecondaryViewID(ID id) {
        URI uri;
        try {
            uri = new URI(id.getName());
        }
        catch (URISyntaxException e) {
            return null;
        }
        int port = uri.getPort();
        return String.valueOf(uri.getAuthority()) + (port == -1 ? "" : ":" + port);
    }

    protected ChatRoomManagerView getChatRoomManagerView() throws PartInitException {
        IViewReference viewRef;
        String secondaryViewID = this.getSecondaryViewID(this.targetID);
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage wp = ww.getActivePage();
        ChatRoomManagerView view = null;
        view = secondaryViewID == null ? (ChatRoomManagerView)wp.showView("org.eclipse.ecf.presence.ui.chatroom.ChatRoomManagerView") : ((viewRef = wp.findViewReference("org.eclipse.ecf.presence.ui.chatroom.ChatRoomManagerView", secondaryViewID)) == null ? (ChatRoomManagerView)wp.showView("org.eclipse.ecf.presence.ui.chatroom.ChatRoomManagerView", secondaryViewID, 1) : (ChatRoomManagerView)viewRef.getView(true));
        this.viewAlreadyActive = view.isEnabled();
        return view;
    }

    protected String modifyRoomNameForTarget(String roomName) {
        return roomName;
    }

    /*
     * Unable to fully structure code
     */
    protected String[] getRoomsForTarget() {
        initialRooms = null;
        try {
            targetURI = new URI(this.targetID.getName());
            initialRooms = targetURI.getPath();
        }
        catch (URISyntaxException e) {
            return new String[0];
        }
        if (initialRooms != null && !initialRooms.equals("")) ** GOTO lbl11
        return new String[0];
lbl-1000:
        // 1 sources

        {
            initialRooms = initialRooms.substring(1);
lbl11:
            // 2 sources

            ** while (initialRooms.charAt((int)0) == '/')
        }
lbl12:
        // 1 sources

        st = new StringTokenizer(initialRooms, ",");
        tokenCount = st.countTokens();
        roomsResult = new String[tokenCount];
        i = 0;
        while (i < tokenCount) {
            roomsResult[i] = this.modifyRoomNameForTarget(st.nextToken());
            ++i;
        }
        return roomsResult;
    }

    static /* synthetic */ void access$0(ChatRoomManagerUI chatRoomManagerUI, boolean bl) {
        chatRoomManagerUI.isContainerConnected = bl;
    }
}

