/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.collab.ui.screencapture;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.internal.presence.collab.ui.Messages;
import org.eclipse.ecf.presence.collab.ui.AbstractCollabShare;
import org.eclipse.ecf.presence.collab.ui.screencapture.ScreenCaptureDataMessage;
import org.eclipse.ecf.presence.collab.ui.screencapture.ScreenCaptureStartMessage;
import org.eclipse.ecf.ui.screencapture.ImageWrapper;
import org.eclipse.ecf.ui.screencapture.ScreenCaptureUtil;
import org.eclipse.ecf.ui.screencapture.ShowImageShell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class ScreenCaptureShare
extends AbstractCollabShare {
    private static final int MAX_MESSAGE_SIZE = 8096;
    private static final Map screenCaptureSharechannels = new Hashtable();
    Map shells = new HashMap();

    public static ScreenCaptureShare getScreenCaptureShare(ID containerID) {
        return (ScreenCaptureShare)((Object)screenCaptureSharechannels.get(containerID));
    }

    public static ScreenCaptureShare addScreenCaptureShare(ID containerID, IChannelContainerAdapter channelAdapter) throws ECFException {
        return screenCaptureSharechannels.put(containerID, new ScreenCaptureShare(channelAdapter));
    }

    public static ScreenCaptureShare removeScreenCaptureShare(ID containerID) {
        return (ScreenCaptureShare)((Object)screenCaptureSharechannels.remove(containerID));
    }

    public ScreenCaptureShare(IChannelContainerAdapter adapter) throws ECFException {
        super(adapter);
    }

    public synchronized void dispose() {
        super.dispose();
        this.shells.clear();
    }

    protected void handleScreenCaptureStart(final ID id, final String fromUser, final ImageWrapper imageWrapper) {
        final Display defaultDisplay = Display.getDefault();
        defaultDisplay.asyncExec(new Runnable(){

            public void run() {
                ShowImageShell showImageShell = (ShowImageShell)ScreenCaptureShare.this.shells.get(id);
                if (showImageShell == null) {
                    showImageShell = new ShowImageShell(defaultDisplay, id, new DisposeListener(this, id){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ ID val$id;
                        {
                            this.this$1 = var1_1;
                            this.val$id = iD;
                        }

                        public void widgetDisposed(DisposeEvent e) {
                            1.access$0(this.this$1).shells.remove(this.val$id);
                        }
                    });
                    ScreenCaptureShare.this.shells.put(id, showImageShell);
                }
                showImageShell.initialize(NLS.bind((String)Messages.ScreenCaptureShare_SCREEN_CAPTURE_RECEIVE_TITLE, (Object)fromUser), imageWrapper);
                showImageShell.open();
            }

            static /* synthetic */ ScreenCaptureShare access$0(1 var0) {
                return var0.ScreenCaptureShare.this;
            }
        });
    }

    protected void handleScreenCaptureData(ID id, final byte[] data, final Boolean done) {
        Display display;
        final ShowImageShell showImageShell = (ShowImageShell)this.shells.get(id);
        if (showImageShell != null && (display = showImageShell.getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    showImageShell.addData(data);
                    if (done.booleanValue()) {
                        showImageShell.showImage();
                    }
                }
            });
        }
    }

    public void sendImage(ID senderID, String senderuser, ID toID, ImageData imageData) {
        try {
            this.sendMessage(toID, this.serialize(new ScreenCaptureStartMessage(senderID, senderuser, new ImageWrapper(imageData))));
            byte[] compressedData = ScreenCaptureUtil.compress((byte[])imageData.data);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(8096);
            int startPos = 0;
            while (startPos <= compressedData.length) {
                bos.reset();
                int length = Math.min(compressedData.length - startPos, 8096);
                bos.write(compressedData, startPos, length);
                bos.flush();
                this.sendMessage(toID, this.serialize(new ScreenCaptureDataMessage(senderID, bos.toByteArray(), new Boolean(compressedData.length - (startPos += 8096) <= 0))));
            }
        }
        catch (Exception e) {
            this.logError(Messages.Share_EXCEPTION_LOG_SEND, e);
        }
    }

    protected void handleMessage(ID fromContainerID, byte[] data) {
        try {
            Object msg = this.deserialize(data);
            if (msg instanceof ScreenCaptureStartMessage) {
                this.handleScreenCaptureStart(((ScreenCaptureStartMessage)msg).getSenderID(), ((ScreenCaptureStartMessage)msg).getSenderUser(), ((ScreenCaptureStartMessage)msg).getImageWrapper());
            } else if (msg instanceof ScreenCaptureDataMessage) {
                this.handleScreenCaptureData(((ScreenCaptureDataMessage)msg).getSenderID(), ((ScreenCaptureDataMessage)msg).getData(), ((ScreenCaptureDataMessage)msg).getIsDone());
            }
        }
        catch (Exception e) {
            this.logError(Messages.Share_EXCEPTION_LOG_MESSAGE, e);
        }
    }
}

