/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.remoteservice.generic;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.events.IContainerConnectedEvent;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.IContainerEjectedEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.jobs.JobsExecutor;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.sharedobject.BaseSharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContext;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.core.sharedobject.SharedObjectMsg;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectActivatedEvent;
import org.eclipse.ecf.core.status.SerializableStatus;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.core.util.IEventProcessor;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.remoteservice.Activator;
import org.eclipse.ecf.provider.remoteservice.generic.AddRegistrationRequest;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteCallImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteFilterImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceReferenceImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceRegistrationImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceRegistryImpl;
import org.eclipse.ecf.provider.remoteservice.generic.Request;
import org.eclipse.ecf.provider.remoteservice.generic.Response;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteFilter;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceCallPolicy;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallStartEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceRegisteredEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceUnregisteredEvent;
import org.eclipse.equinox.concurrent.future.IExecutor;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ImmediateExecutor;
import org.eclipse.equinox.concurrent.future.ThreadsExecutor;
import org.eclipse.equinox.concurrent.future.TimeoutException;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.osgi.framework.InvalidSyntaxException;

public class RegistrySharedObject
extends BaseSharedObject
implements IRemoteServiceContainerAdapter {
    protected static final int ADD_REGISTRATION_REQUEST_TIMEOUT = new Integer(System.getProperty("org.eclipse.ecf.provider.remoteservice.addRegistrationRequestTimeout", "7000"));
    private static int uniqueRequestId = 0;
    protected RemoteServiceRegistryImpl localRegistry;
    protected final Map remoteRegistrys = Collections.synchronizedMap(new HashMap());
    protected final List serviceListeners = new ArrayList();
    protected Map addRegistrationRequests = new Hashtable();
    protected int addRegistrationRequestTimeout = ADD_REGISTRATION_REQUEST_TIMEOUT;
    protected List requests = Collections.synchronizedList(new ArrayList());
    protected IConnectContext connectContext;
    protected final Object rsConnectLock = new Object();
    protected boolean rsConnected = false;
    protected int rsConnectTimeout = ADD_REGISTRATION_REQUEST_TIMEOUT;
    private ListenerQueue rsListenerDispatchQueue;
    private final Object rsQueueLock = new Object();
    private EventManager rsListenerDispatchEventManager;
    protected long registryUpdateRequestTimeout = new Long(System.getProperty("org.eclipse.ecf.provider.remoteservice.registryUpdateRequestTimeout", "5000"));
    private Hashtable pendingUpdateContainers = new Hashtable();
    private List registryUpdateRequests = new ArrayList();
    private static final String DEFAULT_EXECUTOR_TYPE = System.getProperty("org.eclipse.ecf.provider.remoteservice.executorType", "jobs");
    private IExecutor requestExecutor;
    private Object remoteServiceCallPolicyLock = new Object();
    private IRemoteServiceCallPolicy remoteServiceCallPolicy;
    private static final String FIRE_REQUEST = "handleFireRequest";
    private static final String FIRE_REQUEST_ERROR_MESSAGE = "exception sending fire request message";
    private static final int FIRE_REQUEST_ERROR_CODE = 202;
    private static final String CALL_REQUEST = "handleCallRequest";
    private static final String CALL_REQUEST_ERROR_MESSAGE = "exception sending call request message";
    private static final int CALL_REQUEST_ERROR_CODE = 203;
    private static final String CALL_REQUEST_TIMEOUT_ERROR_MESSAGE = "timeout for remote call";
    private static final int CALL_REQUEST_TIMEOUT_ERROR_CODE = 204;
    private static final String UNREGISTER = "handleUnregister";
    private static final String UNREGISTER_ERROR_MESSAGE = "exception sending service unregister message";
    private static final int UNREGISTER_ERROR_CODE = 206;
    private static final int MSG_INVOKE_ERROR_CODE = 207;
    private static final String CALL_RESPONSE = "handleCallResponse";
    private static final String CALL_RESPONSE_ERROR_MESSAGE = "Exception sending response";
    private static final int CALL_RESPONSE_ERROR_CODE = 210;
    private static final String REQUEST_NOT_FOUND_ERROR_MESSAGE = "request not found for response";
    private static final int REQUEST_NOT_FOUND_ERROR_CODE = 211;
    private static final long RESPONSE_WAIT_INTERVAL = 5000L;
    private static final String ADD_REGISTRATION = "handleAddRegistration";
    private static final String ADD_REGISTRATIONS = "handleAddRegistrations";
    private static final String ADD_REGISTRATION_ERROR_MESSAGE = "exception sending add service registration message";
    private static final int ADD_REGISTRATION_ERROR_CODE = 212;
    private static final String ADD_REGISTRATION_REFUSED = "handleAddRegistrationRefused";
    private static final String ADD_REGISTRATION_REFUSED_ERROR_MESSAGE = "Error sending addRegistration refused";
    private static final int ADD_REGISTRATION_REFUSED_ERROR_CODE = 214;
    private static final String REQUEST_SERVICE = "handleRequestService";
    private static final int REQUEST_SERVICE_ERROR_CODE = 213;
    private static final String REQUEST_SERVICE_ERROR_MESSAGE = "Error sending requestServiceReference";
    private static final String REGISTRY_UPDATE_REQUEST = "handleRegistryUpdateRequest";
    private Map localRegistryUnregistrationTargets = new HashMap();

    private static Integer createNextRequestId() {
        return new Integer(uniqueRequestId++);
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        RemoteFilterImpl remoteFilter;
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"getRemoteServiceReferences", (Object[])new Object[]{target, idFilter, clazz, filter});
        RemoteFilterImpl remoteFilterImpl = remoteFilter = filter == null ? null : new RemoteFilterImpl(filter);
        if (target != null) {
            this.connectToRemoteServiceTarget(target);
        }
        this.waitForPendingUpdates(idFilter);
        ArrayList references = new ArrayList();
        this.addReferencesFromRemoteRegistrys(idFilter, clazz, remoteFilter, references);
        this.addReferencesFromLocalRegistry(idFilter, clazz, remoteFilter, references);
        IRemoteServiceReference[] result = references.toArray(new IRemoteServiceReference[references.size()]);
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"getRemoteServiceReferences", (Object)result);
        return result.length == 0 ? null : result;
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException {
        try {
            return this.getRemoteServiceReferences(null, idFilter, clazz, filter);
        }
        catch (ContainerConnectException e) {
            return null;
        }
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID targetID, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        return this.getRemoteServiceReferences(targetID, null, clazz, filter);
    }

    public IRemoteServiceReference[] getAllRemoteServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        IRemoteServiceReference[] result = this.getRemoteServiceReferences((ID[])null, clazz, filter);
        if (result == null) {
            return null;
        }
        return result.length == 0 ? null : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteServiceListener(IRemoteServiceListener listener) {
        List list = this.serviceListeners;
        synchronized (list) {
            this.serviceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteServiceListener(IRemoteServiceListener listener) {
        List list = this.serviceListeners;
        synchronized (list) {
            this.serviceListeners.remove(listener);
        }
    }

    public IRemoteService getRemoteService(IRemoteServiceReference reference) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"getRemoteService", (Object)reference);
        RemoteServiceRegistrationImpl registration = this.getRemoteServiceRegistrationImpl(reference);
        if (registration == null) {
            return null;
        }
        RemoteServiceImpl remoteService = new RemoteServiceImpl(this, registration);
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"getRemoteService", (Object)((Object)remoteService));
        return remoteService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceRegistration registerRemoteService(String[] clazzes, Object service, Dictionary properties) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"registerRemoteService", (Object[])new Object[]{clazzes, service, properties});
        if (service == null) {
            throw new NullPointerException("service cannot be null");
        }
        int size = clazzes.length;
        if (size == 0) {
            throw new IllegalArgumentException("service classes list is empty");
        }
        String[] copy = new String[clazzes.length];
        int i = 0;
        while (i < clazzes.length) {
            copy[i] = new String(clazzes[i].getBytes());
            ++i;
        }
        clazzes = copy;
        String invalidService = RegistrySharedObject.checkServiceClass(clazzes, service);
        if (invalidService != null) {
            throw new IllegalArgumentException("Service=" + invalidService + " is invalid");
        }
        RemoteServiceRegistrationImpl reg = new RemoteServiceRegistrationImpl();
        RemoteServiceRegistryImpl remoteServiceRegistryImpl = this.localRegistry;
        synchronized (remoteServiceRegistryImpl) {
            reg.publish(this, this.localRegistry, service, clazzes, properties);
            if (this.isConnected()) {
                ID[] targets = this.getTargetsFromProperties(properties);
                RemoteServiceRegistrationImpl[] regs = new RemoteServiceRegistrationImpl[]{reg};
                if (targets == null) {
                    this.sendAddRegistrations(null, null, regs);
                } else {
                    int i2 = 0;
                    while (i2 < targets.length) {
                        this.sendAddRegistrations(targets[i2], null, regs);
                        ++i2;
                    }
                }
            }
        }
        this.fireRemoteServiceListeners((IRemoteServiceEvent)this.createRegisteredEvent(reg));
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"registerRemoteService", (Object)reg);
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ungetRemoteService(IRemoteServiceReference ref) {
        if (ref == null) {
            return false;
        }
        IRemoteServiceID serviceID = ref.getID();
        if (serviceID == null) {
            return false;
        }
        Object object = this.localRegistry;
        synchronized (object) {
            RemoteServiceRegistrationImpl remoteServiceRegistrationImpl = this.localRegistry.findRegistrationForRemoteServiceId(serviceID);
            if (remoteServiceRegistrationImpl != null) {
                return true;
            }
        }
        object = this.remoteRegistrys;
        synchronized (object) {
            RemoteServiceRegistryImpl remoteServiceRegistryImpl = (RemoteServiceRegistryImpl)this.remoteRegistrys.get(serviceID.getContainerID());
            if (remoteServiceRegistryImpl == null) return false;
            return true;
        }
    }

    public IFuture asyncGetRemoteServiceReferences(final ID[] idFilter, final String clazz, final String filter) {
        JobsExecutor executor = new JobsExecutor("asyncGetRemoteServiceReferences");
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return RegistrySharedObject.this.getRemoteServiceReferences(idFilter, clazz, filter);
            }
        }, null);
    }

    public IFuture asyncGetRemoteServiceReferences(final ID target, final ID[] idFilter, final String clazz, final String filter) {
        JobsExecutor executor = new JobsExecutor("asyncGetRemoteServiceReferences");
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return RegistrySharedObject.this.getRemoteServiceReferences(target, idFilter, clazz, filter);
            }
        }, null);
    }

    public IFuture asyncGetRemoteServiceReferences(final ID target, final String clazz, final String filter) {
        JobsExecutor executor = new JobsExecutor("asyncGetRemoteServiceReferences");
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return RegistrySharedObject.this.getRemoteServiceReferences(target, clazz, filter);
            }
        }, null);
    }

    public Namespace getRemoteServiceNamespace() {
        return IDFactory.getDefault().getNamespaceByName("ecf.namespace.generic.remoteservice");
    }

    public IRemoteFilter createRemoteFilter(String filter) throws InvalidSyntaxException {
        return new RemoteFilterImpl(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceReference getRemoteServiceReference(IRemoteServiceID serviceId) {
        ID containerID = serviceId.getContainerID();
        if (containerID == null) {
            return null;
        }
        RemoteServiceRegistrationImpl registration = null;
        this.waitForPendingUpdates(new ID[]{containerID});
        ID localContainerID = this.getLocalContainerID();
        if (containerID.equals((Object)localContainerID)) {
            RemoteServiceRegistryImpl remoteServiceRegistryImpl = this.localRegistry;
            synchronized (remoteServiceRegistryImpl) {
                registration = this.localRegistry.findRegistrationForServiceId(serviceId.getContainerRelativeID());
                if (registration != null) {
                    return registration.getReference();
                }
            }
        }
        Map map = this.remoteRegistrys;
        synchronized (map) {
            ArrayList registrys = new ArrayList(this.remoteRegistrys.values());
            Iterator i = registrys.iterator();
            while (i.hasNext()) {
                RemoteServiceRegistryImpl registry = (RemoteServiceRegistryImpl)i.next();
                registration = registry.findRegistrationForServiceId(serviceId.getContainerRelativeID());
            }
        }
        return registration == null ? null : registration.getReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceID getRemoteServiceID(ID containerId, long containerRelativeId) {
        if (containerId == null) {
            return null;
        }
        ID localContainerID = this.getLocalContainerID();
        if (containerId.equals((Object)localContainerID)) {
            RemoteServiceRegistryImpl remoteServiceRegistryImpl = this.localRegistry;
            synchronized (remoteServiceRegistryImpl) {
                RemoteServiceRegistrationImpl reg = this.localRegistry.findRegistrationForServiceId(containerRelativeId);
                if (reg != null) {
                    return reg.getID();
                }
            }
        }
        Map map = this.remoteRegistrys;
        synchronized (map) {
            ArrayList registrys = new ArrayList(this.remoteRegistrys.values());
            Iterator i = registrys.iterator();
            while (i.hasNext()) {
                RemoteServiceRegistryImpl registry = (RemoteServiceRegistryImpl)i.next();
                RemoteServiceRegistrationImpl reg = registry.findRegistrationForServiceId(containerRelativeId);
                if (reg == null) continue;
                return reg.getID();
            }
        }
        return null;
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        this.connectContext = connectContext;
    }

    public void initialize() throws SharedObjectInitException {
        super.initialize();
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"initialize");
        ID localContainerID = this.getLocalContainerID();
        this.localRegistry = localContainerID == null ? new RemoteServiceRegistryImpl() : new RemoteServiceRegistryImpl(localContainerID);
        super.addEventProcessor(new IEventProcessor(){

            public boolean processEvent(Event arg0) {
                if (arg0 instanceof IContainerConnectedEvent) {
                    RegistrySharedObject.this.handleContainerConnectedEvent((IContainerConnectedEvent)arg0);
                } else if (arg0 instanceof IContainerDisconnectedEvent) {
                    RegistrySharedObject.this.handleContainerDisconnectedEvent((IContainerDisconnectedEvent)arg0);
                } else if (arg0 instanceof IContainerEjectedEvent) {
                    RegistrySharedObject.this.handleContainerEjectedEvent((IContainerEjectedEvent)arg0);
                } else if (arg0 instanceof ISharedObjectActivatedEvent && RegistrySharedObject.this.getID().equals((Object)((ISharedObjectActivatedEvent)arg0).getActivatedID())) {
                    RegistrySharedObject.this.handleRegistryActivatedEvent();
                }
                return false;
            }
        });
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"initialize");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(ID containerID) {
        Object object = this.rsQueueLock;
        synchronized (object) {
            if (this.rsListenerDispatchEventManager != null) {
                this.rsListenerDispatchEventManager.close();
                this.rsListenerDispatchEventManager = null;
                this.rsListenerDispatchQueue = null;
            }
        }
        object = this.remoteRegistrys;
        synchronized (object) {
            this.remoteRegistrys.clear();
        }
        object = this.serviceListeners;
        synchronized (object) {
            this.serviceListeners.clear();
        }
        object = this.addRegistrationRequests;
        synchronized (object) {
            this.addRegistrationRequests.clear();
        }
        object = this.requests;
        synchronized (object) {
            this.requests.clear();
        }
        object = this.pendingUpdateContainers;
        synchronized (object) {
            this.pendingUpdateContainers.clear();
        }
        object = this.registryUpdateRequests;
        synchronized (object) {
            this.registryUpdateRequests.clear();
        }
        object = this.localRegistry;
        synchronized (object) {
            this.localRegistry.unpublishServices();
            this.localRegistryUnregistrationTargets.clear();
        }
        super.dispose(containerID);
    }

    protected int getRSConnectTimeout() {
        return this.rsConnectTimeout;
    }

    protected long getRegistryUpdateRequestTimeout() {
        return this.registryUpdateRequestTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRegistryUpdateRequestAndWait(ID targetContainerID) {
        List list = this.registryUpdateRequests;
        synchronized (list) {
            Integer requestId = RegistrySharedObject.createNextRequestId();
            this.registryUpdateRequests.add(requestId);
            this.sendRegistryUpdateRequest(targetContainerID, requestId);
            long timeOut = System.currentTimeMillis() + this.getRegistryUpdateRequestTimeout();
            while (timeOut - System.currentTimeMillis() >= 0L) {
                if (!this.registryUpdateRequests.contains(requestId)) {
                    Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug", ((Object)((Object)this)).getClass(), (String)"sendRegistryUpdateRequestAndWait", (String)("localContainerID=" + this.getLocalContainerID() + " returning because response received"));
                    return;
                }
                try {
                    this.registryUpdateRequests.wait(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug", ((Object)((Object)this)).getClass(), (String)"sendRegistryUpdateRequestAndWait", (String)("localContainerID=" + this.getLocalContainerID() + " returning because of timeout"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReferencesFromRemoteRegistrys(ID[] idFilter, String clazz, IRemoteFilter remoteFilter, List referencesFound) {
        if (idFilter == null) {
            Map map = this.remoteRegistrys;
            synchronized (map) {
                ArrayList registrys = new ArrayList(this.remoteRegistrys.values());
                Iterator i = registrys.iterator();
                while (i.hasNext()) {
                    RemoteServiceRegistryImpl registry = (RemoteServiceRegistryImpl)i.next();
                    this.addReferencesFromRegistry(clazz, remoteFilter, registry, referencesFound);
                }
            }
        }
        int i = 0;
        while (i < idFilter.length) {
            ID targetContainerID = idFilter[i];
            if (targetContainerID != null) {
                this.sendRegistryUpdateRequestAndWait(targetContainerID);
                Map map = this.remoteRegistrys;
                synchronized (map) {
                    RemoteServiceRegistryImpl remoteRegistryForContainer = (RemoteServiceRegistryImpl)this.remoteRegistrys.get(targetContainerID);
                    if (remoteRegistryForContainer != null) {
                        this.addReferencesFromRegistry(clazz, remoteFilter, remoteRegistryForContainer, referencesFound);
                    }
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReferencesFromLocalRegistry(ID[] idFilter, String clazz, IRemoteFilter remoteFilter, List referencesFound) {
        ID localContainerID = this.getLocalContainerID();
        if (idFilter == null || Arrays.asList(idFilter).contains(localContainerID)) {
            RemoteServiceRegistryImpl remoteServiceRegistryImpl = this.localRegistry;
            synchronized (remoteServiceRegistryImpl) {
                this.addReferencesFromRegistry(clazz, remoteFilter, this.localRegistry, referencesFound);
            }
        }
    }

    protected int getAddRegistrationRequestTimeout() {
        return this.addRegistrationRequestTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectToRemoteServiceTarget(ID targetID) throws ContainerConnectException {
        ISharedObjectContext context = this.getContext();
        ID connectedID = context.getConnectedID();
        if (connectedID != null) {
            return;
        }
        Object object = this.rsConnectLock;
        synchronized (object) {
            context.connect(targetID, this.connectContext);
            int rsTimeout = this.getRSConnectTimeout();
            long endTime = System.currentTimeMillis() + (long)rsTimeout;
            while (!this.rsConnected && endTime >= System.currentTimeMillis()) {
                try {
                    this.rsConnectLock.wait(rsTimeout / 10);
                }
                catch (InterruptedException e) {
                    throw new ContainerConnectException("No notification of registry connect complete for connect targetID=" + targetID);
                }
            }
            if (!this.rsConnected) {
                throw new ContainerConnectException("Could not complete registry connect for targetID=" + targetID);
            }
        }
    }

    protected Serializable getAddRegistrationRequestCredentials(AddRegistrationRequest request) {
        return null;
    }

    protected ID[] getTargetsFromProperties(Dictionary properties) {
        if (properties == null) {
            return null;
        }
        ArrayList<Object> results = new ArrayList<Object>();
        Object o = properties.get("ecf.rsvc.reg.targets");
        if (o != null) {
            if (o instanceof ID) {
                results.add(o);
            }
            if (o instanceof ID[]) {
                ID[] targets = (ID[])o;
                int i = 0;
                while (i < targets.length) {
                    results.add(targets[i]);
                    ++i;
                }
            }
        }
        if (results.size() == 0) {
            return null;
        }
        return results.toArray(new ID[0]);
    }

    protected ISharedObjectContext getSOContext() {
        return super.getContext();
    }

    protected void handleRegistryActivatedEvent() {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"handleRegistryActivatedEvent");
        ID[] members = this.getGroupMemberIDs();
        ID localContainerID = this.getLocalContainerID();
        ID connectedID = this.getConnectedID();
        Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug", ((Object)((Object)this)).getClass(), (String)"handleRegistryActivatedEvent", (String)("localContainerID=" + this.getLocalContainerID() + ",members=" + Arrays.asList(members)));
        if (this.isConnected()) {
            int i = 0;
            while (i < members.length) {
                if (!members[i].equals((Object)localContainerID)) {
                    this.addPendingContainers(new ID[]{members[i]});
                    this.sendRegistryUpdate(members[i]);
                    if (connectedID.equals((Object)members[i])) {
                        this.setRegistryConnected(true);
                    }
                }
                ++i;
            }
        }
    }

    protected void handleContainerEjectedEvent(IContainerEjectedEvent arg0) {
        this.handleTargetGoneEvent(arg0.getTargetID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearRemoteRegistrys() {
        ArrayList<RemoteServiceRegistrationImpl> registrations = new ArrayList<RemoteServiceRegistrationImpl>();
        Map map = this.remoteRegistrys;
        synchronized (map) {
            Iterator i = this.remoteRegistrys.keySet().iterator();
            while (i.hasNext()) {
                ID containerID = (ID)i.next();
                RemoteServiceRegistryImpl registry = (RemoteServiceRegistryImpl)this.remoteRegistrys.get(containerID);
                if (registry == null) continue;
                this.removeRemoteRegistry(containerID);
                RemoteServiceRegistrationImpl[] regs = registry.getRegistrations();
                if (regs == null) continue;
                int j = 0;
                while (j < regs.length) {
                    registry.unpublishService(regs[j]);
                    registrations.add(regs[j]);
                    ++j;
                }
            }
        }
        Iterator i = registrations.iterator();
        while (i.hasNext()) {
            this.fireRemoteServiceListeners((IRemoteServiceEvent)this.createUnregisteredEvent((RemoteServiceRegistrationImpl)i.next()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTargetGoneEvent(ID targetID) {
        ID localContainerID;
        RemoteServiceRegistryImpl registry;
        RemoteServiceRegistrationImpl[] registrations = null;
        Map map = this.remoteRegistrys;
        synchronized (map) {
            registry = this.getRemoteRegistry(targetID);
            if (registry != null) {
                this.removeRemoteRegistry(targetID);
                registrations = registry.getRegistrations();
                if (registrations != null) {
                    int i = 0;
                    while (i < registrations.length) {
                        registry.unpublishService(registrations[i]);
                        ++i;
                    }
                }
            }
        }
        this.removePendingContainers(targetID);
        if (!this.isConnected()) {
            this.setRegistryConnected(false);
        }
        if ((localContainerID = this.getLocalContainerID()) == null) {
            registry = this.localRegistry;
            synchronized (registry) {
                this.localRegistry.setContainerID(null);
            }
        }
        if (registrations != null) {
            int i = 0;
            while (i < registrations.length) {
                this.fireRemoteServiceListeners((IRemoteServiceEvent)this.createUnregisteredEvent(registrations[i]));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRegistryConnected(boolean connected) {
        Object object = this.rsConnectLock;
        synchronized (object) {
            this.rsConnected = connected;
            this.rsConnectLock.notify();
        }
    }

    protected void handleContainerDisconnectedEvent(IContainerDisconnectedEvent event) {
        this.handleTargetGoneEvent(event.getTargetID());
    }

    protected void sendRegistryUpdate(ID targetContainerID) {
        this.sendRegistryUpdate(targetContainerID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendRegistryUpdate(ID targetContainerID, Integer requestId) {
        RemoteServiceRegistryImpl remoteServiceRegistryImpl = this.localRegistry;
        synchronized (remoteServiceRegistryImpl) {
            RemoteServiceRegistrationImpl[] registrations = this.localRegistry.getRegistrations();
            this.sendAddRegistrations(targetContainerID, requestId, registrations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingContainers(ID[] ids) {
        if (ids == null) {
            return;
        }
        ID localContainerID = this.getLocalContainerID();
        Hashtable hashtable = this.pendingUpdateContainers;
        synchronized (hashtable) {
            int i = 0;
            while (i < ids.length) {
                if (!ids[i].equals((Object)localContainerID)) {
                    this.pendingUpdateContainers.put(ids[i], ids[i]);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePendingContainers(ID id) {
        if (id == null) {
            return false;
        }
        ID localContainerID = this.getLocalContainerID();
        Hashtable hashtable = this.pendingUpdateContainers;
        synchronized (hashtable) {
            Object result = this.pendingUpdateContainers.remove(id);
            Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug", ((Object)((Object)this)).getClass(), (String)"removePendingContainers", (String)("localContainerID=" + localContainerID + ",REMOVED=" + result + ",pendingUpdateContainers=" + this.pendingUpdateContainers));
            this.pendingUpdateContainers.notify();
            return result != null;
        }
    }

    private boolean anyPending(ID[] idFilter) {
        if (idFilter == null) {
            return this.pendingUpdateContainers.size() > 0;
        }
        int i = 0;
        while (i < idFilter.length) {
            if (this.pendingUpdateContainers.containsKey(idFilter[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPendingUpdates(ID[] idFilter) {
        long timeout = this.getAddRegistrationRequestTimeout();
        long endTime = System.currentTimeMillis() + timeout;
        Hashtable hashtable = this.pendingUpdateContainers;
        synchronized (hashtable) {
            while (this.anyPending(idFilter) && endTime >= System.currentTimeMillis()) {
                try {
                    this.pendingUpdateContainers.wait(timeout / 10L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    protected void handleContainerConnectedEvent(IContainerConnectedEvent event) {
        this.handleTargetConnected(event.getTargetID());
    }

    protected void handleTargetConnected(ID targetID) {
        Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug", ((Object)((Object)this)).getClass(), (String)"handleTargetConnected", (String)("localContainerID=" + this.getLocalContainerID() + ",targetID=" + targetID));
        this.addPendingContainers(new ID[]{targetID});
        this.sendRegistryUpdate(targetID);
        if (this.getConnectedID().equals((Object)targetID)) {
            this.setRegistryConnected(true);
        }
    }

    private Request createRequest(RemoteServiceRegistrationImpl remoteRegistration, IRemoteCall call, IRemoteCallListener listener) {
        return new Request(this.getLocalContainerID(), remoteRegistration.getServiceId(), RemoteCallImpl.createRemoteCall(null, call.getMethod(), call.getParameters(), call.getTimeout()), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doFireRemoteServiceListeners(IRemoteServiceEvent event) {
        ArrayList entries;
        List list = this.serviceListeners;
        synchronized (list) {
            entries = new ArrayList(this.serviceListeners);
        }
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            IRemoteServiceListener l = (IRemoteServiceListener)i.next();
            l.handleServiceEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRemoteServiceListeners(IRemoteServiceEvent event) {
        Object object = this.rsQueueLock;
        synchronized (object) {
            if (this.rsListenerDispatchQueue == null) {
                ID containerID = this.getLocalContainerID();
                String threadGroupName = "RSRegistry Dispatcher for containerID=" + containerID;
                ThreadGroup eventGroup = new ThreadGroup(threadGroupName);
                eventGroup.setDaemon(true);
                this.rsListenerDispatchEventManager = new EventManager(threadGroupName, eventGroup);
                this.rsListenerDispatchQueue = new ListenerQueue(this.rsListenerDispatchEventManager);
                CopyOnWriteIdentityMap listeners = new CopyOnWriteIdentityMap();
                listeners.put((Object)this, (Object)this);
                this.rsListenerDispatchQueue.queueListeners(listeners.entrySet(), new EventDispatcher(){

                    public void dispatchEvent(Object eventListener, Object listenerObject, int eventAction, Object eventObject) {
                        RegistrySharedObject.this.doFireRemoteServiceListeners((IRemoteServiceEvent)eventObject);
                    }
                });
            }
        }
        this.rsListenerDispatchQueue.dispatchEventAsynchronous(0, (Object)event);
    }

    private RemoteServiceRegistrationImpl getRemoteServiceRegistrationImpl(IRemoteServiceReference reference) {
        if (reference instanceof RemoteServiceReferenceImpl) {
            RemoteServiceReferenceImpl ref = (RemoteServiceReferenceImpl)reference;
            if (!ref.isActive()) {
                return null;
            }
            return ref.getRegistration();
        }
        return null;
    }

    private void addReferencesFromRegistry(String clazz, IRemoteFilter remoteFilter, RemoteServiceRegistryImpl registry, List references) {
        IRemoteServiceReference[] rs = registry.lookupServiceReferences(clazz, remoteFilter);
        if (rs != null) {
            int j = 0;
            while (j < rs.length) {
                references.add(rs[j]);
                ++j;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object callSynch(RemoteServiceRegistrationImpl registration, IRemoteCall call) throws ECFException {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"callSynch", (Object[])new Object[]{registration, call});
        boolean doneWaiting = false;
        Response response = null;
        try {
            Request request = this.sendCallRequest(registration, call);
            long requestId = request.getRequestId();
            Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)("callSync request sent with requestid=" + requestId));
            long timeout = call.getTimeout() + System.currentTimeMillis();
            while (timeout - System.currentTimeMillis() > 0L && !doneWaiting) {
                Request request2 = request;
                synchronized (request2) {
                    if (request.isDone()) {
                        Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)("callSynch.request/response done for requestId=" + requestId));
                        doneWaiting = true;
                        response = request.getResponse();
                        if (response == null) {
                            throw new ECFException("Invalid response for requestId=" + requestId);
                        }
                    } else {
                        Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)("Waiting 5000 for response to request: " + requestId));
                        request.wait(5000L);
                    }
                }
            }
            if (!doneWaiting) {
                throw new ECFException("Request timed out after " + Long.toString(call.getTimeout()) + "ms", (Throwable)new TimeoutException(call.getTimeout()));
            }
        }
        catch (IOException e) {
            this.log(203, CALL_REQUEST_ERROR_MESSAGE, e);
            throw new ECFException("Error sending request", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.log(204, CALL_REQUEST_TIMEOUT_ERROR_MESSAGE, e);
            throw new ECFException("Wait for response interrupted", (Throwable)e);
        }
        Object result = null;
        if (response.hadException()) {
            throw new ECFException("Exception in remote call", response.getException());
        }
        result = response.getResponse();
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"callSynch", (Object)result);
        return result;
    }

    protected void fireCallStartEvent(IRemoteCallListener listener, final long requestId, final IRemoteServiceReference reference, final IRemoteCall call) {
        if (listener != null) {
            listener.handleEvent((IRemoteCallEvent)new IRemoteCallStartEvent(){

                public long getRequestId() {
                    return requestId;
                }

                public IRemoteCall getCall() {
                    return call;
                }

                public IRemoteServiceReference getReference() {
                    return reference;
                }

                public String toString() {
                    StringBuffer buf = new StringBuffer("IRemoteCallStartEvent[");
                    buf.append(";reference=").append(reference).append(";call=").append(call).append("]");
                    return buf.toString();
                }
            });
        }
    }

    protected void fireCallCompleteEvent(IRemoteCallListener listener, final long requestId, final Object response, final boolean hadException, final Throwable exception) {
        if (listener != null) {
            listener.handleEvent((IRemoteCallEvent)new IRemoteCallCompleteEvent(){

                public long getRequestId() {
                    return requestId;
                }

                public Throwable getException() {
                    return exception;
                }

                public Object getResponse() {
                    return response;
                }

                public boolean hadException() {
                    return hadException;
                }

                public String toString() {
                    StringBuffer buf = new StringBuffer("IRemoteCallCompleteEvent[");
                    buf.append(";response=").append(response).append(";hadException=").append(hadException).append(";exception=").append(exception).append("]");
                    return buf.toString();
                }
            });
        }
    }

    static String checkServiceClass(String[] clazzes, final Object serviceObject) {
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return serviceObject.getClass().getClassLoader();
            }
        });
        int i = 0;
        while (i < clazzes.length) {
            block4: {
                try {
                    Class<?> serviceClazz;
                    Class<?> clazz = serviceClazz = cl == null ? Class.forName(clazzes[i]) : cl.loadClass(clazzes[i]);
                    if (!serviceClazz.isInstance(serviceObject)) {
                        return clazzes[i];
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!RegistrySharedObject.extensiveCheckServiceClass(clazzes[i], serviceObject.getClass())) break block4;
                    return clazzes[i];
                }
            }
            ++i;
        }
        return null;
    }

    private static boolean extensiveCheckServiceClass(String clazz, Class serviceClazz) {
        if (clazz.equals(serviceClazz.getName())) {
            return false;
        }
        Class<?>[] interfaces = serviceClazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (!RegistrySharedObject.extensiveCheckServiceClass(clazz, interfaces[i])) {
                return false;
            }
            ++i;
        }
        Class superClazz = serviceClazz.getSuperclass();
        return superClazz == null || RegistrySharedObject.extensiveCheckServiceClass(clazz, superClazz);
    }

    protected void sendRegistryUpdateRequest(ID receiver, Integer requestId) {
        ID localContainerID = this.getLocalContainerID();
        Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug", ((Object)((Object)this)).getClass(), (String)"sendRegistryUpdateRequest", (String)("localContainerID=" + localContainerID + ",targetContainerID=" + receiver + ",requestId=" + requestId));
        try {
            this.sendSharedObjectMsgTo(receiver, SharedObjectMsg.createMsg(null, (String)REGISTRY_UPDATE_REQUEST, (Object[])new Object[]{localContainerID, requestId}));
        }
        catch (IOException e) {
            this.log(212, "Exception sending registry update request/2 message", e);
        }
    }

    protected void handleRegistryUpdateRequest(ID remoteContainerID, Integer requestId) {
        Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug", ((Object)((Object)this)).getClass(), (String)REGISTRY_UPDATE_REQUEST, (String)("localContainerID=" + this.getLocalContainerID() + ",remoteContainerID=" + remoteContainerID + ",requestId=" + requestId));
        this.sendRegistryUpdate(remoteContainerID, requestId);
    }

    protected void sendRegistryUpdateRequest() {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendRegistryUpdateRequest");
        try {
            this.sendSharedObjectMsgTo(null, SharedObjectMsg.createMsg((String)REGISTRY_UPDATE_REQUEST, (Object)this.getLocalContainerID()));
        }
        catch (IOException e) {
            this.log(210, CALL_RESPONSE_ERROR_MESSAGE, e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendRegistryUpdateRequest");
    }

    protected void handleRegistryUpdateRequest(ID remoteContainerID) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)REGISTRY_UPDATE_REQUEST);
        if (remoteContainerID == null) {
            return;
        }
        this.sendRegistryUpdate(remoteContainerID);
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)REGISTRY_UPDATE_REQUEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeRegistryUpdateRequest(Integer requestId) {
        if (requestId == null) {
            return false;
        }
        List list = this.registryUpdateRequests;
        synchronized (list) {
            boolean result = this.registryUpdateRequests.remove(requestId);
            Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug", ((Object)((Object)this)).getClass(), (String)"removeRegistryUpdateRequest", (String)("localContainerID=" + this.getLocalContainerID() + ", REMOVED requestId=" + requestId));
            this.registryUpdateRequests.notify();
            return result;
        }
    }

    protected AddRegistrationRequest sendAddRegistrationRequest(ID receiver, AddRegistrationRequest request, Serializable credentials) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendAddRegistrationRequest", (Object[])new Object[]{receiver, request, credentials});
        Assert.isNotNull((Object)receiver);
        Assert.isNotNull((Object)request);
        try {
            this.sendSharedObjectMsgTo(receiver, SharedObjectMsg.createMsg(null, (String)REQUEST_SERVICE, (Object[])new Object[]{this.getLocalContainerID(), request, request.getId(), credentials}));
        }
        catch (IOException e) {
            this.log(213, REQUEST_SERVICE_ERROR_MESSAGE, e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendAddRegistrationRequest");
        return request;
    }

    protected void checkRequestServiceAuthorization(ID remoteContainerID, AddRegistrationRequest request, Serializable credentials) throws AccessControlException {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"checkRequestServiceAuthorization", (Object[])new Object[]{remoteContainerID, request, credentials});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequestService(ID remoteContainerID, AddRegistrationRequest request, Integer requestId, Serializable credentials) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"handleRequestServiceReference", (Object[])new Object[]{remoteContainerID, request, requestId, credentials});
        if (remoteContainerID == null || requestId == null) {
            return;
        }
        if (request == null) {
            return;
        }
        RemoteFilterImpl rf = null;
        try {
            rf = request.getFilter() == null ? null : new RemoteFilterImpl(request.getFilter());
        }
        catch (InvalidSyntaxException e) {
            this.log("handleRequestService invalid syntax exception for filter", e);
            rf = null;
        }
        try {
            this.checkRequestServiceAuthorization(remoteContainerID, request, credentials);
        }
        catch (AccessControlException e) {
            this.log("handleRequestService. checkRequestServiceAuthorization exception", e);
            this.sendAddRegistrationRequestRefused(remoteContainerID, requestId, e);
            return;
        }
        String service = request.getService();
        RemoteServiceRegistryImpl remoteServiceRegistryImpl = this.localRegistry;
        synchronized (remoteServiceRegistryImpl) {
            RemoteServiceRegistrationImpl[] regs = null;
            if (service == null) {
                regs = this.localRegistry.getRegistrations();
            } else {
                RemoteServiceReferenceImpl[] srs = (RemoteServiceReferenceImpl[])this.localRegistry.lookupServiceReferences(request.getService(), rf);
                ArrayList<RemoteServiceRegistrationImpl> regsList = new ArrayList<RemoteServiceRegistrationImpl>();
                if (srs != null && srs.length > 0) {
                    int i = 0;
                    while (i < srs.length) {
                        RemoteServiceRegistrationImpl impl = this.getRemoteServiceRegistrationImpl(srs[i]);
                        if (impl != null) {
                            regsList.add(impl);
                        }
                        ++i;
                    }
                }
                if (regsList.size() > 0) {
                    regs = regsList.toArray(new RemoteServiceRegistrationImpl[0]);
                }
            }
            this.sendAddRegistrations(remoteContainerID, requestId, regs);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)REQUEST_SERVICE);
    }

    protected void sendAddRegistration(ID receiver, RemoteServiceRegistrationImpl reg) {
        this.sendAddRegistration(receiver, null, reg);
    }

    protected void sendAddRegistration(ID receiver, Integer requestId, RemoteServiceRegistrationImpl reg) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendAddRegistration", (Object[])new Object[]{receiver, requestId, reg});
        try {
            this.sendSharedObjectMsgTo(receiver, SharedObjectMsg.createMsg(null, (String)ADD_REGISTRATION, (Object)this.getLocalContainerID(), (Object)requestId, (Object)reg));
        }
        catch (IOException e) {
            this.log(212, ADD_REGISTRATION_ERROR_MESSAGE, e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendAddRegistration");
    }

    protected void sendAddRegistrations(ID receiver, Integer requestId, RemoteServiceRegistrationImpl[] regs) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendAddRegistrations", (Object[])new Object[]{receiver, requestId, regs});
        try {
            this.sendSharedObjectMsgTo(receiver, SharedObjectMsg.createMsg(null, (String)ADD_REGISTRATIONS, (Object)this.getLocalContainerID(), (Object)requestId, (Object)regs));
            if (receiver != null && requestId != null) {
                int i = 0;
                while (i < regs.length) {
                    this.addTargetForUnregister(regs[i], receiver);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            this.log(212, ADD_REGISTRATION_ERROR_MESSAGE, e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendAddRegistrations");
    }

    protected void sendAddRegistrationRequestRefused(ID receiver, Integer requestId, Exception except) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendAddRegistrationRequestRefused", (Object[])new Object[]{receiver, except});
        try {
            this.sendSharedObjectMsgTo(receiver, SharedObjectMsg.createMsg(null, (String)ADD_REGISTRATION_REFUSED, (Object)this.getLocalContainerID(), (Object)requestId, (Object)except));
        }
        catch (IOException e) {
            this.log(214, ADD_REGISTRATION_REFUSED_ERROR_MESSAGE, e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendAddRegistrationRequestRefused");
    }

    protected void handleAddRegistrationRequestRefused(ID remoteContainerID, Integer requestId, AccessControlException e) {
        if (remoteContainerID == null || requestId == null) {
            return;
        }
        this.notifyAddRegistrationResponse(remoteContainerID, requestId, e);
    }

    protected void handleAddRegistration(ID remoteContainerID, RemoteServiceRegistrationImpl registration) {
        this.handleAddRegistration(remoteContainerID, null, registration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAddRegistrations(ID remoteContainerID, Integer requestId, RemoteServiceRegistrationImpl[] registrations) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)ADD_REGISTRATIONS, (Object[])new Object[]{remoteContainerID, registrations});
        ID localContainerID = this.getLocalContainerID();
        if (remoteContainerID == null || localContainerID == null || localContainerID.equals((Object)remoteContainerID)) {
            return;
        }
        ArrayList<RemoteServiceRegistrationImpl> addedRegistrations = new ArrayList<RemoteServiceRegistrationImpl>();
        if (registrations != null) {
            Map map = this.remoteRegistrys;
            synchronized (map) {
                RemoteServiceRegistryImpl registry = this.getRemoteRegistry(remoteContainerID);
                if (registry == null) {
                    registry = new RemoteServiceRegistryImpl(remoteContainerID);
                    this.addRemoteRegistry(registry);
                }
                int i = 0;
                while (i < registrations.length) {
                    RemoteServiceRegistrationImpl[] regs = registry.getRegistrations();
                    List<RemoteServiceRegistrationImpl> regList = Arrays.asList(regs);
                    if (!regList.contains(registrations[i])) {
                        addedRegistrations.add(registrations[i]);
                        registry.publishService(registrations[i]);
                    }
                    ++i;
                }
            }
        }
        this.removePendingContainers(remoteContainerID);
        if (requestId != null) {
            this.removeRegistryUpdateRequest(requestId);
        }
        Iterator i = addedRegistrations.iterator();
        while (i.hasNext()) {
            this.fireRemoteServiceListeners((IRemoteServiceEvent)this.createRegisteredEvent((RemoteServiceRegistrationImpl)i.next()));
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)ADD_REGISTRATIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAddRegistration(ID remoteContainerID, Integer requestId, RemoteServiceRegistrationImpl registration) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)ADD_REGISTRATION, (Object[])new Object[]{remoteContainerID, registration});
        ID localContainerID = this.getLocalContainerID();
        if (remoteContainerID == null || localContainerID == null || localContainerID.equals((Object)remoteContainerID)) {
            return;
        }
        boolean added = false;
        Map map = this.remoteRegistrys;
        synchronized (map) {
            RemoteServiceRegistrationImpl[] regs;
            List<RemoteServiceRegistrationImpl> regList;
            RemoteServiceRegistryImpl registry = this.getRemoteRegistry(remoteContainerID);
            if (registry == null) {
                registry = new RemoteServiceRegistryImpl(remoteContainerID);
                this.addRemoteRegistry(registry);
            }
            if (!(regList = Arrays.asList(regs = registry.getRegistrations())).contains(registration)) {
                added = true;
                registry.publishService(registration);
            }
            this.notifyAddRegistrationResponse(remoteContainerID, requestId, null);
        }
        if (added) {
            this.fireRemoteServiceListeners((IRemoteServiceEvent)this.createRegisteredEvent(registration));
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)ADD_REGISTRATION);
    }

    protected void notifyAddRegistrationResponse(ID remoteContainerID, Integer requestId, AccessControlException exception) {
        if (remoteContainerID == null) {
            return;
        }
        if (requestId == null) {
            return;
        }
        AddRegistrationRequest request = this.removeAddRegistrationRequest(requestId);
        if (request != null) {
            request.notifyResponse(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddRegistrationRequest removeAddRegistrationRequest(Integer requestId) {
        Map map = this.addRegistrationRequests;
        synchronized (map) {
            return (AddRegistrationRequest)this.addRegistrationRequests.remove(requestId);
        }
    }

    protected Request sendCallRequest(RemoteServiceRegistrationImpl remoteRegistration, IRemoteCall call) throws IOException {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendCallRequest", (Object[])new Object[]{remoteRegistration, call});
        Request request = this.createRequest(remoteRegistration, call, null);
        this.addRequest(request);
        try {
            this.sendSharedObjectMsgTo(remoteRegistration.getContainerID(), SharedObjectMsg.createMsg((String)CALL_REQUEST, (Object)request));
        }
        catch (IOException e) {
            this.removeRequest(request);
            throw e;
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendCallRequest", (Object)request);
        return request;
    }

    private IExecutor getRequestExecutor(Request request) {
        if (this.requestExecutor == null) {
            this.requestExecutor = this.createRequestExecutor(request);
        }
        return this.requestExecutor;
    }

    protected IExecutor createRequestExecutor(final Request request) {
        Object executor = null;
        if (DEFAULT_EXECUTOR_TYPE.equals("jobs")) {
            executor = new JobsExecutor("Remote Request Handler"){

                protected String createJobName(String executorName, int jobCounter, IProgressRunnable runnable) {
                    return String.valueOf(executorName) + " - " + request.getCall().getMethod() + ":" + request.getRequestId();
                }
            };
        } else if (DEFAULT_EXECUTOR_TYPE.equals("immediate")) {
            executor = new ImmediateExecutor();
        } else if (DEFAULT_EXECUTOR_TYPE.equals("threads")) {
            executor = new ThreadsExecutor(){

                protected String createThreadName(IProgressRunnable runnable) {
                    return "Remote Request Handler - " + request.getCall().getMethod() + ":" + request.getRequestId();
                }
            };
        }
        return executor;
    }

    protected void executeRequest(IExecutor executor, final Request request, final ID responseTarget, final RemoteServiceRegistrationImpl localRegistration, final boolean respond) {
        IProgressRunnable runnable = new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                RemoteCallImpl call = request.getCall();
                Response response = null;
                Object result = null;
                try {
                    IRemoteServiceCallPolicy callPolicy = RegistrySharedObject.this.getRemoteServiceCallPolicy();
                    if (callPolicy != null) {
                        callPolicy.checkRemoteCall(responseTarget, (IRemoteServiceRegistration)localRegistration, (IRemoteCall)call);
                    }
                    result = localRegistration.callService(call);
                    response = new Response(request.getRequestId(), result);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    response = new Response(request.getRequestId(), RegistrySharedObject.this.getSerializableException(cause));
                    RegistrySharedObject.this.logRemoteCallException("Invocation target exception invoking remote service.  Remote request=" + request, cause);
                }
                catch (Exception e) {
                    response = new Response(request.getRequestId(), RegistrySharedObject.this.getSerializableException(e));
                    RegistrySharedObject.this.logRemoteCallException("Unexpected exception invoking remote service.  Remote request=" + request, e);
                }
                catch (NoClassDefFoundError e) {
                    response = new Response(request.getRequestId(), RegistrySharedObject.this.getSerializableException(e));
                    RegistrySharedObject.this.logRemoteCallException("No class def found error invoking remote service.  Remote request=" + request, e);
                }
                if (respond) {
                    RegistrySharedObject.this.sendCallResponse(responseTarget, response);
                }
                return null;
            }
        };
        executor.execute(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    private void sendErrorResponse(ID responseTarget, long requestId, String message, Throwable e) {
        this.logRemoteCallException(message, e);
        Response response = new Response(requestId, e);
        this.sendCallResponse(responseTarget, response);
    }

    protected void handleCallRequest(Request request) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)CALL_REQUEST, (Object)request);
        if (request == null) {
            this.log(CALL_REQUEST, new NullPointerException("Request cannot be null"));
            return;
        }
        ID responseTarget = request.getRequestContainerID();
        if (responseTarget == null) {
            this.log(CALL_REQUEST, new NullPointerException("Response target cannot be null"));
            return;
        }
        RemoteServiceRegistrationImpl localRegistration = this.getLocalRegistrationForRequest(request);
        if (localRegistration == null) {
            this.sendErrorResponse(responseTarget, request.getRequestId(), CALL_REQUEST, new NullPointerException("local service registration not found for remote request=" + request));
            return;
        }
        IExecutor executor = this.getRequestExecutor(request);
        if (executor == null) {
            this.sendErrorResponse(responseTarget, request.getRequestId(), CALL_REQUEST, new NullPointerException("request executor is not available and so no requests can be processed"));
            return;
        }
        this.executeRequest(executor, request, responseTarget, localRegistration, true);
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)CALL_REQUEST);
    }

    protected void logRemoteCallException(String message, Throwable e) {
    }

    private Throwable getSerializableException(Throwable e) {
        SerializableStatus ss = new SerializableStatus(0, "org.eclipse.ecf.provider.remoteservice", null, e);
        return ss.getException();
    }

    protected void sendCallRequestWithListener(RemoteServiceRegistrationImpl remoteRegistration, IRemoteCall call, IRemoteCallListener listener) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendCallRequestWithListener", (Object[])new Object[]{remoteRegistration, call, listener});
        Request request = this.createRequest(remoteRegistration, call, listener);
        this.fireCallStartEvent(listener, request.getRequestId(), remoteRegistration.getReference(), call);
        try {
            this.addRequest(request);
            this.sendSharedObjectMsgTo(remoteRegistration.getContainerID(), SharedObjectMsg.createMsg((String)CALL_REQUEST, (Object)request));
        }
        catch (IOException e) {
            this.log(203, CALL_REQUEST_ERROR_MESSAGE, e);
            this.removeRequest(request);
            this.fireCallCompleteEvent(listener, request.getRequestId(), null, true, e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendCallRequestWithListener");
    }

    protected void log(int code, String method, Throwable e) {
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.remoteservice", code, method, e));
    }

    protected void sendCallResponse(ID responseTarget, Response response) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendCallResponse", (Object[])new Object[]{responseTarget, response});
        try {
            this.sendSharedObjectMsgTo(responseTarget, SharedObjectMsg.createMsg((String)CALL_RESPONSE, (Object)response));
        }
        catch (IOException e) {
            this.log(210, CALL_RESPONSE_ERROR_MESSAGE, e);
            e.printStackTrace(System.err);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendCallResponse");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCallResponse(Response response) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)CALL_RESPONSE, (Object[])new Object[]{response});
        Request request = this.getRequest(response.getRequestId());
        if (request == null) {
            this.log(211, REQUEST_NOT_FOUND_ERROR_MESSAGE, new NullPointerException());
            return;
        }
        this.removeRequest(request);
        IRemoteCallListener listener = request.getListener();
        if (listener != null) {
            this.fireCallCompleteEvent(listener, request.getRequestId(), response.getResponse(), response.hadException(), response.getException());
            return;
        }
        Request request2 = request;
        synchronized (request2) {
            request.setResponse(response);
            request.setDone(true);
            request.notify();
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)CALL_RESPONSE);
    }

    protected Request sendFireRequest(RemoteServiceRegistrationImpl remoteRegistration, IRemoteCall call) throws ECFException {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendFireRequest", (Object[])new Object[]{remoteRegistration, call});
        Request request = this.createRequest(remoteRegistration, call, null);
        try {
            this.sendSharedObjectMsgTo(remoteRegistration.getContainerID(), SharedObjectMsg.createMsg((String)FIRE_REQUEST, (Object)request));
        }
        catch (IOException e) {
            this.log(202, FIRE_REQUEST_ERROR_MESSAGE, e);
            throw new ECFException("IOException sending fire request", (Throwable)e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendFireRequest", (Object)request);
        return request;
    }

    protected void handleFireRequest(Request request) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)FIRE_REQUEST, (Object[])new Object[]{request});
        if (request == null) {
            this.log(FIRE_REQUEST, new NullPointerException("Request cannot be null"));
            return;
        }
        ID responseTarget = request.getRequestContainerID();
        if (responseTarget == null) {
            this.log(FIRE_REQUEST, new NullPointerException("Response target cannot be null"));
            return;
        }
        RemoteServiceRegistrationImpl localRegistration = this.getLocalRegistrationForRequest(request);
        if (localRegistration == null) {
            this.sendErrorResponse(responseTarget, request.getRequestId(), FIRE_REQUEST, new NullPointerException("local service registration not found for remote request=" + request));
            return;
        }
        IExecutor executor = this.getRequestExecutor(request);
        if (executor == null) {
            this.sendErrorResponse(responseTarget, request.getRequestId(), FIRE_REQUEST, new NullPointerException("request executor is not available and so no requests can be processed"));
            return;
        }
        this.executeRequest(executor, request, responseTarget, localRegistration, false);
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)FIRE_REQUEST);
    }

    private void addTargetForUnregister(RemoteServiceRegistrationImpl serviceRegistration, ID targetContainerID) {
        ArrayList<ID> existingTargets = (ArrayList<ID>)this.localRegistryUnregistrationTargets.get(serviceRegistration);
        if (existingTargets == null) {
            existingTargets = new ArrayList<ID>();
        }
        existingTargets.add(targetContainerID);
        Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)("addTargetForUnregister localContainerID=" + this.getLocalContainerID() + ",targetContainerID=" + targetContainerID + ",serviceRegistration=" + serviceRegistration));
        this.localRegistryUnregistrationTargets.put(serviceRegistration, existingTargets);
    }

    private void sendUnregisterToTargets(RemoteServiceRegistrationImpl serviceRegistration, ID[] otherTargets) {
        List registeredTargets;
        ArrayList<ID> allTargets = new ArrayList<ID>();
        if (otherTargets != null) {
            allTargets.addAll(Arrays.asList(otherTargets));
        }
        if ((registeredTargets = (List)this.localRegistryUnregistrationTargets.remove(serviceRegistration)) != null) {
            allTargets.addAll(registeredTargets);
        }
        Iterator i = allTargets.iterator();
        while (i.hasNext()) {
            ID unregistrationTarget = (ID)i.next();
            ID registrationLocalContainerID = serviceRegistration.getContainerID();
            Long serviceId = new Long(serviceRegistration.getServiceId());
            Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)("sendUnregisterToTargets localContainerID=" + this.getLocalContainerID() + ",targetContainerID=" + unregistrationTarget + ",serviceRegistration=" + serviceRegistration));
            try {
                this.sendSharedObjectMsgTo(unregistrationTarget, SharedObjectMsg.createMsg((String)UNREGISTER, (Object[])new Object[]{registrationLocalContainerID, serviceId}));
            }
            catch (IOException e) {
                this.log(206, UNREGISTER_ERROR_MESSAGE, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendUnregister(RemoteServiceRegistrationImpl serviceRegistration) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"sendUnregister", (Object[])new Object[]{serviceRegistration});
        RemoteServiceRegistryImpl remoteServiceRegistryImpl = this.localRegistry;
        synchronized (remoteServiceRegistryImpl) {
            this.localRegistry.unpublishService(serviceRegistration);
            if (this.isConnected()) {
                ID containerID = serviceRegistration.getContainerID();
                Long serviceId = new Long(serviceRegistration.getServiceId());
                ID[] targetIds = this.getTargetsFromProperties(serviceRegistration.properties);
                if (targetIds == null) {
                    try {
                        this.sendSharedObjectMsgTo(null, SharedObjectMsg.createMsg((String)UNREGISTER, (Object[])new Object[]{containerID, serviceId}));
                    }
                    catch (IOException e) {
                        this.log(206, UNREGISTER_ERROR_MESSAGE, e);
                    }
                }
                this.sendUnregisterToTargets(serviceRegistration, targetIds);
            }
        }
        this.fireRemoteServiceListeners((IRemoteServiceEvent)this.createUnregisteredEvent(serviceRegistration));
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"sendUnregister");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUnregister(ID containerID, Long serviceId) {
        Trace.entering((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)UNREGISTER, (Object[])new Object[]{containerID, serviceId});
        RemoteServiceRegistrationImpl registration = null;
        Map map = this.remoteRegistrys;
        synchronized (map) {
            RemoteServiceRegistryImpl serviceRegistry = (RemoteServiceRegistryImpl)this.remoteRegistrys.get(containerID);
            if (serviceRegistry != null && (registration = serviceRegistry.findRegistrationForServiceId(serviceId)) != null) {
                serviceRegistry.unpublishService(registration);
                RemoteServiceRegistrationImpl[] registrations = serviceRegistry.getRegistrations();
                Trace.trace((String)"org.eclipse.ecf.provider.remoteservice", (String)("handleUnregister localContainerID=" + this.getLocalContainerID() + ",registrationRemoved=" + registration + ",containerID=" + containerID));
                if (registrations.length == 0) {
                    this.remoteRegistrys.remove(containerID);
                }
            }
        }
        if (registration != null) {
            this.fireRemoteServiceListeners((IRemoteServiceEvent)this.createUnregisteredEvent(registration));
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.remoteservice", (String)"org.eclipse.ecf.provider.remoteservice/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)UNREGISTER);
    }

    protected IRemoteServiceUnregisteredEvent createUnregisteredEvent(final RemoteServiceRegistrationImpl registration) {
        return new IRemoteServiceUnregisteredEvent(){

            public String[] getClazzes() {
                return registration.getClasses();
            }

            public ID getLocalContainerID() {
                return RegistrySharedObject.this.getLocalContainerID();
            }

            public ID getContainerID() {
                return registration.getContainerID();
            }

            public IRemoteServiceReference getReference() {
                return registration.getReference();
            }

            public String toString() {
                StringBuffer buf = new StringBuffer("RemoteServiceUnregisteredEvent[");
                buf.append("localContainerID=").append(this.getLocalContainerID());
                buf.append(";containerID=").append(registration.getContainerID());
                buf.append(";clazzes=").append(Arrays.asList(registration.getClasses()));
                buf.append(";reference=").append(registration.getReference()).append("]");
                return buf.toString();
            }
        };
    }

    protected IRemoteServiceRegisteredEvent createRegisteredEvent(final RemoteServiceRegistrationImpl registration) {
        return new IRemoteServiceRegisteredEvent(){

            public ID getLocalContainerID() {
                return RegistrySharedObject.this.getLocalContainerID();
            }

            public String[] getClazzes() {
                return registration.getClasses();
            }

            public ID getContainerID() {
                return registration.getContainerID();
            }

            public IRemoteServiceReference getReference() {
                return registration.getReference();
            }

            public String toString() {
                StringBuffer buf = new StringBuffer("RemoteServiceRegisteredEvent[");
                buf.append("localContainerID=").append(this.getLocalContainerID());
                buf.append(";containerID=").append(registration.getContainerID());
                buf.append(";clazzes=").append(Arrays.asList(registration.getClasses()));
                buf.append(";reference=").append(registration.getReference()).append("]");
                return buf.toString();
            }
        };
    }

    protected RemoteServiceRegistryImpl addRemoteRegistry(RemoteServiceRegistryImpl registry) {
        return this.remoteRegistrys.put(registry.getContainerID(), registry);
    }

    protected RemoteServiceRegistryImpl getRemoteRegistry(ID containerID) {
        return (RemoteServiceRegistryImpl)this.remoteRegistrys.get(containerID);
    }

    protected RemoteServiceRegistryImpl removeRemoteRegistry(ID containerID) {
        return (RemoteServiceRegistryImpl)this.remoteRegistrys.remove(containerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteServiceRegistrationImpl getLocalRegistrationForRequest(Request request) {
        RemoteServiceRegistryImpl remoteServiceRegistryImpl = this.localRegistry;
        synchronized (remoteServiceRegistryImpl) {
            return this.localRegistry.findRegistrationForServiceId(request.getServiceId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addRequest(Request request) {
        List list = this.requests;
        synchronized (list) {
            return this.requests.add(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Request getRequest(long requestId) {
        List list = this.requests;
        synchronized (list) {
            Iterator i = this.requests.iterator();
            while (i.hasNext()) {
                Request req = (Request)i.next();
                long reqId = req.getRequestId();
                if (reqId != requestId) continue;
                return req;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeRequest(Request request) {
        List list = this.requests;
        synchronized (list) {
            return this.requests.remove(request);
        }
    }

    protected void logException(int code, String message, Throwable e) {
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.remoteservice", code, message, e));
    }

    protected boolean handleSharedObjectMsg(SharedObjectMsg msg) {
        try {
            msg.invoke((Object)this);
            return true;
        }
        catch (Exception e) {
            this.logException(207, "Exception invoking shared object message=" + msg, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRemoteServiceCallPolicy getRemoteServiceCallPolicy() {
        Object object = this.remoteServiceCallPolicyLock;
        synchronized (object) {
            return this.remoteServiceCallPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRemoteServiceCallPolicy(IRemoteServiceCallPolicy policy) {
        Object object = this.remoteServiceCallPolicyLock;
        synchronized (object) {
            this.remoteServiceCallPolicy = policy;
            return true;
        }
    }
}

