/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.examples.internal.eventadmin.app;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.ecf.examples.internal.eventadmin.app.AbstractEventAdminApplication;
import org.eclipse.ecf.examples.internal.eventadmin.app.TestEventHandler;
import org.eclipse.ecf.examples.internal.eventadmin.app.TestSender;
import org.eclipse.equinox.app.IApplication;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class EventAdminClientApplication
extends AbstractEventAdminApplication {
    private static final String DEFAULT_CONTAINER_TYPE = "ecf.jms.activemq.tcp.client";
    private static final String DEFAULT_TOPIC = "defaultTopic";
    private static final String DEFAULT_CONTAINER_TARGET = "tcp://localhost:61616/exampleTopic";
    private TestSender testSender;
    private ServiceRegistration testEventHandlerRegistration;

    @Override
    protected Object run() {
        Properties props = new Properties();
        props.put("event.topics", DEFAULT_TOPIC);
        this.testEventHandlerRegistration = this.bundleContext.registerService(EventHandler.class.getName(), (Object)new TestEventHandler("Client"), (Dictionary)props);
        this.testSender = new TestSender((EventAdmin)this.eventAdminImpl, this.topics, this.container.getID().getName());
        new Thread(this.testSender).start();
        this.waitForDone();
        return IApplication.EXIT_OK;
    }

    @Override
    protected void shutdown() {
        if (this.testSender != null) {
            this.testSender.stop();
            this.testSender = null;
        }
        if (this.testEventHandlerRegistration != null) {
            this.testEventHandlerRegistration.unregister();
            this.testEventHandlerRegistration = null;
        }
        super.shutdown();
    }

    @Override
    protected String usageApplicationId() {
        return "org.eclipse.ecf.examples.eventadmin.app.EventAdminClient";
    }

    @Override
    protected String usageParameters() {
        StringBuffer buf = new StringBuffer("\n\t-containerType <default:ecf.jms.activemq.tcp.client>");
        buf.append("\n\t-targetId <default:tcp://localhost:61616/exampleTopic>");
        buf.append("\n\t-topic <default:defaultTopic>");
        return buf.toString();
    }

    @Override
    protected void processArgs(String[] args) {
        this.containerType = DEFAULT_CONTAINER_TYPE;
        this.containerId = null;
        this.targetId = DEFAULT_CONTAINER_TARGET;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-containerType")) {
                this.containerType = args[i + 1];
                ++i;
            } else if (args[i].equals("-targetId")) {
                this.targetId = args[i + 1];
                ++i;
            } else if (args[i].equals("-topic")) {
                this.topics = new String[]{args[i + 1]};
                ++i;
            }
            ++i;
        }
    }
}

