/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainer;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.core.util.ExtensionRegistryRunnable;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.internal.server.generic.Activator;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.generic.TCPServerSOContainer;
import org.eclipse.ecf.provider.generic.TCPServerSOContainerGroup;
import org.eclipse.ecf.server.generic.app.Connector;
import org.eclipse.ecf.server.generic.app.NamedGroup;
import org.eclipse.ecf.server.generic.app.ServerConfigParser;

public class ServerManager {
    private static final String ECF_NAMESPACE_JMDNS = "ecf.namespace.jmdns";
    private static final String GROUP_PROPERTY_NAME = "group";
    private static final String PWREQUIRED_PROPERTY_NAME = "pwrequired";
    private static final String PROTOCOL_PROPERTY_NAME = "protocol";
    private static final String SERVICE_TYPE = "ecfgeneric";
    static TCPServerSOContainerGroup[] serverGroups = null;
    static Map servers = new HashMap();
    public static final String EXTENSION_POINT_NAME = "configuration";
    public static final String EXTENSION_POINT = "org.eclipse.ecf.server.generic.configuration";
    public static final String CONFIGURATION_ELEMENT = "configuration";
    public static final String CONNECTOR_ELEMENT = "connector";
    public static final String GROUP_ELEMENT = "group";
    public static final String HOSTNAME_ATTR = "hostname";
    public static final String PORT_ATTR = "port";
    public static final String KEEPALIVE_ATTR = "keepAlive";
    public static final String NAME_ATTR = "name";
    public static final String DISCOVERY_ATTR = "discovery";

    public ServerManager() {
        SafeRunner.run((ISafeRunnable)new ExtensionRegistryRunnable(Activator.getDefault().getContext()){

            protected void runWithoutRegistry() throws Exception {
                ServerManager.this.createServersFromConfigurationFile(Activator.getDefault().getBundle().getEntry("server.xml").openStream());
            }

            protected void runWithRegistry(IExtensionRegistry registry) throws Exception {
                ServerManager.this.createServersFromExtensionRegistry(registry);
            }
        });
    }

    public synchronized ISharedObjectContainer getServer(ID id) {
        if (id == null) {
            return null;
        }
        return (ISharedObjectContainer)servers.get(id);
    }

    void createServersFromExtensionRegistry(IExtensionRegistry registry) throws Exception {
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String portString = element.getAttribute(PORT_ATTR);
            int port = TCPServerSOContainer.DEFAULT_PORT;
            if (portString != null) {
                port = Integer.parseInt(portString);
            }
            int keepAlive = TCPServerSOContainer.DEFAULT_KEEPALIVE;
            String keepAliveString = element.getAttribute(KEEPALIVE_ATTR);
            if (keepAliveString != null) {
                keepAlive = Integer.parseInt(keepAliveString);
            }
            boolean discovery = false;
            String discoveryString = element.getAttribute(DISCOVERY_ATTR);
            if (discoveryString != null) {
                discovery = Boolean.valueOf(discoveryString);
            }
            Connector connector = new Connector(null, element.getAttribute(HOSTNAME_ATTR), port, keepAlive, discovery);
            IConfigurationElement[] groupElements = element.getChildren("group");
            int j = 0;
            while (j < groupElements.length) {
                String groupName = groupElements[i].getAttribute(NAME_ATTR);
                if (groupName != null) {
                    connector.addGroup(new NamedGroup(groupName));
                }
                ++j;
            }
            connectors.add(connector);
            ++i;
        }
        this.createServersFromConnectorList(connectors);
    }

    protected boolean isActive() {
        return servers.size() > 0;
    }

    public synchronized void closeServers() {
        Iterator i = servers.keySet().iterator();
        while (i.hasNext()) {
            ID serverID = (ID)i.next();
            TCPServerSOContainer server = (TCPServerSOContainer)servers.get(serverID);
            if (server == null) continue;
            try {
                server.dispose();
            }
            catch (Exception e) {
                Activator.log("Exception disposing serverID=" + serverID, e);
            }
        }
        servers.clear();
        if (serverGroups != null) {
            int i2 = 0;
            while (i2 < serverGroups.length) {
                serverGroups[i2].takeOffTheAir();
                ++i2;
            }
            serverGroups = null;
        }
    }

    private synchronized void createServersFromConnectorList(List connectors) throws IDCreateException, IOException {
        serverGroups = new TCPServerSOContainerGroup[connectors.size()];
        int j = 0;
        Iterator i = connectors.iterator();
        while (i.hasNext()) {
            Connector connect = (Connector)i.next();
            ServerManager.serverGroups[j] = this.createServerGroup(connect);
            List groups = connect.getGroups();
            Iterator g = groups.iterator();
            while (g.hasNext()) {
                NamedGroup group = (NamedGroup)g.next();
                TCPServerSOContainer cont = this.createServerContainer(group.getIDForGroup(), serverGroups[j], group.getName(), connect.getTimeout());
                if (connect.shouldRegisterForDiscovery()) {
                    this.registerServerForDiscovery(group, false);
                }
                servers.put(cont.getID(), cont);
                String msg = "Starting server with id=" + cont.getID().getName();
                System.out.println(msg);
                Activator.log(msg);
            }
            serverGroups[j].putOnTheAir();
            ++j;
        }
    }

    void createServersFromConfigurationFile(InputStream ins) throws Exception {
        ServerConfigParser scp = new ServerConfigParser();
        List connectors = scp.load(ins);
        if (connectors != null) {
            this.createServersFromConnectorList(connectors);
        }
    }

    private TCPServerSOContainerGroup createServerGroup(Connector connector) {
        TCPServerSOContainerGroup group = new TCPServerSOContainerGroup(connector.getHostname(), connector.getPort());
        return group;
    }

    private TCPServerSOContainer createServerContainer(String id, TCPServerSOContainerGroup group, String path, int keepAlive) throws IDCreateException {
        ID newServerID = IDFactory.getDefault().createStringID(id);
        TCPServerSOContainer container = new TCPServerSOContainer((ISharedObjectContainerConfig)new SOContainerConfig(newServerID), group, path, keepAlive);
        IContainerManager containerManager = Activator.getDefault().getContainerManager();
        if (containerManager != null) {
            ContainerTypeDescription ctd = containerManager.getContainerFactory().getDescriptionByName("ecf.generic.server");
            containerManager.addContainer((IContainer)container, ctd);
        }
        return container;
    }

    private void registerServerForDiscovery(NamedGroup group, boolean pwrequired) {
        IDiscoveryAdvertiser discovery = Activator.getDefault().getDiscovery();
        if (discovery != null) {
            try {
                String rawGroupName = group.getRawName();
                Connector connector = group.getConnector();
                Properties props = new Properties();
                props.put(PROTOCOL_PROPERTY_NAME, "ecftcp");
                props.put(PWREQUIRED_PROPERTY_NAME, new Boolean(pwrequired).toString());
                props.put("group", rawGroupName);
                Namespace ns = IDFactory.getDefault().getNamespaceByName(ECF_NAMESPACE_JMDNS);
                IServiceTypeID serviceTypeID = ServiceIDFactory.getDefault().createServiceTypeID(ns, new String[]{SERVICE_TYPE}, IServiceTypeID.DEFAULT_PROTO);
                InetAddress host = InetAddress.getByName(connector.getHostname());
                URI uri = new URI("ecftcp", null, host.getHostAddress(), connector.getPort(), null, null, null);
                ServiceInfo svcInfo = new ServiceInfo(uri, rawGroupName, serviceTypeID, 0, 0, (IServiceProperties)new ServiceProperties(props));
                discovery.registerService((IServiceInfo)svcInfo);
            }
            catch (Exception e) {
                Activator.log("Discovery registration exception", e);
            }
        }
    }
}

