/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.wizards;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsWorkingCopy;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandlersManager;
import org.eclipse.php.internal.debug.ui.wizards.IDebuggerSettingsSection;
import org.eclipse.php.internal.debug.ui.wizards.Messages;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class XDebugDebuggerExeSettingsSection
implements IDebuggerSettingsSection {
    protected IDebuggerSettingsWorkingCopy settingsWorkingCopy;
    protected CompositeFragment compositeFragment;
    protected Composite settingsComposite;
    protected IStatus debuggerStatus;

    public XDebugDebuggerExeSettingsSection(CompositeFragment compositeFragment, Composite debuggerSettingsComposite, IDebuggerSettingsWorkingCopy settingsWorkingCopy) {
        this.settingsWorkingCopy = settingsWorkingCopy;
        this.compositeFragment = compositeFragment;
        this.settingsComposite = debuggerSettingsComposite;
        this.createContents();
    }

    @Override
    public boolean performOK() {
        DBGpProxyHandlersManager.INSTANCE.registerHandler(this.settingsWorkingCopy.getOwnerId());
        return true;
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public void validate() {
        String clientPort;
        this.compositeFragment.setMessage(this.compositeFragment.getDescription(), 0);
        if (this.debuggerStatus == null) {
            AbstractDebuggerConfiguration[] debuggers;
            this.debuggerStatus = Status.OK_STATUS;
            PHPexeItem phpExe = (PHPexeItem)this.compositeFragment.getData();
            AbstractDebuggerConfiguration[] abstractDebuggerConfigurationArray = debuggers = PHPDebuggersRegistry.getDebuggersConfigurations();
            int n = debuggers.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractDebuggerConfiguration debugger = abstractDebuggerConfigurationArray[n2];
                if (phpExe.getDebuggerID().equals(debugger.getDebuggerId())) {
                    this.debuggerStatus = debugger.validate(phpExe);
                }
                ++n2;
            }
        }
        if ((clientPort = this.settingsWorkingCopy.getAttribute("clientPort")) == null || clientPort.isEmpty()) {
            this.compositeFragment.setMessage(Messages.XDebugDebuggerSettingsSection_Client_port_is_missing, 3);
            return;
        }
        if (this.debuggerStatus.getSeverity() == 4) {
            this.compositeFragment.setMessage(this.debuggerStatus.getMessage(), 3);
            return;
        }
        if (this.debuggerStatus.getSeverity() == 2) {
            this.compositeFragment.setMessage(this.debuggerStatus.getMessage(), 2);
            return;
        }
        int port = Integer.valueOf(clientPort);
        if (!PHPLaunchUtilities.isPortAvailable((int)port) && !PHPLaunchUtilities.isDebugDaemonActive((int)port, (String)"org.eclipse.php.debug.core.xdebugDebugger")) {
            this.compositeFragment.setMessage(MessageFormat.format(Messages.DebuggerCommonSettingsSection_Port_is_already_in_use, clientPort), 2);
            return;
        }
        boolean isProxyEnabled = Boolean.valueOf(this.settingsWorkingCopy.getAttribute("proxyEnable"));
        if (isProxyEnabled) {
            String proxyIdeKey = this.settingsWorkingCopy.getAttribute("proxyIdeKey");
            if (proxyIdeKey == null || proxyIdeKey.isEmpty()) {
                this.compositeFragment.setMessage(Messages.XDebugDebuggerServerSettingsSection_IDE_key_is_missing, 3);
                return;
            }
            String proxyAddress = this.settingsWorkingCopy.getAttribute("proxyAddress");
            if (proxyAddress == null || proxyAddress.isEmpty()) {
                this.compositeFragment.setMessage(Messages.XDebugDebuggerServerSettingsSection_Proxy_address_is_missing, 3);
                return;
            }
        }
    }

    @Override
    public boolean canTest() {
        return false;
    }

    @Override
    public void performTest() {
    }

    protected void createContents() {
        Group connectionGroup = new Group(this.settingsComposite, 0);
        connectionGroup.setFont(this.compositeFragment.getFont());
        GridLayout cgLayout = new GridLayout(2, false);
        connectionGroup.setLayout((Layout)cgLayout);
        GridData cgGridData = new GridData(768);
        connectionGroup.setLayoutData((Object)cgGridData);
        connectionGroup.setText(Messages.XDebugDebuggerSettingsSection_Connection_settings);
        Label clientPortLabel = new Label((Composite)connectionGroup, 0);
        clientPortLabel.setText(Messages.XDebugDebuggerSettingsSection_Client_port);
        final Text clientPortText = new Text((Composite)connectionGroup, 2048);
        GridData cptLayoutData = new GridData(768);
        clientPortText.setLayoutData((Object)cptLayoutData);
        clientPortText.setText(this.settingsWorkingCopy.getAttribute("clientPort"));
        clientPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String port = clientPortText.getText();
                XDebugDebuggerExeSettingsSection.this.settingsWorkingCopy.setAttribute("clientPort", port);
                XDebugDebuggerExeSettingsSection.this.validate();
            }
        });
        Group advancedSubGroup = new Group((Composite)connectionGroup, 0);
        advancedSubGroup.setLayout((Layout)new GridLayout(2, false));
        GridData dbgpGridData = new GridData(768);
        dbgpGridData.horizontalSpan = 2;
        advancedSubGroup.setLayoutData((Object)dbgpGridData);
        advancedSubGroup.setText(Messages.XDebugDebuggerSettingsSection_Advanced_group);
        final Button enableProxy = new Button((Composite)advancedSubGroup, 32);
        GridData epGridData = new GridData(16384, 0x1000000, true, false);
        epGridData.horizontalSpan = 2;
        enableProxy.setLayoutData((Object)epGridData);
        enableProxy.setText(Messages.XDebugDebuggerSettingsSection_Enable_DBGp_proxy);
        Label proxyIdeKeyLabel = new Label((Composite)advancedSubGroup, 0);
        proxyIdeKeyLabel.setText(Messages.XDebugDebuggerSettingsSection_Proxy_ide_key);
        final Text proxyIdeKeyText = new Text((Composite)advancedSubGroup, 2048);
        GridData pikLayoutData = new GridData(768);
        proxyIdeKeyText.setLayoutData((Object)pikLayoutData);
        proxyIdeKeyText.setText(this.settingsWorkingCopy.getAttribute("proxyIdeKey"));
        proxyIdeKeyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String ideKey = proxyIdeKeyText.getText();
                XDebugDebuggerExeSettingsSection.this.settingsWorkingCopy.setAttribute("proxyIdeKey", ideKey);
                XDebugDebuggerExeSettingsSection.this.validate();
            }
        });
        Label proxyAddressLabel = new Label((Composite)advancedSubGroup, 0);
        proxyAddressLabel.setText(Messages.XDebugDebuggerSettingsSection_Proxy_address);
        final Text proxyAddressText = new Text((Composite)advancedSubGroup, 2048);
        GridData patLayoutData = new GridData(768);
        proxyAddressText.setLayoutData((Object)patLayoutData);
        proxyAddressText.setText(this.settingsWorkingCopy.getAttribute("proxyAddress"));
        proxyAddressText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String proxyAddress = proxyAddressText.getText();
                XDebugDebuggerExeSettingsSection.this.settingsWorkingCopy.setAttribute("proxyAddress", proxyAddress);
                XDebugDebuggerExeSettingsSection.this.validate();
            }
        });
        enableProxy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                proxyIdeKeyText.setEnabled(enableProxy.getSelection());
                proxyAddressText.setEnabled(enableProxy.getSelection());
                XDebugDebuggerExeSettingsSection.this.settingsWorkingCopy.setAttribute("proxyEnable", String.valueOf(enableProxy.getSelection()));
                XDebugDebuggerExeSettingsSection.this.validate();
            }
        });
        boolean isProxyEnabled = Boolean.valueOf(this.settingsWorkingCopy.getAttribute("proxyEnable"));
        enableProxy.setSelection(isProxyEnabled);
        proxyIdeKeyText.setEnabled(isProxyEnabled);
        proxyAddressText.setEnabled(isProxyEnabled);
    }
}

