/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.builder.jersey;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Configuration;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.mandas.docker.client.builder.BaseDockerClientBuilder;
import org.mandas.docker.client.builder.ProxyConfiguration;

public class JerseyDockerClientBuilder
extends BaseDockerClientBuilder<JerseyDockerClientBuilder> {
    private ClientConfig updateProxy(ClientConfig config) {
        ProxyConfiguration proxyConfiguration = this.proxyFromEnv();
        if (proxyConfiguration == null) {
            return config;
        }
        String proxyHost = proxyConfiguration.host();
        config.property("jersey.config.client.proxy.uri", (Object)((!proxyHost.startsWith("http") ? "http://" : "") + proxyHost + ":" + proxyConfiguration.port()));
        if (proxyConfiguration.username() != null) {
            config.property("jersey.config.client.proxy.username", (Object)proxyConfiguration.username());
        }
        if (proxyConfiguration.password() != null) {
            config.property("jersey.config.client.proxy.password", (Object)proxyConfiguration.password());
        }
        config.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
        return config;
    }

    @Override
    protected Client createClient() {
        Registry<ConnectionSocketFactory> schemeRegistry = this.getSchemeRegistry(this.uri, this.dockerCertificatesStore);
        HttpClientConnectionManager cm = this.getConnectionManager(this.uri, schemeRegistry, this.connectionPoolSize);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((int)this.connectTimeoutMillis).setConnectTimeout((int)this.connectTimeoutMillis).setSocketTimeout((int)this.readTimeoutMillis).build();
        ClientConfig config = new ClientConfig(new Class[]{JacksonFeature.class});
        if (this.useProxy) {
            config = this.updateProxy(config);
        }
        config.connectorProvider((ConnectorProvider)new ApacheConnectorProvider()).property("jersey.config.apache.client.connectionManager", (Object)cm).property("jersey.config.apache.client.connectionManagerShared", (Object)"true").property("jersey.config.apache.client.requestConfig", (Object)requestConfig);
        if (this.entityProcessing != null) {
            switch (this.entityProcessing) {
                case BUFFERED: {
                    config.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
                    break;
                }
                case CHUNKED: {
                    config.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.CHUNKED);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid entity processing mode " + this.entityProcessing);
                }
            }
        }
        return ClientBuilder.newBuilder().withConfig((Configuration)config).build();
    }
}

