/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.mapping.SynchronizationCompareAdapter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class ResourceModelPersistenceAdapter
extends SynchronizationCompareAdapter {
    private static final String RESOURCES = "resources";
    private static final String RESOURCE_PATH = "resourcePath";
    private static final String RESOURCE_TYPE = "resourceType";
    private static final String WORKING_SETS = "workingSets";
    private static final String WORKING_SET_NAME = "workingSetName";
    private static final String MODEL_PROVIDERS = "modelProviders";
    private static final String MODEL_PROVIDER_ID = "modelProviderId";

    @Override
    public void save(ResourceMapping[] mappings, IMemento memento) {
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            Object object = mapping.getModelObject();
            if (object instanceof IResource) {
                IResource resource = (IResource)object;
                child = memento.createChild(RESOURCES);
                child.putInteger(RESOURCE_TYPE, resource.getType());
                child.putString(RESOURCE_PATH, resource.getFullPath().toString());
            } else if (object instanceof IWorkingSet) {
                IWorkingSet ws = (IWorkingSet)object;
                child = memento.createChild(WORKING_SETS);
                child.putString(WORKING_SET_NAME, ws.getName());
            } else if (object instanceof ModelProvider) {
                ModelProvider provider = (ModelProvider)object;
                child = memento.createChild(MODEL_PROVIDERS);
                child.putString(MODEL_PROVIDER_ID, provider.getId());
            }
            ++n2;
        }
    }

    @Override
    public ResourceMapping[] restore(IMemento memento) {
        IMemento child;
        IMemento[] children = memento.getChildren(RESOURCES);
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        IMemento[] iMementoArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            child = iMementoArray[n2];
            Integer typeInt = child.getInteger(RESOURCE_TYPE);
            if (typeInt != null) {
                int type = typeInt;
                String pathString = child.getString(RESOURCE_PATH);
                if (pathString != null) {
                    ResourceMapping mapping;
                    IPath path = IPath.fromOSString((String)pathString);
                    IWorkspaceRoot resource = switch (type) {
                        case 8 -> ResourcesPlugin.getWorkspace().getRoot();
                        case 4 -> ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
                        case 1 -> ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                        case 2 -> ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                        default -> null;
                    };
                    if (resource != null && (mapping = Utils.getResourceMapping(resource)) != null) {
                        result.add(mapping);
                    }
                }
            }
            ++n2;
        }
        iMementoArray = children = memento.getChildren(WORKING_SETS);
        n = children.length;
        n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping;
            IWorkingSet set;
            child = iMementoArray[n2];
            String name = child.getString(WORKING_SET_NAME);
            if (name != null && (set = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(name)) != null && (mapping = Utils.getResourceMapping(set)) != null) {
                result.add(mapping);
            }
            ++n2;
        }
        iMementoArray = children = memento.getChildren(MODEL_PROVIDERS);
        n = children.length;
        n2 = 0;
        while (n2 < n) {
            IModelProviderDescriptor desc;
            child = iMementoArray[n2];
            String id = child.getString(MODEL_PROVIDER_ID);
            if (id != null && (desc = ModelProvider.getModelProviderDescriptor((String)id)) != null) {
                try {
                    ResourceMapping mapping;
                    ModelProvider provider = desc.getModelProvider();
                    if (provider != null && (mapping = Utils.getResourceMapping(provider)) != null) {
                        result.add(mapping);
                    }
                }
                catch (CoreException e) {
                    TeamUIPlugin.log(e);
                }
            }
            ++n2;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }
}

