/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.celleditor.action;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.papyrus.infra.nattable.celleditor.IActionCellEditor;
import org.eclipse.papyrus.infra.nattable.celleditor.action.ICellEditorButtonAction;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractCellEditorButtonAction
implements ICellEditorButtonAction {
    private String text;
    private String tooltipText;
    private Image image;
    protected Object originalCanonicalValue;
    protected Composite parent;
    protected IActionCellEditor initialCellEditor;
    protected ILayerCell cell;
    protected IConfigRegistry configRegistry;

    @Override
    public boolean configureAction(IActionCellEditor editor, Composite composite, Object originalCanonicalValue, ILayerCell cell, IConfigRegistry configRegistry) {
        this.initialCellEditor = editor;
        this.cell = cell;
        this.parent = composite;
        this.originalCanonicalValue = originalCanonicalValue;
        this.configRegistry = configRegistry;
        return this.isEnabled();
    }

    @Override
    public void setImage(Image image) {
        this.image = image;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void setTooltipText(String tooltipText) {
        this.tooltipText = tooltipText;
    }

    @Override
    public List<Control> createControl(Composite parent, int style) {
        Button button = new Button(parent, style);
        button.setText(this.getText());
        button.setToolTipText(this.getTooltipText());
        button.setImage(this.getImage());
        GridData buttonGridData = new GridData(131072, 4, false, true);
        button.setLayoutData((Object)buttonGridData);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCellEditorButtonAction.this.runAction(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return Collections.singletonList(button);
    }

    protected abstract int runAction(SelectionEvent var1);

    protected final String getText() {
        return this.text != null ? this.text : "";
    }

    protected final String getTooltipText() {
        return this.tooltipText != null ? this.tooltipText : "";
    }

    protected final Image getImage() {
        return this.image;
    }

    protected final INattableModelManager getNattableModelManager() {
        if (this.configRegistry != null) {
            return (INattableModelManager)this.configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        }
        return null;
    }

    protected final boolean isCellEditable() {
        INattableModelManager manager = this.getNattableModelManager();
        if (manager != null) {
            Object columnElement = manager.getColumnElement(this.getColumnIndex());
            Object rowElement = manager.getRowElement(this.getRowIndex());
            return CellManagerFactory.INSTANCE.isCellEditable(columnElement, rowElement, manager);
        }
        return false;
    }

    protected final Object getCurrentCellValue() {
        INattableModelManager manager = this.getNattableModelManager();
        if (manager != null) {
            return manager.getDataValue(this.getColumnIndex(), this.getRowIndex());
        }
        return null;
    }

    protected final int getRowIndex() {
        return this.cell.getRowIndex();
    }

    protected final int getColumnIndex() {
        return this.cell.getColumnIndex();
    }

    protected final TransactionalEditingDomain getEditingDomain() {
        INattableModelManager manager = this.getNattableModelManager();
        if (manager != null) {
            return TableEditingDomainUtils.getTableContextEditingDomain(manager.getTable());
        }
        return null;
    }

    protected final Object getColumnElement() {
        INattableModelManager manager = this.getNattableModelManager();
        if (manager != null) {
            return manager.getColumnElement(this.getColumnIndex());
        }
        return null;
    }

    protected final Object getRowElement() {
        INattableModelManager manager = this.getNattableModelManager();
        if (manager != null) {
            return manager.getRowElement(this.getRowIndex());
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.isCellEditable();
    }
}

