/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.core.internal;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.modisco.facet.efacet.core.internal.Activator;
import org.eclipse.modisco.facet.efacet.core.internal.incubatingapi.IFacetActions2;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.EFacetPackage;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.modisco.facet.util.core.Logger;
import org.eclipse.modisco.facet.util.emf.core.exception.InvalidFacetSetException;
import org.eclipse.modisco.facet.util.pde.core.internal.exported.BuildPropertiesUtils;

public class FacetActions2Impl
implements IFacetActions2 {
    @Override
    public void saveFacetSet(FacetSet facetSet, IFile file) throws IOException, InvalidFacetSetException {
        if (facetSet == null) {
            throw new IllegalArgumentException("The given FacetSet cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("The given IFile cannot be null");
        }
        if (file.exists()) {
            throw new IllegalArgumentException("The given IFile already exists");
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)facetSet);
        resource.save(null);
        try {
            BuildPropertiesUtils.addToBuild((IFile)file);
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (String)("Error adding file " + file.getFullPath() + " to the build.properties"), (Plugin)Activator.getDefault());
        }
    }

    @Override
    public Facet createFacetInFacetSet(FacetSet facetSet, Facet facet, EditingDomain editingDomain) {
        Command command = this.createCreateFacetInFacetSetCommand(facetSet, facet, editingDomain);
        if (!editingDomain.getResourceSet().getResources().contains((Object)facetSet.eResource())) {
            editingDomain.getResourceSet().getResources().add((Object)facetSet.eResource());
        }
        editingDomain.getCommandStack().execute(command);
        return facet;
    }

    @Override
    public Command createCreateFacetInFacetSetCommand(FacetSet facetSet, Facet facet, EditingDomain editingDomain) {
        if (facetSet == null) {
            throw new IllegalArgumentException("The given FacetSet cannot be null");
        }
        if (facet == null) {
            throw new IllegalArgumentException("The given Facet cannot be null");
        }
        if (facet.eResource() != null || facet.eContainer() != null) {
            throw new IllegalArgumentException("The given Facet cannot be contained by a resource");
        }
        if (editingDomain == null) {
            throw new IllegalArgumentException("The given EditingDomain cannot be null");
        }
        return AddCommand.create((EditingDomain)editingDomain, (Object)facetSet, (Object)EcorePackage.eINSTANCE.getEPackage_EClassifiers(), (Object)facet);
    }

    @Override
    public void addAttributeInFacet(Facet facet, FacetAttribute facetAttribute, EditingDomain editingDomain) {
        Command command = this.createAddAttributeInFacetCommand(facet, facetAttribute, editingDomain);
        editingDomain.getCommandStack().execute(command);
    }

    @Override
    public Command createAddAttributeInFacetCommand(Facet facet, FacetAttribute facetAttribute, EditingDomain editingDomain) {
        if (facet == null) {
            throw new IllegalArgumentException("The given Facet cannot be null");
        }
        if (facetAttribute == null) {
            throw new IllegalArgumentException("The given FacetAttribute cannot be null");
        }
        if (facetAttribute.eResource() != null || facetAttribute.eContainer() != null) {
            throw new IllegalArgumentException("The given FacetAttribute cannot be contained by a resource");
        }
        if (editingDomain == null) {
            throw new IllegalArgumentException("The given EditingDomain cannot be null");
        }
        return AddCommand.create((EditingDomain)editingDomain, (Object)facet, (Object)EFacetPackage.eINSTANCE.getFacet_FacetElements(), (Object)facetAttribute);
    }

    @Override
    public void addReferenceInFacet(Facet facet, FacetReference facetReference, EditingDomain editingDomain) {
        Command command = this.createAddReferenceInFacetCommand(facet, facetReference, editingDomain);
        editingDomain.getCommandStack().execute(command);
    }

    @Override
    public Command createAddReferenceInFacetCommand(Facet facet, FacetReference facetReference, EditingDomain editingDomain) {
        if (facet == null) {
            throw new IllegalArgumentException("The given Facet cannot be null.");
        }
        if (facetReference == null) {
            throw new IllegalArgumentException("The given FacetReference cannot be null");
        }
        if (facetReference.eResource() != null || facetReference.eContainer() != null) {
            throw new IllegalArgumentException("The given FacetReference cannot be contained by a resource");
        }
        if (editingDomain == null) {
            throw new IllegalArgumentException("The given EditingDomain cannot be null.");
        }
        return AddCommand.create((EditingDomain)editingDomain, (Object)facet, (Object)EFacetPackage.eINSTANCE.getFacet_FacetElements(), (Object)facetReference);
    }

    @Override
    public void addOperationInFacet(Facet facet, FacetOperation facetOperation, EditingDomain editingDomain) {
        Command command = this.createAddOperationInFacetCommand(facet, facetOperation, editingDomain);
        editingDomain.getCommandStack().execute(command);
    }

    @Override
    public Command createAddOperationInFacetCommand(Facet facet, FacetOperation facetOperation, EditingDomain editingDomain) {
        if (editingDomain == null) {
            throw new IllegalArgumentException("The given EditingDomain cannot be null");
        }
        if (facetOperation == null) {
            throw new IllegalArgumentException("The given FacetOperation cannot be null");
        }
        if (facetOperation.eResource() != null || facetOperation.eContainer() != null) {
            throw new IllegalArgumentException("The given FacetOperation cannot be contained by a resource");
        }
        if (facet == null) {
            throw new IllegalArgumentException("The given Facet cannot be null");
        }
        return AddCommand.create((EditingDomain)editingDomain, (Object)facet, (Object)EFacetPackage.eINSTANCE.getFacet_FacetOperations(), (Object)facetOperation);
    }

    @Override
    public void addParameterInOperation(FacetOperation operation, EParameter parameter, EditingDomain editingDomain) {
        Command command = this.createAddParameterInOperationCommand(operation, parameter, editingDomain);
        editingDomain.getCommandStack().execute(command);
    }

    @Override
    public Command createAddParameterInOperationCommand(FacetOperation operation, EParameter parameter, EditingDomain editingDomain) {
        if (operation == null) {
            throw new IllegalArgumentException("The given FacetOperation cannot be null");
        }
        if (parameter == null) {
            throw new IllegalArgumentException("The given EParameter cannot be null");
        }
        if (parameter.eResource() != null || parameter.eContainer() != null) {
            throw new IllegalArgumentException("The given EParameter cannot be contained by a resource");
        }
        if (editingDomain == null) {
            throw new IllegalArgumentException("The given EditingDomain cannot be null");
        }
        return AddCommand.create((EditingDomain)editingDomain, (Object)operation, (Object)EcorePackage.eINSTANCE.getEOperation_EParameters(), (Object)parameter);
    }

    @Override
    public void setFacetSetNsUri(FacetSet facetSet, String nsUri, EditingDomain editingDomain) {
        Command command = this.createSetFacetSetNsUriCommand(facetSet, nsUri, editingDomain);
        editingDomain.getCommandStack().execute(command);
    }

    @Override
    public Command createSetFacetSetNsUriCommand(FacetSet facetSet, String nsUri, EditingDomain editingDomain) {
        if (editingDomain == null) {
            throw new IllegalArgumentException("The given EditingDomain cannot be null");
        }
        if (facetSet == null) {
            throw new IllegalArgumentException("The given FacetSet cannot be null");
        }
        return SetCommand.create((EditingDomain)editingDomain, (Object)facetSet, (Object)EcorePackage.eINSTANCE.getEPackage_NsURI(), (Object)nsUri);
    }
}

