/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.dnd.FileTransferDropTargetListener;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetTransfer;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetTransferData;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetTransferDropTargetListener;
import org.eclipse.cdt.make.internal.ui.dnd.TextTransferDropTargetListener;
import org.eclipse.cdt.make.ui.TargetSourceContainer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public class PasteTargetAction
extends SelectionListenerAction {
    private final Shell shell;
    private final Clipboard clipboard;

    public PasteTargetAction(Shell shell, Clipboard clipboard) {
        super(MakeUIPlugin.getResourceString("PasteTargetAction.label"));
        this.shell = shell;
        this.clipboard = clipboard;
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setToolTipText(MakeUIPlugin.getResourceString("PasteTargetAction.tooltip"));
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        return this.determineDropContainer() != null;
    }

    public void run() {
        IContainer dropContainer = this.determineDropContainer();
        if (dropContainer == null) {
            return;
        }
        Object clipboardContent = this.clipboard.getContents((Transfer)MakeTargetTransfer.getInstance());
        if (clipboardContent instanceof MakeTargetTransferData) {
            MakeTargetTransferDropTargetListener.createTransferTargetsUI((MakeTargetTransferData)clipboardContent, dropContainer, 1, this.shell);
            return;
        }
        clipboardContent = this.clipboard.getContents((Transfer)FileTransfer.getInstance());
        if (clipboardContent instanceof String[]) {
            FileTransferDropTargetListener.createFileTargetsUI((String[])clipboardContent, dropContainer, 1, this.shell);
            return;
        }
        clipboardContent = this.clipboard.getContents((Transfer)TextTransfer.getInstance());
        if (clipboardContent instanceof String) {
            TextTransferDropTargetListener.createMultilineTargetsUI((String)clipboardContent, dropContainer, 1, this.shell);
            return;
        }
    }

    private IContainer determineDropContainer() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.size() == 0) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (first instanceof IContainer) {
            if (selection.size() == 1) {
                return (IContainer)first;
            }
            return null;
        }
        if (first instanceof IMakeTarget) {
            IContainer dropContainer = ((IMakeTarget)first).getContainer();
            for (Object item : selection.toList()) {
                if (item instanceof IMakeTarget && ((IMakeTarget)item).getContainer() == dropContainer) continue;
                return null;
            }
            return dropContainer;
        }
        if (first instanceof TargetSourceContainer) {
            return ((TargetSourceContainer)first).getContainer();
        }
        return null;
    }
}

