/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.safehtml.shared;

import com.google.gwt.safehtml.shared.HtmlSanitizer;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlString;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class SimpleHtmlSanitizer
implements HtmlSanitizer {
    private static final SimpleHtmlSanitizer INSTANCE = new SimpleHtmlSanitizer();
    private static final Set<String> TAG_WHITELIST = new HashSet<String>(Arrays.asList("b", "em", "i", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "ul", "ol", "li"));

    public static SimpleHtmlSanitizer getInstance() {
        return INSTANCE;
    }

    public static SafeHtml sanitizeHtml(String html) {
        if (html == null) {
            throw new NullPointerException("html is null");
        }
        return new SafeHtmlString(SimpleHtmlSanitizer.simpleSanitize(html));
    }

    private static String simpleSanitize(String text) {
        StringBuilder sanitized = new StringBuilder();
        boolean firstSegment = true;
        for (String segment : text.split("<", -1)) {
            if (firstSegment) {
                firstSegment = false;
                sanitized.append(SafeHtmlUtils.htmlEscapeAllowEntities(segment));
                continue;
            }
            int tagStart = 0;
            int tagEnd = segment.indexOf(62);
            String tag = null;
            boolean isValidTag = false;
            if (tagEnd > 0) {
                if (segment.charAt(0) == '/') {
                    tagStart = 1;
                }
                if (TAG_WHITELIST.contains(tag = segment.substring(tagStart, tagEnd))) {
                    isValidTag = true;
                }
            }
            if (isValidTag) {
                if (tagStart == 0) {
                    sanitized.append('<');
                } else {
                    sanitized.append("</");
                }
                sanitized.append(tag).append('>');
                sanitized.append(SafeHtmlUtils.htmlEscapeAllowEntities(segment.substring(tagEnd + 1)));
                continue;
            }
            sanitized.append("&lt;").append(SafeHtmlUtils.htmlEscapeAllowEntities(segment));
        }
        return sanitized.toString();
    }

    private SimpleHtmlSanitizer() {
    }

    public SafeHtml sanitize(String html) {
        return SimpleHtmlSanitizer.sanitizeHtml(html);
    }
}

