/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.resources.client.DataResource;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssCompilerException;
import com.google.gwt.resources.css.ast.CssDef;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssUrl;
import com.google.gwt.resources.css.ast.CssVisitor;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstitutionReplacer
extends CssVisitor {
    private final ResourceContext context;
    private final JClassType dataResourceType;
    private final TreeLogger logger;
    private final Map<String, CssDef> substitutions;

    public SubstitutionReplacer(TreeLogger logger, ResourceContext context, Map<String, CssDef> substitutions) {
        this.context = context;
        this.dataResourceType = context.getGeneratorContext().getTypeOracle().findType(DataResource.class.getCanonicalName());
        this.logger = logger;
        this.substitutions = substitutions;
    }

    @Override
    public void endVisit(CssProperty x, Context ctx) {
        if (x.getValues() == null) {
            return;
        }
        ArrayList<CssProperty.Value> values = new ArrayList<CssProperty.Value>(x.getValues().getValues());
        ListIterator<CssProperty.Value> i = values.listIterator();
        while (i.hasNext()) {
            String value;
            CssDef def;
            CssProperty.IdentValue v = ((CssProperty.Value)i.next()).isIdentValue();
            if (v == null || (def = this.substitutions.get(value = v.getIdent())) == null) continue;
            if (def instanceof CssUrl) {
                assert (def.getValues().size() == 1);
                assert (def.getValues().get(0).isDotPathValue() != null);
                CssProperty.DotPathValue functionName = def.getValues().get(0).isDotPathValue();
                try {
                    ResourceGeneratorUtil.getMethodByPath(this.context.getClientBundleType(), functionName.getParts(), (JType)this.dataResourceType);
                }
                catch (NotFoundException e) {
                    this.logger.log(TreeLogger.ERROR, e.getMessage());
                    throw new CssCompilerException("Cannot find data method");
                }
                String instance = "((" + DataResource.class.getName() + ")(" + this.context.getImplementationSimpleSourceName() + ".this." + functionName.getExpression() + "))";
                StringBuilder expression = new StringBuilder();
                expression.append("\"url('\" + ");
                expression.append(instance).append(".getUrl()");
                expression.append(" + \"')\"");
                i.set(new CssProperty.ExpressionValue(expression.toString()));
                continue;
            }
            i.remove();
            for (CssProperty.Value defValue : def.getValues()) {
                i.add(defValue);
            }
        }
        x.setValue(new CssProperty.ListValue(values));
    }
}

