/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.shared;

import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.regexp.shared.SplitResult;

public class BidiUtils {
    private static volatile String LTR_CHARS = "A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02b8\u0300-\u0590\u0800-\u1fff\u2c00-\ufb1c\ufdfe-\ufe6f\ufefd-\uffff";
    private static volatile String RTL_CHARS = "\u0591-\u07ff\ufb1d-\ufdfd\ufe70-\ufefc";
    private static final RegExp FIRST_STRONG_IS_LTR_RE = RegExp.compile("^[^" + RTL_CHARS + "]*[" + LTR_CHARS + ']');
    private static final RegExp FIRST_STRONG_IS_RTL_RE = RegExp.compile("^[^" + LTR_CHARS + "]*[" + RTL_CHARS + ']');
    private static final RegExp HAS_ANY_LTR_RE = RegExp.compile("[" + LTR_CHARS + ']');
    private static final RegExp HAS_ANY_RTL_RE = RegExp.compile("[" + RTL_CHARS + ']');
    private static final RegExp HAS_NUMERALS_RE = RegExp.compile("\\d");
    private static final RegExp SKIP_HTML_RE = RegExp.compile("<[^>]*>|&[^;]+;", "g");
    private static final BidiUtils INSTANCE = new BidiUtils();
    private static final RegExp IS_REQUIRED_LTR_RE = RegExp.compile("^http://.*");
    private static final RegExp LAST_STRONG_IS_LTR_RE = RegExp.compile("[" + LTR_CHARS + "][^" + RTL_CHARS + "]*$");
    private static final RegExp LAST_STRONG_IS_RTL_RE = RegExp.compile("[" + RTL_CHARS + "][^" + LTR_CHARS + "]*$");
    private static final float RTL_DETECTION_THRESHOLD = 0.4f;
    private static final RegExp WORD_SEPARATOR_RE = RegExp.compile("\\s+");

    public static BidiUtils get() {
        return INSTANCE;
    }

    private BidiUtils() {
    }

    public boolean endsWithLtr(String str) {
        return LAST_STRONG_IS_LTR_RE.test(str);
    }

    public boolean endsWithLtr(String str, boolean isHtml) {
        return this.endsWithLtr(this.stripHtmlIfNeeded(str, isHtml));
    }

    public boolean endsWithRtl(String str) {
        return LAST_STRONG_IS_RTL_RE.test(str);
    }

    public boolean endsWithRtl(String str, boolean isHtml) {
        return this.endsWithRtl(this.stripHtmlIfNeeded(str, isHtml));
    }

    public HasDirection.Direction estimateDirection(String str) {
        int rtlCount = 0;
        int total = 0;
        boolean hasWeaklyLtr = false;
        SplitResult tokens = WORD_SEPARATOR_RE.split(str);
        for (int i = 0; i < tokens.length(); ++i) {
            String token = tokens.get(i);
            if (this.startsWithRtl(token)) {
                ++rtlCount;
                ++total;
                continue;
            }
            if (IS_REQUIRED_LTR_RE.test(token)) {
                hasWeaklyLtr = true;
                continue;
            }
            if (this.hasAnyLtr(token)) {
                ++total;
                continue;
            }
            if (!HAS_NUMERALS_RE.test(token)) continue;
            hasWeaklyLtr = true;
        }
        return total == 0 ? (hasWeaklyLtr ? HasDirection.Direction.LTR : HasDirection.Direction.DEFAULT) : ((float)rtlCount / (float)total > 0.4f ? HasDirection.Direction.RTL : HasDirection.Direction.LTR);
    }

    public HasDirection.Direction estimateDirection(String str, boolean isHtml) {
        return this.estimateDirection(this.stripHtmlIfNeeded(str, isHtml));
    }

    public boolean hasAnyLtr(String str) {
        return HAS_ANY_LTR_RE.test(str);
    }

    public boolean hasAnyLtr(String str, boolean isHtml) {
        return this.hasAnyLtr(this.stripHtmlIfNeeded(str, isHtml));
    }

    public boolean hasAnyRtl(String str) {
        return HAS_ANY_RTL_RE.test(str);
    }

    public boolean hasAnyRtl(String str, boolean isHtml) {
        return this.hasAnyRtl(this.stripHtmlIfNeeded(str, isHtml));
    }

    public boolean startsWithLtr(String str) {
        return FIRST_STRONG_IS_LTR_RE.test(str);
    }

    public boolean startsWithLtr(String str, boolean isHtml) {
        return this.startsWithLtr(this.stripHtmlIfNeeded(str, isHtml));
    }

    public boolean startsWithRtl(String str) {
        return FIRST_STRONG_IS_RTL_RE.test(str);
    }

    public boolean startsWithRtl(String str, boolean isHtml) {
        return this.startsWithRtl(this.stripHtmlIfNeeded(str, isHtml));
    }

    String stripHtmlIfNeeded(String str, boolean isStripNeeded) {
        return isStripNeeded ? SKIP_HTML_RE.replace(str, " ") : str;
    }
}

