/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client.impl;

import com.google.gwt.core.client.JavaScriptObject;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantMap
extends AbstractMap<String, String> {
    private final String[] keys;
    private JavaScriptObject map;

    public ConstantMap(String[] keys, String[] values) {
        this.keys = keys;
        this.init();
        for (int i = 0; i < keys.length; ++i) {
            assert (keys[i] != null);
            assert (values[i] != null);
            this.putImpl(keys[i], values[i]);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new AbstractSet<Map.Entry<String, String>>(){

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry other = (Map.Entry)o;
                String value = ConstantMap.this.get(other.getKey());
                return value != null && value.equals(other.getValue());
            }

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return new Iterator<Map.Entry<String, String>>(){
                    private int next = 0;

                    @Override
                    public boolean hasNext() {
                        return this.next < ConstantMap.this.size();
                    }

                    @Override
                    public Map.Entry<String, String> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        String key = ConstantMap.this.keys[this.next++];
                        return new EntryImpl(key, ConstantMap.this.get(key));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ConstantMap.this.size();
            }
        };
    }

    @Override
    public String get(Object key) {
        return key instanceof String ? this.get((String)key) : null;
    }

    public native String get(String var1);

    @Override
    public Set<String> keySet() {
        return new AbstractSet<String>(){

            @Override
            public boolean contains(Object o) {
                return ConstantMap.this.containsKey(o);
            }

            @Override
            public Iterator<String> iterator() {
                return Arrays.asList(ConstantMap.this.keys).iterator();
            }

            @Override
            public int size() {
                return ConstantMap.this.size();
            }
        };
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    protected void init() {
        this.map = JavaScriptObject.createObject();
    }

    protected native void putImpl(String var1, String var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntryImpl
    implements Map.Entry<String, String> {
        private final String key;
        private final String value;

        private EntryImpl(String key, String value) {
            assert (key != null);
            assert (value != null);
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            Map.Entry other;
            return o instanceof Map.Entry && this.key.equals((other = (Map.Entry)o).getKey()) && this.value.equals(other.getValue());
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            int keyHash = 0;
            int valueHash = 0;
            if (this.getKey() != null) {
                keyHash = this.getKey().hashCode();
            }
            if (this.getValue() != null) {
                valueHash = this.getValue().hashCode();
            }
            return keyHash ^ valueHash;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

