/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBundleClasspathResolver;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PDEManager;
import org.eclipse.pde.internal.core.TargetWeaver;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.project.PDEProject;

public class ClasspathHelper {
    private static final String DOT = ".";
    private static final String FRAGMENT_ANNOTATION = "@fragment@";
    private static final String DEV_CLASSPATH_ENTRY_SEPARATOR = ",";
    private static final String DEV_CLASSPATH_VERSION_SEPARATOR = ";";
    private static final Pattern BIN_EXCLUDES_SEPARATOR = Pattern.compile(",");

    private ClasspathHelper() {
    }

    public static String getDevEntriesProperties(String fileName, boolean checkExcluded) throws CoreException {
        IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
        Map<String, List<IPluginModelBase>> bundleModels = Arrays.stream(models).filter(o -> o.toString() != null).collect(Collectors.groupingBy(m -> m.getPluginBase().getId()));
        Properties properties = ClasspathHelper.getDevEntriesProperties(bundleModels, checkExcluded);
        return ClasspathHelper.writeDevEntries(fileName, properties);
    }

    public static String getDevEntriesProperties(String fileName, Map<String, List<IPluginModelBase>> map) throws CoreException {
        Properties properties = ClasspathHelper.getDevEntriesProperties(map, true);
        return ClasspathHelper.writeDevEntries(fileName, properties);
    }

    public static String writeDevEntries(String fileName, Properties properties) throws CoreException {
        Serializable directory;
        File file = new File(fileName);
        if (!(file.exists() || (directory = file.getParentFile()) == null || ((File)directory).exists() && !((File)directory).isFile())) {
            ((File)directory).mkdirs();
        }
        try {
            directory = null;
            Object var4_6 = null;
            try (FileOutputStream stream = new FileOutputStream(fileName);){
                properties.store(stream, "");
                return new URL("file:" + fileName).toString();
            }
            catch (Throwable throwable) {
                if (directory == null) {
                    directory = throwable;
                } else if (directory != throwable) {
                    ((Throwable)directory).addSuppressed(throwable);
                }
                throw directory;
            }
        }
        catch (IOException e) {
            PDECore.logException(e);
            throw new CoreException(Status.error((String)"Failed to create dev.properties file", (Throwable)e));
        }
    }

    public static Properties getDevEntriesProperties(Map<String, List<IPluginModelBase>> bundlesMap, boolean checkExcluded) {
        Set launchedPlugins = bundlesMap.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashMap<IPluginModelBase, String> modelEntries = new LinkedHashMap<IPluginModelBase, String>();
        TargetWeaver.weaveRunningPlatformDevProperties(modelEntries, launchedPlugins);
        for (List<IPluginModelBase> models : bundlesMap.values()) {
            for (IPluginModelBase model : models) {
                String entry;
                if (model.getUnderlyingResource() == null || (entry = ClasspathHelper.formatEntry(ClasspathHelper.getDevPaths(model, checkExcluded, launchedPlugins))).isEmpty()) continue;
                modelEntries.put(model, entry);
            }
            if (!models.stream().anyMatch(modelEntries::containsKey)) continue;
            for (IPluginModelBase model : models) {
                modelEntries.putIfAbsent(model, "");
            }
        }
        Properties properties = new Properties();
        modelEntries.forEach((m, cp) -> ClasspathHelper.addDevClasspath(m.getPluginBase(), properties, cp, false));
        properties.put("@ignoredot@", "true");
        return properties;
    }

    private static String formatEntry(Collection<IPath> paths) {
        return paths.stream().map(IPath::toString).collect(Collectors.joining(DEV_CLASSPATH_ENTRY_SEPARATOR));
    }

    public static void addDevClasspath(IPluginBase model, Properties devProperties, String devCP, boolean append) {
        String id = model.getId();
        if (!devCP.isEmpty()) {
            ClasspathHelper.addDevCPEntry(id, devCP, devProperties, append);
        }
        ClasspathHelper.addDevCPEntry(id + DEV_CLASSPATH_VERSION_SEPARATOR + model.getVersion(), devCP, devProperties, append);
    }

    private static void addDevCPEntry(String id, String devCP, Properties devProperties, boolean append) {
        if (append) {
            devProperties.merge(id, devCP, (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(vOld, vNew) -> String.valueOf(vOld) + DEV_CLASSPATH_ENTRY_SEPARATOR + String.valueOf(vNew)));
        } else {
            devProperties.put(id, devCP);
        }
    }

    public static String getDevClasspath(Properties devProperties, String id, String version) {
        Object cp = devProperties.get(id + DEV_CLASSPATH_VERSION_SEPARATOR + version);
        return (String)(cp != null ? cp : devProperties.get(id));
    }

    private static Map<IPath, List<IPath>> getClasspathMap(IProject project, boolean checkExcluded, boolean absolutePaths) throws JavaModelException {
        IBundleClasspathResolver[] resolvers;
        IClasspathEntry[] entries;
        Set<IPath> excluded = ClasspathHelper.getFoldersToExclude(project, checkExcluded);
        IJavaProject jProject = JavaCore.create((IProject)project);
        LinkedHashMap<IPath, List<IPath>> map = new LinkedHashMap<IPath, List<IPath>>();
        IClasspathEntry[] iClasspathEntryArray = entries = jProject.getRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                IPath source;
                IPath output;
                block10: {
                    block8: {
                        IResource file;
                        block9: {
                            IClasspathEntry entry = iClasspathEntryArray[n2];
                            output = null;
                            source = null;
                            if (entry.getEntryKind() == 3) {
                                source = entry.getPath();
                                output = entry.getOutputLocation();
                                if (output == null) {
                                    output = jProject.getOutputLocation();
                                }
                            } else if (entry.getEntryKind() == 1) {
                                source = entry.getPath();
                                output = entry.getPath();
                                if (source.segmentCount() == 1) {
                                    source = IPath.fromOSString((String)DOT);
                                }
                            }
                            if (output == null || excluded.contains(output) || (file = project.findMember(output.removeFirstSegments(1))) == null) break block7;
                            boolean isLinked = file.isLinked(512);
                            if (!isLinked && !absolutePaths) break block8;
                            IPath location = file.getLocation();
                            if (location == null) break block9;
                            output = location.makeAbsolute();
                            break block10;
                        }
                        PDECore.log(Status.error((String)NLS.bind((String)PDECoreMessages.ClasspathHelper_BadFileLocation, (Object)file.getFullPath())));
                        break block7;
                    }
                    output = output.makeRelative();
                }
                map.computeIfAbsent(source, s -> new ArrayList()).add(output);
            }
            ++n2;
        }
        IBundleClasspathResolver[] iBundleClasspathResolverArray = resolvers = PDECore.getDefault().getClasspathContainerResolverManager().getBundleClasspathResolvers(project);
        int n3 = resolvers.length;
        n = 0;
        while (n < n3) {
            IBundleClasspathResolver resolver = iBundleClasspathResolverArray[n];
            Map<IPath, Collection<IPath>> resolved = resolver.getAdditionalClasspathEntries(jProject);
            resolved.forEach((ceSource, value) -> {
                List mapValue = map.computeIfAbsent((IPath)ceSource, s -> new ArrayList());
                mapValue.addAll(value);
            });
            ++n;
        }
        return map;
    }

    private static List<IPath> findLibrary(String libName, IProject project, Map<IPath, List<IPath>> classpathMap, IBuild build) {
        IResource res;
        IBuildEntry entry;
        ArrayList<IPath> paths = new ArrayList<IPath>();
        IBuildEntry iBuildEntry = entry = build != null ? build.getEntry("source." + libName) : null;
        if (entry != null) {
            String[] resources;
            String[] stringArray = resources = entry.getTokens();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                String resource = stringArray[n2];
                IResource res2 = project.findMember(resource);
                if (res2 != null) {
                    List list = classpathMap.getOrDefault(res2.getFullPath(), Collections.emptyList());
                    paths.addAll(list);
                }
                ++n2;
            }
        }
        IPath path = null;
        path = libName.equals(DOT) ? IPath.fromOSString((String)DOT) : ((res = project.findMember(libName)) != null ? res.getFullPath() : IPath.fromOSString((String)libName));
        List list = classpathMap.getOrDefault(path, Collections.emptyList());
        paths.addAll(list);
        return paths;
    }

    private static Set<IPath> getDevPaths(IPluginModelBase model, boolean checkExcluded, Set<IPluginModelBase> plugins) {
        IProject project = model.getUnderlyingResource().getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                Map<IPath, List<IPath>> classpathMap = ClasspathHelper.getClasspathMap(project, checkExcluded, false);
                IBuild build = ClasspathHelper.getBuild(project);
                LinkedHashSet<IPath> result = new LinkedHashSet<IPath>();
                if (build != null && build.getEntry("custom") == null) {
                    IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
                    if (libraries.length == 0) {
                        List<IPath> paths = ClasspathHelper.findLibrary(DOT, project, classpathMap, build);
                        if (paths.isEmpty() && !classpathMap.isEmpty()) {
                            paths = new ArrayList<IPath>();
                            classpathMap.values().forEach(paths::addAll);
                        }
                        ClasspathHelper.addPaths(paths, project, result);
                    } else {
                        int i = 0;
                        while (i < libraries.length) {
                            List<IPath> paths = ClasspathHelper.findLibrary(libraries[i].getName(), project, classpathMap, build);
                            if (paths.isEmpty() && !libraries[i].getName().equals(DOT)) {
                                paths = ClasspathHelper.findLibraryFromFragments(libraries[i].getName(), model, checkExcluded, plugins);
                            }
                            ClasspathHelper.addPaths(paths, project, result);
                            ++i;
                        }
                    }
                    return result;
                }
                classpathMap.values().forEach(l -> ClasspathHelper.addPaths(l, project, result));
                return result;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    private static void addPaths(List<IPath> paths, IProject project, Set<IPath> result) {
        for (IPath path : paths) {
            IPath resultPath = ClasspathHelper.resolvePath(project, path);
            if (resultPath == null) continue;
            result.add(resultPath);
        }
    }

    private static List<IPath> findLibraryFromFragments(String libName, IPluginModelBase model, boolean checkExcluded, Set<IPluginModelBase> plugins) {
        IFragmentModel[] frags = PDEManager.findFragmentsFor(model);
        int i = 0;
        while (i < frags.length) {
            if (plugins.contains(frags[i])) {
                if (frags[i].getUnderlyingResource() != null) {
                    try {
                        IProject project = frags[i].getUnderlyingResource().getProject();
                        Map<IPath, List<IPath>> classpathMap = ClasspathHelper.getClasspathMap(project, checkExcluded, true);
                        IBuild build = ClasspathHelper.getBuild(project);
                        List<IPath> paths = ClasspathHelper.findLibrary(libName, project, classpathMap, build);
                        if (!paths.isEmpty()) {
                            return ClasspathHelper.postfixFragmentAnnotation(paths);
                        }
                    }
                    catch (JavaModelException project) {}
                } else {
                    File file = new File(frags[i].getInstallLocation());
                    if (file.isDirectory() && (file = new File(file, libName)).exists()) {
                        return List.of(IPath.fromOSString((String)(file.getPath() + FRAGMENT_ANNOTATION)));
                    }
                }
            }
            ++i;
        }
        return Collections.emptyList();
    }

    private static IBuild getBuild(IProject project) {
        IFile file = PDEProject.getBuildProperties(project);
        IPath location = file.getLocation();
        boolean existsOnFileSystem = location != null && location.toFile().exists();
        return existsOnFileSystem ? new WorkspaceBuildModel(file).getBuild() : null;
    }

    private static List<IPath> postfixFragmentAnnotation(List<IPath> paths) {
        return paths.stream().map(p -> IPath.fromOSString((String)(String.valueOf(p) + FRAGMENT_ANNOTATION))).collect(Collectors.toList());
    }

    private static IPath resolvePath(IProject project, IPath path) {
        if (path.isAbsolute()) {
            return path;
        }
        if (path.segmentCount() > 0 && path.segment(0).equals(project.getName())) {
            IContainer bundleRoot = PDEProject.getBundleRoot(project);
            IPath rootPath = bundleRoot.getFullPath();
            if ((path = path.makeRelativeTo(rootPath)).segmentCount() == 0) {
                return IPath.fromOSString((String)DOT);
            }
            if (bundleRoot.findMember(path) != null) {
                return path;
            }
        }
        return null;
    }

    private static Set<IPath> getFoldersToExclude(IProject project, boolean checkExcluded) {
        String binExcludes;
        IEclipsePreferences pref;
        if (checkExcluded && (pref = new ProjectScope(project).getNode("org.eclipse.pde.core")) != null && !(binExcludes = pref.get("selfhosting.binExcludes", "")).isBlank()) {
            Stream<String> elements = BIN_EXCLUDES_SEPARATOR.splitAsStream(binExcludes);
            return elements.map(String::trim).map(IPath::fromOSString).collect(Collectors.toUnmodifiableSet());
        }
        return Collections.emptySet();
    }
}

