/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.ui.viewers;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.ws.internal.cxf.ui.CXFUIPlugin;

public class JavaViewerFilter
extends ViewerFilter {
    private IJavaProject javaProject;
    private int elementKinds;

    public JavaViewerFilter(IJavaProject javaProject, int elementKinds) {
        this.javaProject = javaProject;
        this.elementKinds = elementKinds;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        try {
            if (element instanceof IJavaProject) {
                return this.javaProject.equals((IJavaProject)element);
            }
            if (element instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)element;
                return packageFragmentRoot.getKind() == 1;
            }
            if (element instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)element;
                return packageFragment.hasChildren();
            }
            if (element instanceof ICompilationUnit) {
                ICompilationUnit compilationUnit = (ICompilationUnit)element;
                IType type = compilationUnit.findPrimaryType();
                switch (this.elementKinds) {
                    case 5: {
                        return type.isClass();
                    }
                    case 6: {
                        return type.isInterface() && !type.isAnnotation();
                    }
                    case 10: {
                        return type.isClass() || type.isInterface() && !type.isAnnotation();
                    }
                }
            }
        }
        catch (JavaModelException jme) {
            CXFUIPlugin.log(jme.getStatus());
        }
        return false;
    }
}

