/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.bindings;

import java.util.Arrays;
import org.eclipse.jpt.common.ui.internal.swt.bindings.BooleanButtonModelBinding;
import org.eclipse.jpt.common.ui.internal.swt.bindings.BooleanControlStateModelBinding;
import org.eclipse.jpt.common.ui.internal.swt.bindings.ButtonLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bindings.CLabelLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bindings.CaretLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bindings.ComboBoxListWidgetAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bindings.CompositeBooleanControlStateModelBinding;
import org.eclipse.jpt.common.ui.internal.swt.bindings.DropDownListBoxListWidgetAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bindings.FormLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bindings.GroupLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bindings.HyperlinkLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bindings.ImageHyperlinkLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bindings.ItemLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bindings.LabelLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bindings.LabelModelBinding;
import org.eclipse.jpt.common.ui.internal.swt.bindings.LinkLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bindings.ListBoxListWidgetAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bindings.ListWidgetModelBinding;
import org.eclipse.jpt.common.ui.internal.swt.bindings.PageBookModelBinding;
import org.eclipse.jpt.common.ui.internal.swt.bindings.ScrolledFormLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bindings.ShellLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bindings.SimpleBooleanControlStateModelBinding;
import org.eclipse.jpt.common.ui.internal.swt.bindings.TextFieldModelBinding;
import org.eclipse.jpt.common.ui.internal.swt.bindings.WidgetLabelAdapter;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.value.ModifiablePropertyCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.NullPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.StaticCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;

public final class SWTBindingTools {
    private static final BooleanControlStateModelBinding.Adapter ENABLED_ADAPTER = new EnabledAdapter();
    private static final BooleanControlStateModelBinding.Adapter VISIBLE_ADAPTER = new VisibleAdapter();
    private static final BooleanControlStateModelBinding.Adapter<Section> EXPANDED_ADAPTER = new ExpandedAdapter();

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, Button button) {
        SWTBindingTools.bindImage(imageModel, new ButtonLabelAdapter(button));
    }

    public static void bindTextLabel(PropertyValueModel<String> textModel, Button button) {
        SWTBindingTools.bindText(textModel, new ButtonLabelAdapter(button));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, Button button) {
        SWTBindingTools.bind(imageModel, textModel, new ButtonLabelAdapter(button));
    }

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, CLabel label) {
        SWTBindingTools.bindImage(imageModel, new CLabelLabelAdapter(label));
    }

    public static void bindTextLabel(PropertyValueModel<String> textModel, CLabel label) {
        SWTBindingTools.bindText(textModel, new CLabelLabelAdapter(label));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, CLabel label) {
        SWTBindingTools.bind(imageModel, textModel, new CLabelLabelAdapter(label));
    }

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, Form form) {
        SWTBindingTools.bindImage(imageModel, new FormLabelAdapter(form));
    }

    public static void bindTextLabel(PropertyValueModel<String> textModel, Form form) {
        SWTBindingTools.bindText(textModel, new FormLabelAdapter(form));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, Form form) {
        SWTBindingTools.bind(imageModel, textModel, new FormLabelAdapter(form));
    }

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, ImageHyperlink hyperlink) {
        SWTBindingTools.bindImage(imageModel, new ImageHyperlinkLabelAdapter(hyperlink));
    }

    public static void bindTextLabel(PropertyValueModel<String> textModel, ImageHyperlink hyperlink) {
        SWTBindingTools.bindText(textModel, new ImageHyperlinkLabelAdapter(hyperlink));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, ImageHyperlink hyperlink) {
        SWTBindingTools.bind(imageModel, textModel, new ImageHyperlinkLabelAdapter(hyperlink));
    }

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, Label label) {
        SWTBindingTools.bindImage(imageModel, new LabelLabelAdapter(label));
    }

    public static void bindTextLabel(PropertyValueModel<String> textModel, Label label) {
        SWTBindingTools.bindText(textModel, new LabelLabelAdapter(label));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, Label label) {
        SWTBindingTools.bind(imageModel, textModel, new LabelLabelAdapter(label));
    }

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, ScrolledForm form) {
        SWTBindingTools.bindImage(imageModel, new ScrolledFormLabelAdapter(form));
    }

    public static void bindTextLabel(PropertyValueModel<String> textModel, ScrolledForm form) {
        SWTBindingTools.bindText(textModel, new ScrolledFormLabelAdapter(form));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, ScrolledForm form) {
        SWTBindingTools.bind(imageModel, textModel, new ScrolledFormLabelAdapter(form));
    }

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, Item item) {
        SWTBindingTools.bindImage(imageModel, new ItemLabelAdapter(item));
    }

    public static void bindTextLabel(PropertyValueModel<String> textModel, Item item) {
        SWTBindingTools.bindText(textModel, new ItemLabelAdapter(item));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, Item item) {
        SWTBindingTools.bind(imageModel, textModel, new ItemLabelAdapter(item));
    }

    public static void bindImageLabel(PropertyValueModel<Image> imageModel, Shell window) {
        SWTBindingTools.bindImage(imageModel, new ShellLabelAdapter(window));
    }

    public static void bindLabel(PropertyValueModel<String> textModel, Shell window) {
        SWTBindingTools.bindText(textModel, new ShellLabelAdapter(window));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, Shell window) {
        SWTBindingTools.bind(imageModel, textModel, new ShellLabelAdapter(window));
    }

    public static void bindLabel(PropertyValueModel<Image> imageModel, Caret caret) {
        SWTBindingTools.bindImage(imageModel, new CaretLabelAdapter(caret));
    }

    public static void bindLabel(PropertyValueModel<String> textModel, Group group) {
        SWTBindingTools.bindText(textModel, new GroupLabelAdapter(group));
    }

    public static void bindLabel(PropertyValueModel<String> textModel, Hyperlink hyperlink) {
        SWTBindingTools.bindText(textModel, new HyperlinkLabelAdapter(hyperlink));
    }

    public static void bindLabel(PropertyValueModel<String> textModel, Link link) {
        SWTBindingTools.bindText(textModel, new LinkLabelAdapter(link));
    }

    public static void bindImage(PropertyValueModel<Image> imageModel, WidgetLabelAdapter labelAdapter) {
        new LabelModelBinding(imageModel, (PropertyValueModel<String>)new NullPropertyValueModel(), labelAdapter);
    }

    public static void bindText(PropertyValueModel<String> textModel, WidgetLabelAdapter labelAdapter) {
        new LabelModelBinding((PropertyValueModel<Image>)new NullPropertyValueModel(), textModel, labelAdapter);
    }

    public static void bind(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, WidgetLabelAdapter labelAdapter) {
        new LabelModelBinding(imageModel, textModel, labelAdapter);
    }

    public static void bind(ModifiablePropertyValueModel<Boolean> booleanModel, Button button) {
        SWTBindingTools.bind(booleanModel, button, false);
    }

    public static void bind(ModifiablePropertyValueModel<Boolean> booleanModel, Button button, boolean defaultValue) {
        new BooleanButtonModelBinding(booleanModel, button, defaultValue);
    }

    public static <E> void bind(ModifiablePropertyValueModel<String> textModel, Text textField) {
        new TextFieldModelBinding(textModel, textField);
    }

    public static <E> void bind(ListValueModel<E> listModel, List listBox) {
        SWTBindingTools.bind(listModel, listBox, TransformerTools.objectToStringTransformer());
    }

    public static <E> void bind(ListValueModel<E> listModel, List listBox, Transformer<E, String> transformer) {
        SWTBindingTools.bind(listModel, new SimpleCollectionValueModel(), listBox, transformer);
    }

    public static <E> void bind(ListValueModel<E> listModel, ModifiablePropertyValueModel<E> selectedItemModel, List listBox) {
        SWTBindingTools.bind(listModel, selectedItemModel, listBox, TransformerTools.objectToStringTransformer());
    }

    public static <E> void bind(ListValueModel<E> listModel, ModifiablePropertyValueModel<E> selectedItemModel, List listBox, Transformer<E, String> transformer) {
        SWTBindingTools.checkForSingleSelectionStyle(listBox);
        SWTBindingTools.bind(listModel, new ModifiablePropertyCollectionValueModelAdapter(selectedItemModel), listBox, transformer);
    }

    public static <E> void bind(ListValueModel<E> listModel, ModifiableCollectionValueModel<E> selectedItemsModel, List listBox) {
        SWTBindingTools.bind(listModel, selectedItemsModel, listBox, TransformerTools.objectToStringTransformer());
    }

    public static <E> void bind(ListValueModel<E> listModel, ModifiableCollectionValueModel<E> selectedItemsModel, List listBox, Transformer<E, String> transformer) {
        SWTBindingTools.bind(listModel, selectedItemsModel, new ListBoxListWidgetAdapter(listBox), transformer);
    }

    private static void checkForSingleSelectionStyle(List listBox) {
        if (!BitTools.flagIsSet((int)listBox.getStyle(), (int)4)) {
            throw new IllegalStateException("list box must be single-selection: " + listBox);
        }
    }

    public static <E> void bindDropDownListBox(ListValueModel<E> listModel, ModifiablePropertyValueModel<E> selectedItemModel, Combo dropDownListBox) {
        SWTBindingTools.bindDropDownListBox(listModel, selectedItemModel, dropDownListBox, TransformerTools.objectToStringTransformer());
    }

    public static <E> void bindDropDownListBox(ListValueModel<E> listModel, ModifiablePropertyValueModel<E> selectedItemModel, Combo dropDownListBox, Transformer<E, String> transformer) {
        SWTBindingTools.checkForReadOnlyStyle((Widget)dropDownListBox);
        SWTBindingTools.bind(listModel, selectedItemModel, new DropDownListBoxListWidgetAdapter(dropDownListBox), transformer);
    }

    private static void checkForReadOnlyStyle(Widget comboBox) {
        if (!BitTools.flagIsSet((int)comboBox.getStyle(), (int)8)) {
            throw new IllegalStateException("combo-box must be read-only: " + comboBox);
        }
    }

    public static void bindComboBox(ListValueModel<String> listModel, ModifiablePropertyValueModel<String> valueModel, Combo comboBox) {
        SWTBindingTools.checkForReadWriteStyle((Widget)comboBox);
        SWTBindingTools.bind(listModel, valueModel, new ComboBoxListWidgetAdapter(comboBox), TransformerTools.passThruTransformer());
    }

    private static void checkForReadWriteStyle(Widget comboBox) {
        if (BitTools.flagIsSet((int)comboBox.getStyle(), (int)8)) {
            throw new IllegalStateException("combo-box must be read-write: " + comboBox);
        }
    }

    private static <E> void bind(ListValueModel<E> listModel, Object selectionModel, ListWidgetModelBinding.ListWidget<E> listWidget, Transformer<E, String> transformer) {
        new ListWidgetModelBinding<E>(listModel, selectionModel, listWidget, transformer);
    }

    public static void bind(PropertyValueModel<Control> controlModel, PageBook pageBook) {
        SWTBindingTools.bind(controlModel, pageBook, null);
    }

    public static void bind(PropertyValueModel<Control> controlModel, PageBook pageBook, Control defaultPage) {
        SWTBindingTools.bind(controlModel, TransformerTools.passThruTransformer(), pageBook, defaultPage);
    }

    public static <T> void bind(PropertyValueModel<T> valueModel, Transformer<? super T, Control> transformer, PageBook pageBook) {
        SWTBindingTools.bind(valueModel, transformer, pageBook, null);
    }

    public static <T> void bind(PropertyValueModel<T> valueModel, Transformer<? super T, Control> transformer, PageBook pageBook, Control defaultPage) {
        new PageBookModelBinding<T>(valueModel, transformer, pageBook, defaultPage);
    }

    public static void bindEnabledState(PropertyValueModel<Boolean> booleanModel, Control ... controls) {
        SWTBindingTools.bindEnabledState(booleanModel, controls, false);
    }

    public static void bindEnabledState(PropertyValueModel<Boolean> booleanModel, Control[] controls, boolean defaultValue) {
        switch (controls.length) {
            case 0: {
                throw new IllegalArgumentException("empty controls array: " + Arrays.toString(controls));
            }
            case 1: {
                SWTBindingTools.bindEnabledState(booleanModel, controls[0], defaultValue);
                break;
            }
            default: {
                SWTBindingTools.bindEnabledState(booleanModel, new StaticCollectionValueModel((Object[])controls), defaultValue);
            }
        }
    }

    public static void bindEnabledState(PropertyValueModel<Boolean> booleanModel, Iterable<? extends Control> controls) {
        SWTBindingTools.bindEnabledState(booleanModel, controls, false);
    }

    public static <C extends Control> void bindEnabledState(PropertyValueModel<Boolean> booleanModel, Iterable<C> controls, boolean defaultValue) {
        BooleanControlStateModelBinding.Adapter<C> adapter = SWTBindingTools.enabledAdapter();
        SWTBindingTools.bindState(booleanModel, controls, defaultValue, adapter);
    }

    public static void bindEnabledState(PropertyValueModel<Boolean> booleanModel, Control control, boolean defaultValue) {
        SWTBindingTools.bindState(booleanModel, control, defaultValue, SWTBindingTools.enabledAdapter());
    }

    private static <C extends Control> BooleanControlStateModelBinding.Adapter<C> enabledAdapter() {
        return ENABLED_ADAPTER;
    }

    public static void bindVisibleState(PropertyValueModel<Boolean> booleanModel, Control ... controls) {
        SWTBindingTools.bindVisibleState(booleanModel, controls, false);
    }

    public static void bindVisibleState(PropertyValueModel<Boolean> booleanModel, Control[] controls, boolean defaultValue) {
        switch (controls.length) {
            case 0: {
                throw new IllegalArgumentException("empty controls array: " + Arrays.toString(controls));
            }
            case 1: {
                SWTBindingTools.bindVisibleState(booleanModel, controls[0], defaultValue);
                break;
            }
            default: {
                SWTBindingTools.bindVisibleState(booleanModel, new StaticCollectionValueModel((Object[])controls), defaultValue);
            }
        }
    }

    public static void bindVisibleState(PropertyValueModel<Boolean> booleanModel, Iterable<? extends Control> controls) {
        SWTBindingTools.bindVisibleState(booleanModel, controls, false);
    }

    public static <C extends Control> void bindVisibleState(PropertyValueModel<Boolean> booleanModel, Iterable<C> controls, boolean defaultValue) {
        BooleanControlStateModelBinding.Adapter<C> adapter = SWTBindingTools.visibleAdapter();
        SWTBindingTools.bindState(booleanModel, controls, defaultValue, adapter);
    }

    public static void bindVisibleState(PropertyValueModel<Boolean> booleanModel, Control control, boolean defaultValue) {
        SWTBindingTools.bindState(booleanModel, control, defaultValue, SWTBindingTools.visibleAdapter());
    }

    private static <C extends Control> BooleanControlStateModelBinding.Adapter<C> visibleAdapter() {
        return VISIBLE_ADAPTER;
    }

    private static <C extends Control> void bindState(PropertyValueModel<Boolean> booleanModel, Iterable<C> controls, boolean defaultValue, BooleanControlStateModelBinding.Adapter<C> adapter) {
        new CompositeBooleanControlStateModelBinding<C>(booleanModel, controls, defaultValue, adapter);
    }

    private static <C extends Control> void bindState(PropertyValueModel<Boolean> booleanModel, C control, boolean defaultValue, BooleanControlStateModelBinding.Adapter<C> adapter) {
        new SimpleBooleanControlStateModelBinding<C>(booleanModel, control, defaultValue, adapter);
    }

    public static void bindExpandedState(PropertyValueModel<Boolean> booleanModel, Section section) {
        SWTBindingTools.bindExpandedState(booleanModel, section, false);
    }

    public static void bindExpandedState(PropertyValueModel<Boolean> booleanModel, Section section, boolean defaultValue) {
        SWTBindingTools.bindState(booleanModel, section, defaultValue, EXPANDED_ADAPTER);
    }

    private SWTBindingTools() {
        throw new UnsupportedOperationException();
    }

    static class EnabledAdapter<C extends Control>
    implements BooleanControlStateModelBinding.Adapter<C> {
        EnabledAdapter() {
        }

        @Override
        public void setState(Control control, boolean b) {
            control.setEnabled(b);
        }

        public String toString() {
            return ObjectTools.singletonToString((Object)this);
        }
    }

    static class ExpandedAdapter
    implements BooleanControlStateModelBinding.Adapter<Section> {
        ExpandedAdapter() {
        }

        @Override
        public void setState(Section section, boolean b) {
            section.setExpanded(b);
        }

        public String toString() {
            return ObjectTools.singletonToString((Object)this);
        }
    }

    static class VisibleAdapter<C extends Control>
    implements BooleanControlStateModelBinding.Adapter<C> {
        VisibleAdapter() {
        }

        @Override
        public void setState(C control, boolean b) {
            control.setVisible(b);
        }

        public String toString() {
            return ObjectTools.singletonToString((Object)this);
        }
    }
}

