/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ChangeMethodSignatureProposalCore;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public abstract class TypeMismatchBaseSubProcessor<T> {
    protected TypeMismatchBaseSubProcessor() {
    }

    public void collectTypeMismatchProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) throws CoreException {
        BodyDeclaration decl;
        boolean nullOrVoid;
        MethodInvocation methodInvoc;
        IMethodBinding methodBinding;
        Expression nodeToCast;
        String[] args = problem.getProblemArguments();
        if (args.length != 2) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        AST ast = astRoot.getAST();
        ASTNode selectedNode = problem.getCoveredNode(astRoot);
        if (!(selectedNode instanceof Expression)) {
            return;
        }
        Expression expression = (Expression)selectedNode;
        SimpleName receiverNode = null;
        ITypeBinding castTypeBinding = null;
        int parentNodeType = selectedNode.getParent().getNodeType();
        switch (parentNodeType) {
            case 7: {
                Assignment assign = (Assignment)selectedNode.getParent();
                Expression leftHandSide = assign.getLeftHandSide();
                if (selectedNode.equals((Object)leftHandSide)) {
                    nodeToCast = assign.getRightHandSide();
                }
                castTypeBinding = assign.getLeftHandSide().resolveTypeBinding();
                if (leftHandSide instanceof Name) {
                    Name name2 = (Name)leftHandSide;
                    receiverNode = name2;
                    break;
                }
                if (!(leftHandSide instanceof FieldAccess)) break;
                FieldAccess fieldAccess = (FieldAccess)leftHandSide;
                receiverNode = fieldAccess.getName();
                break;
            }
            case 59: {
                VariableDeclarationFragment frag = (VariableDeclarationFragment)selectedNode.getParent();
                if (!selectedNode.equals((Object)frag.getName()) && !selectedNode.equals((Object)frag.getInitializer())) break;
                nodeToCast = frag.getInitializer();
                castTypeBinding = ASTNodes.getType((VariableDeclaration)frag).resolveBinding();
                receiverNode = frag.getName();
                break;
            }
            case 80: {
                receiverNode = ((MemberValuePair)selectedNode.getParent()).getName();
                castTypeBinding = ASTResolving.guessBindingForReference((ASTNode)nodeToCast);
                break;
            }
            case 79: {
                receiverNode = ((SingleMemberAnnotation)selectedNode.getParent()).getTypeName();
                castTypeBinding = ASTResolving.guessBindingForReference((ASTNode)nodeToCast);
                break;
            }
            default: {
                castTypeBinding = ASTResolving.guessBindingForReference((ASTNode)nodeToCast);
            }
        }
        if (castTypeBinding == null) {
            return;
        }
        ITypeBinding currBinding = nodeToCast.resolveTypeBinding();
        if (currBinding == null && nodeToCast instanceof MethodInvocation && (methodBinding = (methodInvoc = (MethodInvocation)nodeToCast).resolveMethodBinding()) != null) {
            currBinding = methodBinding.getReturnType();
        }
        if (!(nodeToCast instanceof ArrayInitializer)) {
            ITypeBinding boxUnboxedTypeBinding;
            String castTypeName = castTypeBinding.getErasure().getQualifiedName();
            if ("java.util.Optional".equals(castTypeName) && ast.apiLevel() >= 8) {
                ITypeBinding nodeToCastTypeBinding = nodeToCast.resolveTypeBinding();
                String label0 = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changetooptionalempty_description, nodeToCast.toString());
                T prop1 = this.createOptionalProposal(label0, cu, nodeToCast, 8, 0);
                if (prop1 != null) {
                    proposals.add(prop1);
                }
                ITypeBinding[] typeArguments = castTypeBinding.getTypeArguments();
                boolean wrapAll = false;
                ITypeBinding[] iTypeBindingArray = typeArguments;
                int n = typeArguments.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding typeArgument = iTypeBindingArray[n2];
                    if (typeArgument.isCastCompatible(nodeToCastTypeBinding)) {
                        wrapAll = true;
                        break;
                    }
                    ++n2;
                }
                if (wrapAll) {
                    String label2;
                    T prop3;
                    String label1 = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changetooptionalof_description, nodeToCast.toString());
                    T prop2 = this.createOptionalProposal(label1, cu, nodeToCast, 9, 1);
                    if (prop2 != null) {
                        proposals.add(prop2);
                    }
                    if (!nodeToCastTypeBinding.isPrimitive() && (prop3 = this.createOptionalProposal(label2 = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changetooptionalofnullable_description, nodeToCast.toString()), cu, nodeToCast, 9, 2)) != null) {
                        proposals.add(prop3);
                    }
                }
            }
            ITypeBinding castFixType = null;
            if (currBinding == null || castTypeBinding.isCastCompatible(currBinding) || nodeToCast instanceof CastExpression) {
                castFixType = castTypeBinding;
            } else if (JavaModelUtil.is50OrHigher(cu.getJavaProject()) && (boxUnboxedTypeBinding = TypeMismatchBaseSubProcessor.boxOrUnboxPrimitives(castTypeBinding, currBinding, ast)) != castTypeBinding && boxUnboxedTypeBinding.isCastCompatible(currBinding)) {
                castFixType = boxUnboxedTypeBinding;
            }
            if (castFixType != null) {
                proposals.add(this.collectCastProposals(context, castFixType, nodeToCast, 7));
            }
        }
        boolean bl = nullOrVoid = currBinding == null || "void".equals(currBinding.getName());
        if (!nullOrVoid && TypeMismatchBaseSubProcessor.isTypeReturned(nodeToCast) && (decl = ASTResolving.findParentBodyDeclaration(selectedNode)) instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)decl;
            if ((currBinding = Bindings.normalizeTypeBinding(currBinding)) == null) {
                currBinding = ast.resolveWellKnownType("java.lang.Object");
            }
            if (currBinding.isWildcardType()) {
                currBinding = ASTResolving.normalizeWildcardType(currBinding, true, ast);
            }
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            String label = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changereturntype_description, BasicElementLabels.getJavaElementName(currBinding.getName()));
            T proposal = this.createChangeReturnTypeProposal(label, cu, rewrite, 6, currBinding, ast, astRoot, methodDeclaration, decl);
            proposals.add(proposal);
        }
        if (!nullOrVoid && receiverNode != null) {
            if ((currBinding = Bindings.normalizeTypeBinding(currBinding)) == null) {
                currBinding = ast.resolveWellKnownType("java.lang.Object");
            }
            if (currBinding.isWildcardType()) {
                currBinding = ASTResolving.normalizeWildcardType(currBinding, true, ast);
            }
            this.collectChangeSenderTypeProposals(context, (Expression)receiverNode, currBinding, true, 6, proposals);
        }
        this.collectChangeSenderTypeProposals(context, nodeToCast, castTypeBinding, false, 5, proposals);
        if (castTypeBinding == ast.resolveWellKnownType("boolean") && currBinding != null && !currBinding.isPrimitive() && !Bindings.isVoidType(currBinding)) {
            String label = CorrectionMessages.TypeMismatchSubProcessor_insertnullcheck_description;
            ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
            InfixExpression expression2 = ast.newInfixExpression();
            expression2.setLeftOperand((Expression)rewrite.createMoveTarget((ASTNode)nodeToCast));
            expression2.setRightOperand((Expression)ast.newNullLiteral());
            expression2.setOperator(InfixExpression.Operator.NOT_EQUALS);
            rewrite.replace((ASTNode)nodeToCast, (ASTNode)expression2, null);
            T prop = this.createInsertNullCheckProposal(label, context.getCompilationUnit(), rewrite, 2);
            if (prop != null) {
                proposals.add(prop);
            }
        }
    }

    private static boolean isTypeReturned(Expression nodeToCast) {
        int parentNodeType = nodeToCast.getParent().getNodeType();
        if (parentNodeType == 41) {
            return true;
        }
        if (parentNodeType == 36 || parentNodeType == 16 && (nodeToCast.getLocationInParent() == ConditionalExpression.THEN_EXPRESSION_PROPERTY || nodeToCast.getLocationInParent() == ConditionalExpression.ELSE_EXPRESSION_PROPERTY)) {
            return TypeMismatchBaseSubProcessor.isTypeReturned((Expression)nodeToCast.getParent());
        }
        return false;
    }

    public static ITypeBinding boxOrUnboxPrimitives(ITypeBinding castType, ITypeBinding toCast, AST ast) {
        if (castType.isPrimitive() && !toCast.isPrimitive()) {
            return Bindings.getBoxedTypeBinding(castType, ast);
        }
        if (!castType.isPrimitive() && toCast.isPrimitive()) {
            return Bindings.getUnboxedTypeBinding(castType, ast);
        }
        return castType;
    }

    public void collectChangeSenderTypeProposals(IInvocationContext context, Expression nodeToCast, ITypeBinding castTypeBinding, boolean isAssignedNode, int relevance, Collection<T> proposals) throws JavaModelException {
        T p;
        IBinding callerBinding = Bindings.resolveExpressionBinding(nodeToCast, false);
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ICompilationUnit targetCu = null;
        ITypeBinding declaringType = null;
        IBinding callerBindingDecl = callerBinding;
        if (callerBinding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)callerBinding;
            if (variableBinding.isEnumConstant()) {
                return;
            }
            if (!variableBinding.isField()) {
                targetCu = cu;
            } else {
                callerBindingDecl = variableBinding.getVariableDeclaration();
                ITypeBinding declaringClass = variableBinding.getDeclaringClass();
                if (declaringClass == null) {
                    return;
                }
                declaringType = declaringClass.getTypeDeclaration();
            }
        } else if (callerBinding instanceof IMethodBinding) {
            IMethodBinding methodBinding = (IMethodBinding)callerBinding;
            if (!methodBinding.isConstructor()) {
                declaringType = methodBinding.getDeclaringClass().getTypeDeclaration();
                callerBindingDecl = methodBinding.getMethodDeclaration();
            }
        } else if (callerBinding instanceof ITypeBinding) {
            ITypeBinding typeBinding2 = (ITypeBinding)callerBinding;
            if (nodeToCast.getLocationInParent() == SingleMemberAnnotation.TYPE_NAME_PROPERTY && (callerBindingDecl = Bindings.findMethodInType(declaringType = typeBinding2, "value", null)) == null) {
                return;
            }
        }
        if (declaringType != null && declaringType.isFromSource()) {
            targetCu = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringType);
        }
        if (targetCu != null && ASTResolving.isUseableTypeInContext(castTypeBinding, callerBindingDecl, false) && (p = this.createChangeSenderTypeProposal(targetCu, callerBindingDecl, astRoot, castTypeBinding, isAssignedNode, relevance)) != null) {
            proposals.add(p);
        }
        if (!isAssignedNode) {
            T p2;
            ITypeBinding typeDecl;
            ICompilationUnit nodeCu;
            ITypeBinding nodeType = nodeToCast.resolveTypeBinding();
            if (castTypeBinding.isInterface() && nodeType != null && nodeType.isClass() && !nodeType.isAnonymous() && nodeType.isFromSource() && (nodeCu = ASTResolving.findCompilationUnitForBinding(cu, astRoot, typeDecl = nodeType.getTypeDeclaration())) != null && ASTResolving.isUseableTypeInContext(castTypeBinding, (IBinding)typeDecl, true) && (p2 = this.createImplementInterfaceProposal(nodeCu, typeDecl, astRoot, castTypeBinding, relevance - 1)) != null) {
                proposals.add(p2);
            }
        }
    }

    public T collectCastProposals(IInvocationContext context, ITypeBinding castTypeBinding, Expression nodeToCast, int relevance) {
        return this.collectCastProposals(null, context, castTypeBinding, nodeToCast, relevance);
    }

    public T collectCastProposals(String label, IInvocationContext context, ITypeBinding castTypeBinding, Expression nodeToCast, int relevance) {
        ICompilationUnit cu = context.getCompilationUnit();
        if (label == null) {
            String castType = BindingLabelProviderCore.getBindingLabel((IBinding)castTypeBinding, 0x200009L);
            label = nodeToCast.getNodeType() == 11 ? Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changecast_description, castType) : Messages.format(CorrectionMessages.TypeMismatchSubProcessor_addcast_description, castType);
        }
        return this.createCastCorrectionProposal(label, cu, nodeToCast, castTypeBinding, relevance);
    }

    public void collectIncompatibleReturnTypeProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) throws JavaModelException {
        T proposal;
        T p1;
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        MethodDeclaration decl = ASTResolving.findParentMethodDeclaration(selectedNode);
        if (decl == null) {
            return;
        }
        IMethodBinding methodDeclBinding = decl.resolveBinding();
        if (methodDeclBinding == null) {
            return;
        }
        ITypeBinding returnType = methodDeclBinding.getReturnType();
        IMethodBinding overridden = Bindings.findOverriddenMethod(methodDeclBinding, false);
        if (overridden == null || overridden.getReturnType() == returnType) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        IMethodBinding methodDecl = methodDeclBinding.getMethodDeclaration();
        ITypeBinding overriddenReturnType = overridden.getReturnType();
        if (!JavaModelUtil.is50OrHigher(context.getCompilationUnit().getJavaProject())) {
            overriddenReturnType = overriddenReturnType.getErasure();
        }
        if ((p1 = this.createChangeIncompatibleReturnTypeProposal(cu, methodDecl, astRoot, overriddenReturnType, false, 8)) != null) {
            proposals.add(p1);
        }
        ICompilationUnit targetCu = cu;
        IMethodBinding overriddenDecl = overridden.getMethodDeclaration();
        ITypeBinding overridenDeclType = overriddenDecl.getDeclaringClass();
        if (overridenDeclType.isFromSource() && (targetCu = ASTResolving.findCompilationUnitForBinding(cu, astRoot, overridenDeclType)) != null && ASTResolving.isUseableTypeInContext(returnType, (IBinding)overriddenDecl, false) && (proposal = this.createChangeReturnTypeOfOverridden(targetCu, overriddenDecl, astRoot, returnType, false, 7, overridenDeclType)) != null) {
            proposals.add(proposal);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void collectIncompatibleThrowsProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) throws JavaModelException {
        void decl;
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration methodDeclaration = (MethodDeclaration)selectedNode;
        IMethodBinding methodDeclBinding = decl.resolveBinding();
        if (methodDeclBinding == null) {
            return;
        }
        IMethodBinding overridden = Bindings.findOverriddenMethod(methodDeclBinding, false);
        if (overridden == null) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ITypeBinding[] methodExceptions = methodDeclBinding.getExceptionTypes();
        ITypeBinding[] definedExceptions = overridden.getExceptionTypes();
        ArrayList<ITypeBinding> undeclaredExceptions = new ArrayList<ITypeBinding>();
        ChangeMethodSignatureProposalCore.ChangeDescription[] changes = new ChangeMethodSignatureProposalCore.ChangeDescription[methodExceptions.length];
        int i = 0;
        while (i < methodExceptions.length) {
            if (!TypeMismatchBaseSubProcessor.isDeclaredException(methodExceptions[i], definedExceptions)) {
                changes[i] = new ChangeMethodSignatureProposalCore.RemoveDescription();
                undeclaredExceptions.add(methodExceptions[i]);
            }
            ++i;
        }
        if (undeclaredExceptions.isEmpty()) {
            return;
        }
        String label = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_removeexceptions_description, BasicElementLabels.getJavaElementName(methodDeclBinding.getName()));
        T p1 = this.createChangeMethodSignatureProposal(label, cu, astRoot, methodDeclBinding, null, changes, 8);
        if (p1 != null) {
            proposals.add(p1);
        }
        ITypeBinding declaringType = overridden.getDeclaringClass();
        ICompilationUnit targetCu = null;
        if (declaringType.isFromSource()) {
            targetCu = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringType);
        }
        if (targetCu != null) {
            ChangeMethodSignatureProposalCore.ChangeDescription[] changes2 = new ChangeMethodSignatureProposalCore.ChangeDescription[definedExceptions.length + undeclaredExceptions.size()];
            int i2 = 0;
            while (i2 < undeclaredExceptions.size()) {
                changes2[i2 + definedExceptions.length] = new ChangeMethodSignatureProposalCore.InsertDescription((ITypeBinding)undeclaredExceptions.get(i2), "");
                ++i2;
            }
            IMethodBinding overriddenDecl = overridden.getMethodDeclaration();
            Object[] args = new String[]{BasicElementLabels.getJavaElementName(declaringType.getName()), BasicElementLabels.getJavaElementName(overridden.getName())};
            String label2 = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_addexceptions_description, args);
            T p2 = this.createChangeMethodSignatureProposal(label2, targetCu, astRoot, overriddenDecl, null, changes2, 7);
            if (p2 != null) {
                proposals.add(p2);
            }
        }
    }

    private static boolean isDeclaredException(ITypeBinding curr, ITypeBinding[] declared) {
        ITypeBinding[] iTypeBindingArray = declared;
        int n = declared.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding d = iTypeBindingArray[n2];
            if (Bindings.isSuperType(d, curr)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void collectTypeMismatchInForEachProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ASTRewrite rewrite;
        String label;
        T p2;
        ITypeBinding expectedBinding;
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null || selectedNode.getLocationInParent() != EnhancedForStatement.EXPRESSION_PROPERTY) {
            return;
        }
        EnhancedForStatement forStatement = (EnhancedForStatement)selectedNode.getParent();
        ITypeBinding expressionBinding = forStatement.getExpression().resolveTypeBinding();
        if (expressionBinding == null) {
            return;
        }
        if (expressionBinding.isArray()) {
            expectedBinding = expressionBinding.getComponentType();
        } else {
            IMethodBinding iteratorMethod = Bindings.findMethodInHierarchy(expressionBinding, "iterator", new String[0]);
            if (iteratorMethod == null) {
                return;
            }
            ITypeBinding[] typeArguments = iteratorMethod.getReturnType().getTypeArguments();
            if (typeArguments.length != 1) {
                return;
            }
            expectedBinding = typeArguments[0];
        }
        AST ast = astRoot.getAST();
        expectedBinding = Bindings.normalizeForDeclarationUse(expectedBinding, ast);
        SingleVariableDeclaration parameter = forStatement.getParameter();
        ICompilationUnit cu = context.getCompilationUnit();
        if (parameter.getName().getLength() == 0) {
            SimpleName simpleName = null;
            Type type = parameter.getType();
            if (type instanceof SimpleType) {
                SimpleType simpleType = (SimpleType)type;
                SimpleType type2 = simpleType;
                Name name = type2.getName();
                if (name instanceof SimpleName) {
                    SimpleName simpleName2;
                    simpleName = simpleName2 = (SimpleName)name;
                }
            } else {
                Type type3 = parameter.getType();
                if (type3 instanceof NameQualifiedType) {
                    NameQualifiedType nameQualifiedType = (NameQualifiedType)type3;
                    simpleName = nameQualifiedType.getName();
                }
            }
            if (simpleName != null) {
                String name = simpleName.getIdentifier();
                int relevance = StubUtility.hasLocalVariableName(cu.getJavaProject(), name) ? 10 : 7;
                String label2 = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_create_loop_variable_description, BasicElementLabels.getJavaElementName(name));
                T p1 = this.createNewVariableCorrectionProposal(label2, cu, 1, simpleName, null, relevance);
                if (p1 != null) {
                    proposals.add(p1);
                }
                return;
            }
        }
        if ((p2 = this.createIncompatibleForEachTypeProposal(label = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_incompatible_for_each_type_description, new String[]{BasicElementLabels.getJavaElementName(parameter.getName().getIdentifier()), BindingLabelProviderCore.getBindingLabel((IBinding)expectedBinding, 0x200009L)}), cu, rewrite = ASTRewrite.create((AST)ast), 5, astRoot, ast, expectedBinding, selectedNode, parameter)) != null) {
            proposals.add(p2);
        }
    }

    protected abstract T createInsertNullCheckProposal(String var1, ICompilationUnit var2, ASTRewrite var3, int var4);

    protected abstract T createChangeReturnTypeProposal(String var1, ICompilationUnit var2, ASTRewrite var3, int var4, ITypeBinding var5, AST var6, CompilationUnit var7, MethodDeclaration var8, BodyDeclaration var9);

    protected abstract T createOptionalProposal(String var1, ICompilationUnit var2, Expression var3, int var4, int var5);

    protected abstract T createImplementInterfaceProposal(ICompilationUnit var1, ITypeBinding var2, CompilationUnit var3, ITypeBinding var4, int var5);

    protected abstract T createChangeSenderTypeProposal(ICompilationUnit var1, IBinding var2, CompilationUnit var3, ITypeBinding var4, boolean var5, int var6);

    protected abstract T createCastCorrectionProposal(String var1, ICompilationUnit var2, Expression var3, ITypeBinding var4, int var5);

    protected abstract T createChangeReturnTypeOfOverridden(ICompilationUnit var1, IMethodBinding var2, CompilationUnit var3, ITypeBinding var4, boolean var5, int var6, ITypeBinding var7);

    protected abstract T createChangeIncompatibleReturnTypeProposal(ICompilationUnit var1, IMethodBinding var2, CompilationUnit var3, ITypeBinding var4, boolean var5, int var6);

    protected abstract T createChangeMethodSignatureProposal(String var1, ICompilationUnit var2, CompilationUnit var3, IMethodBinding var4, ChangeMethodSignatureProposalCore.ChangeDescription[] var5, ChangeMethodSignatureProposalCore.ChangeDescription[] var6, int var7);

    protected abstract T createNewVariableCorrectionProposal(String var1, ICompilationUnit var2, int var3, SimpleName var4, ITypeBinding var5, int var6);

    protected abstract T createIncompatibleForEachTypeProposal(String var1, ICompilationUnit var2, ASTRewrite var3, int var4, CompilationUnit var5, AST var6, ITypeBinding var7, ASTNode var8, SingleVariableDeclaration var9);
}

