/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ExternalFoldersManager;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;

public class ExternalFolderChange {
    private ScriptProject project;
    private IBuildpathEntry[] oldResolvedBuildpath;

    public ExternalFolderChange(ScriptProject project, IBuildpathEntry[] oldResolvedBuildpath) {
        this.project = project;
        this.oldResolvedBuildpath = oldResolvedBuildpath;
    }

    public void updateExternalFoldersIfNecessary(boolean refreshIfExistAlready, IProgressMonitor monitor) throws ModelException {
        Set<IPath> oldFolders = ExternalFoldersManager.getExternalFolders(this.oldResolvedBuildpath);
        IBuildpathEntry[] newResolvedBuildpath = this.project.getResolvedBuildpath();
        Set<IPath> newFolders = ExternalFoldersManager.getExternalFolders(newResolvedBuildpath);
        if (newFolders == null) {
            return;
        }
        ExternalFoldersManager foldersManager = ModelManager.getExternalManager();
        for (IPath folderPath : newFolders) {
            if (oldFolders != null && oldFolders.remove(folderPath)) continue;
            try {
                foldersManager.createLinkFolder(folderPath, refreshIfExistAlready, monitor);
            }
            catch (CoreException e) {
                ModelException.propagate(e);
            }
        }
    }

    public String toString() {
        return "ExternalFolderChange: " + this.project.getElementName();
    }
}

