/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.grid;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.layout.GeneralLayoutData;
import org.eclipse.wb.internal.core.model.util.grid.GridConvertionHelper;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.ICompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public final class GridLayoutConverter {
    private GridLayoutConverter() {
    }

    public static <T extends IControlInfo> void convert(ICompositeInfo parent, IGridLayoutInfo<T> layout) throws Exception {
        List columns = GridConvertionHelper.buildGroups(parent.getChildrenControls(), (boolean)true);
        List rows = GridConvertionHelper.buildGroups(parent.getChildrenControls(), (boolean)false);
        GridConvertionHelper.sortGroupsByTranspose((List)columns, (List)rows);
        GridConvertionHelper.sortGroupsByTranspose((List)rows, (List)columns);
        GridConvertionHelper.sortGroups((List)columns);
        GridConvertionHelper.sortGroups((List)rows);
        GridConvertionHelper.updateBoundsGaps((List)columns, (boolean)false);
        GridConvertionHelper.updateBoundsGaps((List)rows, (boolean)false);
        GridLayoutConverter.reorderControls(parent, rows);
        int numColumns = columns.size();
        ArrayList appliedControls = Lists.newArrayList();
        for (GridConvertionHelper.ComponentGroup column : columns) {
            for (GridConvertionHelper.ComponentInGroup component : column.getComponents()) {
                IControlInfo control = (IControlInfo)component.getComponent();
                if (appliedControls.contains(control)) continue;
                GeneralLayoutData generalLayoutData = GeneralLayoutData.getFromInfoEx((ObjectInfo)control.getUnderlyingModel());
                IGridDataInfo gridData = layout.getGridData2(control);
                Rectangle cells = GridLayoutConverter.getCells(component, generalLayoutData, columns, rows);
                gridData.setX(cells.x);
                gridData.setY(cells.y);
                gridData.setHorizontalSpan(cells.width);
                gridData.setVerticalSpan(cells.height);
                GridLayoutConverter.applyGeneralLayoutData(gridData, generalLayoutData);
                appliedControls.add(control);
                numColumns = Math.max(numColumns, cells.x + cells.width);
            }
        }
        if (numColumns > 0) {
            layout.getPropertyByTitle("numColumns").setValue((Object)numColumns);
        }
        layout.fixGrid();
    }

    private static Rectangle getCells(GridConvertionHelper.ComponentInGroup component, GeneralLayoutData generalLayoutData, List<GridConvertionHelper.ComponentGroup> columns, List<GridConvertionHelper.ComponentGroup> rows) {
        int x = -1;
        int y = -1;
        int w = 1;
        int h = 1;
        GridConvertionHelper.ComponentGroup beginColumn = GridConvertionHelper.getBeginForComponent(columns, (GridConvertionHelper.ComponentInGroup)component);
        GridConvertionHelper.ComponentGroup endColumn = GridConvertionHelper.getEndForComponent(columns, (GridConvertionHelper.ComponentInGroup)component);
        GridConvertionHelper.ComponentGroup beginRow = GridConvertionHelper.getBeginForComponent(rows, (GridConvertionHelper.ComponentInGroup)component);
        GridConvertionHelper.ComponentGroup endRow = GridConvertionHelper.getEndForComponent(rows, (GridConvertionHelper.ComponentInGroup)component);
        x = columns.indexOf(beginColumn);
        y = rows.indexOf(beginRow);
        w = 1 + columns.indexOf(endColumn) - x;
        h = 1 + rows.indexOf(endRow) - y;
        if (generalLayoutData.gridX != null) {
            x = generalLayoutData.gridX;
            w = 1;
        }
        if (generalLayoutData.gridY != null) {
            y = generalLayoutData.gridY;
            h = 1;
        }
        if (generalLayoutData.spanX != null) {
            w = generalLayoutData.spanX;
        }
        if (generalLayoutData.spanY != null) {
            h = generalLayoutData.spanY;
        }
        return new Rectangle(x, y, w, h);
    }

    private static void applyGeneralLayoutData(IGridDataInfo gridData, GeneralLayoutData generalLayoutData) throws Exception {
        Integer verticalAlignmentValue;
        Integer horizontalAlignmentValue;
        if (generalLayoutData.horizontalGrab != null) {
            gridData.setHorizontalGrab(generalLayoutData.horizontalGrab);
        }
        if (generalLayoutData.verticalGrab != null) {
            gridData.setVerticalGrab(generalLayoutData.verticalGrab);
        }
        if ((horizontalAlignmentValue = (Integer)GeneralLayoutData.getRealValue(GridLayoutInfo.m_horizontalAlignmentMap, (Object)generalLayoutData.horizontalAlignment)) != null) {
            gridData.setHorizontalAlignment(horizontalAlignmentValue);
        }
        if ((verticalAlignmentValue = (Integer)GeneralLayoutData.getRealValue(GridLayoutInfo.m_verticalAlignmentMap, (Object)generalLayoutData.verticalAlignment)) != null) {
            gridData.setVerticalAlignment(verticalAlignmentValue);
        }
    }

    private static void reorderControls(ICompositeInfo parent, List<GridConvertionHelper.ComponentGroup> rows) throws Exception {
        ArrayList reversedControls = Lists.newArrayList();
        for (GridConvertionHelper.ComponentGroup row : rows) {
            for (GridConvertionHelper.ComponentInGroup componentInGroup : row.getComponents()) {
                IControlInfo control = (IControlInfo)componentInGroup.getComponent();
                reversedControls.add(0, control);
            }
        }
        IControlInfo nextControl = null;
        for (IControlInfo control : reversedControls) {
            if (nextControl != null && !GridLayoutConverter.isAlreadyRightOrder(control, nextControl)) {
                GlobalState.getOrderProcessor().move((Object)control, (Object)nextControl);
            }
            nextControl = control;
        }
    }

    private static boolean isAlreadyRightOrder(IControlInfo control, IControlInfo nextControl) {
        ICompositeInfo composite = (ICompositeInfo)control.getParent();
        List<? extends IControlInfo> controls = composite.getChildrenControls();
        return GenericsUtils.getNextOrNull(controls, (Object)control) == nextControl;
    }
}

