/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.graphical.handles;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.ILocator;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.handles.Handle;

public abstract class SquareHandle
extends Handle {
    protected static final int DEFAULT_HANDLE_SIZE = 7;

    public SquareHandle(GraphicalEditPart owner, ILocator locator) {
        super(owner, locator);
        this.setSize(7, 7);
    }

    protected boolean isPrimary() {
        return this.getOwner().getSelected() == 2;
    }

    protected Color getBorderColor() {
        return this.isPrimary() ? IColorConstants.white : IColorConstants.black;
    }

    protected Color getFillColor() {
        return this.isPrimary() ? IColorConstants.black : IColorConstants.white;
    }

    @Override
    protected void paintClientArea(Graphics graphics) {
        Rectangle area = this.getClientArea();
        area.shrink(1, 1);
        graphics.setBackgroundColor(this.getFillColor());
        graphics.fillRectangle(area);
        graphics.setForegroundColor(this.getBorderColor());
        graphics.drawRectangle(area);
    }
}

