/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.jface.internal.util.SerializableEventManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.graphics.Graphics;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;

public class ColorSelector
extends SerializableEventManager {
    public static final String PROP_COLORCHANGE = "colorValue";
    private Button fButton;
    private Color fColor;
    private RGB fColorValue;

    public ColorSelector(Composite parent) {
        this.fButton = new Button(parent, 8);
        this.fButton.setForeground(this.fButton.getBackground());
        this.fButton.setText("\u2588\u2588\u2588");
        this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorSelector.this.open();
            }
        });
        this.fButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (ColorSelector.this.fColor != null) {
                    ColorSelector.this.fColor = null;
                }
            }
        });
        this.fButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = JFaceResources.getString("ColorSelector.Name");
            }
        });
    }

    public void addListener(IPropertyChangeListener listener) {
        this.addListenerObject(listener);
    }

    public Button getButton() {
        return this.fButton;
    }

    public RGB getColorValue() {
        return this.fColorValue;
    }

    public void removeListener(IPropertyChangeListener listener) {
        this.removeListenerObject(listener);
    }

    public void setColorValue(RGB rgb) {
        this.fColorValue = rgb;
        this.updateColorImage();
    }

    public void setEnabled(boolean state) {
        this.getButton().setEnabled(state);
    }

    protected void updateColorImage() {
        this.fColor = Graphics.getColor((RGB)this.fColorValue);
        this.fButton.setForeground(this.fColor);
    }

    public void open() {
        ColorDialog colorDialog = new ColorDialog(this.fButton.getShell());
        colorDialog.setRGB(this.fColorValue);
        RGB newColor = colorDialog.open();
        if (newColor != null) {
            RGB oldValue = this.fColorValue;
            this.fColorValue = newColor;
            Object[] finalListeners = this.getListeners();
            if (finalListeners.length > 0) {
                PropertyChangeEvent pEvent = new PropertyChangeEvent(this, PROP_COLORCHANGE, oldValue, newColor);
                int i = 0;
                while (i < finalListeners.length) {
                    IPropertyChangeListener listener = (IPropertyChangeListener)finalListeners[i];
                    listener.propertyChange(pEvent);
                    ++i;
                }
            }
            this.updateColorImage();
        }
    }
}

